// the units are millimeters, 1 = 1mm.
// some objects are not included, but the file can be raytraced as such.
// "wasp.inc" is a POV-Ray file. It can be raytraced separately (add lights and cameras).
// I was in a hurry writing this, so it's really a mess.

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "wasp.inc"
// #include "a011a_.inc"

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0 color rgb <0.67, 0.88, .99> ]
      [ 1 color rgb <.65, 0.85, 0.95> ]
      }
      scale 2
      translate -1
    }
  pigment { bozo
  turbulence 0.9
  octaves 8
  omega 0.7
  lambda 2
  color_map {
    [0.0 0.1 color rgb <0.95, 0.92, 0.81>
             color rgb <0.98, 0.95, 0.85>]
    [0.1 0.5 color rgb <0.98, 0.95, 0.85>
             color rgbt <1, 1, 1, 1>]
    [0.5 1.0 color rgbt <1, 1, 1, 1>
             color rgbt <1, 1, 1, 1>]
    }
   }
 }

camera {
   location <10000, 6700, 1600>
   direction <0, 0.778, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.333, 0, 0>
   look_at <10381, 7780, 910>
}

light_source {
    <-104.6387, 21225.0977, 5986.8140> color rgb <1.00, 0.65, 0.25>
    spotlight
    point_at <10902.4248, 6228.6055, 1428.0475>
    tightness 10
    radius 12.00
    falloff 22.50
}

light_source {
    <18182.4688, -10600.2393, 2142.0698> color rgb <0.5, 0.65, .75>
    spotlight
    point_at <10183.1553, 4846.4980, 0.0000>
    tightness 10
    radius 6.63
    falloff 51.13
    fade_distance 1300
    fade_power 1
}

light_source {
    <8000., 6300, 1765.> color rgb <0.6, 0.6, 0.55>
    fade_distance 2500
    fade_power 1
}

// #declare Kettle=
// union {
//      object {BODY01}
//      object {HANDLE01}
//      object {NOSE01}
//      }
// object {Kettle translate <10350,7770,910>}

#declare MARBLE = texture {
    finish {
        ambient 0.3
        diffuse 0.7
        phong 0.12
        phong_size 3.5
        reflection 0.15
        }
    pigment {
        gradient x
        turbulence 0.75
        frequency 6
        scale 500
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.85, 0.85, 0.85, 0.0> ]
            [0.10 color rgbf <1.00, 1.00, 1.00, 0.0> ]
            [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
        }
    }
}
texture {
    finish {
        ambient 0.3
        diffuse 0.7
        phong 0.12
        phong_size 3.5
        reflection 0.2
        }
    pigment {
        crackle
        turbulence 0.3
        lambda 2.5
        omega 0.75
        octaves 5
        scale 450
        frequency 2
        phase 0.25
        rotate <0, 5, 60>
        color_map {
            [0.00 color Clear ]
            [0.15 color rgbf <0.40, 0.36, 0.36, 0.50> ]
            [0.30 color rgbf <0.30, 0.25, 0.20, 0.30> ]
            [0.35 color rgbf <0.55, 0.52, 0.48, 0.50> ]
            [0.45 color rgbf <0.40, 0.39, 0.36, 0.60> ]
            [0.65 color Clear ]
        }
    }
}


#declare WHITE_GLASS = texture {
finish {
    specular 1
    roughness 0.001
    ambient 0.1
    diffuse 0.1
    refraction 1
    reflection 0.4
    ior 1.45
    }
    pigment { rgbf <1, 1, 1, 0.7> }
}

#declare WOOD = texture {
         pigment {
           wood
           frequency .5
           turbulence 0.1
           octaves 3
           scale <0.2, .2, 1>
           color_map {
             [0.0, 0.1 color rgb <0.99, 0.86, 0.70>
                       color rgb <0.99, 0.86, 0.70>]
             [0.1, 0.9 color rgb <0.99, 0.86, 0.70>
                       color rgb <0.94, 0.80, 0.62>]
             [0.9, 1.0 color rgb <0.94, 0.80, 0.62>
                       color rgb <0.94, 0.80, 0.62>]
            }
          }
          finish {
            ambient 0.4
            diffuse 0.6
            phong 0.1
            phong_size 20
            reflection 0.05 }
}

#declare DOORS_WHITE = texture {
    finish {
        ambient 0.5
        diffuse 0.90
        phong 1.00
        phong_size 37.1
        reflection 0.150
    }
    pigment { rgb <0.92, 0.94, 0.95> }
}

#declare TERRACE = texture {
    finish {
        ambient 0.3
        diffuse 0.90
        phong 0.12
        phong_size 3.5
    }
    pigment { rgb <0.8, 0.8, 0.8> }
}

#declare METALS = texture {
finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
}

    pigment { rgb <0.6, 0.6, 0.6> }
}

#declare WALLS_WHITE = texture {
    finish {
        ambient 0.5
        diffuse 0.90
        phong 0.12
        phong_size 3.5
        reflection 0.01
    }
    normal {bumps 0.05 scale 10}
    pigment { rgb <0.92, 0.94, 0.95> }
}

// #include "lt03a1.inc"
// #include "lt03a2.inc"

