//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 30 textures and 368 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/31/1996    (31.12.1996)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//

// Copyright Xavier Manget 1996





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 1    // Constant
  distance     4000.0
  color <0.35,0.4,0.6,0.0,0.0>
}

camera {  //  Camera StdCam
  location  <39.450, -33.000, 54.500>
  direction <0.0,     0.0,  1.4739>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.500, 2.000, 38.913>
}

//    Other cameras are commented out.
/*
camera {  //  Camera CameraObj
  location  <4919.573, 4910.160, 4925.464>
  direction <0.0,     0.0,  1.8241>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <4919.970, 4918.494, 4921.639>
}

*/

// *******  L I G H T S *******
light_source {   // Light001
  <111.030, -14.876, 10.000>
  color rgb <0.255, 0.255, 0.255>
}

light_source {   // Light1
  <1335.521, -1559.705, 2300.000>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "autr6.inc"



// ********  REFERENCED OBJECTS  *******

#declare UnionCuisse0 = union {
  sphere { // SphCuisse0
    <0,0,0>,1
    scale <1.5, 1.5, 2.5>
    translate  -0.99231*z
  }
  cone { // ConeCuisse0
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <1.46763, 1.46763, 5.506609>
    translate  -6.818167*z
  }
  scale <0.8, 0.5, 0.85>
  translate  -1.015654*z
}
#declare ElCuisse0 = union {
  object { UnionCuisse0 }
  sphere { // SphGenou
    <0,0,0>,1
    scale <0.663649, 0.55, 1.0>
    translate  -7.0*z
  }
}
#declare UnMollet0 = union {
  box { // CubMollet1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 3.0>
    rotate 0.75*y
    translate  <-0.05, 0.0, -3.0>
  }
  box { // CubMollet0
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 3.0>
    rotate -0.75*y
    translate  <0.05, 0.0, -3.0>
  }
  cylinder { // CylMollet1
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.25, 6.0>
    rotate <180.0, 0.75, 180.0>
    translate  0.310754*x
  }
  cylinder { // CylMollet0
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.25, 6.0>
    rotate <180.0, -0.75, 180.0>
    translate  -0.310753*x
  }
}
#declare DiffMollet0 = difference {
  object { UnMollet0 }
  cone { // ConeDiffMolle1
    <0,0,0>, 0.3, <0,0,1>, 0.4
    scale <1.0, 0.35, 6.0>
    rotate -180.0*y
    translate  0.25*y
  }
  cone { // ConeDiffMollet0
    <0,0,0>, 0.3, <0,0,1>, 0.4
    scale <1.0, 0.35, 6.0>
    rotate -180.0*y
    translate  -0.25*y
  }
  scale <0.8, 0.8, 1.0>
}
#declare Mollet0 = union {
  object { DiffMollet0 }
  cone { // ConeMollet2
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <0.566654, 0.398316, 1.124887>
    translate  -1.517905*z
  }
  cone { // SphCone2
    <0,0,0>, 0.45, <0,0,1>, 1.0
    scale <0.574067, 0.42, 0.683452>
    rotate <180.0, 0.0, 180.0>
    translate  -5.173708*z
  }
}
#declare Ongle0 = union {
  sphere { // SphOngle001
    <0,0,0>,1
  }
  cone { // ConOngle0
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.926421, 1.0, 1.5>
    translate  -1.875018*z
  }
  texture {
    TexOngle
  }
  scale <0.15, 0.15, 0.25>
  rotate 24.734909*y
  translate  <0.020067, 0.0, -1.120403>
}
#declare Doigt0 = union {
  sphere { // SphDoigt0
    <0,0,0>,1
    scale 0.170118
    translate  -1.0*z
  }
  cone { // ConDoigt0
    <0,0,0>, 0.7, <0,0,1>, 1.0
    scale <0.25, 0.25, 1.0>
    translate  -1.0*z
  }
  object { Ongle0 }
  scale 1.2
  rotate <43.393612, -72.726143, -56.775387>
  translate  <0.952986, -0.269118, -0.602841>
}
#declare Pied0 = union {
  sphere { // SphPied001
    <0,0,0>,1
    scale <0.6, 0.45, 0.6>
  }
  cone { // SphCone001
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.574067, 0.42, 0.587399>
    rotate <0.0, -52.521553, 0.0>
    translate  <0.593276, 0.0, -0.453289>
  }
  sphere { // SphPied002
    <0,0,0>,1
    scale <0.6, 0.6, 0.4>
    translate  <0.68556, 0.0, -0.510809>
  }
  object { Doigt0 }
  object { // Doigt1->Doigt0
    Doigt0
    rotate <0.0, 0.0, 16.691523>
    translate  <-0.074188, 0.158734, 0.0>
  }
  object { // Doigt2->Doigt0
    Doigt0
    scale 0.5
    rotate <-20.0, 45.0, -30.0>
    translate  <0.45, -0.1, 0.15>
  }
  object { // Doigt3->Doigt0
    Doigt0
    scale 0.5
    rotate <-20.0, 45.0, 30.0>
    translate  <0.2, 0.55, 0.15>
  }
  sphere { // DoigtAr0
    <0,0,0>,1
    scale <0.3, 0.3, 0.4>
    translate  <-0.25, 0.0, -0.45>
  }
}
#declare Tete0 = blob {
  threshold 0.6
  component 1.0, 1.0036, <-0.025316, 0.0, 0.008439>
  component 0.683129, 0.392655, <0.295359, -0.109705, -0.008439>
  component 0.683129, 0.392655, <0.295359, 0.008439, -0.008439>
  component 0.683129, 0.392655, <0.511568, -0.074661, -0.008296>
  component 1.001063, 0.167209, <0.246106, 0.207393, -0.31865>
  component 0.981833, 0.214589, <-0.141027, 0.201862, -0.351738>
  component 0.920857, 0.200592, <0.052539, 0.262697, -0.356306>
  component -3.844693, 0.519421, <0.06481, 0.090734, -0.791139>
  component 1.0, 0.251372, <-0.211713, 0.246279, -0.146273>
  component -1.949149, 1.096713, <0.875528, -1.00211, 0.0>
  component 0.889029, 0.119721, <0.329063, 0.163149, -0.293806>
  component -1.096506, 0.436868, <0.056169, 0.159865, -0.534684>
  component 0.973399, 0.210194, <-0.074661, 0.235045, -0.351738>
  component 0.877201, 0.207334, <0.196332, 0.223984, -0.347313>
  component 0.927999, 0.18794, <0.157618, 0.262697, -0.254401>
  component 0.915761, 0.221709, <-0.008296, 0.262697, -0.254401>
  component -6.918593, 0.223898, <0.074262, 0.0, -0.57384>
  component 0.683129, 0.231285, <0.600055, -0.069131, -0.013826>
  component 1.0, 0.251372, <-0.211713, 0.246279, 0.146273>
  component -6.918593, 0.223898, <0.074262, 0.0, 0.57384>
  component -3.844693, 0.519421, <0.06481, 0.090734, 0.791139>
  component -1.096506, 0.436868, <0.056169, 0.159865, 0.534684>
  component 0.981833, 0.214589, <-0.141027, 0.201862, 0.351738>
  component 0.973399, 0.210194, <-0.074661, 0.235045, 0.351738>
  component 0.915761, 0.221709, <-0.008296, 0.262697, 0.254401>
  component 0.920857, 0.200592, <0.052539, 0.262697, 0.356306>
  component 0.927999, 0.18794, <0.157618, 0.262697, 0.254401>
  component 0.877201, 0.207334, <0.196332, 0.223984, 0.347313>
  component 1.001063, 0.167209, <0.246106, 0.207393, 0.31865>
  component 0.889029, 0.119721, <0.329063, 0.163149, 0.293806>

sturm
  rotate 90.0*x
}

#declare DiffTete0 = difference {
  object { Tete0 }
}
#declare UnBec1 = union {
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.2
    translate  1.0*x
  }
  cone { // Bec9
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
    rotate -90.0*y
    translate  1.0*x
  }
  scale <0.4, 0.4, 0.15>
}
#declare DiffBec1 = difference {
  object { UnBec1 }
  cone { // Bec10
    <0,0,0>, 0.15, <0,0,1>, 1.0
    scale <0.1, 0.35, 1.0>
    rotate -90.0*y
    translate  0.403093*x
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <0.04, 0.04, 0.025>
    translate  0.4*x
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.6, 0.2>
    translate  <-0.1, 0.0, 0.2>
  }
}
#declare BasBec0 = union {
  object { DiffBec1 }
  cylinder { // CylBec2
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <17.700001, 90.0, 0.0>
    translate  <-0.609105, 0.371395, 0.0>
  }
  cylinder { // CylBec3
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <-17.700001, 90.0, 0.0>
    translate  <-0.609105, -0.371421, 0.0>
  }
  torus { // Torus2
    0.05, 0.03  rotate -x*90
    translate  0.401379*x
  }
  texture {
    TexBec
  }
  scale 0.9
  translate  <0.833067, 0.0, -0.177205>
}
#declare UnBec0 = union {
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.2
    translate  1.0*x
  }
  cone { // Bec0
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
    rotate -90.0*y
    translate  1.0*x
  }
  scale <0.4, 0.4, 0.25>
}
#declare DiffBec0 = difference {
  object { UnBec0 }
  cone { // Bec11
    <0,0,0>, 0.15, <0,0,1>, 1.0
    scale <0.1, 0.35, 1.0>
    rotate -90.0*y
    translate  0.403093*x
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale <0.04, 0.04, 0.025>
    translate  0.4*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.6, 0.2>
    translate  <-0.1, 0.0, -0.2>
  }
  cylinder { // CylNar0
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.05, 0.8>
    rotate <-176.0, 88.0, -180.0>
    translate  <-0.41211, -0.17, 0.068059>
  }
  cylinder { // CylNar1
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.05, 0.8>
    rotate <176.0, 88.000023, -180.0>
    translate  <-0.41211, 0.17, 0.068059>
  }
}
#declare HautBec0 = union {
  object { DiffBec0 }
  cylinder { // CylBec1
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <17.700001, 90.0, 0.0>
    translate  <-0.609105, 0.371395, 0.0>
  }
  cylinder { // CylBec0
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <-17.700001, 90.0, 0.0>
    translate  <-0.609105, -0.371421, 0.0>
  }
  torus { // Torus001
    0.05, 0.03  rotate -x*90
    translate  0.401379*x
  }
  texture {
    TexBec
  }
  scale 0.9
  translate  <0.838046, 0.0, -0.115809>
}
#declare TeteBf0 = union {
  object { DiffTete0 }
  object { BasBec0 }
  object { HautBec0 }
  sphere { // Oeil1
    <0,0,0>,1
    texture {
      TexNoirOeil
    }
    scale 0.12
    translate  <0.1, 0.35, 0.15>
  }
  sphere { // Oeil0
    <0,0,0>,1
    texture {
      TexNoirOeil
    }
    scale 0.12
    translate  <0.1, -0.35, 0.15>
  }
  scale 3.7
}
#declare RefCou2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.286813, 0.029118, -14.294895>, <-4.280967, -1.214864, -14.302271>, <-3.672743, -2.261137, -15.069631>, <-2.881067, -2.261025, -16.026142>,
      <-2.646541, 0.025913, -13.171904>, <-2.640982, -1.083931, -13.178197>, <-2.062642, -2.017386, -13.832934>, <-1.322989, -1.992831, -14.635341>,
      <-1.379952, 0.022821, -11.941874>, <-1.374225, -0.949185, -11.946486>, <-0.778367, -1.766709, -12.426403>, <-0.032849, -1.723785, -13.001179>,
      <-0.672103, 0.021068, -10.571799>, <-0.666438, -0.858679, -10.575116>, <-0.076969, -1.598607, -10.920239>, <0.646116, -1.542405, -11.325610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.881067, -2.261025, -16.026142>, <-2.089391, -2.260914, -16.982654>, <-1.499374, -1.245333, -17.811640>, <-1.499374, -0.003796, -17.811640>,
      <-1.322989, -1.992831, -14.635341>, <-0.583336, -1.968276, -15.437749>, <0.003941, -1.111116, -16.172508>, <0.003941, -0.003452, -16.172508>,
      <-0.032849, -1.723785, -13.001179>, <0.712670, -1.680861, -13.575954>, <1.350814, -0.972993, -14.141293>, <1.350814, -0.002896, -14.141293>,
      <0.646116, -1.542405, -11.325610>, <1.369201, -1.486203, -11.730981>, <2.029381, -0.880227, -12.153466>, <2.029381, -0.002208, -12.153466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.499374, -0.003796, -17.811640>, <-1.499374, 1.237742, -17.811640>, <-2.092058, 2.253375, -16.984766>, <-2.847850, 2.247779, -16.070789>,
      <0.003941, -0.003452, -16.172508>, <0.003941, 1.104212, -16.172508>, <-0.588551, 1.967631, -15.437772>, <-1.292744, 1.983988, -14.672546>,
      <1.350814, -0.002896, -14.141293>, <1.350814, 0.967200, -14.141293>, <0.705339, 1.685990, -13.575464>, <-0.002665, 1.719015, -13.028196>,
      <2.029381, -0.002208, -12.153466>, <2.029381, 0.875811, -12.153466>, <1.360157, 1.496079, -11.731283>, <0.675080, 1.541117, -11.345366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.847850, 2.247779, -16.070789>, <-3.603641, 2.242184, -15.156812>, <-4.292659, 1.273099, -14.287520>, <-4.286813, 0.029118, -14.294895>,
      <-1.292744, 1.983988, -14.672546>, <-1.996936, 2.000346, -13.907320>, <-2.652100, 1.135757, -13.165611>, <-2.646541, 0.025913, -13.171904>,
      <-0.002665, 1.719015, -13.028196>, <-0.710670, 1.752039, -12.480928>, <-1.385679, 0.994828, -11.937261>, <-1.379952, 0.022821, -11.941874>,
      <0.675080, 1.541117, -11.345366>, <-0.009998, 1.586156, -10.959449>, <-0.677769, 0.900816, -10.568482>, <-0.672103, 0.021068, -10.571799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.672103, 0.021068, -10.571799>, <-0.666438, -0.858679, -10.575116>, <-0.076969, -1.598607, -10.920239>, <0.646116, -1.542405, -11.325610>,
      <0.035745, 0.019315, -9.201724>, <0.041350, -0.768173, -9.203746>, <0.624429, -1.430505, -9.414074>, <1.325081, -1.361025, -9.650041>,
      <0.288418, 0.016572, -7.094723>, <0.293464, -0.653156, -7.095174>, <0.818535, -1.216443, -7.142074>, <1.435954, -1.142595, -7.183934>,
      <-0.133098, 0.015935, -5.050634>, <-0.128557, -0.615354, -5.049880>, <0.343878, -1.146312, -4.971435>, <0.888542, -1.063639, -4.871491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.646116, -1.542405, -11.325610>, <1.369201, -1.486203, -11.730981>, <2.029381, -0.880227, -12.153466>, <2.029381, -0.002208, -12.153466>,
      <1.325081, -1.361025, -9.650041>, <2.025732, -1.291544, -9.886009>, <2.707947, -0.787462, -10.165639>, <2.707947, -0.001520, -10.165639>,
      <1.435954, -1.142595, -7.183934>, <2.053372, -1.068747, -7.225795>, <2.694772, -0.669560, -7.309660>, <2.694772, -0.001148, -7.309660>,
      <0.888542, -1.063639, -4.871491>, <1.433205, -0.980966, -4.771546>, <2.032031, -0.630817, -4.691129>, <2.032031, -0.000768, -4.691129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.029381, -0.002208, -12.153466>, <2.029381, 0.875811, -12.153466>, <1.360157, 1.496079, -11.731283>, <0.675080, 1.541117, -11.345366>,
      <2.707947, -0.001520, -10.165639>, <2.707947, 0.784422, -10.165639>, <2.014975, 1.306168, -9.887102>, <1.352825, 1.363220, -9.662536>,
      <2.694772, -0.001148, -7.309660>, <2.694772, 0.667264, -7.309660>, <2.042649, 1.085222, -7.229371>, <1.460419, 1.146626, -7.188387>,
      <2.032031, -0.000768, -4.691129>, <2.032031, 0.629281, -4.691129>, <1.423148, 1.000441, -4.778364>, <0.910350, 1.069725, -4.870444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.675080, 1.541117, -11.345366>, <-0.009998, 1.586156, -10.959449>, <-0.677769, 0.900816, -10.568482>, <-0.672103, 0.021068, -10.571799>,
      <1.352825, 1.363220, -9.662536>, <0.690674, 1.420273, -9.437970>, <0.030141, 0.806804, -9.199703>, <0.035745, 0.019315, -9.201724>,
      <1.460419, 1.146626, -7.188387>, <0.878190, 1.208030, -7.147402>, <0.283371, 0.686300, -7.094273>, <0.288418, 0.016572, -7.094723>,
      <0.910350, 1.069725, -4.870444>, <0.397552, 1.139010, -4.962523>, <-0.137639, 0.647224, -5.051388>, <-0.133098, 0.015935, -5.050634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.133098, 0.015935, -5.050634>, <-0.128557, -0.615354, -5.049880>, <0.343878, -1.146312, -4.971435>, <0.888542, -1.063639, -4.871491>,
      <-0.554613, 0.015297, -3.006545>, <-0.550578, -0.577553, -3.004586>, <-0.130779, -1.076181, -2.800797>, <0.341129, -0.984683, -2.559047>,
      <-1.019972, 0.014694, -2.337998>, <-1.016406, -0.553621, -2.335596>, <-0.645369, -1.031613, -2.085713>, <-0.236877, -0.931379, -1.797623>,
      <-1.263246, 0.014645, 1.006457>, <-1.250789, -0.538828, 1.010600>, <-0.853305, -1.004338, 1.132577>, <-0.428808, -0.894852, 1.277163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.888542, -1.063639, -4.871491>, <1.433205, -0.980966, -4.771546>, <2.032031, -0.630817, -4.691129>, <2.032031, -0.000768, -4.691129>,
      <0.341129, -0.984683, -2.559047>, <0.813038, -0.893185, -2.317298>, <1.369290, -0.592074, -2.072598>, <1.369290, -0.000388, -2.072598>,
      <-0.236877, -0.931379, -1.797623>, <0.171614, -0.831144, -1.509534>, <0.680458, -0.567541, -1.192804>, <0.680458, -0.000342, -1.192804>,
      <-0.428808, -0.894852, 1.277163>, <0.012960, -0.785367, 1.424176>, <0.567025, -0.552385, 1.568438>, <0.558434, 0.000001, 1.569320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.032031, -0.000768, -4.691129>, <2.032031, 0.629281, -4.691129>, <1.423148, 1.000441, -4.778364>, <0.910350, 1.069725, -4.870444>,
      <1.369290, -0.000388, -2.072598>, <1.369290, 0.591297, -2.072598>, <0.803646, 0.915660, -2.327357>, <0.360281, 0.992825, -2.552501>,
      <0.680458, -0.000342, -1.192804>, <0.680458, 0.566856, -1.192804>, <0.162849, 0.855930, -1.521705>, <-0.244554, 0.940834, -1.784462>,
      <0.558434, 0.000001, 1.569320>, <0.567025, 0.552388, 1.568438>, <0.000204, 0.813189, 1.415313>, <-0.424786, 0.906237, 1.282217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.910350, 1.069725, -4.870444>, <0.397552, 1.139010, -4.962523>, <-0.137639, 0.647224, -5.051388>, <-0.133098, 0.015935, -5.050634>,
      <0.360281, 0.992825, -2.552501>, <-0.083085, 1.069989, -2.777644>, <-0.558648, 0.608148, -3.008503>, <-0.554613, 0.015297, -3.006545>,
      <-0.244554, 0.940834, -1.784462>, <-0.651956, 1.025738, -2.047219>, <-1.023538, 0.583010, -2.340400>, <-1.019972, 0.014694, -2.337998>,
      <-0.424786, 0.906237, 1.282217>, <-0.832517, 0.999285, 1.151487>, <-1.258430, 0.568119, 1.008256>, <-1.263246, 0.014645, 1.006457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.263246, 0.014645, 1.006457>, <-1.250789, -0.538828, 1.010600>, <-0.853305, -1.004338, 1.132577>, <-0.428808, -0.894852, 1.277163>,
      <-1.489246, 0.014596, 4.356854>, <-1.485172, -0.524036, 4.356797>, <-1.061241, -0.977062, 4.350867>, <-0.603468, -0.858326, 4.354377>,
      <-0.370457, 0.014581, 6.390386>, <-0.366576, -0.536502, 6.388864>, <0.037261, -1.000000, 6.230514>, <0.469248, -0.866376, 6.071858>,
      <-0.408919, 0.017259, 6.490117>, <-0.404214, -0.650734, 6.488272>, <-0.134343, -1.421541, 6.367476>, <0.467408, -1.214825, 6.146512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.428808, -0.894852, 1.277163>, <0.012960, -0.785367, 1.424176>, <0.567025, -0.552385, 1.568438>, <0.558434, 0.000001, 1.569320>,
      <-0.603468, -0.858326, 4.354377>, <-0.145695, -0.739589, 4.357887>, <0.453592, -0.537229, 4.329679>, <0.453592, 0.000345, 4.329679>,
      <0.469248, -0.866376, 6.071858>, <0.901235, -0.732751, 5.913201>, <1.550849, -0.550000, 5.663221>, <1.550849, 0.000000, 5.663221>,
      <0.467408, -1.214825, 6.146512>, <1.069160, -1.008108, 5.925547>, <1.982608, -0.783386, 5.563596>, <1.982608, -0.003419, 5.563596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.558434, 0.000001, 1.569320>, <0.567025, 0.552388, 1.568438>, <0.000204, 0.813189, 1.415313>, <-0.424786, 0.906237, 1.282217>,
      <0.453592, 0.000345, 4.329679>, <0.453592, 0.537919, 4.329679>, <-0.162441, 0.770448, 4.352330>, <-0.587759, 0.871641, 4.351262>,
      <1.550849, 0.000000, 5.663221>, <1.550849, 0.550000, 5.663221>, <0.881448, 0.766703, 5.914122>, <0.482295, 0.880835, 6.063323>,
      <1.982608, -0.003419, 5.563596>, <1.982608, 0.776549, 5.563596>, <1.038619, 1.053793, 5.927153>, <0.484670, 1.230680, 6.134558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.424786, 0.906237, 1.282217>, <-0.832517, 0.999285, 1.151487>, <-1.258430, 0.568119, 1.008256>, <-1.263246, 0.014645, 1.006457>,
      <-0.587759, 0.871641, 4.351262>, <-1.013077, 0.972833, 4.350194>, <-1.493321, 0.553228, 4.356911>, <-1.489246, 0.014596, 4.356854>,
      <0.482295, 0.880835, 6.063323>, <0.083141, 0.994967, 6.212524>, <-0.374339, 0.565663, 6.391908>, <-0.370457, 0.014581, 6.390386>,
      <0.484670, 1.230680, 6.134558>, <-0.069279, 1.407567, 6.341964>, <-0.413624, 0.685252, 6.491962>, <-0.408919, 0.017259, 6.490117>
    }
  }
}
#declare BlobCorps = blob {
  threshold 0.6
  component 1.0, 1.358338, <-0.008439, -0.008439, 0.14346>
  component 0.98646, 1.087601, <0.379747, 0.008439, 0.0>
  component 1.0, 1.087601, <-0.362869, 0.008439, 0.0>
  component 1.0, 0.632938, <-0.830696, 0.025316, 0.013186>
  component 1.0, 1.358338, <0.008439, 0.008439, -0.075949>
  component -1.302989, 0.864998, <-0.042194, -0.312236, -1.105485>
  component -1.224997, 0.924203, <0.008439, -0.278481, 1.206751>
  component 1.0, 0.632938, <0.869198, 0.025316, 0.008439>
  component 1.0, 0.228455, <1.156118, 0.008439, 0.075949>
  component 1.0, 0.228455, <1.156118, 0.008439, -0.075949>
  scale <0.95, 0.7, 0.85>
  rotate <90.0, 0.0, 0.0>
}

#declare Un1Plume = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 3.0>
    rotate 90.0*y
    translate  1.5*y
  }
  sphere { // SphPlume
    <0,0,0>,1
    scale 0.5
    translate  1.5*y
  }
  scale <1.0, 0.5, 1.0>
}
#declare Un2Plume = union {
  sphere { // Sphere001
    <0,0,0>,1
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 2.0>
  }
  scale <4.0, 2.0, 4.0>
  rotate 90.0*y
  translate  -1.25*y
}
#declare Plume0 = difference {
  object { Un1Plume }
  object { Un2Plume }
  texture {
    TexMatMapPlume
    scale <5.1529, 0.9765, 1.6>
  translate <-1.882300, 0.261700, -0.800000>
  }
  scale <1.2, 1.2, 1.6>
  translate  -0.6*x
}
#declare AilDeplD = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.681276, -5.589511, 1.649098>, <2.506799, -5.241039, 1.649098>, <2.506962, -5.152608, 0.859271>, <2.507161, -5.152608, -0.106072>,
      <4.235777, -3.420909, 3.815844>, <4.235777, -3.264622, 3.815844>, <4.236013, -3.136750, 1.002243>, <4.236300, -3.136750, -2.436603>,
      <9.702306, -3.129523, 3.838566>, <9.702306, -2.397396, 3.838566>, <9.634838, -0.665575, 1.129880>, <9.635521, -0.665575, -2.180736>,
      <13.510582, -3.129523, 3.839056>, <13.510582, -2.397396, 3.839056>, <13.443114, -0.665575, 1.130371>, <13.443797, -0.665575, -2.180245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.507161, -5.152608, -0.106072>, <2.507360, -5.152608, -1.071415>, <2.507523, -5.241039, -1.861241>, <2.682000, -5.589511, -1.861241>,
      <4.236300, -3.136750, -2.436603>, <4.236588, -3.136750, -5.875449>, <4.236824, -3.264622, -8.689050>, <4.236824, -3.420909, -8.689050>,
      <9.635521, -0.665575, -2.180736>, <9.636204, -0.665575, -5.491352>, <9.704788, -2.397396, -8.200038>, <9.704788, -3.129523, -8.200038>,
      <13.443797, -0.665575, -2.180245>, <13.444480, -0.665575, -5.490861>, <13.513065, -2.397396, -8.199547>, <13.513065, -3.129523, -8.199547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.682000, -5.589511, -1.861241>, <2.856477, -5.937984, -1.861241>, <2.856314, -6.026414, -1.071415>, <2.856115, -6.026414, -0.106072>,
      <4.236824, -3.420909, -8.689050>, <4.236824, -3.577197, -8.689050>, <4.236588, -3.705069, -5.875449>, <4.236300, -3.705069, -2.436603>,
      <9.704788, -3.129523, -8.200038>, <9.704788, -3.861651, -8.200038>, <9.636204, -2.013438, -5.491352>, <9.635521, -2.013438, -2.180736>,
      <13.513065, -3.129523, -8.199547>, <13.513065, -3.861651, -8.199547>, <13.444480, -2.013438, -5.490861>, <13.443797, -2.013438, -2.180245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.856115, -6.026414, -0.106072>, <2.855916, -6.026414, 0.859271>, <2.855754, -5.937984, 1.649098>, <2.681276, -5.589511, 1.649098>,
      <4.236300, -3.705069, -2.436603>, <4.236013, -3.705069, 1.002243>, <4.235777, -3.577197, 3.815844>, <4.235777, -3.420909, 3.815844>,
      <9.635521, -2.013438, -2.180736>, <9.634838, -2.013438, 1.129880>, <9.702306, -3.861651, 3.838566>, <9.702306, -3.129523, 3.838566>,
      <13.443797, -2.013438, -2.180245>, <13.443114, -2.013438, 1.130371>, <13.510582, -3.861651, 3.839056>, <13.510582, -3.129523, 3.839056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.510582, -3.129523, 3.839056>, <13.510582, -2.397396, 3.839056>, <13.443114, -0.665575, 1.130371>, <13.443797, -0.665575, -2.180245>,
      <17.318858, -3.129523, 3.839547>, <17.318858, -2.397396, 3.839547>, <17.251391, -0.665575, 1.130861>, <17.252073, -0.665575, -2.179755>,
      <20.399832, -2.756009, 1.273687>, <20.399832, -2.543385, 1.273687>, <20.400152, -2.369419, -0.280108>, <20.400544, -2.369419, -2.179190>,
      <21.201761, -2.756009, -1.234285>, <21.201761, -2.697840, -1.234285>, <21.201848, -2.650247, -1.659368>, <21.201955, -2.650247, -2.178914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.443797, -0.665575, -2.180245>, <13.444480, -0.665575, -5.490861>, <13.513065, -2.397396, -8.199547>, <13.513065, -3.129523, -8.199547>,
      <17.252073, -0.665575, -2.179755>, <17.252756, -0.665575, -5.490371>, <17.321341, -2.397396, -8.199057>, <17.321341, -3.129523, -8.199057>,
      <20.400544, -2.369419, -2.179190>, <20.400935, -2.369419, -4.078272>, <20.401256, -2.543385, -5.632066>, <20.401256, -2.756009, -5.632066>,
      <21.201955, -2.650247, -2.178914>, <21.202063, -2.650247, -2.698460>, <21.202150, -2.697840, -3.123543>, <21.202150, -2.756009, -3.123543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.513065, -3.129523, -8.199547>, <13.513065, -3.861651, -8.199547>, <13.444480, -2.013438, -5.490861>, <13.443797, -2.013438, -2.180245>,
      <17.321341, -3.129523, -8.199057>, <17.321341, -3.861651, -8.199057>, <17.252756, -2.013438, -5.490371>, <17.252073, -2.013438, -2.179755>,
      <20.401256, -2.756009, -5.632066>, <20.401256, -2.968634, -5.632066>, <20.400935, -3.142599, -4.078272>, <20.400544, -3.142599, -2.179190>,
      <21.202150, -2.756009, -3.123543>, <21.202150, -2.814178, -3.123543>, <21.202063, -2.861771, -2.698460>, <21.201955, -2.861771, -2.178914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.443797, -2.013438, -2.180245>, <13.443114, -2.013438, 1.130371>, <13.510582, -3.861651, 3.839056>, <13.510582, -3.129523, 3.839056>,
      <17.252073, -2.013438, -2.179755>, <17.251391, -2.013438, 1.130861>, <17.318858, -3.861651, 3.839547>, <17.318858, -3.129523, 3.839547>,
      <20.400544, -3.142599, -2.179190>, <20.400152, -3.142599, -0.280108>, <20.399832, -2.968634, 1.273687>, <20.399832, -2.756009, 1.273687>,
      <21.201955, -2.861771, -2.178914>, <21.201848, -2.861771, -1.659368>, <21.201761, -2.814178, -1.234285>, <21.201761, -2.756009, -1.234285>
    }
  }
  rotate <0.0, -20.570927, 20.089581>
}
#declare AilDeplPlumD = union {
  object { AilDeplD }
  object { // Plume23->Plume0
    Plume0
    scale 1.5
    rotate <-179.380005, 15.41186, -166.92424>
    translate  <23.70395, 4.472143, 5.413925>
  }
  object { // Plume24->Plume0
    Plume0
    scale 1.5
    rotate <-164.100006, 23.46983, -173.241302>
    translate  <22.759382, 3.75047, 7.235203>
  }
  object { // Plume33->Plume0
    Plume0
    scale 1.4
    rotate <-159.433609, 30.501675, 171.246307>
    translate  <18.6443, 1.93075, 9.757982>
  }
  object { // Plume34->Plume0
    Plume0
    scale 1.2
    rotate <-217.24614, 37.013184, 168.962921>
    translate  <17.391655, 1.167587, 10.137922>
  }
  object { // Plume35->Plume0
    Plume0
    scale 1.5
    rotate <-167.369995, 6.339622, -165.357132>
    translate  <23.77888, 4.564279, 3.005975>
  }
  object { // Plume36->Plume0
    Plume0
    scale 1.4
    rotate <-161.929993, 5.8394, -161.143677>
    translate  <22.205346, 4.564279, 1.235203>
  }
  object { // Plume37->Plume0
    Plume0
    scale 1.2
    rotate <-152.789993, -1.672701, -166.431168>
    translate  <21.231254, 3.82719, -0.701523>
  }
  object { // Plume38->Plume0
    Plume0
    scale 1.5
    rotate <-152.75, 19.611683, -155.237396>
    translate  <21.639177, 4.903204, 5.950451>
  }
  object { // Plume39->Plume0
    Plume0
    scale 1.5
    rotate <-176.990005, -0.424592, -153.671204>
    translate  <22.401436, 4.472143, 1.264065>
  }
  object { // Plume40->Plume0
    Plume0
    scale 1.5
    rotate <-172.679993, 37.489941, -156.89061>
    translate  <20.155671, 4.02618, 8.736668>
  }
  object { // Plume41->Plume0
    Plume0
    scale 1.4
    rotate <-179.029999, 8.629639, -148.001251>
    translate  <22.070286, 5.77249, 4.186503>
  }
  object { // Plume42->Plume0
    Plume0
    scale 1.4
    rotate <-161.830002, 3.906987, 176.903824>
    translate  <21.696715, 3.065349, 2.644242>
  }
  object { // Plume43->Plume0
    Plume0
    scale 1.4
    rotate <-162.889999, 11.214452, 169.96701>
    translate  <22.173092, 2.308121, 6.751335>
  }
  object { // Plume44->Plume0
    Plume0
    scale 1.4
    rotate <-155.440002, 23.492559, 163.029633>
    translate  <20.380549, 1.764967, 8.108114>
  }
}
#declare AilDeplG = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.681276, 5.589511, 1.649098>, <2.506799, 5.241039, 1.649098>, <2.506962, 5.152608, 0.859271>, <2.507161, 5.152608, -0.106072>,
      <4.235777, 3.420909, 3.815844>, <4.235777, 3.264622, 3.815844>, <4.236013, 3.136750, 1.002243>, <4.236300, 3.136750, -2.436603>,
      <9.605572, 3.152455, 3.992777>, <9.605572, 2.401569, 3.992777>, <9.536376, 0.625376, 1.214690>, <9.537076, 0.625376, -2.180748>,
      <13.511422, 3.152455, 3.993280>, <13.511422, 2.401569, 3.993280>, <13.442225, 0.625376, 1.215193>, <13.442926, 0.625376, -2.180245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.507161, 5.152608, -0.106072>, <2.507360, 5.152608, -1.071415>, <2.507523, 5.241039, -1.861241>, <2.682000, 5.589511, -1.861241>,
      <4.236300, 3.136750, -2.436603>, <4.236588, 3.136750, -5.875449>, <4.236824, 3.264622, -8.689050>, <4.236824, 3.420909, -8.689050>,
      <9.537076, 0.625376, -2.180748>, <9.537776, 0.625376, -5.576187>, <9.608118, 2.401569, -8.354273>, <9.608118, 3.152455, -8.354273>,
      <13.442926, 0.625376, -2.180245>, <13.443626, 0.625376, -5.575684>, <13.513968, 2.401569, -8.353770>, <13.513968, 3.152455, -8.353770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.682000, 5.589511, -1.861241>, <2.856477, 5.937984, -1.861241>, <2.856314, 6.026414, -1.071415>, <2.856115, 6.026414, -0.106072>,
      <4.236824, 3.420909, -8.689050>, <4.236824, 3.577197, -8.689050>, <4.236588, 3.705069, -5.875449>, <4.236300, 3.705069, -2.436603>,
      <9.608118, 3.152455, -8.354273>, <9.608118, 3.903340, -8.354273>, <9.537776, 2.007773, -5.576187>, <9.537076, 2.007773, -2.180748>,
      <13.513968, 3.152455, -8.353770>, <13.513968, 3.903340, -8.353770>, <13.443626, 2.007773, -5.575684>, <13.442926, 2.007773, -2.180245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.856115, 6.026414, -0.106072>, <2.855916, 6.026414, 0.859271>, <2.855754, 5.937984, 1.649098>, <2.681276, 5.589511, 1.649098>,
      <4.236300, 3.705069, -2.436603>, <4.236013, 3.705069, 1.002243>, <4.235777, 3.577197, 3.815844>, <4.235777, 3.420909, 3.815844>,
      <9.537076, 2.007773, -2.180748>, <9.536376, 2.007773, 1.214690>, <9.605572, 3.903340, 3.992777>, <9.605572, 3.152455, 3.992777>,
      <13.442926, 2.007773, -2.180245>, <13.442225, 2.007773, 1.215193>, <13.511422, 3.903340, 3.993280>, <13.511422, 3.152455, 3.993280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.511422, 3.152455, 3.993280>, <13.511422, 2.401569, 3.993280>, <13.442225, 0.625376, 1.215193>, <13.442926, 0.625376, -2.180245>,
      <17.417271, 3.152455, 3.993783>, <17.417271, 2.401569, 3.993783>, <17.348075, 0.625376, 1.215696>, <17.348775, 0.625376, -2.179742>,
      <20.399832, 2.756009, 1.273687>, <20.399832, 2.543385, 1.273687>, <20.400152, 2.369419, -0.280108>, <20.400544, 2.369419, -2.179190>,
      <21.201788, 2.756009, -1.368554>, <21.201788, 2.706108, -1.368554>, <21.201863, 2.665280, -1.733216>, <21.201955, 2.665280, -2.178914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.442926, 0.625376, -2.180245>, <13.443626, 0.625376, -5.575684>, <13.513968, 2.401569, -8.353770>, <13.513968, 3.152455, -8.353770>,
      <17.348775, 0.625376, -2.179742>, <17.349475, 0.625376, -5.575181>, <17.419817, 2.401569, -8.353267>, <17.419817, 3.152455, -8.353267>,
      <20.400544, 2.369419, -2.179190>, <20.400935, 2.369419, -4.078272>, <20.401256, 2.543385, -5.632066>, <20.401256, 2.756009, -5.632066>,
      <21.201955, 2.665280, -2.178914>, <21.202047, 2.665280, -2.624612>, <21.202122, 2.706108, -2.989274>, <21.202122, 2.756009, -2.989274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.513968, 3.152455, -8.353770>, <13.513968, 3.903340, -8.353770>, <13.443626, 2.007773, -5.575684>, <13.442926, 2.007773, -2.180245>,
      <17.419817, 3.152455, -8.353267>, <17.419817, 3.903340, -8.353267>, <17.349475, 2.007773, -5.575181>, <17.348775, 2.007773, -2.179742>,
      <20.401256, 2.756009, -5.632066>, <20.401256, 2.968634, -5.632066>, <20.400935, 3.142599, -4.078272>, <20.400544, 3.142599, -2.179190>,
      <21.202122, 2.756009, -2.989274>, <21.202122, 2.805910, -2.989274>, <21.202047, 2.846738, -2.624612>, <21.201955, 2.846738, -2.178914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <13.442926, 2.007773, -2.180245>, <13.442225, 2.007773, 1.215193>, <13.511422, 3.903340, 3.993280>, <13.511422, 3.152455, 3.993280>,
      <17.348775, 2.007773, -2.179742>, <17.348075, 2.007773, 1.215696>, <17.417271, 3.903340, 3.993783>, <17.417271, 3.152455, 3.993783>,
      <20.400544, 3.142599, -2.179190>, <20.400152, 3.142599, -0.280108>, <20.399832, 2.968634, 1.273687>, <20.399832, 2.756009, 1.273687>,
      <21.201955, 2.846738, -2.178914>, <21.201863, 2.846738, -1.733216>, <21.201788, 2.805910, -1.368554>, <21.201788, 2.756009, -1.368554>
    }
  }
  rotate <0.0, -20.570927, -20.089581>
}
#declare AilDeplPlumG = union {
  object { AilDeplG }
  object { // Plume9->Plume0
    Plume0
    scale 1.5
    rotate <-0.618223, 15.41186, 166.92424>
    translate  <23.70395, -4.472143, 5.413925>
  }
  object { // Plume10->Plume0
    Plume0
    scale 1.5
    rotate <15.902899, 23.46983, 173.241302>
    translate  <22.759382, -3.75047, 7.235203>
  }
  object { // Plume11->Plume0
    Plume0
    scale 1.4
    rotate <30.823271, 31.445288, -176.533829>
    translate  <19.771134, -2.05299, 9.270021>
  }
  object { // Plume12->Plume0
    Plume0
    scale 1.2
    rotate <37.246132, 37.013184, -168.962921>
    translate  <17.391655, -1.167587, 10.137922>
  }
  object { // Plume13->Plume0
    Plume0
    scale 1.5
    rotate <-12.635045, 6.339622, 165.357132>
    translate  <23.77888, -4.564279, 3.005975>
  }
  object { // Plume14->Plume0
    Plume0
    scale 1.4
    rotate <-18.067417, 5.8394, 161.143677>
    translate  <22.205346, -4.564279, 1.235203>
  }
  object { // Plume15->Plume0
    Plume0
    scale 1.2
    rotate <-27.218685, -1.672701, 166.431168>
    translate  <21.231254, -3.82719, -0.701523>
  }
  object { // Plume16->Plume0
    Plume0
    scale 1.5
    rotate <27.248631, 19.611683, 155.237396>
    translate  <21.639177, -4.903204, 5.950451>
  }
  object { // Plume17->Plume0
    Plume0
    scale 1.5
    rotate <3.008756, -0.424592, 153.671204>
    translate  <22.401436, -4.472143, 1.264065>
  }
  object { // Plume18->Plume0
    Plume0
    scale 1.5
    rotate <-7.317406, 37.489941, 156.89061>
    translate  <20.155671, -4.02618, 8.736668>
  }
  object { // Plume19->Plume0
    Plume0
    scale 1.4
    rotate <0.970188, 8.629639, 148.001251>
    translate  <22.070286, -5.77249, 4.186503>
  }
  object { // Plume20->Plume0
    Plume0
    scale 1.4
    rotate <-18.172468, 3.906987, -176.903839>
    translate  <21.696715, -3.065349, 2.644242>
  }
  object { // Plume21->Plume0
    Plume0
    scale 1.4
    rotate <-17.113132, 11.214452, -169.96701>
    translate  <22.173092, -2.308121, 6.751335>
  }
  object { // Plume22->Plume0
    Plume0
    scale 1.4
    rotate <-24.564497, 23.492559, -163.029648>
    translate  <20.800282, -1.764967, 8.422914>
  }
}
#declare Corps03 = union {
  object { // BlobCorps3->BlobCorps
    BlobCorps
    rotate <0.0, 0.0, 0.0>
  }
  sphere { // BaseCou3
    <0,0,0>,1
    scale <0.25, 0.25, 0.5>
    rotate <0.0, -59.026997, 0.0>
    translate  <-0.89, 0.0, 0.003>
  }
  object { // Plume72->Plume0
    Plume0
    scale 0.15
    rotate <90.0, 11.690005, -180.0>
    translate  <1.487399, 0.0, 0.146804>
  }
  object { // Plume73->Plume0
    Plume0
    scale 0.145
    rotate <110.805458, 22.232855, -169.720963>
    translate  <1.534855, 0.174212, 0.194259>
  }
  object { // Plume74->Plume0
    Plume0
    scale 0.14
    rotate <-164.014633, 25.726416, -148.874451>
    translate  <1.373567, 0.261591, 0.234132>
  }
  object { // Plume75->Plume0
    Plume0
    scale 0.135
    rotate <102.910919, 8.262207, -163.755997>
    translate  <1.509048, 0.170785, 0.177651>
  }
  object { // Plume76->Plume0
    Plume0
    scale 0.13
    rotate <89.326729, 60.045109, -178.966843>
    translate  <1.236743, 0.058521, 0.427577>
  }
  object { // Plume77->Plume0
    Plume0
    scale 0.145
    rotate <88.866058, 55.982086, -178.700073>
    translate  <1.367258, -0.118918, 0.37684>
  }
  object { // Plume78->Plume0
    Plume0
    scale 0.14
    rotate <58.246136, 35.292183, 164.826569>
    translate  <1.408308, -0.191468, 0.318394>
  }
  object { // Plume79->Plume0
    Plume0
    scale 0.135
    rotate <69.956894, 24.824842, 164.992523>
    translate  <1.353639, -0.355492, 0.126358>
  }
  object { // Plume80->Plume0
    Plume0
    scale 0.13
    rotate <86.004341, 15.215815, -176.917938>
    translate  <1.350405, -0.173287, 0.215483>
  }
  object { // AilDeplPlumG2->AilDeplPlumD
    AilDeplPlumD
    scale 0.083333
    rotate <0.587665, -3.929617, -8.512289>
    translate  <-1.0, 0.9, 0.0>
  }
  object { // AilDeplPlumD2->AilDeplPlumG
    AilDeplPlumG
    scale 0.083333
    rotate <0.540649, 4.763305, 6.483114>
    translate  <-1.0, -0.9, 0.0>
  }
  texture {
    TextPlumNoir
    scale <1.2, 1.2, 3.0>
    rotate -90.0*y
  translate <1.300000, 0.000000, 0.000000>
  }
}
#declare Corps1 = union {
  object { // BlobCorps1->BlobCorps
    BlobCorps
    rotate <0.0, 0.0, 0.0>
  }
  sphere { // BaseCou1
    <0,0,0>,1
    scale <0.25, 0.25, 0.5>
    rotate <0.0, -59.026997, 0.0>
    translate  <-0.89, 0.0, 0.003>
  }
  object { // Plume54->Plume0
    Plume0
    scale 0.15
    rotate <90.0, 11.690005, -180.0>
    translate  <1.487399, 0.0, 0.146804>
  }
  object { // Plume55->Plume0
    Plume0
    scale 0.145
    rotate <110.805458, 22.232855, -169.720963>
    translate  <1.534855, 0.174212, 0.194259>
  }
  object { // Plume56->Plume0
    Plume0
    scale 0.14
    rotate <-164.014633, 25.726416, -148.874451>
    translate  <1.373567, 0.261591, 0.234132>
  }
  object { // Plume57->Plume0
    Plume0
    scale 0.135
    rotate <102.910919, 8.262207, -163.755997>
    translate  <1.509048, 0.170785, 0.177651>
  }
  object { // Plume58->Plume0
    Plume0
    scale 0.13
    rotate <89.326729, 60.045109, -178.966843>
    translate  <1.236743, 0.058521, 0.427577>
  }
  object { // Plume59->Plume0
    Plume0
    scale 0.145
    rotate <88.866058, 55.982086, -178.700073>
    translate  <1.367258, -0.118918, 0.37684>
  }
  object { // Plume60->Plume0
    Plume0
    scale 0.14
    rotate <58.246136, 35.292183, 164.826569>
    translate  <1.408308, -0.191468, 0.318394>
  }
  object { // Plume61->Plume0
    Plume0
    scale 0.135
    rotate <69.956894, 24.824842, 164.992523>
    translate  <1.353639, -0.355492, 0.126358>
  }
  object { // Plume62->Plume0
    Plume0
    scale 0.13
    rotate <86.004341, 15.215815, -176.917938>
    translate  <1.350405, -0.173287, 0.215483>
  }
  object { // AilDeplPlumG1->AilDeplPlumD
    AilDeplPlumD
    scale 0.083333
    translate  <-1.0, 0.9, 0.0>
  }
  object { // AilDeplPlumD1->AilDeplPlumG
    AilDeplPlumG
    scale 0.083333
    translate  <-1.0, -0.9, 0.0>
  }
  texture {
    TextPlumNoir
    scale <1.2, 1.2, 3.0>
    rotate -90.0*y
  translate <1.300000, 0.000000, 0.000000>
  }
}
#declare RefCou0 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.259320, 0.029118, -8.288118>, <-1.253274, -1.214864, -8.295330>, <-0.624228, -2.261137, -9.045716>, <0.193390, -2.261025, -9.980149>,
      <0.349528, 0.025913, -7.120551>, <0.355257, -1.083931, -7.126689>, <0.951341, -2.017386, -7.765314>, <1.712728, -1.992831, -8.547128>,
      <1.581896, 0.022821, -5.856237>, <1.587748, -0.949185, -5.860691>, <2.196547, -1.766709, -6.324081>, <2.957553, -1.723785, -6.878188>,
      <2.944612, 0.019875, -3.685275>, <2.943452, -0.800108, -3.706447>, <3.483435, -1.489769, -4.054801>, <4.156240, -1.438840, -4.442812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193390, -2.261025, -9.980149>, <1.011008, -2.260914, -10.914582>, <1.623545, -1.245333, -11.727071>, <1.623545, -0.003796, -11.727071>,
      <1.712728, -1.992831, -8.547128>, <2.474116, -1.968276, -9.328943>, <3.081328, -1.111116, -10.047314>, <3.081328, -0.003452, -10.047314>,
      <2.957553, -1.723785, -6.878188>, <3.718559, -1.680861, -7.432295>, <4.371972, -0.972993, -7.979915>, <4.371972, -0.002896, -7.979915>,
      <4.156240, -1.438840, -4.442812>, <4.812224, -1.387911, -4.875137>, <5.412954, -0.820192, -5.299574>, <5.423698, -0.001820, -5.272783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.623545, -0.003796, -11.727071>, <1.623545, 1.237742, -11.727071>, <1.008400, 2.253375, -10.916766>, <0.227820, 2.247779, -10.023868>,
      <3.081328, -0.003452, -10.047314>, <3.081328, 1.104212, -10.047314>, <2.468903, 1.967631, -9.329109>, <1.743983, 1.983988, -8.583489>,
      <4.371972, -0.002896, -7.979915>, <4.371972, 0.967200, -7.979915>, <3.711217, 1.685990, -7.432006>, <2.988466, 1.719015, -6.904367>,
      <5.423698, -0.001820, -5.272783>, <5.412954, 0.816552, -5.299574>, <4.803968, 1.397223, -4.874936>, <4.182841, 1.437931, -4.462408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.227820, 2.247779, -10.023868>, <-0.552760, 2.242184, -9.130969>, <-1.265366, 1.273099, -8.280905>, <-1.259320, 0.029118, -8.288118>,
      <1.743983, 1.983988, -8.583489>, <1.019063, 2.000346, -7.837869>, <0.343798, 1.135757, -7.114412>, <0.349528, 0.025913, -7.120551>,
      <2.988466, 1.719015, -6.904367>, <2.265714, 1.752039, -6.376728>, <1.576045, 0.994828, -5.851783>, <1.581896, 0.022821, -5.856237>,
      <4.182841, 1.437931, -4.462408>, <3.544783, 1.478640, -4.094378>, <2.933072, 0.839858, -3.699751>, <2.944612, 0.019875, -3.685275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.944612, 0.019875, -3.685275>, <2.943452, -0.800108, -3.706447>, <3.483435, -1.489769, -4.054801>, <4.156240, -1.438840, -4.442812>,
      <4.294629, 0.016929, -1.549961>, <4.299157, -0.651030, -1.552204>, <4.770322, -1.212830, -1.785521>, <5.338106, -1.153895, -2.051750>,
      <4.266733, 0.016572, -1.452148>, <4.271696, -0.653156, -1.453168>, <4.788066, -1.216443, -1.559286>, <5.396760, -1.142595, -1.670866>,
      <4.810042, 0.015935, 0.944645>, <4.828476, -0.615354, 0.921442>, <5.315209, -1.146312, 0.821414>, <5.867346, -1.063639, 0.744168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.156240, -1.438840, -4.442812>, <4.812224, -1.387911, -4.875137>, <5.412954, -0.820192, -5.299574>, <5.423698, -0.001820, -5.272783>,
      <5.338106, -1.153895, -2.051750>, <5.905890, -1.094961, -2.317979>, <6.453937, -0.667391, -2.619233>, <6.453937, -0.000744, -2.619233>,
      <5.396760, -1.142595, -1.670866>, <6.005453, -1.068747, -1.782446>, <6.633212, -0.669560, -1.938478>, <6.633212, -0.001148, -1.938478>,
      <5.867346, -1.063639, 0.744168>, <6.445449, -0.980966, 0.614284>, <7.054454, -0.630817, 0.463986>, <7.042446, -0.000768, 0.494917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.423698, -0.001820, -5.272783>, <5.412954, 0.816552, -5.299574>, <4.803968, 1.397223, -4.874936>, <4.182841, 1.437931, -4.462408>,
      <6.453937, -0.000744, -2.619233>, <6.453937, 0.665903, -2.619233>, <5.896719, 1.108455, -2.317866>, <5.360286, 1.156848, -2.064947>,
      <6.633212, -0.001148, -1.938478>, <6.633212, 0.667264, -1.938478>, <5.994394, 1.085222, -1.784783>, <5.420563, 1.146626, -1.678063>,
      <7.042446, -0.000768, 0.494917>, <7.054454, 0.629281, 0.463986>, <6.433132, 1.000441, 0.611985>, <5.888863, 1.069725, 0.737416>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.182841, 1.437931, -4.462408>, <3.544783, 1.478640, -4.094378>, <2.933072, 0.839858, -3.699751>, <2.944612, 0.019875, -3.685275>,
      <5.360286, 1.156848, -2.064947>, <4.823852, 1.205241, -1.812028>, <4.290100, 0.684888, -1.547719>, <4.294629, 0.016929, -1.549961>,
      <5.420563, 1.146626, -1.678063>, <4.846732, 1.208030, -1.571343>, <4.261770, 0.686300, -1.451128>, <4.266733, 0.016572, -1.452148>,
      <5.888863, 1.069725, 0.737416>, <5.370508, 1.139010, 0.810050>, <4.819119, 0.647224, 0.923364>, <4.810042, 0.015935, 0.944645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.810042, 0.015935, 0.944645>, <4.828476, -0.615354, 0.921442>, <5.315209, -1.146312, 0.821414>, <5.867346, -1.063639, 0.744168>,
      <5.380861, 0.015297, 3.296954>, <5.385255, -0.577553, 3.296052>, <5.842351, -1.076181, 3.202115>, <6.363898, -0.984683, 3.106564>,
      <5.805207, 0.014694, 4.390109>, <5.809256, -0.553621, 4.388661>, <6.230449, -1.031613, 4.237974>, <6.704614, -0.931379, 4.079772>,
      <7.178145, -0.021407, 7.159289>, <7.240750, -0.574065, 7.115254>, <7.668239, -1.024091, 6.971568>, <8.026654, -0.901415, 6.837842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.867346, -1.063639, 0.744168>, <6.445449, -0.980966, 0.614284>, <7.054454, -0.630817, 0.463986>, <7.042446, -0.000768, 0.494917>,
      <6.363898, -0.984683, 3.106564>, <6.885444, -0.893185, 3.011014>, <7.475695, -0.592074, 2.866450>, <7.475695, -0.000388, 2.866450>,
      <6.704614, -0.931379, 4.079772>, <7.178779, -0.831144, 3.921569>, <8.102337, -0.567541, 3.705741>, <8.102337, -0.000342, 3.705741>,
      <8.026654, -0.901415, 6.837842>, <8.464280, -0.778739, 6.626303>, <9.475960, -0.402635, 6.248580>, <9.438126, 0.063213, 6.291906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.042446, -0.000768, 0.494917>, <7.054454, 0.629281, 0.463986>, <6.433132, 1.000441, 0.611985>, <5.888863, 1.069725, 0.737416>,
      <7.475695, -0.000388, 2.866450>, <7.475695, 0.591297, 2.866450>, <6.871869, 0.915660, 3.008752>, <6.383076, 0.992825, 3.100097>,
      <8.102337, -0.000342, 3.705741>, <8.102337, 0.566856, 3.705741>, <7.163781, 0.855930, 3.921413>, <6.721041, 0.940834, 4.071134>,
      <9.438126, 0.063213, 6.291906>, <9.473505, 0.529060, 6.245631>, <8.398575, 0.817333, 6.647104>, <7.985148, 0.898063, 6.852868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.888863, 1.069725, 0.737416>, <5.370508, 1.139010, 0.810050>, <4.819119, 0.647224, 0.923364>, <4.810042, 0.015935, 0.944645>,
      <6.383076, 0.992825, 3.100097>, <5.894283, 1.069989, 3.191442>, <5.376468, 0.608148, 3.297857>, <5.380861, 0.015297, 3.296954>,
      <6.721041, 0.940834, 4.071134>, <6.278301, 1.025738, 4.220854>, <5.801159, 0.583010, 4.391558>, <5.805207, 0.014694, 4.390109>,
      <7.985148, 0.898063, 6.852868>, <7.651257, 0.978793, 6.981641>, <7.197535, 0.531251, 7.132110>, <7.178145, -0.021407, 7.159289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.178145, -0.021407, 7.159289>, <7.240750, -0.574065, 7.115254>, <7.668239, -1.024091, 6.971568>, <8.026654, -0.901415, 6.837842>,
      <8.633077, -0.057509, 9.857255>, <8.672244, -0.594509, 9.841847>, <9.106028, -1.016569, 9.705162>, <9.427905, -0.871451, 9.518100>,
      <9.518565, -0.499292, 11.643059>, <9.737048, -0.997496, 11.554925>, <10.277338, -1.235632, 11.321759>, <10.612946, -0.897993, 11.056130>,
      <9.489314, -0.526117, 11.742344>, <9.754147, -1.130013, 11.635513>, <10.294044, -1.705340, 11.392458>, <10.751677, -1.223611, 11.063083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <8.026654, -0.901415, 6.837842>, <8.464280, -0.778739, 6.626303>, <9.475960, -0.402635, 6.248580>, <9.438126, 0.063213, 6.291906>,
      <9.427905, -0.871451, 9.518100>, <9.749782, -0.726333, 9.331037>, <10.849583, -0.237729, 8.791420>, <10.847128, 0.126768, 8.788471>,
      <10.612946, -0.897993, 11.056130>, <10.948553, -0.560355, 10.790502>, <11.812506, 0.337939, 10.220802>, <11.678366, 0.649826, 10.274821>,
      <10.751677, -1.223611, 11.063083>, <11.209311, -0.741883, 10.733708>, <12.236956, 0.391890, 10.034918>, <12.046729, 0.834184, 10.111524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.438126, 0.063213, 6.291906>, <9.473505, 0.529060, 6.245631>, <8.398575, 0.817333, 6.647104>, <7.985148, 0.898063, 6.852868>,
      <10.847128, 0.126768, 8.788471>, <10.844672, 0.491264, 8.785522>, <9.633369, 0.778735, 9.372794>, <9.328791, 0.855291, 9.557610>,
      <11.678366, 0.649826, 10.274821>, <11.544225, 0.961713, 10.328840>, <10.345894, 0.791749, 11.030026>, <9.973178, 0.718400, 11.254331>,
      <12.046729, 0.834184, 10.111524>, <11.856501, 1.276478, 10.188129>, <10.377671, 1.115994, 11.063917>, <9.812865, 1.003338, 11.437543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.985148, 0.898063, 6.852868>, <7.651257, 0.978793, 6.981641>, <7.197535, 0.531251, 7.132110>, <7.178145, -0.021407, 7.159289>,
      <9.328791, 0.855291, 9.557610>, <9.024212, 0.931848, 9.742427>, <8.593910, 0.479492, 9.872662>, <8.633077, -0.057509, 9.857255>,
      <9.973178, 0.718400, 11.254331>, <9.600461, 0.645051, 11.478635>, <9.300082, -0.001088, 11.731193>, <9.518565, -0.499292, 11.643059>,
      <9.812865, 1.003338, 11.437543>, <9.248060, 0.890682, 11.811169>, <9.224480, 0.077779, 11.849175>, <9.489314, -0.526117, 11.742344>
    }
  }
}
#declare Tete8 = blob {
  threshold 0.6
  component 1.0, 1.0036, <-0.025316, 0.0, 0.008439>
  component 0.683129, 0.392655, <0.295359, -0.109705, -0.008439>
  component 0.683129, 0.392655, <0.295359, 0.008439, -0.008439>
  component 0.683129, 0.392655, <0.511568, -0.074661, -0.008296>
  component 1.001063, 0.167209, <0.246106, 0.207393, -0.31865>
  component 0.981833, 0.214589, <-0.141027, 0.201862, -0.351738>
  component 0.920857, 0.200592, <0.052539, 0.262697, -0.356306>
  component -3.844693, 0.519421, <0.06481, 0.090734, -0.791139>
  component 1.0, 0.251372, <-0.211713, 0.246279, -0.146273>
  component -1.949149, 0.994044, <0.43038, -1.341772, 0.0>
  component 0.889029, 0.119721, <0.329063, 0.163149, -0.293806>
  component -1.096506, 0.436868, <0.056169, 0.159865, -0.534684>
  component 0.973399, 0.210194, <-0.074661, 0.235045, -0.351738>
  component 0.877201, 0.207334, <0.196332, 0.223984, -0.347313>
  component 0.927999, 0.18794, <0.157618, 0.262697, -0.254401>
  component 0.915761, 0.221709, <-0.008296, 0.262697, -0.254401>
  component -6.918593, 0.223898, <0.091253, -0.074661, -0.57384>
  component 0.683129, 0.194592, <0.626498, -0.090734, -0.013826>
  component 1.0, 0.251372, <-0.211713, 0.246279, 0.146273>
  component -3.844693, 0.519421, <0.06481, 0.090734, 0.791139>
  component -1.096506, 0.436868, <0.056169, 0.159865, 0.534684>
  component 0.981833, 0.214589, <-0.141027, 0.201862, 0.351738>
  component 0.973399, 0.210194, <-0.074661, 0.235045, 0.351738>
  component 0.915761, 0.221709, <-0.008296, 0.262697, 0.254401>
  component 0.920857, 0.200592, <0.052539, 0.262697, 0.356306>
  component 0.927999, 0.18794, <0.157618, 0.262697, 0.254401>
  component 0.877201, 0.207334, <0.196332, 0.223984, 0.347313>
  component 1.001063, 0.167209, <0.246106, 0.207393, 0.31865>
  component 0.889029, 0.119721, <0.329063, 0.163149, 0.293806>
  component 1.0, 0.27765, <0.262697, -0.312471, 0.0>
  component 0.683129, 0.213189, <0.41202, -0.378837, -0.008296>
  component 0.683129, 0.068953, <0.483916, -0.400959, -0.013826>
  component -6.918593, 0.223898, <0.091253, -0.074661, 0.57384>

sturm
  rotate 90.0*x
}

#declare VideBouche = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  <0.5, 0.0, -0.5>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.55, 1.0>
    rotate -36.019333*y
    translate  <0.120038, 0.0, -1.06516>
  }
  texture {
    TexIntBouche
  }
  translate  <0.274808, 0.0, -0.116553>
}
#declare DiffTete1 = difference {
  object { Tete8 }
  object { VideBouche }
}
#declare UnBec2 = union {
  sphere { // Sphere6
    <0,0,0>,1
    scale 0.2
    translate  1.0*x
  }
  cone { // Bec12
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
    rotate -90.0*y
    translate  1.0*x
  }
  scale <0.4, 0.4, 0.15>
}
#declare DiffBec2 = difference {
  object { UnBec2 }
  cone { // Bec13
    <0,0,0>, 0.15, <0,0,1>, 1.0
    scale <0.1, 0.35, 1.0>
    rotate -90.0*y
    translate  0.403093*x
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale <0.04, 0.04, 0.025>
    translate  0.4*x
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.6, 0.2>
    translate  <-0.1, 0.0, 0.2>
  }
}
#declare BasBec1 = union {
  object { DiffBec2 }
  cylinder { // CylBec4
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <17.700001, 90.0, 0.0>
    translate  <-0.609105, 0.371395, 0.0>
  }
  cylinder { // CylBec5
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <-17.700001, 90.0, 0.0>
    translate  <-0.609105, -0.371421, 0.0>
  }
  torus { // Torus3
    0.05, 0.03  rotate -x*90
    translate  0.401379*x
  }
  texture {
    TexBec
  }
  scale 0.9
  rotate <0.0, 53.427345, 0.0>
  translate  <0.563976, 0.0, -0.571666>
}
#declare UnBec3 = union {
  sphere { // Sphere8
    <0,0,0>,1
    scale 0.2
    translate  1.0*x
  }
  cone { // Bec14
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
    rotate -90.0*y
    translate  1.0*x
  }
  scale <0.4, 0.4, 0.25>
}
#declare DiffBec3 = difference {
  object { UnBec3 }
  cone { // Bec15
    <0,0,0>, 0.15, <0,0,1>, 1.0
    scale <0.1, 0.35, 1.0>
    rotate -90.0*y
    translate  0.403093*x
  }
  sphere { // Sphere9
    <0,0,0>,1
    scale <0.04, 0.04, 0.025>
    translate  0.4*x
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.6, 0.2>
    translate  <-0.1, 0.0, -0.2>
  }
  cylinder { // CylNar2
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.05, 0.8>
    rotate <-176.0, 88.0, -180.0>
    translate  <-0.41211, -0.17, 0.068059>
  }
  cylinder { // CylNar3
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.05, 0.8>
    rotate <176.0, 88.000023, -180.0>
    translate  <-0.41211, 0.17, 0.068059>
  }
}
#declare HautBec1 = union {
  object { DiffBec3 }
  cylinder { // CylBec6
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <17.700001, 90.0, 0.0>
    translate  <-0.609105, 0.371395, 0.0>
  }
  cylinder { // CylBec7
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.05>
    rotate <-17.700001, 90.0, 0.0>
    translate  <-0.609105, -0.371421, 0.0>
  }
  torus { // Torus4
    0.05, 0.03  rotate -x*90
    translate  0.401379*x
  }
  texture {
    TexBec
  }
  scale 0.9
  translate  <0.838046, 0.0, -0.115809>
}
#declare TeteBo0 = union {
  object { DiffTete1 }
  object { BasBec1 }
  object { HautBec1 }
  sphere { // Oeil2
    <0,0,0>,1
    texture {
      TexNoirOeil
    }
    scale 0.13
    translate  <0.1, 0.35, 0.15>
  }
  sphere { // Oeil3
    <0,0,0>,1
    texture {
      TexNoirOeil
    }
    scale 0.13
    translate  <0.1, -0.35, 0.15>
  }
  torus { // TourOeil0
    1.075, 0.325  rotate -x*90
    scale 0.150893
    rotate <-77.046005, 8.836464, -3.059424>
    translate  <0.097458, -0.34, 0.144183>
  }
  torus { // TourOeil1
    1.075, 0.325  rotate -x*90
    scale 0.150893
    rotate <-103.0, 8.836464, 3.059424>
    translate  <0.097363, 0.34, 0.143436>
  }
  scale 3.7
  rotate -7.22363*y
}
#declare RefCou1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.302771, 0.029118, 2.223524>, <-2.301844, -1.214864, 2.214159>, <-2.205383, -2.261137, 1.239750>, <-2.056946, -2.261025, 0.007016>,
      <0.375153, 0.025913, 2.271730>, <0.373904, -1.083931, 2.263426>, <0.244003, -2.017386, 1.399550>, <0.104647, -1.992831, 0.317179>,
      <3.283580, 0.022821, 1.981261>, <3.279111, -0.949185, 1.975421>, <2.814099, -1.766709, 1.367860>, <2.257965, -1.723785, 0.608334>,
      <5.452752, 0.019875, 0.246038>, <5.441886, -0.800108, 0.208523>, <4.999313, -1.489769, -0.253308>, <4.484470, -1.438840, -0.797780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.056946, -2.261025, 0.007016>, <-1.908509, -2.260914, -1.225717>, <-1.860697, -1.245333, -2.242109>, <-1.860697, -0.003796, -2.242109>,
      <0.104647, -1.992831, 0.317179>, <-0.034710, -1.968276, -0.765191>, <-0.220173, -1.111116, -1.687344>, <-0.220173, -0.003452, -1.687344>,
      <2.257965, -1.723785, 0.608334>, <1.701830, -1.680861, -0.151192>, <1.152470, -0.972993, -0.803142>, <1.152470, -0.002896, -0.803142>,
      <4.484470, -1.438840, -0.797780>, <3.950229, -1.387911, -1.400464>, <3.417863, -0.820192, -1.903571>, <3.430803, -0.001820, -1.878830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.860697, -0.003796, -2.242109>, <-1.860697, 1.237742, -2.242109>, <-1.911894, 2.253375, -1.226051>, <-2.053159, 2.247779, -0.048503>,
      <-0.220173, -0.003452, -1.687344>, <-0.220173, 1.104212, -1.687344>, <-0.038080, 1.967631, -0.761210>, <0.095582, 1.983988, 0.270096>,
      <1.152470, -0.002896, -0.803142>, <1.152470, 0.967200, -0.803142>, <1.702139, 1.685990, -0.143851>, <2.231703, 1.719015, 0.577491>,
      <3.430803, -0.001820, -1.878830>, <3.417863, 0.816552, -1.903571>, <3.952494, 1.397223, -1.392723>, <4.460522, 1.437931, -0.820238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.053159, 2.247779, -0.048503>, <-2.194424, 2.242184, 1.129045>, <-2.303699, 1.273099, 2.232890>, <-2.302771, 0.029118, 2.223524>,
      <0.095582, 1.983988, 0.270096>, <0.229245, 2.000346, 1.301402>, <0.376401, 1.135757, 2.280033>, <0.375153, 0.025913, 2.271730>,
      <2.231703, 1.719015, 0.577491>, <2.761268, 1.752039, 1.298833>, <3.288050, 0.994828, 1.987100>, <3.283580, 0.022821, 1.981261>,
      <4.460522, 1.437931, -0.820238>, <4.949031, 1.478640, -0.305778>, <5.450394, 0.839858, 0.217401>, <5.452752, 0.019875, 0.246038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.452752, 0.019875, 0.246038>, <5.441886, -0.800108, 0.208523>, <4.999313, -1.489769, -0.253308>, <4.484470, -1.438840, -0.797780>,
      <7.608700, 0.016929, -1.555337>, <7.604661, -0.651030, -1.558375>, <7.184526, -1.212830, -1.874476>, <6.691577, -1.153895, -2.262107>,
      <8.100488, 0.016572, -2.275447>, <8.096135, -0.653156, -2.278039>, <7.643180, -1.216443, -2.547726>, <7.118347, -1.142595, -2.875611>,
      <9.499014, 0.015935, -3.960028>, <9.470390, -0.615354, -4.009982>, <9.064386, -1.146312, -4.293856>, <8.629221, -1.063639, -4.587556>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.484470, -1.438840, -0.797780>, <3.950229, -1.387911, -1.400464>, <3.417863, -0.820192, -1.903571>, <3.430803, -0.001820, -1.878830>,
      <6.691577, -1.153895, -2.262107>, <6.198628, -1.094961, -2.649737>, <5.683257, -0.667391, -3.004000>, <5.683257, -0.000744, -3.004000>,
      <7.118347, -1.142595, -2.875611>, <6.593515, -1.068747, -3.203496>, <6.024635, -0.669560, -3.511397>, <6.024635, -0.001148, -3.511397>,
      <8.629221, -1.063639, -4.587556>, <8.138951, -0.980966, -4.969101>, <7.613608, -0.630817, -5.308226>, <7.644295, -0.000768, -5.268122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.430803, -0.001820, -1.878830>, <3.417863, 0.816552, -1.903571>, <3.952494, 1.397223, -1.392723>, <4.460522, 1.437931, -0.820238>,
      <5.683257, -0.000744, -3.004000>, <5.683257, 0.665903, -3.004000>, <6.202849, 1.108455, -2.641595>, <6.669822, 1.156848, -2.275992>,
      <6.024635, -0.001148, -3.511397>, <6.024635, 0.667264, -3.511397>, <6.600109, 1.085222, -3.194314>, <7.095914, 1.146626, -2.886340>,
      <7.644295, -0.000768, -5.268122>, <7.613608, 0.629281, -5.308226>, <8.145608, 1.000441, -4.958506>, <8.609533, 1.069725, -4.598458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.460522, 1.437931, -0.820238>, <4.949031, 1.478640, -0.305778>, <5.450394, 0.839858, 0.217401>, <5.452752, 0.019875, 0.246038>,
      <6.669822, 1.156848, -2.275992>, <7.136794, 1.205241, -1.910389>, <7.612738, 0.684888, -1.552299>, <7.608700, 0.016929, -1.555337>,
      <7.095914, 1.146626, -2.886340>, <7.591719, 1.208030, -2.578365>, <8.104842, 0.686300, -2.272855>, <8.100488, 0.016572, -2.275447>,
      <8.609533, 1.069725, -4.598458>, <9.018258, 1.139010, -4.326108>, <9.478195, 0.647224, -4.004525>, <9.499014, 0.015935, -3.960028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.499014, 0.015935, -3.960028>, <9.470390, -0.615354, -4.009982>, <9.064386, -1.146312, -4.293856>, <8.629221, -1.063639, -4.587556>,
      <10.848096, 0.015297, -5.739060>, <10.844645, -0.577553, -5.741924>, <10.485591, -1.076181, -6.039987>, <10.084989, -0.984683, -6.387347>,
      <11.436089, 0.014694, -6.753615>, <11.432428, -0.553621, -6.755869>, <11.051522, -1.031613, -6.990433>, <10.631635, -0.931379, -7.261646>,
      <12.807823, 0.014645, -9.461343>, <12.751037, -0.538828, -9.524716>, <12.369798, -1.004338, -9.734404>, <12.010914, -0.894852, -9.916303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <8.629221, -1.063639, -4.587556>, <8.138951, -0.980966, -4.969101>, <7.613608, -0.630817, -5.308226>, <7.644295, -0.000768, -5.268122>,
      <10.084989, -0.984683, -6.387347>, <9.684387, -0.893185, -6.734707>, <9.202582, -0.592074, -7.105055>, <9.202582, -0.000388, -7.105055>,
      <10.631635, -0.931379, -7.261646>, <10.211749, -0.831144, -7.532858>, <9.690427, -0.567541, -7.828601>, <9.690427, -0.000342, -7.828601>,
      <12.010914, -0.894852, -9.916303>, <11.542325, -0.785367, -10.214044>, <11.007516, -0.552385, -10.483685>, <11.064350, 0.000001, -10.429907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.644295, -0.000768, -5.268122>, <7.613608, 0.629281, -5.308226>, <8.145608, 1.000441, -4.958506>, <8.609533, 1.069725, -4.598458>,
      <9.202582, -0.000388, -7.105055>, <9.202582, 0.591297, -7.105055>, <9.691108, 0.915660, -6.722697>, <10.067953, 0.992825, -6.398274>,
      <9.690427, -0.000342, -7.828601>, <9.690427, 0.566856, -7.828601>, <10.221003, 0.855930, -7.521054>, <10.614625, 0.940834, -7.269068>,
      <11.064350, 0.000001, -10.429907>, <11.007516, 0.552388, -10.483685>, <11.553190, 0.813189, -10.201904>, <11.994709, 0.906237, -9.922211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <8.609533, 1.069725, -4.598458>, <9.018258, 1.139010, -4.326108>, <9.478195, 0.647224, -4.004525>, <9.499014, 0.015935, -3.960028>,
      <10.067953, 0.992825, -6.398274>, <10.444798, 1.069989, -6.073851>, <10.851547, 0.608148, -5.736195>, <10.848096, 0.015297, -5.739060>,
      <10.614625, 0.940834, -7.269068>, <11.008246, 1.025738, -7.017082>, <11.439750, 0.583010, -6.751360>, <11.436089, 0.014694, -6.753615>,
      <11.994709, 0.906237, -9.922211>, <12.326485, 0.999285, -9.758228>, <12.758365, 0.568119, -9.520685>, <12.807823, 0.014645, -9.461343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <12.807823, 0.014645, -9.461343>, <12.751037, -0.538828, -9.524716>, <12.369798, -1.004338, -9.734404>, <12.010914, -0.894852, -9.916303>,
      <14.073313, 0.014596, -12.291786>, <14.069645, -0.524036, -12.293562>, <13.688074, -0.977062, -12.478376>, <13.280488, -0.858326, -12.686803>,
      <14.744398, 0.014581, -14.162934>, <14.740459, -0.536502, -14.164303>, <14.330724, -1.000000, -14.306695>, <13.899407, -0.866376, -14.467164>,
      <14.838480, 0.017259, -14.213669>, <14.833707, -0.650734, -14.215328>, <14.550153, -1.421541, -14.299109>, <13.949362, -1.214825, -14.522672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <12.010914, -0.894852, -9.916303>, <11.542325, -0.785367, -10.214044>, <11.007516, -0.552385, -10.483685>, <11.064350, 0.000001, -10.429907>,
      <13.280488, -0.858326, -12.686803>, <12.872901, -0.739589, -12.895230>, <12.324605, -0.537229, -13.138769>, <12.324605, 0.000345, -13.138769>,
      <13.899407, -0.866376, -14.467164>, <13.468090, -0.732751, -14.627633>, <12.812071, -0.550000, -14.860288>, <12.812071, 0.000000, -14.860288>,
      <13.949362, -1.214825, -14.522672>, <13.348570, -1.008108, -14.746234>, <12.419324, -0.783386, -15.065447>, <12.419324, -0.003419, -15.065447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.064350, 0.000001, -10.429907>, <11.007516, 0.552388, -10.483685>, <11.553190, 0.813189, -10.201904>, <11.994709, 0.906237, -9.922211>,
      <12.324605, 0.000345, -13.138769>, <12.324605, 0.537919, -13.138769>, <12.885378, 0.770448, -12.882753>, <13.265050, 0.871641, -12.691063>,
      <12.812071, 0.000000, -14.860288>, <12.812071, 0.550000, -14.860288>, <13.483719, 0.766703, -14.615462>, <13.883946, 0.880835, -14.469167>,
      <12.419324, -0.003419, -15.065447>, <12.419324, 0.776549, -15.065447>, <13.372813, 1.053793, -14.727589>, <13.928475, 1.230680, -14.524820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.994709, 0.906237, -9.922211>, <12.326485, 0.999285, -9.758228>, <12.758365, 0.568119, -9.520685>, <12.807823, 0.014645, -9.461343>,
      <13.265050, 0.871641, -12.691063>, <13.644723, 0.972833, -12.499373>, <14.076980, 0.553228, -12.290010>, <14.073313, 0.014596, -12.291786>,
      <13.883946, 0.880835, -14.469167>, <14.284173, 0.994967, -14.322872>, <14.748336, 0.565663, -14.161566>, <14.744398, 0.014581, -14.162934>,
      <13.928475, 1.230680, -14.524820>, <14.484138, 1.407567, -14.322051>, <14.843254, 0.685252, -14.212010>, <14.838480, 0.017259, -14.213669>
    }
  }
}
#declare AilPlieG = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.247287, 1.396393, -3.953024>, <3.880131, 1.298675, -4.434120>, <2.312443, 1.466148, -3.802512>, <-0.147577, 1.520129, -3.507236>,
      <6.855320, 1.556725, -3.167328>, <4.260850, 0.892623, -2.850285>, <2.465440, 0.818192, -2.516420>, <-0.071014, 0.757252, -2.481673>,
      <7.458863, 1.621637, -1.769704>, <4.641570, 0.486571, -1.266451>, <2.257682, -0.044680, -1.148282>, <-0.174828, -0.113083, -1.415087>,
      <7.797586, 1.628823, -0.360410>, <5.013633, 0.563554, 0.321859>, <2.427789, -0.078033, 0.281583>, <-0.074833, -0.148749, 0.143095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.797586, 1.628823, -0.360410>, <5.013633, 0.563554, 0.321859>, <2.427789, -0.078033, 0.281583>, <-0.074833, -0.148749, 0.143095>,
      <8.136308, 1.636010, 1.048884>, <5.385697, 0.640537, 1.910168>, <2.597896, -0.111385, 1.711447>, <-0.004591, -0.184416, 1.716154>,
      <8.234335, 1.585965, 2.570210>, <5.755197, 1.020980, 3.502952>, <3.199207, 0.476225, 2.925256>, <0.296129, 0.522710, 2.697244>,
      <7.924921, 1.608747, 3.578771>, <6.124698, 1.401423, 5.095737>, <3.268685, 1.278753, 4.235535>, <0.330933, 1.337295, 3.726570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.147577, 1.520129, -3.507236>, <-2.607597, 1.574109, -3.211961>, <-5.274917, 1.599450, -1.745059>, <-6.048957, 1.706840, -0.389820>,
      <-0.071014, 0.757252, -2.481673>, <-2.607467, 0.696312, -2.446926>, <-5.310072, 1.023072, -1.137910>, <-6.048801, 1.707056, -0.259880>,
      <-0.174828, -0.113083, -1.415087>, <-2.607337, -0.181486, -1.681891>, <-5.331218, 0.675427, -0.568955>, <-6.048644, 1.707273, -0.129940>,
      <-0.074833, -0.148749, 0.143095>, <-2.607208, -0.219466, 0.019485>, <-5.348878, 0.606927, -0.164783>, <-6.048487, 1.707490, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.074833, -0.148749, 0.143095>, <-2.607208, -0.219466, 0.019485>, <-5.348878, 0.606927, -0.164783>, <-6.048487, 1.707490, 0.000000>,
      <-0.004591, -0.184416, 1.716154>, <-2.607078, -0.257447, 1.720861>, <-5.366537, 0.538426, 0.239389>, <-6.048331, 1.707707, 0.129940>,
      <0.296129, 0.522710, 2.697244>, <-2.606949, 0.569195, 2.469233>, <-5.376294, 0.978183, 0.740919>, <-6.048174, 1.707924, 0.259880>,
      <0.330933, 1.337295, 3.726570>, <-2.606819, 1.395838, 3.217605>, <-5.335563, 1.644440, 1.222529>, <-6.048017, 1.708140, 0.389820>
    }
  }
}
#declare AilPliePlumG = union {
  object { AilPlieG }
  object { // Plume1->Plume0
    Plume0
    scale 1.5
    rotate <1.300587, 7.179993, -169.704651>
    translate  <10.158492, 3.319497, 4.03632>
  }
  object { // Plume2->Plume0
    Plume0
    scale 1.35
    rotate <1.300587, 7.179993, -169.704651>
    translate  <10.99972, 3.159392, 2.056076>
  }
  object { // Plume3->Plume0
    Plume0
    scale 1.215
    rotate <0.407228, 2.258992, -169.778229>
    translate  <10.016965, 3.159392, -0.19617>
  }
  object { // Plume4->Plume0
    Plume0
    scale 1.0935
    rotate <-0.388005, -2.152428, -169.778976>
    translate  <9.344104, 2.999287, -2.480096>
  }
  object { // Plume5->Plume0
    Plume0
    scale 0.98415
    rotate <-1.593484, -8.773651, -169.664017>
    translate  <8.515991, 2.75913, -3.73485>
  }
  object { // Plume6->Plume0
    Plume0
    scale 1.215
    rotate <0.407228, 2.258992, -169.778229>
    translate  <10.055889, 3.159392, 0.738393>
  }
  object { // Plume7->Plume0
    Plume0
    scale 1.215
    rotate <-0.006969, -0.038694, -169.786224>
    translate  <9.572019, 3.159392, -1.319537>
  }
  object { // Plume8->Plume0
    Plume0
    scale 1.215
    rotate <1.147078, 6.340014, -169.722733>
    translate  <9.864715, 3.159392, 3.018677>
  }
}
#declare AilPlieD1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.247287, -1.396393, -3.953024>, <3.880131, -1.298675, -4.434120>, <2.312443, -1.466148, -3.802512>, <-0.147577, -1.520129, -3.507236>,
      <6.855320, -1.556725, -3.167328>, <4.260850, -0.892623, -2.850285>, <2.465440, -0.818192, -2.516420>, <-0.071014, -0.757252, -2.481673>,
      <7.458863, -1.621637, -1.769704>, <4.641570, -0.486571, -1.266451>, <2.257682, 0.044680, -1.148282>, <-0.174828, 0.113083, -1.415087>,
      <7.797586, -1.628823, -0.360410>, <5.013633, -0.563554, 0.321859>, <2.427789, 0.078033, 0.281583>, <-0.089709, 0.020026, 0.150534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.797586, -1.628823, -0.360410>, <5.013633, -0.563554, 0.321859>, <2.427789, 0.078033, 0.281583>, <-0.089709, 0.020026, 0.150534>,
      <8.136308, -1.636010, 1.048884>, <5.385697, -0.640537, 1.910168>, <2.597896, 0.111385, 1.711447>, <-0.004591, 0.184416, 1.716154>,
      <8.234335, -1.585965, 2.570210>, <5.755197, -1.020980, 3.502952>, <3.199207, -0.476225, 2.925256>, <0.296129, -0.522710, 2.697244>,
      <7.924921, -1.608747, 3.578771>, <6.124698, -1.401423, 5.095737>, <3.268685, -1.278753, 4.235535>, <0.330933, -1.337295, 3.726570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.147577, -1.520129, -3.507236>, <-2.607597, -1.574109, -3.211961>, <-5.274917, -1.599450, -1.745059>, <-6.048957, -1.706840, -0.389820>,
      <-0.071014, -0.757252, -2.481673>, <-2.607467, -0.696312, -2.446926>, <-5.310072, -1.023072, -1.137910>, <-6.048801, -1.707056, -0.259880>,
      <-0.174828, 0.113083, -1.415087>, <-2.607337, 0.181486, -1.681891>, <-5.331218, -0.675427, -0.568955>, <-6.048644, -1.707273, -0.129940>,
      <-0.089709, 0.020026, 0.150534>, <-2.607208, 0.219466, 0.019485>, <-5.348878, -0.606927, -0.164783>, <-6.048487, -1.707490, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.089709, 0.020026, 0.150534>, <-2.607208, 0.219466, 0.019485>, <-5.348878, -0.606927, -0.164783>, <-6.048487, -1.707490, 0.000000>,
      <-0.004591, 0.184416, 1.716154>, <-2.607078, 0.257447, 1.720861>, <-5.366537, -0.538426, 0.239389>, <-6.048331, -1.707707, 0.129940>,
      <0.296129, -0.522710, 2.697244>, <-2.606949, -0.569195, 2.469233>, <-5.376294, -0.978183, 0.740919>, <-6.048174, -1.707924, 0.259880>,
      <0.330933, -1.337295, 3.726570>, <-2.606819, -1.395838, 3.217605>, <-5.335563, -1.644440, 1.222529>, <-6.048017, -1.708140, 0.389820>
    }
  }
}
#declare AilPliePlumD = union {
  object { AilPlieD1 }
  object { // Plume25->Plume0
    Plume0
    scale 1.5
    rotate <-181.300583, 7.179993, 169.704651>
    translate  <10.158492, -3.319497, 4.03632>
  }
  object { // Plume26->Plume0
    Plume0
    scale 1.35
    rotate <-181.300583, 7.179993, 169.704651>
    translate  <10.99972, -3.159392, 2.056076>
  }
  object { // Plume27->Plume0
    Plume0
    scale 1.215
    rotate <-180.407227, 2.258992, 169.778214>
    translate  <10.016965, -3.159392, -0.19617>
  }
  object { // Plume28->Plume0
    Plume0
    scale 1.0935
    rotate <-179.612, -2.152428, 169.778976>
    translate  <9.344104, -2.999287, -2.480096>
  }
  object { // Plume29->Plume0
    Plume0
    scale 0.98415
    rotate <-178.410004, -8.773651, 169.664017>
    translate  <8.515991, -2.75913, -3.73485>
  }
  object { // Plume30->Plume0
    Plume0
    scale 1.215
    rotate <-180.407227, 2.258992, 169.778214>
    translate  <10.055889, -3.159392, 0.738393>
  }
  object { // Plume31->Plume0
    Plume0
    scale 1.215
    rotate <-179.992996, -0.038694, 169.786224>
    translate  <9.572019, -3.159392, -1.319537>
  }
  object { // Plume32->Plume0
    Plume0
    scale 1.215
    rotate <-181.147064, 6.340014, 169.722733>
    translate  <9.864715, -3.159392, 3.018677>
  }
}
#declare Corps02 = union {
  object { // BlobCorps2->BlobCorps
    BlobCorps
    rotate <0.0, 0.0, 0.0>
  }
  sphere { // BaseCou2
    <0,0,0>,1
    scale <0.25, 0.25, 0.5>
    rotate <180.0, -86.224472, -180.0>
    translate  <-0.89, 0.0, 0.003>
  }
  object { // Plume63->Plume0
    Plume0
    scale 0.15
    rotate <90.0, -18.208359, -180.0>
    translate  <1.388535, 0.0, -0.074652>
  }
  object { // Plume64->Plume0
    Plume0
    scale 0.145
    rotate <103.813416, -17.715113, 174.488251>
    translate  <1.388535, 0.129651, -0.074652>
  }
  object { // Plume65->Plume0
    Plume0
    scale 0.14
    rotate <135.747131, -14.284135, 175.132141>
    translate  <1.384863, 0.124406, -0.048881>
  }
  object { // Plume66->Plume0
    Plume0
    scale 0.135
    rotate <102.081367, -17.830868, -175.706635>
    translate  <1.358773, 0.170785, -0.027988>
  }
  object { // Plume67->Plume0
    Plume0
    scale 0.13
    rotate <88.218964, -22.3983, -179.442078>
    translate  <1.244911, 0.058521, 0.071968>
  }
  object { // Plume68->Plume0
    Plume0
    scale 0.145
    rotate <87.54953, -18.192804, -179.234528>
    translate  <1.403778, -0.118918, -0.074652>
  }
  object { // Plume69->Plume0
    Plume0
    scale 0.14
    rotate <71.052277, -17.282021, 167.071289>
    translate  <1.388535, -0.191468, -0.081019>
  }
  object { // Plume70->Plume0
    Plume0
    scale 0.135
    rotate <75.556435, -19.107733, -173.397354>
    translate  <1.266588, -0.236167, -0.136188>
  }
  object { // Plume71->Plume0
    Plume0
    scale 0.13
    rotate <83.360764, -31.633789, -176.506485>
    translate  <1.211994, -0.173287, 0.025663>
  }
  object { // AilPliePlumG2->AilPliePlumG
    AilPliePlumG
    scale 0.083333
    rotate <14.98, 0.435, -6.0>
    translate  <-0.258795, -0.741337, -0.145814>
  }
  object { // AilPliePlumD2->AilPliePlumD
    AilPliePlumD
    scale 0.083333
    rotate <-14.98, 0.435, 6.0>
    translate  <-0.258, 0.725, -0.146>
  }
  texture {
    TextPlumNoir
    scale <1.2, 1.2, 3.0>
    rotate -90.0*y
  translate <1.300000, 0.000000, 0.000000>
  }
}
#declare Corps0 = union {
  object { // BlobCorps0->BlobCorps
    BlobCorps
    rotate <0.0, 0.0, 0.0>
  }
  sphere { // BaseCou0
    <0,0,0>,1
    scale <0.25, 0.25, 0.5>
    rotate -40.0*y
    translate  <-0.89, 0.0, 0.003>
  }
  object { // Plume45->Plume0
    Plume0
    scale 0.15
    rotate <90.0, -18.208359, -180.0>
    translate  <1.388535, 0.0, -0.074652>
  }
  object { // Plume46->Plume0
    Plume0
    scale 0.145
    rotate <103.813416, -17.715113, 174.488251>
    translate  <1.388535, 0.129651, -0.074652>
  }
  object { // Plume47->Plume0
    Plume0
    scale 0.14
    rotate <135.747131, -14.284135, 175.132141>
    translate  <1.384863, 0.124406, -0.048881>
  }
  object { // Plume48->Plume0
    Plume0
    scale 0.135
    rotate <102.081367, -17.830868, -175.706635>
    translate  <1.358773, 0.170785, -0.027988>
  }
  object { // Plume49->Plume0
    Plume0
    scale 0.13
    rotate <88.218964, -22.3983, -179.442078>
    translate  <1.244911, 0.058521, 0.071968>
  }
  object { // Plume50->Plume0
    Plume0
    scale 0.145
    rotate <87.54953, -18.192804, -179.234528>
    translate  <1.403778, -0.118918, -0.074652>
  }
  object { // Plume51->Plume0
    Plume0
    scale 0.14
    rotate <71.052277, -17.282021, 167.071289>
    translate  <1.388535, -0.191468, -0.081019>
  }
  object { // Plume52->Plume0
    Plume0
    scale 0.135
    rotate <75.556435, -19.107733, -173.397354>
    translate  <1.266588, -0.236167, -0.136188>
  }
  object { // Plume53->Plume0
    Plume0
    scale 0.13
    rotate <83.360764, -31.633789, -176.506485>
    translate  <1.211994, -0.173287, 0.025663>
  }
  object { // AilPliePlumG1->AilPliePlumG
    AilPliePlumG
    scale 0.083333
    rotate <14.98, 0.435, -6.0>
    translate  <-0.25867, -0.756142, -0.145829>
  }
  object { // AilPliePlumD1->AilPliePlumD
    AilPliePlumD
    scale 0.083333
    rotate <-14.98, 0.435, 6.0>
    translate  <-0.258, 0.725, -0.146>
  }
  texture {
    TextPlumNoir
    scale <1.2, 1.2, 3.0>
    rotate <0.0, -90.0, 0.0>
  translate <1.300000, 0.000000, 0.000000>
  }
}
object { UnionCuisse0 }
object { Un1Plume }
object { Un2Plume }
object { DiffTete1 }
object { BasBec1 }
object { HautBec1 }
object { DiffTete0 }
object { BasBec0 }
object { HautBec0 }
object { AilPlieG }
object { AilDeplG }
object { AilPlieD1 }
object { AilDeplD }
object { DiffMollet0 }
object { Ongle0 }


#declare SangleBonb0 = object {
  cylinder { // SangleBonb0
    <0,0,1>, <0,0,0>, 1
    texture {
      TexSangles
    }
    scale <2.1, 2.1, 0.4>
    translate  1.5*z
  }
}
#declare BonBonne0 = union {
  sphere { // SphReserv1
    <0,0,0>,1
    scale 2.0
    translate  5.0*z
  }
  cylinder { // CylReserv0
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 5.0>
  }
  sphere { // SphReserv0
    <0,0,0>,1
    scale 2.0
  }
  torus { // ToreBonbonne0
    2.0, 0.1  rotate -x*90
  }
  torus { // ToreBonbonne1
    2.0, 0.1  rotate -x*90
    translate  2.5*z
  }
  torus { // ToreBonbonne2
    2.0, 0.1  rotate -x*90
    translate  5.0*z
  }
  object { SangleBonb0 }
  object { // SangleBonb1->SangleBonb0
    SangleBonb0
    translate  2.5*z
  }
  cylinder { // SortieBonb0
    <0,0,1>, <0,0,0>, 1
    texture {
      TexTuyau
    }
    scale <0.5, 0.5, 1.0>
    translate  6.1*z
  }
  sphere { // SphSortieBonb
    <0,0,0>,1
    texture {
      TexTuyau
    }
    scale <0.5, 0.5, 0.35>
    translate  7.1*z
  }
  texture {
    TexBonbonne
  }
  scale <0.6, 1.0, 0.9>
  rotate <0.0, 90.0, 0.0>
  translate  <-2.75, -2.2, 0.0>
}
#declare FixBonb0 = object {
  superellipsoid { // FixBonb0
    <0.1, 0.4>
    texture {
      TexCarcasse
    }
    scale <0.4, 4.4, 1.0>
    translate  <-1.25, 0.0, -0.75>
  }
}
#declare Boucle = difference {
  superellipsoid { // Boucle0
    <0.1, 0.3>
    scale <1.5, 0.4, 1.0>
  }
  box { // TrouBoucle
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.5, 0.4>
  }
  texture {
    TexBoucleHarnais
  }
  scale 0.5
  rotate 31.0*x
  translate  <0.0, -2.37516, -2.398332>
}
#declare FixReac0 = object {
  superellipsoid { // FixReac0
    <0.1, 0.4>
    texture {
      TexCarcasse
    }
    scale <0.6, 0.5, 1.5>
    rotate 9.862949*y
    translate  <3.422335, 1.6, 5.116211>
  }
}




// ********  OBJECTS  *******

sphere { // Poussiere4
  <0,0,0>,1
  texture {
    TexPoussiere
  }
  scale <15.0, 15.0, 5.0>
  rotate 49.822083*z
  translate  <-17.151948, 64.132113, 0.0>
}


sphere { // Poussiere3
  <0,0,0>,1
  texture {
    TexPoussiere
  }
  scale <15.0, 15.0, 5.0>
  rotate -179.245865*z
  translate  <-36.820355, 84.834522, 0.0>
}


sphere { // Poussiere2
  <0,0,0>,1
  texture {
    TexPoussiere
  }
  scale <15.0, 15.0, 5.0>
  rotate -133.404984*z
  translate  <-75.49163, 55.782125, 0.0>
}


sphere { // Poussiere1
  <0,0,0>,1
  texture {
    TexPoussiere
  }
  scale <15.0, 15.0, 5.0>
  rotate 26.515942*z
  translate  <-65.252066, 30.244747, 0.0>
}


#declare Mollet28 = union {
  object { // ElMollet28->Mollet0
    Mollet0
  }
  object { // Pied28->Pied0
    Pied0
    rotate <179.999985, 60.920261, -179.999985>
    translate  -6.0*z
  }
  rotate <-120.989738, -84.164787, 121.121246>
  translate  -7.0*z
}
#declare Patte12 = union {
  object { // ElCuisse13->ElCuisse0
    ElCuisse0
  }
  object { Mollet28 }
  texture {
    TexPatte
  }
  rotate <5.0, 10.145003, 0.0>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet29 = union {
  object { // ElMollet29->Mollet0
    Mollet0
  }
  object { // Pied29->Pied0
    Pied0
    rotate <0.000008, 64.624176, -0.000005>
    translate  -6.0*z
  }
  rotate <6.300436, -37.421295, -3.838342>
  translate  -7.0*z
}
#declare Patte13 = union {
  object { // ElCuisse14->ElCuisse0
    ElCuisse0
  }
  object { Mollet29 }
  texture {
    TexPatte
  }
  rotate <-5.0, 60.161968, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou6 = union {
  object { // TeteBf5->TeteBf0
    TeteBf0
    scale 0.4
    rotate <0.0, -41.746056, 0.0>
    translate  <-0.701385, -0.0115, 5.670294>
  }
  object { // LeCou6->RefCou2
    RefCou2
    scale 0.4
    rotate <0.0, -19.327122, 0.0>
    translate  <-0.526527, 0.0, 2.964081>
  }
  texture {
    TexRoseCouTete
  }
  rotate <0.0, 13.267951, 0.0>
  translate  <5.820592, 0.0, 4.204602>
}
union { // Autruche7
  object { Patte12 }
  object { Patte13 }
  object { TeteCou6 }
  object { // Corps4->Corps03
    Corps03
    scale 5.0
    rotate -180.0*z
  }
  rotate 118.982697*z
  translate  <-42.154421, 92.060356, 11.277204>
}


#declare Mollet26 = union {
  object { // ElMollet26->Mollet0
    Mollet0
  }
  object { // Pied26->Pied0
    Pied0
    rotate <-0.00001, 77.436569, -0.000006>
    translate  -6.0*z
  }
  rotate <-8.608649, -54.390015, 7.016652>
  translate  -7.0*z
}
#declare Patte10 = union {
  object { // ElCuisse11->ElCuisse0
    ElCuisse0
  }
  object { Mollet26 }
  texture {
    TexPatte
  }
  rotate <5.0, 60.055023, 0.0>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet27 = union {
  object { // ElMollet27->Mollet0
    Mollet0
  }
  object { // Pied27->Pied0
    Pied0
    rotate <-179.999954, 51.897011, 180.0>
    translate  -6.0*z
  }
  rotate <84.584473, -84.977524, -84.563698>
  translate  -7.0*z
}
#declare Patte11 = union {
  object { // ElCuisse12->ElCuisse0
    ElCuisse0
  }
  object { Mollet27 }
  texture {
    TexPatte
  }
  rotate <-5.0, -2.680316, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou5 = union {
  object { // TeteBf4->TeteBf0
    TeteBf0
    scale 0.4
    rotate <0.0, -41.746056, 0.0>
    translate  <-0.897081, 0.0, 5.929799>
  }
  object { // LeCou5->RefCou2
    RefCou2
    scale 0.4
    rotate <0.0, -19.327122, 0.0>
    translate  <-0.526527, 0.0, 2.964081>
  }
  texture {
    TexRoseCouTete
  }
  rotate <0.0, 35.674892, 0.0>
  translate  <6.752871, 0.0, 3.452655>
}
union { // Autruche6
  object { Patte10 }
  object { Patte11 }
  object { TeteCou5 }
  object { // Corps5->Corps03
    Corps03
    scale 5.0
    rotate -180.0*z
  }
  rotate <-8.989223, 4.91374, 176.473892>
  translate  <-85.69627, 55.284943, 11.527959>
}


#declare Mollet24 = union {
  object { // ElMollet24->Mollet0
    Mollet0
  }
  object { // Pied24->Pied0
    Pied0
    rotate <179.999985, 60.920261, -179.999985>
    translate  -6.0*z
  }
  rotate <-32.637547, -80.700089, 32.294174>
  translate  -7.0*z
}
#declare Patte8 = union {
  object { // ElCuisse9->ElCuisse0
    ElCuisse0
  }
  object { Mollet24 }
  texture {
    TexPatte
  }
  rotate <5.0, 6.967362, 0.0>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet25 = union {
  object { // ElMollet25->Mollet0
    Mollet0
  }
  object { // Pied25->Pied0
    Pied0
    rotate <0.000008, 64.624176, -0.000005>
    translate  -6.0*z
  }
  rotate <5.790346, -30.244831, -2.923998>
  translate  -7.0*z
}
#declare Patte9 = union {
  object { // ElCuisse10->ElCuisse0
    ElCuisse0
  }
  object { Mollet25 }
  texture {
    TexPatte
  }
  rotate <-5.0, 60.161968, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou4 = union {
  object { // TeteBf3->TeteBf0
    TeteBf0
    scale 0.4
    rotate <0.0, -41.746056, 0.0>
    translate  <-0.859507, 0.007173, 5.911212>
  }
  object { // LeCou4->RefCou2
    RefCou2
    scale 0.4
    rotate <0.0, -19.327122, 0.0>
    translate  <-0.526527, 0.0, 2.964081>
  }
  texture {
    TexRoseCouTete
  }
  rotate <0.0, 18.968206, 0.0>
  translate  <6.181257, 0.0, 4.024269>
}
union { // Autruche5
  object { Patte8 }
  object { Patte9 }
  object { TeteCou4 }
  object { // Corps12->Corps1
    Corps1
    scale 5.0
    rotate -180.0*z
  }
  rotate <-7.815686, -0.803089, 174.169617>
  translate  <-59.928288, 7.301922, 10.671782>
}


#declare Mollet22 = union {
  object { // ElMollet22->Mollet0
    Mollet0
  }
  object { // Pied22->Pied0
    Pied0
    rotate <179.999985, 40.311798, -179.999985>
    translate  -6.0*z
  }
  rotate <-40.985512, -82.18998, 40.720829>
  translate  -7.0*z
}
#declare Patte6 = union {
  object { // ElCuisse7->ElCuisse0
    ElCuisse0
  }
  object { Mollet22 }
  texture {
    TexPatte
  }
  rotate <4.882123, 20.205074, -0.027876>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet23 = union {
  object { // ElMollet23->Mollet0
    Mollet0
  }
  object { // Pied23->Pied0
    Pied0
    rotate <0.000008, 64.624176, -0.000005>
    translate  -6.0*z
  }
  rotate <13.789127, -68.268829, -12.634333>
  translate  -7.0*z
}
#declare Patte7 = union {
  object { // ElCuisse8->ElCuisse0
    ElCuisse0
  }
  object { Mollet23 }
  texture {
    TexPatte
  }
  rotate <-4.798525, 42.151031, 0.158879>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou3 = union {
  object { // LeCou3->RefCou0
    RefCou0
    scale 0.4
    rotate <0.0, 5.070758, 0.0>
    translate  <0.098729, 0.0, -0.182363>
  }
  object { // TeteBf2->TeteBf0
    TeteBf0
    scale 0.4
    rotate <-9.892998, -25.670731, 31.45191>
    translate  <5.117638, 0.026541, 4.102183>
  }
  texture {
    TexRoseCouTete
  }
  rotate <0.0, 18.968206, 0.0>
  translate  <6.181257, 0.0, 4.024269>
}
union { // Autruche4
  object { Patte6 }
  object { Patte7 }
  object { TeteCou3 }
  object { // Corps10->Corps1
    Corps1
    scale 5.0
    rotate -180.0*z
  }
  rotate 179.516922*z
  translate  <-77.709525, 29.051509, 12.57997>
}


#declare Mollet20 = union {
  object { // ElMollet20->Mollet0
    Mollet0
  }
  object { // Pied20->Pied0
    Pied0
    rotate <0.0, 70.834282, 0.0>
    translate  -6.0*z
  }
  rotate <-5.479243, -24.109354, 2.243859>
  translate  -7.0*z
}
#declare Patte4 = union {
  object { // ElCuisse5->ElCuisse0
    ElCuisse0
  }
  object { Mollet20 }
  texture {
    TexPatte
  }
  rotate <5.0, 55.911705, 0.0>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet21 = union {
  object { // ElMollet21->Mollet0
    Mollet0
  }
  object { // Pied21->Pied0
    Pied0
    rotate <-179.999985, 71.449699, 180.0>
    translate  -6.0*z
  }
  rotate <83.255875, -84.965073, -83.229988>
  translate  -7.0*z
}
#declare Patte5 = union {
  object { // ElCuisse6->ElCuisse0
    ElCuisse0
  }
  object { Mollet21 }
  texture {
    TexPatte
  }
  rotate <-5.0, 11.945951, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou2 = union {
  object { // LeCou2->RefCou0
    RefCou0
    scale 0.4
  }
  object { // TeteBo3->TeteBo0
    TeteBo0
    scale 0.4
    rotate <-5.159204, -28.399416, -15.806975>
    translate  <4.560384, -0.067281, 4.548445>
  }
  texture {
    TexRoseCouTete
  }
  rotate <0.0, 18.968206, 0.0>
  translate  <6.181257, 0.0, 4.024269>
}
union { // Autruche3
  object { Patte4 }
  object { Patte5 }
  object { TeteCou2 }
  object { // Corps9->Corps1
    Corps1
    scale 5.0
    rotate -180.0*z
  }
  rotate <0.015067, 5.647316, 90.153114>
  translate  <-19.865876, 76.571744, 10.662499>
}


#declare Mollet18 = union {
  object { // ElMollet18->Mollet0
    Mollet0
  }
  object { // Pied18->Pied0
    Pied0
    rotate <-0.000003, 23.678967, 0.000013>
    translate  -6.0*z
  }
  rotate <-113.955643, -84.527344, 114.052887>
  translate  -7.0*z
}
#declare Patte2 = union {
  object { // ElCuisse3->ElCuisse0
    ElCuisse0
  }
  object { Mollet18 }
  texture {
    TexPatte
  }
  rotate <5.0, 52.526573, 0.0>
  translate  <1.8, -2.2, 0.7>
}
#declare Mollet19 = union {
  object { // ElMollet19->Mollet0
    Mollet0
  }
  object { // Pied19->Pied0
    Pied0
    rotate <-0.00001, 27.891405, -0.000008>
    translate  -6.0*z
  }
  rotate <131.131607, -83.355179, -131.323013>
  translate  -7.0*z
}
#declare Patte3 = union {
  object { // ElCuisse4->ElCuisse0
    ElCuisse0
  }
  object { Mollet19 }
  texture {
    TexPatte
  }
  rotate <-5.0, 47.028294, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou1 = union {
  object { // RefCou3->RefCou1
    RefCou1
    scale 0.4
    rotate <-1.6141, -17.483589, -0.623241>
    translate  <-1.300442, 0.093745, 0.620599>
  }
  texture {
    TexRoseCouTete
  }
  rotate 13.822956*y
  translate  <6.542911, 0.0, -0.964958>
}
union { // Autruche2
  object { Patte2 }
  object { Patte3 }
  object { TeteCou1 }
  object { // Corps11->Corps02
    Corps02
    scale 5.0
    rotate -180.0*z
  }
  rotate <0.0, 13.181042, -83.780563>
  translate  <-38.365065, 16.640865, 9.159566>
}


#declare Group2 = union {
  object { Corps0 }
  translate  <-80.0, -80.0, -80.0>
}
#declare BidonBug3 = union {
  object { BlobCorps }
}
#declare Group3 = union {
  object { BidonBug3 }
  translate  <-60.0, -60.0, -60.0>
}
#declare BidonBug4 = union {
  object { RefCou0 }
}
#declare Group4 = union {
  object { BidonBug4 }
  translate  <-40.0, -40.0, -40.0>
}
#declare BidonBug5 = union {
  object { RefCou1 }
}
#declare Group5 = union {
  object { BidonBug5 }
  translate  <-20.0, -20.0, -20.0>
}
#declare BidonBug6 = union {
  object { RefCou2 }
}
#declare Group6 = union {
  object { BidonBug6 }
}
#declare Group7 = union {
  object { ElCuisse0 }
  translate  <20.0, 20.0, 20.0>
}
#declare Group8 = union {
  object { Plume0 }
  translate  <40.0, 40.0, 40.0>
}
#declare Group9 = union {
  object { TeteBo0 }
  translate  <60.0, 60.0, 60.0>
}
#declare Group10 = union {
  object { TeteBf0 }
  translate  <80.0, 80.0, 80.0>
}
#declare Group11 = union {
  object { AilPliePlumG }
  translate  <100.0, 100.0, 100.0>
}
#declare Group12 = union {
  object { AilDeplPlumG }
  translate  <140.0, 140.0, 140.0>
}
#declare Group13 = union {
  object { AilPliePlumD }
  translate  <120.0, 120.0, 120.0>
}
#declare Group14 = union {
  object { AilDeplPlumD }
  translate  <160.0, 160.0, 160.0>
}
#declare Group15 = union {
  object { Corps1 }
  translate  <-100.0, -100.0, -100.0>
}
#declare Group16 = union {
  object { Mollet0 }
  translate  <30.0, 30.0, 30.0>
}
#declare Group17 = union {
  object { Pied0 }
  translate  <40.0, 40.0, 40.0>
}
#declare Group18 = union {
  object { Corps02 }
  translate  <-120.0, -120.0, -120.0>
}
#declare Group19 = union {
  object { Corps03 }
  translate  <-140.0, -140.0, -140.0>
}
union { // RefObjets
  object { Group2 }
  object { Group3 }
  object { Group4 }
  object { Group5 }
  object { Group6 }
  object { Group7 }
  object { Group8 }
  object { Group9 }
  object { Group10 }
  object { Group11 }
  object { Group12 }
  object { Group13 }
  object { Group14 }
  object { Group15 }
  object { Group16 }
  object { Group17 }
  object { Group18 }
  object { Group19 }
  texture {
    TexBidon
  }
  translate  <5000.0, 5000.0, 5000.0>
}


#declare Mollet16 = union {
  object { // ElMollet16->Mollet0
    Mollet0
  }
  object { // Pied16->Pied0
    Pied0
    rotate <0.0, 45.060757, 0.0>
    translate  -6.0*z
  }
  rotate <-5.091978, -10.89267, 0.96468>
  translate  -7.0*z
}
#declare Patte0 = union {
  object { // ElCuisse1->ElCuisse0
    ElCuisse0
  }
  object { Mollet16 }
  texture {
    TexPatte
  }
  rotate <5.0, 18.726112, 0.0>
  translate  <2.737628, -2.218096, 0.478038>
}
#declare Mollet17 = union {
  object { // ElMollet17->Mollet0
    Mollet0
  }
  object { // Pied17->Pied0
    Pied0
    rotate <0.0, 45.394707, 0.0>
    translate  -6.0*z
  }
  rotate <5.096668, -11.162593, -0.989196>
  translate  -7.0*z
}
#declare Patte1 = union {
  object { // ElCuisse2->ElCuisse0
    ElCuisse0
  }
  object { Mollet17 }
  texture {
    TexPatte
  }
  rotate <-5.0, 15.001354, 0.0>
  translate  <1.8, 2.2, 0.7>
}
#declare TeteCou0 = union {
  object { // LeCou0->RefCou0
    RefCou0
    scale 0.4
  }
  object { // TeteBo1->TeteBo0
    TeteBo0
    scale 0.4
    rotate <-3.833971, -23.545412, 5.738224>
    translate  <4.591009, 0.013302, 4.579045>
  }
  texture {
    TexRoseCouTete
  }
  rotate 8.0*z
  translate  <4.556089, 0.0, 4.167667>
}
#declare Autruche1 = union {
  object { // Corps8->Corps0
    Corps0
    scale 5.0
    rotate -180.0*z
  }
  object { Patte0 }
  object { Patte1 }
  object { TeteCou0 }
}
#declare Reserv0 = union {
  object { BonBonne0 }
  object { // BonBonne1->BonBonne0
    BonBonne0
    rotate 0.0*z
    translate  4.4*y
  }
  object { FixBonb0 }
  object { // FixBonb1->FixBonb0
    FixBonb0
    translate  <2.290139, 0.0, 0.00027>
  }
  rotate -10.0*y
  translate  <-2.2, 0.0, 4.6>
}
#declare BlobCorps5 = blob {
  threshold 0.52
  component 1.0, 1.358338, <-0.008439, -0.008439, 0.14346>
  component 0.98646, 1.087601, <0.379747, 0.008439, 0.0>
  component 1.0, 1.087601, <-0.362869, 0.008439, 0.0>
  component 1.0, 0.632938, <-0.830696, 0.025316, 0.013186>
  component 1.0, 1.358338, <0.008439, 0.008439, -0.075949>
  component -1.302989, 0.864998, <-0.042194, -0.312236, -1.105485>
  component -1.224997, 0.924203, <0.008439, -0.278481, 1.206751>
  component 1.0, 0.632938, <0.869198, 0.025316, 0.008439>
  component 1.0, 0.228455, <1.156118, 0.008439, 0.075949>
  component 1.0, 0.228455, <1.156118, 0.008439, -0.075949>
  scale <4.75, 3.5, 4.25>
  rotate <90.0, 0.0, -180.0>
}

#declare UnionHarnais = union {
  cylinder { // CylHarnais0
    <0,0,1>, <0,0,0>, 1
    scale <3.5, 4.0, 0.5>
    rotate 69.083405*y
    translate  <3.153504, 0.0, 0.35232>
  }
  cylinder { // CylHarnais1
    <0,0,1>, <0,0,0>, 1
    scale <3.5, 4.0, 0.5>
    rotate <180.0, 84.078606, 180.0>
    translate  <-3.274743, 0.0, 0.123233>
  }
  box { // CubHarnais0
    <-1, -1, -1>, <1, 1, 1>
    scale <4.035013, 0.25, 1.0>
    translate  <0.525771, 0.0, -2.933312>
  }
  box { // CubHarnais1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.798759, 0.25, 1.0>
    rotate -45.0*x
    translate  <0.503652, -2.074165, -2.074165>
  }
  box { // CubHarnais2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.810044, 0.25, 1.0>
    rotate 45.0*x
    translate  <0.511674, 2.074165, -2.074165>
  }
  box { // CubHarnais3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.71598, 0.25, 1.0>
    rotate 125.0*x
    translate  <-0.111158, 2.617274, 1.87548>
  }
  box { // CubHarnais4
    <-1, -1, -1>, <1, 1, 1>
    scale <2.71598, 0.25, 1.0>
    rotate -125.0*x
    translate  <-0.111158, -2.657535, 1.817981>
  }
}
#declare Harnais0 = intersection {
  object { BlobCorps5 }
  object { UnionHarnais }
}
#declare Harnais = union {
  object { Harnais0 }
  object { // Boucle1->Boucle
    Boucle
    rotate -62.0*x
    translate  <0.0, 5.677259, -3.383183>
  }
  object { // Boucle2->Boucle
    Boucle
    rotate <156.620834, -74.586929, -165.105652>
    translate  <0.982965, -0.56612, 1.00017>
  }
  object { // Boucle3->Boucle
    Boucle
    rotate <102.651459, -62.677505, -152.322693>
    translate  <3.202687, 6.500258, 2.175595>
  }
  object { // Boucle4->Boucle
    Boucle
    rotate <29.92333, -78.254288, -47.285831>
    translate  <-4.43388, 6.171306, 1.857276>
  }
  object { // Boucle5->Boucle
    Boucle
    rotate <-115.844368, -65.144402, 63.910572>
    translate  <-2.582066, -0.014915, -0.115827>
  }
  object { Boucle }
  texture {
    TexHarnais
  }
}
#declare Coussin = union {
  superellipsoid { // Coussin0
    <0.1, 0.7>
    scale <2.5, 2.728652, 0.8>
    rotate -5.088685*y
    translate  <-1.304341, 0.0, 2.601751>
  }
  superellipsoid { // Coussin1
    <0.1, 0.7>
    scale <2.5, 2.728652, 0.8>
    rotate 0.228446*y
    translate  <1.156639, 0.0, 2.682355>
  }
  texture {
    TexCoussin
  }
}
#declare AvantCarc = difference {
  superellipsoid { // AvantCarc0
    <1.0, 0.5>
    scale <0.9, 1.0, 1.0>
  }
  box { // CubAvCarc
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
  }
  scale <1.0, 3.0, 1.0>
  rotate 85.0*y
  translate  <2.68475, 0.0, 3.813763>
}
#declare Carcasse = union {
  superellipsoid { // Carcas0
    <0.1, 0.3>
    scale <4.149635, 3.14947, 0.306011>
    rotate -7.032597*y
    translate  <-0.259788, 0.0, 3.282975>
  }
  superellipsoid { // BarCarcAv1
    <0.1, 0.5>
    scale <0.5, 2.552181, 0.8>
    rotate 5.136935*y
    translate  <-2.750011, 0.0, 2.87004>
  }
  superellipsoid { // BarCarcAv
    <0.1, 0.5>
    scale <0.5, 3.159813, 1.2>
    rotate -13.716735*y
    translate  <2.286544, 0.0, 3.07804>
  }
  object { AvantCarc }
  object { FixReac0 }
  object { // FixReac1->FixReac0
    FixReac0
    rotate 0.0*y
    translate  -3.2*y
  }
  texture {
    TexCarcasse
  }
}
#declare DiffCatal = difference {
  cylinder { // ExtCatal
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 2.0>
  }
  cylinder { // ExtCatal1
    <0,0,1>, <0,0,0>, 1
    scale <0.63, 0.63, 2.2>
    translate  -0.1*z
  }
  sphere { // Trou3
    <0,0,0>,1
    scale 0.15
    translate  <0.7, 0.0, 1.75>
  }
  sphere { // Trou5
    <0,0,0>,1
    scale 0.15
    rotate -90.0*z
    translate  <0.0, -0.7, 0.25>
  }
  sphere { // Trou6
    <0,0,0>,1
    scale 0.15
    rotate -135.0*z
    translate  <-0.494975, -0.494975, 0.25>
  }
  sphere { // Trou7
    <0,0,0>,1
    scale 0.15
    rotate -180.0*z
    translate  <-0.7, 0.0, 0.25>
  }
  sphere { // Trou8
    <0,0,0>,1
    scale 0.15
    rotate -225.0*z
    translate  <-0.494975, 0.494975, 0.25>
  }
  sphere { // Trou9
    <0,0,0>,1
    scale 0.15
    rotate -270.0*z
    translate  <0.0, 0.7, 0.25>
  }
  sphere { // Trou12
    <0,0,0>,1
    scale 0.15
    rotate -90.0*z
    translate  <0.0, -0.7, 0.75>
  }
  sphere { // Trou13
    <0,0,0>,1
    scale 0.15
    rotate -135.0*z
    translate  <-0.494975, -0.494975, 0.75>
  }
  sphere { // Trou14
    <0,0,0>,1
    scale 0.15
    rotate -180.0*z
    translate  <-0.7, 0.0, 0.75>
  }
  sphere { // Trou15
    <0,0,0>,1
    scale 0.15
    rotate -225.0*z
    translate  <-0.494975, 0.494975, 0.75>
  }
  sphere { // Trou16
    <0,0,0>,1
    scale 0.15
    rotate -270.0*z
    translate  <0.0, 0.7, 0.75>
  }
  sphere { // Trou19
    <0,0,0>,1
    scale 0.15
    rotate -90.0*z
    translate  <0.0, -0.7, 1.25>
  }
  sphere { // Trou20
    <0,0,0>,1
    scale 0.15
    rotate -135.0*z
    translate  <-0.494975, -0.494975, 1.25>
  }
  sphere { // Trou21
    <0,0,0>,1
    scale 0.15
    rotate -180.0*z
    translate  <-0.7, 0.0, 1.25>
  }
  sphere { // Trou22
    <0,0,0>,1
    scale 0.15
    rotate -225.0*z
    translate  <-0.494975, 0.494975, 1.25>
  }
  sphere { // Trou23
    <0,0,0>,1
    scale 0.15
    rotate -270.0*z
    translate  <0.0, 0.7, 1.25>
  }
  sphere { // Trou25
    <0,0,0>,1
    scale 0.15
    rotate -45.0*z
    translate  <0.494975, -0.494975, 1.75>
  }
  sphere { // Trou26
    <0,0,0>,1
    scale 0.15
    rotate -90.0*z
    translate  <0.0, -0.7, 1.75>
  }
  sphere { // Trou27
    <0,0,0>,1
    scale 0.15
    rotate -135.0*z
    translate  <-0.494975, -0.494975, 1.75>
  }
  sphere { // Trou28
    <0,0,0>,1
    scale 0.15
    rotate -180.0*z
    translate  <-0.7, 0.0, 1.75>
  }
  sphere { // Trou29
    <0,0,0>,1
    scale 0.15
    rotate -225.0*z
    translate  <-0.494975, 0.494975, 1.75>
  }
  sphere { // Trou30
    <0,0,0>,1
    scale 0.15
    rotate -270.0*z
    translate  <0.0, 0.7, 1.75>
  }
  sphere { // Trou31
    <0,0,0>,1
    scale 0.15
    rotate -315.0*z
    translate  <0.494975, 0.494975, 1.75>
  }
  sphere { // Trou4
    <0,0,0>,1
    scale 0.15
    translate  <0.646716, -0.267878, 1.5>
  }
  sphere { // Trou10
    <0,0,0>,1
    scale 0.15
    translate  <0.267878, -0.646716, 1.5>
  }
  sphere { // Trou11
    <0,0,0>,1
    scale 0.15
    translate  <-0.267878, -0.646716, 1.5>
  }
  sphere { // Trou17
    <0,0,0>,1
    scale 0.15
    translate  <-0.646716, -0.267878, 1.5>
  }
  sphere { // Trou18
    <0,0,0>,1
    scale 0.15
    translate  <-0.646716, 0.267878, 1.5>
  }
  sphere { // Trou24
    <0,0,0>,1
    scale 0.15
    translate  <-0.267878, 0.646716, 1.5>
  }
  sphere { // Trou32
    <0,0,0>,1
    scale 0.15
    translate  <0.267878, 0.646716, 1.5>
  }
  sphere { // Trou33
    <0,0,0>,1
    scale 0.15
    translate  <0.646716, 0.267878, 1.5>
  }
  texture {
    TexExtCatal
  }
}
#declare Catal = union {
  object { DiffCatal }
  superellipsoid { // SortieCatal
    <1.0, 0.6>
    texture {
      TexExtCatal
    }
    scale <0.6, 0.6, 1.0>
    rotate -90.0*x
    translate  <0.761502, 0.0, 0.674973>
  }
  superellipsoid { // IntCatal
    <1.0, 0.3>
    texture {
      TexIntCatal
    }
    scale <0.5, 0.5, 1.5>
    translate  0.75*z
  }
  sphere { // HautCatal
    <0,0,0>,1
    texture {
      TexExtCatal
    }
    scale <0.3, 0.3, 0.1>
    translate  2.243789*z
  }
  rotate -29.059599*y
  translate  <3.178587, 0.0, 5.052364>
}
#declare InterTuy1 = difference {
  torus { // TorTuy1
    1.2, 0.1  rotate -x*90
  }
  box { // CubTuy1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.75, 0.5>
    translate  0.75*y
  }
  translate  <2.4, -2.2, 0.0>
}
#declare InterTuy0 = intersection {
  torus { // TorTuy0
    0.2, 0.1  rotate -x*90
  }
  box { // CubTuy0
    <-1, -1, -1>, <1, 1, 1>
    scale 0.3
    translate  <0.3, 0.3, 0.0>
  }
  translate  <1.0, -0.2, 0.0>
}
#declare Tuyau0 = union {
  cylinder { // CylTuy2
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    rotate 90.0*x
    translate  <3.6, -0.2, 0.0>
  }
  object { InterTuy1 }
  cylinder { // CylTuy1
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    rotate 90.0*x
    translate  <1.2, -0.2, 0.0>
  }
  object { InterTuy0 }
  cylinder { // CylTuy0
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.0>
    rotate <90.0, 0.0, 90.0>
  }
  texture {
    TexTuyau
  }
  scale 0.65
  rotate <-106.0, -13.0, 52.0>
  translate  <1.35, -1.95, 5.2>
}
#declare InterTuy2 = difference {
  torus { // TorTuy2
    1.2, 0.1  rotate -x*90
  }
  box { // CubTuy2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.75, 0.5>
    translate  0.75*y
  }
  translate  <2.4, -2.2, 0.0>
}
#declare InterTuy3 = intersection {
  torus { // TorTuy3
    0.2, 0.1  rotate -x*90
  }
  box { // CubTuy3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.3
    translate  <0.3, 0.3, 0.0>
  }
  translate  <1.0, -0.2, 0.0>
}
#declare Tuyau1 = union {
  cylinder { // CylTuy3
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    rotate 90.0*x
    translate  <3.6, -0.2, 0.0>
  }
  object { InterTuy2 }
  cylinder { // CylTuy4
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    rotate 90.0*x
    translate  <1.2, -0.2, 0.0>
  }
  object { InterTuy3 }
  cylinder { // CylTuy5
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.0>
    rotate <90.0, 0.0, 90.0>
  }
  texture {
    TexTuyau
  }
  scale 0.65
  rotate <-74.0, -13.0, -52.0>
  translate  <1.35, 1.95, 5.2>
}
#declare UnSortReac0 = union {
  cylinder { // CylSortReac0
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.0>
  }
  torus { // TorSortReac1
    0.3, 0.2  rotate -x*90
    translate  1.0*z
  }
  cone { // ConSortReac0
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 0.45
    rotate 180.0*x
    translate  1.578677*z
  }
  translate  3.0*z
}
#declare SortReac0 = difference {
  object { UnSortReac0 }
  cylinder { // CylIntSorReac0
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 1.0>
    translate  3.6*z
  }
  torus { // TorSortReac0
    0.3, 0.1  rotate -x*90
    translate  3.5*z
  }
  texture {
    TexSortieReac
  }
}
#declare ReacC0 = union {
  torus { // TorReac0
    0.15, 0.35  rotate -x*90
    translate  3.0*z
  }
  cylinder { // CylReac0
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 3.0>
  }
  sphere { // SphReac0
    <0,0,0>,1
    scale 0.5
  }
  object { SortReac0 }
  rotate <-12.692669, 60.144135, 2.597116>
  translate  4.5*z
}
#declare ReacB0 = union {
  object { ReacC0 }
  cylinder { // CylReac1
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 4.5>
  }
  sphere { // SphReac1
    <0,0,0>,1
    scale 0.5
  }
  rotate <90.0, 0.0, -65.0>
  translate  2.0*z
}
#declare ReacA0 = union {
  object { ReacB0 }
  cylinder { // CylReac2
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 2.0>
  }
  torus { // TorReac1
    0.4, 0.1  rotate -x*90
  }
  texture {
    TexProtReac
  }
  rotate 90.0*x
  translate  <3.65, -3.0, 6.0>
}
#declare UnSortReac1 = union {
  cylinder { // CylSortReac1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.0>
  }
  torus { // TorSortReac2
    0.3, 0.2  rotate -x*90
    translate  1.0*z
  }
  cone { // ConSortReac1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 0.45
    rotate 180.0*x
    translate  1.578677*z
  }
  translate  3.0*z
}
#declare SortReac1 = difference {
  object { UnSortReac1 }
  cylinder { // CylIntSorReac1
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 1.0>
    translate  3.6*z
  }
  torus { // TorSortReac3
    0.3, 0.1  rotate -x*90
    translate  3.5*z
  }
  texture {
    TexSortieReac
  }
}
#declare ReacC1 = union {
  torus { // TorReac2
    0.15, 0.35  rotate -x*90
    translate  3.0*z
  }
  cylinder { // CylReac3
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 3.0>
  }
  sphere { // SphReac2
    <0,0,0>,1
    scale 0.5
  }
  object { SortReac1 }
  rotate <12.692668, 60.144135, -2.597116>
  translate  4.5*z
}
#declare ReacB1 = union {
  object { ReacC1 }
  cylinder { // CylReac4
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 4.5>
  }
  sphere { // SphReac3
    <0,0,0>,1
    scale 0.5
  }
  rotate <-90.0, 0.0, 65.0>
  translate  2.0*z
}
#declare ReacA1 = union {
  object { ReacB1 }
  cylinder { // CylReac5
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 2.0>
  }
  torus { // TorReac3
    0.4, 0.1  rotate -x*90
  }
  texture {
    TexProtReac
  }
  rotate <-90.0, 0.0, 0.0>
  translate  <3.65, 3.0, 6.0>
}
#declare CableGaz = difference {
  torus { // TorCable
    2.98, 0.04  rotate -x*90
  }
  box { // CubCable
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 0.1>
    translate  2.0*y
  }
  texture {
    TexCable
  }
  scale <1.0, 1.5, 1.0>
  rotate <16.628269, -71.993477, 14.13279>
  translate  <1.580711, -1.745684, 3.15>
}
#declare LaVapeur = union {
  cone { // Vapeur0
    <0,0,0>, 0.2, <0,0,1>, 12.0
    texture {
      TexVapeurCone
    }
    hollow
    scale <1.0, 1.0, 65.0>
    rotate <-164.990356, 5.129406, 0.123772>
    translate  <-0.836532, 6.193383, -0.244549>
  }
  cone { // Vapeur1
    <0,0,0>, 0.2, <0,0,1>, 12.0
    texture {
      TexVapeurCone
    }
    hollow
    scale <1.0, 1.0, 65.0>
    rotate <164.993698, 5.02649, -0.075545>
    translate  <-0.852546, -6.184105, -0.195955>
  }
  sphere { // VapBas1
    <0,0,0>,1
    texture {
      TexVapeurSol
    }
    hollow
    scale <80.0, 80.0, 20.0>
    rotate <-2.069276, -8.619708, -0.931088>
    translate  <-39.917093, -0.771603, -52.471461>
  }
  hollow
}
#declare Engin = union {
  cylinder { // DebutReacs
    <0,0,1>, <0,0,0>, 1
    texture {
      TexIntCatal
    }
    scale <0.4, 0.4, 8.0>
    rotate 90.0*x
    translate  <3.65, 4.0, 6.0>
  }
  object { Reserv0 }
  object { Harnais }
  object { Coussin }
  object { Carcasse }
  object { Catal }
  object { Tuyau0 }
  object { Tuyau1 }
  object { ReacA0 }
  object { ReacA1 }
  object { CableGaz }
  object { LaVapeur }
}
union { // AutruchVol
  object { Autruche1 }
  object { Engin }
  rotate <2.529279, 9.268778, -89.466476>
  translate  <7.091374, 0.400167, 45.235234>
}






sphere { // Poussiere0
  <0,0,0>,1
  texture {
    TexPoussiere
  }
  hollow
  scale <15.0, 15.0, 5.0>
  translate  <-48.252606, 7.065342, 0.0>
}


object {   // Terre
  height_field {
    tga "D:\POVUTILS\MORAY\MAPS\TERRE.TGA"
    water_level 0.0099
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <8.0, 8.0, 2.0>
  rotate 38.197548*z
  translate  <-37.427716, 7.128737, 1.733861>
  texture {
    TexTerre
  }
}


object {   // HFSolProche
  height_field {
    tga "D:\POVUTILS\MORAY\MAPS\SOL.TGA"
    water_level 0.0099
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <600.0, 600.0, 0.5>
  rotate -140.273361*z
  translate  <-2.694572, -59.500605, 0.48>
  texture {
    TexSolProche
  }
}


#include "D:\POVUTILS\MORAY\POVSCN\herbe.inc"

object {
  Herbe
  texture {
    TexHerbe
  }
  rotate 15.0*z
}


object {   // Montagne0
  height_field {
    tga "D:\POVUTILS\MORAY\MAPS\MONTAGNE.TGA"
    water_level 0.0099
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TexMont
  }
  scale <2500.0, 2500.0, 70.0>
  rotate 81.09964*z
  translate  <-364.073596, 2756.89244, 68.0>
}


sphere { // Ciel
  <0,0,0>,1
  texture {
    TexCiel
  }
  hollow
  scale 5000.0
}


plane { // Sol
  z,0
  texture {
    TexSol
  }
  scale <5000.0, 5000.0, 1.0>
}


