///////////////////////////////////////////////////////////////////////////
//  This file is a collection of the author's favorite Polyray textures  //
//                                                                       //
//  This file requires that Polyray's "colors.inc", "texture.inc", and   //
//  "stones.inc" already be parsed...                                    //
//                                                                       //
//  If you add your own textures to this file, add the texture name to   //
//  the file "textures.def" so they'll appear in the texture list in     //
//  POVCAD.                                                              //
///////////////////////////////////////////////////////////////////////////

// We only need to define these things on the very first frame.
if (frame == start_frame) {

// Rob McGregor's mirrored marble texture
static define mirrored_white_marble
texture {
  noise surface {
    color white
    position_fn position_objectx
    lookup_fn lookup_sawtooth
    octaves 3
    turbulence 6
    ambient 0.3
    specular white, 0.7
    microfacet Cook 5
    reflection .75
    color_map([0.0, 0.8, <1, 1, 1>, <0.6, 0.6, 0.6>]
              [0.8, 1.0, <0.6, 0.6, 0.6>, <0.1, 0.1, 0.1>])
  }
}

// Alfonso Hermida's moon texture
static define moon
texture {
  noise surface {
    color white
    position_fn position_spherical
    position_scale 1.0
    lookup_fn lookup_sawtooth
    octaves 3
    turbulence 0.53
    ambient 0.4
    diffuse 0.8
    specular 0.2
    microfacet Reitz 5
    normal  dented_normal
    bump_scale 0.2
    frequency 10
    color_map([0.0, 0.8, <1, 1, 1>, <0.6, 0.6, 0.6>]
              [0.8, 1.0, <0.6, 0.6, 0.6>, <0.1, 0.1, 0.1>])
  }
}

// Bob Sewell's bumpy_white texture
static define bumpy_white
texture {
   special surface {
     color color_map(
       [ 0.000, 1.000,  <0.870, 0.805, 0.782>, <1.000, 1.000, 1.000> ]
     )
     [fnoise(7*P, 5)]
     diffuse 0.400
     ambient 0.250
     specular <1.0, 1.0, 1.0>, 0.250
     microfacet Phong 4.999
     normal N + 1.0000 * (dnoise(P,<20.0000,0.5000,7>) - <0.5, 0.5, 0.5>)
   }
}

// Alfonso Hermida's water texture
static define water
texture {
	noise surface {
		color < 0.6, 0.6, 1.0 >
//		color <0.3, 0.3, 1.0>
		normal ripple_normal
		frequency 100
		bump_scale 0.25
		ambient 0.3
		diffuse 0.3
		specular white, 0.7
		reflection 0.9
		transmission 0.9, 1.33
		microfacet Reitz 10
	}
	scale<10, 1, 10>
}

static define clear_water
texture {
	surface {
		color < 0.7, 0.8, 1 >
		normal ripple_normal
		frequency 100
		bump_scale 3
		ambient 0.3
		diffuse 0.3
		specular 0
		reflection white, 0
		transmission white, 0.9, 1.33
		microfacet Reitz 10
	}
	scale < 10, 1, 10 >
}

// Rob's variation on the old standard blue_ripple
static define green_ripple
texture {
  special shiny {
    color <0.043137, 0.764706, 0.588235>
    normal N + ripple_normal
//    normal N + ripple_val
    reflection 0.55
  }
}

// Variations on the standard marble texture
static define green_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, aquamarine, 0.6 * aquamarine]
      [0.8, 1.0, 0.6 * aquamarine, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Red marble texture
static define blood_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, red, 0.6 * red]
      [0.8, 1.0, 0.6 * red, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Ice marble texture
static define ice_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, cyan, 0.6 * cyan]
      [0.8, 1.0, 0.6 * cyan, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Blue marble texture
static define blue_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, blue, 0.6 * cyan]
      [0.8, 1.0, 0.6 * blue, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Black marble texture
static define black_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, black, 0.6 * midnight_blue]  // 0.6 * midnight_blue
      [0.8, 1.0, 0.6 * black, <0.1, 0.1, 0.1>])
  }
  scale <3, 3, 3>
}

// Rob McGregor's desert texture...
// Create a desert wasteland
static define sand_dunes
texture {
  noise surface {
    color <0.85, 0.75, 0.69>
    normal 2
    frequency 100
    bump_scale 1.5
    ambient 0.37
    diffuse 0.75
  }
  // apply to a disc w/radius 10000 and scale to make it look good...
  // haze makes it look more realistic
  // scale <92, 92, 92>
}

// Rob McGregor's chrome textures
static define chrome1
texture {
  special surface {
    color white * 0.85 
    ambient 0.05
    diffuse 0.1
    specular white * 0.95, 0.4
    reflection 0.85
    microfacet Cook 5
  }
}

static define chrome2
texture {
  special surface {
    color white * 0.9
    ambient 0.05
    diffuse 0.1
    specular white * 0.9, 0.3
    reflection 0.75
    microfacet Cook 3
  }
}

// A firey combo
static define fire_map
color_map(
  [0.0, 0.6, <0.85, 0.275, 0>, <1, 0, 0>]
  [0.6, 0.8, <1, 1, 0>, <1, 0.79, 0>]
  [0.8, 1.0, <1, 0.79, 0>, <1, 0.275, 0>])

static define fire_sky
texture {
  special surface {
    color fire_map[noise(P)]
    ambient 0.9
    diffuse 0
    specular 0
  }
}

//  New stuff copied below here

define wooden2
texture {
   noise surface {
      position_fn position_cylindrical
      position_scale 1
      lookup_fn lookup_sawtooth
      octaves 1
      turbulence 1
      ambient 0.2
      diffuse 0.7
      specular white, 0.5
      microfacet Reitz 10
      color_map(
         [0.0, 0.2, light_wood1, light_wood1]
         [0.2, 0.3, light_wood1, median_wood1]
         [0.3, 0.4, median_wood1, light_wood1]
         [0.4, 0.7, light_wood1, light_wood1]
         [0.7, 0.8, light_wood1, median_wood1]
         [0.8, 0.9, median_wood1, light_wood1]
         [0.9, 1.0, light_wood1, dark_wood1])
      }
      scale < 0.3, 0.15, 0.1 >
   }

define light_wood <0.52, 0.37, 0.26> * 1.5
define median_wood <0.42, 0.26, 0.15> * 1.5
define dark_wood <0.05, 0.01, 0.005>  * 1.5

define wood_scale 2
define xydist wood_scale * sqrt(x * x + y * y)

define wood_turb 0.8
define Octaves 3.0
define wood_fn  (sawtooth(xydist + wood_turb * noise(P,Octaves)) + 1) / 2

define wood_map
   color_map(
      [0.0,  0.10,  black,  black]
      [0.10, 0.30,  black,  median_wood]
      [0.30, 0.40,  median_wood,  dark_wood]
      [0.40, 0.70,  dark_wood,  median_wood]
      [0.70, 0.90,  median_wood,  median_wood]
      [0.90, 1.00,  median_wood,  black]
      )

define wood_texture1
   texture {
      special surface {
         color wood_map[wood_fn]
         specular white, 0.5 + 0.5 * wood_fn^4
         microfacet Reitz 5 + 10 * (1 - wood_fn)
         ambient 0.18
         diffuse 0.8
         }
      scale <0.2, 0.2, 1>            // make 5 "rings" per unit
      translate <0, -0.25, 15>       // cosmetic adjustments
      scale <2.75, 2.75, 1>          // Enlarge the whole thing
      rotate <0, 90, 0>              // Align along the x axis (almost)
      rotate <0, -1, 0>              // Shift slightly askew of center
   }

define wood_texture2
   texture {
      special surface {
         color wood_map[wood_fn]
         specular white, 0.5 + 0.5 * wood_fn^4
         microfacet Reitz 5 + 10 * (1 - wood_fn)
         ambient 0.18
         diffuse 0.8
         }
      scale <0.2, 0.2, 1>            // make 5 "rings" per unit
      translate <0, -0.25, 15>       // cosmetic adjustments
      scale <1.5, 1.5, 0.65>          // Enlarge the whole thing
      rotate <0, 90, 0>              // Align along the x axis (almost)
      rotate <0, -1, 0>              // Shift slightly askew of center
   }

define wood1 color_map(
   [0.000, 0.177, <1.000, 0.510, 0.008>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.177, 0.301, <0.635, 0.349, 0.161>, 0.000, <0.514, 0.514, 0.129>, 0.000]
   [0.301, 0.354, <0.514, 0.514, 0.129>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.354, 0.451, <0.635, 0.349, 0.161>, 0.000, <0.431, 0.137, 0.141>, 0.000]
   [0.451, 0.558, <0.431, 0.137, 0.141>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.558, 0.646, <0.635, 0.349, 0.161>, 0.000, <0.467, 0.000, 0.000>, 0.000]
   [0.646, 0.743, <0.467, 0.000, 0.000>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.743, 0.858, <0.635, 0.349, 0.161>, 0.000, <0.576, 0.576, 0.145>, 0.000]
   [0.858, 0.982, <0.576, 0.576, 0.145>, 0.000, <1.000, 0.510, 0.008>, 0.000]
   [0.982, 1.000, <1.000, 0.510, 0.008>, 0.000, <1.000, 0.510, 0.008>, 0.000])

static define noisy_wood_fn1
   sawtooth(|<x+0.5*dnoise(P,3)[0], y+0.5*dnoise(P,3)[1], 0>|)

static define brightness
   1-|wood1[noisy_wood_fn1]|/sqrt(3)

define shiny_wood
texture {
   special shiny {
      color wood1[noisy_wood_fn1]
      diffuse 0.2 + 0.4 * brightness
      specular white, 0.3
      microfacet Cook brightness * 10
      }
   scale <0.4, 0.4, 0.4>
   }

// Bark Textures *************************

define rough 1
define u_scale 64
define v_scale 15
define two_pi 2 * 3.14159265
define bark_pos <u_scale*sawtooth(u),0,v_scale*v>

define bark_texture
texture {
  special shiny {
    color tan
    normal N + rough*(dnoise(bark_pos,3)-<0.5,0.5,0.5>)
  }
  scale < 3000, 3000, 3000 >
}

define light_wood1 <0.6, 0.24, 0.1>
define median_wood1 <0.3, 0.12, 0.03>

define wood_fn0
   sawtooth(|<x+0.05*sin(6.28*(x+4*dnoise(P)[0])),
	      y+0.05*sin(6.28*(y+4*dnoise(P)[1])), 0>|)
define light_wood_texture
texture {
   special shiny {
      color color_map([0, 0.8, light_wood1, light_wood1]
              [0.8, 1, median_wood1, median_wood1])[wood_fn0]
      }
   rotate <90, 0, 0>
   scale <0.1, 0.1, 0.1>
   }


} // End of definitions
