
// Persistence of Vision Ray Tracer Scene Description File
// File: bodydest.inc
// Vers: 3
// Desc: Main robot body file
// Date: 31 December 1996
// Auth: Mick McMullin
//

#version 3

// --------------------------------------------
// declare positions for the joints in the body
// --------------------------------------------
#declare head_angle = <20, 0, 0>
#declare head_position = <0, 4.8, 0>

#declare shoulder1_position = <1.5, 3.9, 0>
#declare shoulder2_position = <-1.5, 3.9, 0>

#declare neck_base = (shoulder1_position + shoulder2_position) / 2
#declare uppertorso_length = 1.9
#declare lowertorso_length = 1.7
#declare uppertorso_angle = <20, 0, 0>
#declare lowertorso_angle = <30, 0, 0>
#declare pelvis_angle = <0, 0, 0>
#declare pelvis_width = 2

#declare upperarm_length = 2.2
#declare upperarm1_angle = <40, 0, 20>
#declare upperarm2_angle = <40, 0, -20>

#declare lowerarm_length = 2
#declare lowerarm1_angle = <90, 0, 10>
#declare lowerarm2_angle = <90, 0, -10>

#declare wrist1_angle = <90, 0, 60>
#declare wrist2_angle = <90, 0, -60>

#declare tophand_length = 0.6
#declare fingertopA_length = 0.3   //index
#declare fingertopB_length = 0.35  //middle
#declare fingertopC_length = 0.3   //ring
#declare fingertopD_length = 0.25  //little
#declare fingertopE_length = 0.25  //thumb
/////////////////////////////////////-----
#declare fingermidA_length = 0.15  //index
#declare fingermidB_length = 0.2   //middle
#declare fingermidC_length = 0.15  //ring
#declare fingermidD_length = 0.1   //little
/////////////////////////////////////-----
#declare fingertipA_length = 0.1   //index
#declare fingertipB_length = 0.1   //middle
#declare fingertipC_length = 0.1   //ring
#declare fingertipD_length = 0.1   //little
#declare fingertipE_length = 0.1   //thumb

// finger angles (hand 1)
#declare fingertopA1_angle = <0, 0, 0>   //index
#declare fingertopB1_angle = <0, 0, 0>   //middle
#declare fingertopC1_angle = <0, 0, 0>   //ring
#declare fingertopD1_angle = <0, 0, 0>   //little
#declare fingertopE1_angle = <0, 0, 0>   //thumb
//////////////////////////////////////////-----
#declare fingermidA1_angle = <0, 0, 0>   //index
#declare fingermidB1_angle = <0, 0, 0>   //middle
#declare fingermidC1_angle = <0, 0, 0>   //ring
#declare fingermidD1_angle = <0, 0, 0>   //little
//////////////////////////////////////////-----
#declare fingertipA1_angle = <0, 0, 0>   //index
#declare fingertipB1_angle = <0, 0, 0>   //middle
#declare fingertipC1_angle = <0, 0, 0>   //ring
#declare fingertipD1_angle = <0, 0, 0>   //little
#declare fingertipE1_angle = <0, 0, 0>   //thumb

// finger angles (hand 2)
#declare fingertopA2_angle = <0, 0, 0>   //index
#declare fingertopB2_angle = <0, 0, 0>   //middle
#declare fingertopC2_angle = <0, 0, 0>   //ring
#declare fingertopD2_angle = <0, 0, 0>   //little
#declare fingertopE2_angle = <0, 0, 0>   //thumb
//////////////////////////////////////////-----
#declare fingermidA2_angle = <0, 0, 0>   //index
#declare fingermidB2_angle = <0, 0, 0>   //middle
#declare fingermidC2_angle = <0, 0, 0>   //ring
#declare fingermidD2_angle = <0, 0, 0>   //little
//////////////////////////////////////////-----
#declare fingertipA2_angle = <0, 0, 0>   //index
#declare fingertipB2_angle = <0, 0, 0>   //middle
#declare fingertipC2_angle = <0, 0, 0>   //ring
#declare fingertipD2_angle = <0, 0, 0>   //little
#declare fingertipE2_angle = <0, 0, 0>   //thumb


#declare upperleg_length = 3
#declare upperleg1_angle = <60, 0, 40>
#declare upperleg2_angle = <60, 0, -40>

#declare lowerleg_length = 2.5
#declare lowerleg1_angle = <25, 0, 0>
#declare lowerleg2_angle = <20, 0, 0>

#declare ankle1_angle = <0, 0, 10>
#declare ankle2_angle = <0, 0, -10>

// --------------------------------------------
// calculate relative positions for the joints
// --------------------------------------------
#declare elbow1_position = vrotate(<0, -upperarm_length, 0>, upperarm1_angle)
                           + shoulder1_position
#declare elbow2_position = vrotate(<0, -upperarm_length, 0>, upperarm2_angle)
                           + shoulder2_position

#declare wrist1_position = vrotate(<0, -lowerarm_length, 0>, lowerarm1_angle)
                           + elbow1_position
#declare wrist2_position = vrotate(<0, -lowerarm_length, 0>, lowerarm2_angle)
                           + elbow2_position

#declare ribcage_base = vrotate(<0, -uppertorso_length, 0>, uppertorso_angle)
                           + neck_base

#declare pelvis_position = vrotate(<0, -lowertorso_length, 0>, lowertorso_angle)
                           + ribcage_base

#declare hip1_position = vrotate(<pelvis_width/2, 0, 0>, pelvis_angle) + pelvis_position
#declare hip2_position = vrotate(<-pelvis_width/2, 0, 0>, pelvis_angle) + pelvis_position

#declare knee1_position = vrotate(<0, -upperleg_length, 0>, upperleg1_angle)
                           + hip1_position
#declare knee2_position = vrotate(<0, -upperleg_length, 0>, upperleg2_angle)
                           + hip2_position

#declare ankle1_position = vrotate(<0, -lowerleg_length, 0>, lowerleg1_angle)
                           + knee1_position
#declare ankle2_position = vrotate(<0, -lowerleg_length, 0>, lowerleg2_angle)
                           + knee2_position


// --------------------------------------------
// declare the body parts
// --------------------------------------------
#declare head = blob { threshold 0.6
                     sphere { <0,0,0> 1.5, 1 scale <0.66,1,1> }
                     }
#declare head = union {
                     object { head }
                     cylinder { <-0.1,0.4,0.2> <0.1, 0.4, 0.2>, 0.8
                                 scale <1, 1.2, 1>
                                 texture { Gold_Hair }
                               }
                     //sphere { <0, 0, 0>, 0.75 scale <0.66, 1, 1> }
                     rotate head_angle
                     translate head_position
                     }

#declare shoulders = cylinder { shoulder1_position, shoulder2_position 0.3 }
#declare upper_torso = cylinder { neck_base, ribcage_base 0.8 } //<0, 3.5, 0>
#declare lower_torso = cylinder { ribcage_base, pelvis_position 0.6 }
#declare pelvis = cylinder { hip1_position, hip2_position 0.5 }

#declare upper_left_arm = cylinder { shoulder1_position, elbow1_position 0.3 }
#declare upper_right_arm = cylinder { shoulder2_position, elbow2_position 0.3 }
#declare lower_left_arm = cylinder { elbow1_position, wrist1_position 0.2 }
#declare lower_right_arm = cylinder { elbow2_position, wrist2_position 0.2 }
#declare left_hand = union {
                     box { <-0.1, 0, -0.2>, <0.1, -0.5, 0.2> }
                     box { <0,0,0>,<0.2, -0.5, 4> rotate <50,0,0> translate <-0.1, 0, -0.2>}
                     rotate wrist1_angle
                     translate wrist1_position
                     }
#declare right_hand = box { <-0.1, 0, -0.2>, <0.1, -1, 0.2> rotate wrist2_angle translate wrist2_position }

#declare upper_left_leg = cylinder { hip1_position, knee1_position 0.4 }
#declare upper_right_leg = cylinder { hip2_position, knee2_position 0.4 }
#declare lower_left_leg = cylinder { knee1_position, ankle1_position 0.35 }
#declare lower_right_leg = cylinder { knee2_position, ankle2_position 0.35 }
#declare left_foot = box { <-0.25, -0.5, -1>, <0.25, 0, 0.2> translate ankle1_position }
#declare right_foot = box { <-0.25, -0.5, -1>, <0.25, 0, 0.2> translate ankle2_position }




#declare main_body = blob {
                          threshold 0.5

                          #include "torsobik.inc"
                          }

#declare limbs = blob {
                          threshold 0.5

                          #include "armslegb.inc"
                          }


#declare body = union {
                      object { head }
                      object { main_body }
                      object { limbs }

                      object { left_hand }
                      object { right_hand }
                      object { left_foot }
                      object { right_foot }
                      }



