
// Persistence of Vision Ray Tracer Scene Description File
// File: destroy.pov
// Vers: 3
// Desc: Main Destroyer file
// Date: 31 December 1996
// Auth: Mick McMullin
//

#version 3

#include "biketex.inc"
#include "bodydest.inc"
#include "bike.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

// ********************* SKY
sphere { <0,-3200,0>, 3500 texture { FireSky_1 } hollow}

// ********************* CLOUDS
sphere { <0,0,0>, 1
         pigment { color rgbt <1, 1, 1, 1> }
              halo {
                      emitting
                      spherical_mapping
                      linear
                      turbulence 3
                      color_map {
                                [ 0 color rgbt <1, 1, 0,  1> ]
                                [ 1 color rgbt <1, 1, 1, -1> ]
                                }
                      samples 10
                      scale 0.5
                      }
              hollow
              scale <300, 1, 300>
              translate <0,-100,0>
 }

// ********************* GROUND
sphere { <0,-3200,0>, 3000 texture { Grass_1 }}


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}



// ----------------------------------------
#declare biker = union {
                       object { body texture { Robot_Skin }}
                       object { bike } //texture { pigment {rgb <1,0.6,0>} }}
                       scale 0.2
                       }

object { biker
         scale 1//0.5
         rotate <10, 50 ,0>
         translate <1, 0, 0>//<0, 0, 0>
         }
