// Written by Nir Shemi and Sharon Biniashvili, (c) 1996
// Site: http://www.morgile.com

#include "colors.inc"    // Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
#include "GLASS.INC"

 plane{ <0,1,0>,10 pigment{color Blue}/* normal{wrinkles 4} */finish{reflection 0.9}}
camera {location <0,80,-43> look_at<30.5,70,5>}

//light_source {<-50,80,-52> color White}

light_source
{
  0*x
  color rgb 1.0
  area_light
  <8, 0, 0> <0, 0, 8>
  40, 40
  adaptive 0
  jitter
  translate <40,800,-43>
 }

 light_source {<15,74,-43> color White}


height_field {
  tga "exp.tga"
  pigment { gradient y
            turbulence 1.5
            color_map {
                      [0   rgb<0.859,0.375,0>]
                      [0.1 rgb<0.562,0.246,0.003>]
                      [0.2 rgb<0.648,0.492,0.304>]
                      [0.3 rgb<0.535,0.382,0.207>]
                      [0.4 rgb<0.429,0.289,0.125>]
                      [0.5 rgb<0.335,0.207,0.05>]
                      [0.6 rgb<0.429,0.289,0.125>]
                      [0.7 rgb<0.535,0.382,0.207>]
                      [0.8 rgb<0.648,0.492,0.304>]
                      [0.9 rgb<0.562,0.246,0.003>]
                      [1   rgb<0.859,0.375,0>]
                      }
          }

  smooth
  normal { crackle 10 scale 0.3 }
   scale <2005,150,3005>
   translate<-30,-30,0>
 }

fog
{
  fog_type   2
  distance   0.05
  color rgb<0.8,0.6,0.6>
  fog_offset 0
  fog_alt    0.35
  turbulence <0.15,0.15,0.15>
  omega 0.35
  lambda 1.25
  octaves 5
}


  # declare col2=texture{pigment{MediumAquamarine} normal{bumps 0.6 scale 1.2}}

  # declare col3=texture{pigment{MediumAquamarine}}

  #declare col=texture { pigment {
                  crackle
                  color_map {
                            [0 /*rgb <0,0.3,0>*/ Aquamarine ]
                            [0.2 /*rgb <0,0.4,0>*/ MediumAquamarine ]
                            [0.7 rgb <0.15,0.8,0.58> ]}scale 0.3}
                  normal { crackle scale 0.4 }
 }

light_source
 {
  0*x
  color White
  area_light
  <8, 0, 0> <0, 0, 8>
  4, 4
  adaptive 0
  jitter
  translate <40, 80, -40>
  }

 #declare body =
  sphere { <0,0,0>1
       texture{ col }
       scale<1.5,0.5,1>
       translate<0,0.2,0>
  }



 # declare wing =
 union{
 cylinder{ <-1,0,-0.5>
          <-0.5,0,-1.25>0.17
 texture { col }
  }
 sphere {<-0.5,0,-1.25> 0.17 texture {col}}
 cylinder { <-0.5,0,-1.25>
           <-1,0,-2>0.17
           texture{ col }
 }
 sphere {<-1,0,-2> 0.17 texture {col}}
 cylinder {<-1,0,-2> <0,0,-4>0.13 texture { col }}
 sphere{<0,0,-4> 0.13 texture {col}}
 cone {<0,0,-4>,0.13 <3.1,0,-6>0.01 texture { col }}

  polygon{ 9, <-1,0>,<-0.5,-1.25>,<-1,-2>,<0,-4>,<3.1,-6>,<2.5,-4.5>,
  <2.2,-3.5>,<1.5,0>,<-1,0> texture{col2} rotate<90,0,0> }

 }


#declare nose=union {
 torus {0.07,0.05 texture{col} /*scale<1,1,1.6> rotate<90,90,0>*/ translate<-3.565,0.863,0.15>}
 torus {0.07,0.05 texture{col} /*scale<1,1,1.6> rotate<90,90,0>*/ translate<-3.565,0.863,-0.15>}
 }

 #declare leg =
  union {
   cone { <1.3,0,0>,0.17 <2,0,-1>,0.17 texture{col} }
   sphere { <2,0,-1> 0.17 texture{col} }
   cone { <2,0,-1>,0.17 <3,0,-1.6>,0.13 texture{col} }
   sphere { <3,0,-1.6> 0.13 texture{col} }
   cone { <3,0,-1.6>,0.13 <3.3,0,-1.6>,0.15 texture{col} }
  }
 # declare foot=
   superellipsoid { <0.5,1> texture{col} scale <0.1,0.35,0.2> translate<3.3,-0.18,-1.6> }

 #declare neck=
  cone{
 <-1,0.2,0>,0.4
 <-3,1.25,0>,0.15
 texture{ col }
 }

 #declare tail =
blob {
threshold 0.2
#declare delta=0.2
# declare loop= 1.5
# while (loop<6)
//# declare tempy=exp(loop)/20+cos(loop*3)
//# declare tempy2=exp(loop+delta)/20+cos((loop+delta)*3)
# declare tempy=cos(loop*2)+loop/3
# declare tempy2=cos((loop+delta)*2)+loop/3
#declare currrad=0.3-(loop)/10
#declare nextrad=0.3-((loop+delta))/10



//   sphere { <loop,tempy-0.3,0>, 0.3, 2 texture {col } }
   cylinder { < loop,tempy-0.3,0 ><loop+delta,tempy2-0.3,0> 0.3, 1 texture { col } }
   /*sphere {


    <loop,tempy,0>0.3-(loop/80)
    texture{ col }
   }*/
# declare loop=loop+delta
# end
scale <1.2,0.6,1>
translate<-0.3,0.6,0>
 }
# declare eye=
  union {
  torus{0.15,0.14 pigment{color White} rotate <90,0,0>}
  torus{0.15,0.138 pigment{color Black} rotate<90,0,0> translate<-0.003,-0.002,-0.0035>}
  }

# declare head=
difference {
 union{
  sphere{<-2.7,1.15,0> 0.5 texture{col} scale<0.75,2.74,1> rotate<0,0,-65>
         translate<-4.7,-2.1,0>}
  cone { <-2.6,1.1,0> ,0.28 <-2.6,2.4,0> ,0 pigment{gradient y color_map{[0.1 color Aquamarine]
          [0.7 color Gray85]} scale 1.2} rotate <0,0,-52>
       translate<-1.15,-1.27,0> /*normal {crackle 0.2 scale 2}*/}
  object{eye translate<-2.6,1.24,0.25>}
  object{eye translate<-2.6,1.24,-0.25>}
 }
 cylinder{<-0.75,4,0> <-0.75,4,-2>0.1 texture{col} scale<4,1,1> rotate<0,0,25> translate<0.8,-1.7,1>}
 object{nose}
}


 #declare creature =
 union {
  object{tail}
  object{neck}
  object{body}
  object{head}
  object {wing rotate <25,0,0> }
  object {wing rotate <180,0,0> rotate <-25,0,0>}
  object {leg rotate<12,0,0>}
  object {leg rotate <180,0,0> rotate <-12,0,0> }
  object {foot rotate <12,0,0>}
  object {foot rotate <180,0,0>}
 }


 object{creature rotate<-40,0,0> translate<7.5,78,-32>}
 object{creature rotate<70,0,0> translate<5,65,-10>}
 object{creature translate<32,50,10>}

#declare mount =
height_field
{
  tga
  "mount.tga"
    pigment { gradient y
            turbulence 1.5
            color_map {

                     // [0   rgb<0.859,0.375,0>]
                    //  [0.1 rgb<0.562,0.246,0.003>]
                     // [0.2 rgb<0.648,0.492,0.304>]
                    //  [0.3 rgb<0.535,0.382,0.207>]
                      [0.24 rgb<0.335,0.207,0.05>]
                    [0.4 rgb<0.429,0.289,0.125>]
                   //   [0.5 rgb<0.335,0.207,0.05>]
                      [0.2 rgb<0.429,0.289,0.125>]
                   //   [0.7 rgb<0.535,0.382,0.207>]
                   //   [0.8 rgb<0.648,0.492,0.304>]
                      [0.9 rgb<0.562,0.246,0.003>]
                   //   [1   rgb<0.859,0.375,0>]
                   //   [0.99 rgb<0.335,0.207,0.05>]

                      }
          }
  smooth
  rotate<0,60,0>
  scale <300,200,150>

  translate<450,0,450>
}

object{mount}


#declare cloud=                            // Making Cloud color_map
pigment {
    wrinkles scale 2
    turbulence 0.5
    octaves 8
    omega 0.4
    color_map {
        [0.0, 0.1   rgb<1,0.8,0.8>                                   //white/gray colors
                    color red 1 green 0.25 blue 0.25]
        [0.1, 0.4   rgb<1,0.62,0.65>
                    color red 1 green 0.7 blue 0.63  ]
       [0.5, 0.6   rgb <0.5, 0.4, 0.5>                              // dark blue colors
                 color red 0.5 green 0.4 blue 0.5 ]
    }
    scale <5.7, 1, 5.7>
}

#declare S_sky=
sky_sphere {
    pigment {
        gradient y
        pigment_map{[0.1 cloud scale 0.13]}                    // using cloud in sky_sphere
        }
    }


sky_sphere {S_sky}
