//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 6 textures and 1026 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/12/1996    (12.12.1996)
//

#max_trace_level 8

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//

#include "colors.inc"
#include "textures.inc"
// #include "my_tex.inc"
#include "shapes.inc"



camera {  //  Camera Camera01
  location  <0.100, -8.000, 1.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.500>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera2
  location  <0.100, -15.000, 1.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

*/

// *******  L I G H T S *******
light_source {   // Light001
  <-10.000, -10.000, 25.000>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light2
  <2.915, 9.376, -0.623>
  color rgb <1.000, 0.710, 0.000>
}

light_source {   // Light3
  <2.030, 8.491, -0.761>
  color rgb <1.000, 0.388, 0.000>
}


// ********  TEXTURES  *******
//

#include "space7.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



#include "spltwing.inc"

#declare FUSELAGE2_Ref = object {
  FUSELAGE01
}
#declare BOTTOM2_Ref = object {
  BOTTOM01
}
#declare CANNON2_Ref = object {
  CANNON01
}
#declare ENG2_Ref = object {
  ENG01
}
#declare TOP2_Ref = object {
  TOP01
}
#declare CANOPY2_Ref = object {
  CANOPY01
  texture {
    Sun_Glow1
  }
}
#declare DROID2_Ref = object {
  DROID01
}
#declare BzPtch5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid5
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate -90.0*x
  translate  <23.8, 3.6, -1.0>
}
#declare BzPtch6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid5
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate -90.0*x
  translate  <19.3, 3.6, -1.0>
}
#declare BzPtch7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid5
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate -90.0*x
  translate  <23.8, 3.6, 1.0>
}
#declare BzPtch8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid5
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate -90.0*x
  translate  <19.3, 3.6, 1.0>
}
union { // spltwing_obj1
  object { FUSELAGE2_Ref }
  object { BOTTOM2_Ref }
  object { CANNON2_Ref }
  object { ENG2_Ref }
  object { TOP2_Ref }
  object { CANOPY2_Ref }
  object { DROID2_Ref }
  object { BzPtch5 }
  object { BzPtch6 }
  object { BzPtch7 }
  object { BzPtch8 }
  texture {
    Chrome_Metal1
  }
  no_shadow
  scale 0.25
  rotate -30.0*x
  translate  <-20.0, 60.0, 0.0>
}


#declare FUSELAGE01_Ref = object {
  FUSELAGE01
}
#declare BOTTOM01_Ref = object {
  BOTTOM01
}
#declare CANNON01_Ref = object {
  CANNON01
}
#declare ENG01_Ref = object {
  ENG01
}
#declare TOP01_Ref = object {
  TOP01
}
#declare CANOPY01_Ref = object {
  CANOPY01
  texture {
    Sun_Glow1
  }
}
#declare DROID01_Ref = object {
  DROID01
}
#declare BzPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid6
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate <-90.0, 0.0, 0.0>
  translate  <19.3, 3.6, -1.0>
}
#declare BzPtch2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid6
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate <-90.0, 0.0, 0.0>
  translate  <23.8, 3.6, -1.0>
}
#declare BzPtch3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid6
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate <-90.0, 0.0, 0.0>
  translate  <19.3, 3.6, 1.0>
}
#declare BzPtch4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, -2.625214, -0.730124>, <-2.042024, -3.000000, -0.382236>, <-1.042024, -3.000000, -0.382236>, <-0.042024, -3.000000, -0.382236>, 
      <-2.296551, -2.000000, -0.730124>, <-2.042024, -2.000000, 6.758924>, <-1.042024, -2.000000, 6.758924>, <-0.042024, -2.000000, 6.758924>, 
      <-2.296551, -1.000000, -0.730124>, <-2.042024, -1.000000, 6.758924>, <-1.092152, -1.000000, 14.805866>, <-0.092152, -1.000000, 14.805866>, 
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.296551, 0.000000, -0.730124>, <-2.042024, 0.000000, 6.758924>, <-1.092152, 0.000000, 14.805866>, <-0.092152, 0.000000, 14.805866>, 
      <-2.296551, 1.000000, -0.730124>, <-2.042024, 1.000000, 6.758924>, <-1.092152, 1.000000, 14.805866>, <-0.092152, 1.000000, 14.805866>, 
      <-2.296551, 2.000000, -0.730124>, <-2.042024, 2.000000, 6.758924>, <-1.042024, 2.000000, 6.758924>, <-0.042024, 2.000000, 6.758924>, 
      <-2.296551, 2.637184, -0.730124>, <-2.041276, 3.000000, -0.439597>, <-1.041283, 3.000000, -0.435947>, <-0.041289, 3.000000, -0.432298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042024, -3.000000, -0.382236>, <0.957976, -3.000000, -0.382236>, <1.957976, -3.000000, -0.382236>, <2.262202, -2.711703, -0.730124>, 
      <-0.042024, -2.000000, 6.758924>, <0.957976, -2.000000, 6.758924>, <1.957976, -2.000000, 6.758924>, <2.262202, -2.000000, -0.730124>, 
      <-0.092152, -1.000000, 14.805866>, <0.907848, -1.000000, 14.805866>, <1.957976, -1.000000, 6.758924>, <2.262202, -1.000000, -0.730124>, 
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092152, 0.000000, 14.805866>, <0.907848, 0.000000, 14.805866>, <1.957976, 0.000000, 6.758924>, <2.262202, 0.000000, -0.730124>, 
      <-0.092152, 1.000000, 14.805866>, <0.907848, 1.000000, 14.805866>, <1.957976, 1.000000, 6.758924>, <2.262202, 1.000000, -0.730124>, 
      <-0.042024, 2.000000, 6.758924>, <0.957976, 2.000000, 6.758924>, <1.957976, 2.000000, 6.758924>, <2.262202, 2.000000, -0.730124>, 
      <-0.041289, 3.000000, -0.432298>, <0.958704, 3.000000, -0.428648>, <1.958697, 3.000000, -0.424998>, <2.262202, 2.588809, -0.730124>
    }
  }
  texture {
    Grid6
    scale 0.01
  }
  scale <0.08, 0.08, 1.0>
  rotate <-90.0, 0.0, 0.0>
  translate  <23.8, 3.6, 1.0>
}
union { // spltwing_obj
  object { FUSELAGE01_Ref }
  object { BOTTOM01_Ref }
  object { CANNON01_Ref }
  object { ENG01_Ref }
  object { TOP01_Ref }
  object { CANOPY01_Ref }
  object { DROID01_Ref }
  object { BzPtch001 }
  object { BzPtch2 }
  object { BzPtch3 }
  object { BzPtch4 }
  texture {
    Chrome_Metal1
  }
  no_shadow
  scale 0.25
  rotate <0.0, 30.0, -135.0>
  translate  <6.0, 12.0, 2.0>
}


object {   // HgtFld001
  height_field {
    gif "C:\POVRAY2\IMAGES\SATURN3.GIF"
    water_level 0.201
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    hf_tex
    scale 2.0
  translate <-1.000000, -1.000000, 0.000000>
  }
  no_shadow
  scale <6.4, 4.8, 0.5>
  rotate 90.0*x
  translate  <0.0, 20.0, -1.0>
}


union { // stars
  sphere { // sphere0_2
    <0,0,0>,1
    scale 8.0
    translate  <260.0, -1246.085326, 1604.361356>
  }
  sphere { // sphere1_3
    <0,0,0>,1
    scale 9.0
    translate  <-614.0, 1547.150477, 1193.161096>
  }
  sphere { // sphere2_4
    <0,0,0>,1
    scale 4.0
    translate  <1470.0, 600.277581, 1293.472391>
  }
  sphere { // sphere3_5
    <0,0,0>,1
    scale 2.0
    translate  <-1674.0, -319.876695, -1135.652632>
  }
  sphere { // sphere4_6
    <0,0,0>,1
    translate  <-223.0, -1550.973011, -1318.733377>
  }
  sphere { // sphere5_7
    <0,0,0>,1
    scale 8.0
    translate  <129.0, 290.921159, 2023.123298>
  }
  sphere { // sphere6_8
    <0,0,0>,1
    translate  <667.0, -190.632167, -1926.933932>
  }
  sphere { // sphere7_9
    <0,0,0>,1
    scale 4.0
    translate  <1160.0, 1021.401384, 1343.667821>
  }
  sphere { // sphere8_10
    <0,0,0>,1
    scale 7.0
    translate  <928.0, 1664.55439, 749.919117>
  }
  sphere { // sphere9_11
    <0,0,0>,1
    scale 3.0
    translate  <-156.0, -1080.975294, 1732.472341>
  }
  sphere { // sphere10_12
    <0,0,0>,1
    scale 8.0
    translate  <1407.0, 1478.543633, 169.008062>
  }
  sphere { // sphere11_13
    <0,0,0>,1
    translate  <-958.0, -733.925623, 1654.658025>
  }
  sphere { // sphere12_14
    <0,0,0>,1
    translate  <-1669.0, 420.603592, -1109.880903>
  }
  sphere { // sphere13_15
    <0,0,0>,1
    scale 9.0
    translate  <-918.0, -831.561782, 1630.976702>
  }
  sphere { // sphere14_16
    <0,0,0>,1
    scale 9.0
    translate  <927.0, -55.062167, -1825.361103>
  }
  sphere { // sphere15_17
    <0,0,0>,1
    scale 2.0
    translate  <-173.0, 1833.049808, 896.829639>
  }
  sphere { // sphere16_18
    <0,0,0>,1
    scale 7.0
    translate  <-471.0, 936.700423, 1759.27693>
  }
  sphere { // sphere17_19
    <0,0,0>,1
    scale 10.0
    translate  <-1428.0, -807.131258, -1226.237796>
  }
  sphere { // sphere18_20
    <0,0,0>,1
    scale 3.0
    translate  <2006.0, 207.57698, -356.622766>
  }
  sphere { // sphere19_21
    <0,0,0>,1
    scale 7.0
    translate  <-34.0, -1787.50362, 998.988892>
  }
  sphere { // sphere20_22
    <0,0,0>,1
    scale 9.0
    translate  <1841.0, -643.186953, 625.566578>
  }
  sphere { // sphere21_23
    <0,0,0>,1
    scale 9.0
    translate  <-301.0, -1740.640092, 1036.279436>
  }
  sphere { // sphere22_24
    <0,0,0>,1
    scale 3.0
    translate  <1545.0, 864.835031, 1029.242134>
  }
  sphere { // sphere23_25
    <0,0,0>,1
    scale 7.0
    translate  <1299.0, -78.373579, -1581.379329>
  }
  sphere { // sphere24_26
    <0,0,0>,1
    scale 9.0
    translate  <-387.0, -886.608671, 1805.120512>
  }
  sphere { // sphere25_27
    <0,0,0>,1
    scale 5.0
    translate  <908.0, -90.754824, -1833.467633>
  }
  sphere { // sphere26_28
    <0,0,0>,1
    scale 6.0
    translate  <-1905.0, 25.560343, 751.415776>
  }
  sphere { // sphere27_29
    <0,0,0>,1
    scale 5.0
    translate  <1840.0, 757.834166, 484.139831>
  }
  sphere { // sphere28_30
    <0,0,0>,1
    scale 6.0
    translate  <-513.0, 1375.819011, -1427.6754>
  }
  sphere { // sphere29_31
    <0,0,0>,1
    scale 7.0
    translate  <1978.0, -214.692759, 485.51727>
  }
  sphere { // sphere30_32
    <0,0,0>,1
    scale 7.0
    translate  <1070.0, 1185.415043, -1282.261742>
  }
  sphere { // sphere31_33
    <0,0,0>,1
    translate  <-1936.0, 660.7716, 97.922888>
  }
  sphere { // sphere32_34
    <0,0,0>,1
    scale 8.0
    translate  <-1254.0, 1110.823753, 1178.074102>
  }
  sphere { // sphere33_35
    <0,0,0>,1
    scale 9.0
    translate  <1401.0, -1125.380867, -982.354775>
  }
  sphere { // sphere34_36
    <0,0,0>,1
    scale 2.0
    translate  <1806.0, -413.201241, -872.887584>
  }
  sphere { // sphere35_37
    <0,0,0>,1
    scale 9.0
    translate  <1370.0, 633.208589, 1384.359376>
  }
  sphere { // sphere36_38
    <0,0,0>,1
    scale 10.0
    translate  <-1457.0, -1434.599222, -115.672257>
  }
  sphere { // sphere37_39
    <0,0,0>,1
    translate  <-1186.0, -1283.61964, 1067.721228>
  }
  sphere { // sphere38_40
    <0,0,0>,1
    scale 7.0
    translate  <-187.0, 1028.684792, 1761.006132>
  }
  sphere { // sphere39_41
    <0,0,0>,1
    scale 4.0
    translate  <-260.0, -1210.996556, 1631.009302>
  }
  sphere { // sphere40_42
    <0,0,0>,1
    scale 8.0
    translate  <-1096.0, 269.370643, 1708.955078>
  }
  sphere { // sphere41_43
    <0,0,0>,1
    scale 12.0
    translate  <16.0, 1896.442123, 773.016996>
  }
  sphere { // sphere42_44
    <0,0,0>,1
    scale 6.0
    translate  <-672.0, -1244.555707, 1481.148572>
  }
  sphere { // sphere43_45
    <0,0,0>,1
    scale 6.0
    translate  <-1649.0, 304.005194, -1175.875777>
  }
  sphere { // sphere44_46
    <0,0,0>,1
    scale 3.0
    translate  <-1850.0, 693.317397, -539.550726>
  }
  sphere { // sphere45_47
    <0,0,0>,1
    scale 8.0
    translate  <-366.0, -1201.097904, 1617.934431>
  }
  sphere { // sphere46_48
    <0,0,0>,1
    scale 11.0
    translate  <-138.0, 399.714458, 2003.868347>
  }
  sphere { // sphere47_49
    <0,0,0>,1
    scale 5.0
    translate  <511.0, 876.134367, 1779.20532>
  }
  sphere { // sphere48_50
    <0,0,0>,1
    scale 3.0
    translate  <974.0, 198.585337, 1790.584224>
  }
  sphere { // sphere49_51
    <0,0,0>,1
    scale 5.0
    translate  <428.0, 795.048131, 1838.210671>
  }
  sphere { // sphere50_52
    <0,0,0>,1
    scale 8.0
    translate  <-1719.0, 535.972765, 975.743919>
  }
  sphere { // sphere51_53
    <0,0,0>,1
    scale 11.0
    translate  <1247.0, -1140.108891, 1157.344683>
  }
  sphere { // sphere52_54
    <0,0,0>,1
    scale 9.0
    translate  <469.0, 907.719282, -1774.933437>
  }
  sphere { // sphere53_55
    <0,0,0>,1
    scale 3.0
    translate  <-758.0, 263.251145, -1884.260819>
  }
  sphere { // sphere54_56
    <0,0,0>,1
    scale 2.0
    translate  <1511.0, 971.02643, 984.017618>
  }
  sphere { // sphere55_57
    <0,0,0>,1
    scale 10.0
    translate  <-1723.0, -937.457737, 588.853116>
  }
  sphere { // sphere56_58
    <0,0,0>,1
    scale 6.0
    translate  <-212.0, -370.871851, -2002.95134>
  }
  sphere { // sphere57_59
    <0,0,0>,1
    scale 4.0
    translate  <-1423.0, -521.315317, 1377.535967>
  }
  sphere { // sphere58_60
    <0,0,0>,1
    scale 4.0
    translate  <1880.0, 606.531578, 540.391936>
  }
  sphere { // sphere59_61
    <0,0,0>,1
    scale 7.0
    translate  <-1527.0, -1185.337012, 676.425286>
  }
  sphere { // sphere60_62
    <0,0,0>,1
    scale 8.0
    translate  <1868.0, -718.227027, 434.775733>
  }
  sphere { // sphere61_63
    <0,0,0>,1
    scale 4.0
    translate  <-1619.0, 12.631302, -1254.18637>
  }
  sphere { // sphere62_64
    <0,0,0>,1
    scale 6.0
    translate  <209.0, 663.269025, -1926.317004>
  }
  sphere { // sphere63_65
    <0,0,0>,1
    scale 5.0
    translate  <-14.0, 1201.471927, 1658.485215>
  }
  sphere { // sphere64_66
    <0,0,0>,1
    translate  <131.0, 434.358674, -1997.116807>
  }
  sphere { // sphere65_67
    <0,0,0>,1
    scale 6.0
    translate  <-1636.0, 303.185902, 1194.104815>
  }
  sphere { // sphere66_68
    <0,0,0>,1
    scale 7.0
    translate  <-13.0, -491.115106, 1988.200431>
  }
  sphere { // sphere67_69
    <0,0,0>,1
    scale 5.0
    translate  <1866.0, 220.840971, -814.60252>
  }
  sphere { // sphere68_70
    <0,0,0>,1
    translate  <996.0, 1616.595305, 767.403165>
  }
  sphere { // sphere69_71
    <0,0,0>,1
    scale 11.0
    translate  <-1819.0, 261.966019, -903.834501>
  }
  sphere { // sphere70_72
    <0,0,0>,1
    translate  <396.0, 890.618942, 1801.190134>
  }
  sphere { // sphere71_73
    <0,0,0>,1
    translate  <851.0, 436.371335, -1810.989525>
  }
  sphere { // sphere72_74
    <0,0,0>,1
    scale 5.0
    translate  <508.0, -631.018249, -1880.972081>
  }
  sphere { // sphere73_75
    <0,0,0>,1
    scale 8.0
    translate  <1238.0, 1001.240537, 1288.090597>
  }
  sphere { // sphere74_76
    <0,0,0>,1
    scale 5.0
    translate  <1640.0, -871.407446, 863.338325>
  }
  sphere { // sphere75_77
    <0,0,0>,1
    scale 6.0
    translate  <-1489.0, 998.807621, -989.730436>
  }
  sphere { // sphere76_78
    <0,0,0>,1
    scale 4.0
    translate  <-810.0, 180.707519, -1872.311083>
  }
  sphere { // sphere77_79
    <0,0,0>,1
    scale 10.0
    translate  <1261.0, -1178.989564, -1101.892285>
  }
  sphere { // sphere78_80
    <0,0,0>,1
    scale 5.0
    translate  <1186.0, 814.032525, 1457.758227>
  }
  sphere { // sphere79_81
    <0,0,0>,1
    scale 3.0
    translate  <-1113.0, 1250.026603, -1180.240861>
  }
  sphere { // sphere80_82
    <0,0,0>,1
    scale 7.0
    translate  <1985.0, -449.822861, -227.460752>
  }
  sphere { // sphere81_83
    <0,0,0>,1
    scale 3.0
    translate  <-1661.0, -577.977446, 1049.440361>
  }
  sphere { // sphere82_84
    <0,0,0>,1
    translate  <-1536.0, 1169.3394, -683.851861>
  }
  sphere { // sphere83_85
    <0,0,0>,1
    scale 6.0
    translate  <-671.0, 1604.749218, -1081.130402>
  }
  sphere { // sphere84_86
    <0,0,0>,1
    scale 9.0
    translate  <1381.0, 103.474261, 1508.786293>
  }
  sphere { // sphere85_87
    <0,0,0>,1
    scale 12.0
    translate  <-987.0, -1778.920773, 235.745379>
  }
  sphere { // sphere86_88
    <0,0,0>,1
    scale 9.0
    translate  <-1061.0, 299.689892, -1725.911055>
  }
  sphere { // sphere87_89
    <0,0,0>,1
    scale 12.0
    translate  <-265.0, 1584.813817, -1269.820525>
  }
  sphere { // sphere88_90
    <0,0,0>,1
    scale 3.0
    translate  <1172.0, 257.501453, -1659.642432>
  }
  sphere { // sphere89_91
    <0,0,0>,1
    scale 8.0
    translate  <-2031.0, -43.23482, -259.757099>
  }
  sphere { // sphere90_92
    <0,0,0>,1
    scale 9.0
    translate  <-1783.0, 626.784847, 788.895275>
  }
  sphere { // sphere91_93
    <0,0,0>,1
    scale 9.0
    translate  <123.0, 758.877637, -1898.230685>
  }
  sphere { // sphere92_94
    <0,0,0>,1
    scale 8.0
    translate  <1137.0, -1597.551239, 591.071095>
  }
  sphere { // sphere93_95
    <0,0,0>,1
    translate  <-1698.0, 119.017992, 1138.830417>
  }
  sphere { // sphere94_96
    <0,0,0>,1
    scale 4.0
    translate  <-1454.0, 1389.643667, 386.106823>
  }
  sphere { // sphere95_97
    <0,0,0>,1
    scale 2.0
    translate  <-543.0, 768.234977, -1819.139912>
  }
  sphere { // sphere96_98
    <0,0,0>,1
    scale 11.0
    translate  <87.0, 1646.137685, -1215.304786>
  }
  sphere { // sphere97_99
    <0,0,0>,1
    scale 12.0
    translate  <-1720.0, 627.170154, -917.911542>
  }
  sphere { // sphere98_100
    <0,0,0>,1
    translate  <1517.0, -796.263923, -1122.042229>
  }
  sphere { // sphere99_101
    <0,0,0>,1
    scale 12.0
    translate  <-1581.0, -248.144109, -1277.954421>
  }
  sphere { // sphere100_102
    <0,0,0>,1
    scale 2.0
    translate  <-1016.0, -1105.089322, -1393.135166>
  }
  sphere { // sphere101_103
    <0,0,0>,1
    scale 10.0
    translate  <1578.0, 1146.339172, -624.601075>
  }
  sphere { // sphere102_104
    <0,0,0>,1
    scale 12.0
    translate  <642.0, 1591.285392, -1118.011985>
  }
  sphere { // sphere103_105
    <0,0,0>,1
    scale 6.0
    translate  <-1431.0, 399.453113, 1409.602856>
  }
  sphere { // sphere104_106
    <0,0,0>,1
    scale 4.0
    translate  <166.0, 320.691332, 2015.912962>
  }
  sphere { // sphere105_107
    <0,0,0>,1
    scale 3.0
    translate  <-614.0, -1810.693143, 733.960721>
  }
  sphere { // sphere106_108
    <0,0,0>,1
    scale 3.0
    translate  <-453.0, 362.420003, -1964.114748>
  }
  sphere { // sphere107_109
    <0,0,0>,1
    scale 9.0
    translate  <591.0, -179.16424, 1952.67078>
  }
  sphere { // sphere108_110
    <0,0,0>,1
    scale 8.0
    translate  <755.0, -394.020358, 1862.532404>
  }
  sphere { // sphere109_111
    <0,0,0>,1
    scale 12.0
    translate  <1840.0, 676.21619, -592.820095>
  }
  sphere { // sphere110_112
    <0,0,0>,1
    scale 8.0
    translate  <1620.0, 186.521289, -1238.997098>
  }
  sphere { // sphere111_113
    <0,0,0>,1
    scale 5.0
    translate  <-1845.0, -381.276673, -803.06108>
  }
  sphere { // sphere112_114
    <0,0,0>,1
    scale 5.0
    translate  <860.0, 849.136065, 1653.381971>
  }
  sphere { // sphere113_115
    <0,0,0>,1
    scale 7.0
    translate  <1654.0, -462.330376, -1115.723363>
  }
  sphere { // sphere114_116
    <0,0,0>,1
    scale 9.0
    translate  <957.0, 888.416678, 1577.710622>
  }
  sphere { // sphere115_117
    <0,0,0>,1
    scale 11.0
    translate  <-1229.0, -745.131766, 1458.986515>
  }
  sphere { // sphere116_118
    <0,0,0>,1
    scale 3.0
    translate  <72.0, -1599.010925, 1277.608728>
  }
  sphere { // sphere117_119
    <0,0,0>,1
    scale 2.0
    translate  <634.0, -239.502032, 1932.611388>
  }
  sphere { // sphere118_120
    <0,0,0>,1
    scale 4.0
    translate  <-1738.0, -1023.11803, -356.215521>
  }
  sphere { // sphere119_121
    <0,0,0>,1
    scale 9.0
    translate  <-1464.0, -301.216676, -1400.098752>
  }
  sphere { // sphere120_122
    <0,0,0>,1
    scale 8.0
    translate  <-1235.0, 633.888666, 1505.743723>
  }
  sphere { // sphere121_123
    <0,0,0>,1
    scale 12.0
    translate  <-1646.0, 110.524954, -1213.578277>
  }
  sphere { // sphere122_124
    <0,0,0>,1
    scale 9.0
    translate  <1924.0, 319.803718, 624.702795>
  }
  sphere { // sphere123_125
    <0,0,0>,1
    scale 10.0
    translate  <-524.0, -441.063268, -1930.075437>
  }
  sphere { // sphere124_126
    <0,0,0>,1
    scale 3.0
    translate  <-1799.0, -370.845092, 905.746608>
  }
  sphere { // sphere125_127
    <0,0,0>,1
    scale 7.0
    translate  <-63.0, -2009.548524, -389.935548>
  }
  sphere { // sphere126_128
    <0,0,0>,1
    scale 11.0
    translate  <1058.0, -346.985554, -1718.877839>
  }
  sphere { // sphere127_129
    <0,0,0>,1
    scale 7.0
    translate  <505.0, 1973.859077, -207.748272>
  }
  sphere { // sphere128_130
    <0,0,0>,1
    translate  <-464.0, -772.379327, -1839.140608>
  }
  sphere { // sphere129_131
    <0,0,0>,1
    scale 6.0
    translate  <-446.0, -1924.426717, -540.342309>
  }
  sphere { // sphere130_132
    <0,0,0>,1
    scale 8.0
    translate  <1788.0, -195.968835, 979.263098>
  }
  sphere { // sphere131_133
    <0,0,0>,1
    translate  <1537.0, 223.543931, 1334.901911>
  }
  sphere { // sphere132_134
    <0,0,0>,1
    scale 7.0
    translate  <-155.0, 370.06057, 2008.316254>
  }
  sphere { // sphere133_135
    <0,0,0>,1
    scale 4.0
    translate  <707.0, -601.359053, -1825.601898>
  }
  sphere { // sphere134_136
    <0,0,0>,1
    scale 11.0
    translate  <-1098.0, 936.988344, -1452.843021>
  }
  sphere { // sphere135_137
    <0,0,0>,1
    scale 3.0
    translate  <923.0, 471.337026, 1766.413431>
  }
  sphere { // sphere136_138
    <0,0,0>,1
    scale 3.0
    translate  <1646.0, 682.562249, 1009.503233>
  }
  sphere { // sphere137_139
    <0,0,0>,1
    scale 11.0
    translate  <1218.0, 1492.894396, 694.295558>
  }
  sphere { // sphere138_140
    <0,0,0>,1
    scale 4.0
    translate  <-1289.0, 372.127019, -1547.354026>
  }
  sphere { // sphere139_141
    <0,0,0>,1
    scale 6.0
    translate  <1180.0, -1101.656729, 1260.26047>
  }
  sphere { // sphere140_142
    <0,0,0>,1
    scale 4.0
    translate  <1255.0, 1150.100623, -1138.660422>
  }
  sphere { // sphere141_143
    <0,0,0>,1
    scale 9.0
    translate  <-111.0, 1071.672475, -1741.694895>
  }
  sphere { // sphere142_144
    <0,0,0>,1
    scale 3.0
    translate  <-1986.0, 147.645406, 477.816737>
  }
  sphere { // sphere143_145
    <0,0,0>,1
    scale 7.0
    translate  <-922.0, 645.923318, 1710.848639>
  }
  sphere { // sphere144_146
    <0,0,0>,1
    scale 3.0
    translate  <1144.0, -908.756725, 1435.175674>
  }
  sphere { // sphere145_147
    <0,0,0>,1
    scale 10.0
    translate  <1929.0, -300.302427, -618.935741>
  }
  sphere { // sphere146_148
    <0,0,0>,1
    scale 8.0
    translate  <-1856.0, -849.764593, -165.735139>
  }
  sphere { // sphere147_149
    <0,0,0>,1
    scale 7.0
    translate  <-350.0, -336.968718, -1989.53665>
  }
  sphere { // sphere148_150
    <0,0,0>,1
    scale 7.0
    translate  <-664.0, 610.276726, 1838.741504>
  }
  sphere { // sphere149_151
    <0,0,0>,1
    scale 6.0
    translate  <-1827.0, -63.373094, -923.232826>
  }
  sphere { // sphere150_152
    <0,0,0>,1
    scale 9.0
    translate  <-55.0, -1689.265507, 1156.572974>
  }
  sphere { // sphere151_153
    <0,0,0>,1
    scale 11.0
    translate  <1491.0, 984.275673, -1001.211466>
  }
  sphere { // sphere152_154
    <0,0,0>,1
    scale 11.0
    translate  <1011.0, 1170.561468, 1342.374333>
  }
  sphere { // sphere153_155
    <0,0,0>,1
    scale 2.0
    translate  <1689.0, 50.829721, -1157.15139>
  }
  sphere { // sphere154_156
    <0,0,0>,1
    translate  <1323.0, -226.044269, -1546.893335>
  }
  sphere { // sphere155_157
    <0,0,0>,1
    scale 5.0
    translate  <1120.0, -1496.101901, -837.605577>
  }
  sphere { // sphere156_158
    <0,0,0>,1
    translate  <1259.0, -1117.524837, -1166.345248>
  }
  sphere { // sphere157_159
    <0,0,0>,1
    translate  <-1972.0, 528.853202, 160.730491>
  }
  sphere { // sphere158_160
    <0,0,0>,1
    scale 3.0
    translate  <563.0, -268.971835, -1950.63814>
  }
  sphere { // sphere159_161
    <0,0,0>,1
    scale 10.0
    translate  <630.0, 1098.518529, -1609.553056>
  }
  sphere { // sphere160_162
    <0,0,0>,1
    scale 6.0
    translate  <549.0, 198.821765, 1963.000995>
  }
  sphere { // sphere161_163
    <0,0,0>,1
    scale 6.0
    translate  <-817.0, 1059.688731, -1550.443419>
  }
  sphere { // sphere162_164
    <0,0,0>,1
    scale 2.0
    translate  <-1629.0, 1202.521648, 307.578748>
  }
  sphere { // sphere163_165
    <0,0,0>,1
    scale 8.0
    translate  <866.0, 1851.137927, 132.80202>
  }
  sphere { // sphere164_166
    <0,0,0>,1
    scale 7.0
    translate  <1827.0, 348.213121, -857.392922>
  }
  sphere { // sphere165_167
    <0,0,0>,1
    scale 7.0
    translate  <197.0, 865.716843, -1845.543104>
  }
  sphere { // sphere166_168
    <0,0,0>,1
    scale 8.0
    translate  <1851.0, 297.630143, 824.329605>
  }
  sphere { // sphere167_169
    <0,0,0>,1
    scale 3.0
    translate  <1223.0, 806.628115, 1431.05768>
  }
  sphere { // sphere168_170
    <0,0,0>,1
    scale 7.0
    translate  <1678.0, 214.347667, 1154.41547>
  }
  sphere { // sphere169_171
    <0,0,0>,1
    scale 3.0
    translate  <-206.0, 1586.537658, 1278.579782>
  }
  sphere { // sphere170_172
    <0,0,0>,1
    scale 8.0
    translate  <-1217.0, 759.248857, 1461.764746>
  }
  sphere { // sphere171_173
    <0,0,0>,1
    scale 7.0
    translate  <578.0, -1829.116465, 717.323467>
  }
  sphere { // sphere172_174
    <0,0,0>,1
    scale 8.0
    translate  <-1797.0, 974.537665, -123.981206>
  }
  sphere { // sphere173_175
    <0,0,0>,1
    scale 4.0
    translate  <-1341.0, 496.003631, -1466.288989>
  }
  sphere { // sphere174_176
    <0,0,0>,1
    scale 9.0
    translate  <-367.0, -292.192404, -1993.549247>
  }
  sphere { // sphere175_177
    <0,0,0>,1
    scale 6.0
    translate  <-11.0, 31.249549, 2047.73203>
  }
  sphere { // sphere176_178
    <0,0,0>,1
    scale 10.0
    translate  <-658.0, -481.421553, -1878.715862>
  }
  sphere { // sphere177_179
    <0,0,0>,1
    scale 7.0
    translate  <1602.0, 365.697516, 1222.360555>
  }
  sphere { // sphere178_180
    <0,0,0>,1
    scale 5.0
    translate  <971.0, 1648.330515, -731.074219>
  }
  sphere { // sphere179_181
    <0,0,0>,1
    scale 2.0
    translate  <1657.0, 773.18719, -922.408028>
  }
  sphere { // sphere180_182
    <0,0,0>,1
    scale 12.0
    translate  <1070.0, -1609.614996, -677.158449>
  }
  sphere { // sphere181_183
    <0,0,0>,1
    scale 8.0
    translate  <-1373.0, -877.49677, -1240.634684>
  }
  sphere { // sphere182_184
    <0,0,0>,1
    scale 9.0
    translate  <484.0, 318.708845, 1964.299537>
  }
  sphere { // sphere183_185
    <0,0,0>,1
    scale 5.0
    translate  <695.0, -776.395769, 1763.090641>
  }
  sphere { // sphere184_186
    <0,0,0>,1
    scale 5.0
    translate  <1116.0, -1015.197919, -1384.998623>
  }
  sphere { // sphere185_187
    <0,0,0>,1
    scale 3.0
    translate  <331.0, -1230.358838, 1603.421383>
  }
  sphere { // sphere186_188
    <0,0,0>,1
    translate  <-803.0, -1428.761511, -1228.061702>
  }
  sphere { // sphere187_189
    <0,0,0>,1
    scale 6.0
    translate  <1069.0, 1331.154162, -1131.181505>
  }
  sphere { // sphere188_190
    <0,0,0>,1
    scale 9.0
    translate  <1235.0, -126.338987, -1628.839299>
  }
  sphere { // sphere189_191
    <0,0,0>,1
    scale 11.0
    translate  <243.0, -1656.341131, 1179.741098>
  }
  sphere { // sphere190_192
    <0,0,0>,1
    scale 9.0
    translate  <-1804.0, -17.692504, 969.316757>
  }
  sphere { // sphere191_193
    <0,0,0>,1
    scale 3.0
    translate  <-1001.0, 1464.672282, 1023.2488>
  }
  sphere { // sphere192_194
    <0,0,0>,1
    scale 9.0
    translate  <-1839.0, 39.938992, 900.437603>
  }
  sphere { // sphere193_195
    <0,0,0>,1
    scale 11.0
    translate  <949.0, 193.626015, 1804.497705>
  }
  sphere { // sphere194_196
    <0,0,0>,1
    translate  <-797.0, -396.448586, -1844.430405>
  }
  sphere { // sphere195_197
    <0,0,0>,1
    scale 3.0
    translate  <-2045.0, 59.517439, 93.47018>
  }
  sphere { // sphere196_198
    <0,0,0>,1
    scale 5.0
    translate  <-1813.0, 324.994267, -895.384681>
  }
  sphere { // sphere197_199
    <0,0,0>,1
    scale 8.0
    translate  <1221.0, -209.642203, 1630.801382>
  }
  sphere { // sphere198_200
    <0,0,0>,1
    scale 2.0
    translate  <-95.0, 1531.599543, -1356.274986>
  }
  sphere { // sphere199_201
    <0,0,0>,1
    scale 5.0
    translate  <-1463.0, 1198.028517, -786.551125>
  }
  sphere { // sphere200_202
    <0,0,0>,1
    scale 11.0
    translate  <-1857.0, 542.667252, -671.838711>
  }
  sphere { // sphere201_203
    <0,0,0>,1
    scale 11.0
    translate  <-945.0, -1061.065862, -1474.929909>
  }
  sphere { // sphere202_204
    <0,0,0>,1
    translate  <1587.0, 892.577345, 937.571695>
  }
  sphere { // sphere203_205
    <0,0,0>,1
    scale 3.0
    translate  <-1296.0, -457.033567, -1518.488827>
  }
  sphere { // sphere204_206
    <0,0,0>,1
    scale 7.0
    translate  <503.0, 183.937934, 1976.730087>
  }
  sphere { // sphere205_207
    <0,0,0>,1
    scale 11.0
    translate  <2045.0, 104.006724, 38.230896>
  }
  sphere { // sphere206_208
    <0,0,0>,1
    scale 12.0
    translate  <-515.0, -854.868027, -1788.373467>
  }
  sphere { // sphere207_209
    <0,0,0>,1
    scale 10.0
    translate  <887.0, -1731.931053, 638.709501>
  }
  sphere { // sphere208_210
    <0,0,0>,1
    scale 5.0
    translate  <1303.0, -1186.179796, 1043.77799>
  }
  sphere { // sphere209_211
    <0,0,0>,1
    scale 10.0
    translate  <1701.0, 888.843687, -714.744639>
  }
  sphere { // sphere210_212
    <0,0,0>,1
    scale 2.0
    translate  <-2017.0, -192.681259, -298.14247>
  }
  sphere { // sphere211_213
    <0,0,0>,1
    scale 11.0
    translate  <6.0, -1053.24548, 1756.400284>
  }
  sphere { // sphere212_214
    <0,0,0>,1
    scale 7.0
    translate  <-1917.0, 390.836159, -605.526297>
  }
  sphere { // sphere213_215
    <0,0,0>,1
    scale 12.0
    translate  <1441.0, -490.124697, 1370.255736>
  }
  sphere { // sphere214_216
    <0,0,0>,1
    scale 5.0
    translate  <601.0, -1066.148068, 1642.081392>
  }
  sphere { // sphere215_217
    <0,0,0>,1
    scale 2.0
    translate  <-1905.0, 92.145726, -746.182394>
  }
  sphere { // sphere216_218
    <0,0,0>,1
    scale 2.0
    translate  <1634.0, -737.139667, 990.440868>
  }
  sphere { // sphere217_219
    <0,0,0>,1
    scale 8.0
    translate  <1613.0, -137.410337, -1254.453427>
  }
  sphere { // sphere218_220
    <0,0,0>,1
    scale 11.0
    translate  <508.0, -302.975947, -1960.725778>
  }
  sphere { // sphere219_221
    <0,0,0>,1
    scale 7.0
    translate  <-953.0, -754.246688, 1648.39526>
  }
  sphere { // sphere220_222
    <0,0,0>,1
    scale 10.0
    translate  <439.0, 1153.060125, -1634.636151>
  }
  sphere { // sphere221_223
    <0,0,0>,1
    translate  <-1492.0, 46.325099, -1402.174734>
  }
  sphere { // sphere222_224
    <0,0,0>,1
    scale 10.0
    translate  <-681.0, 1553.27972, -1147.983063>
  }
  sphere { // sphere223_225
    <0,0,0>,1
    scale 12.0
    translate  <536.0, -1881.066015, 607.123257>
  }
  sphere { // sphere224_226
    <0,0,0>,1
    scale 8.0
    translate  <845.0, -873.338197, 1648.502167>
  }
  sphere { // sphere225_227
    <0,0,0>,1
    scale 9.0
    translate  <-969.0, 1242.078473, -1308.657353>
  }
  sphere { // sphere226_228
    <0,0,0>,1
    scale 5.0
    translate  <-1989.0, -22.906661, 487.502087>
  }
  sphere { // sphere227_229
    <0,0,0>,1
    scale 11.0
    translate  <-1935.0, -283.354771, 608.102848>
  }
  sphere { // sphere228_230
    <0,0,0>,1
    translate  <1767.0, -242.351583, 1006.618453>
  }
  sphere { // sphere229_231
    <0,0,0>,1
    scale 4.0
    translate  <1495.0, -175.22411, 1388.73162>
  }
  sphere { // sphere230_232
    <0,0,0>,1
    scale 5.0
    translate  <-6.0, 244.123952, -2033.389165>
  }
  sphere { // sphere231_233
    <0,0,0>,1
    scale 8.0
    translate  <1791.0, 714.168957, 690.351867>
  }
  sphere { // sphere232_234
    <0,0,0>,1
    scale 6.0
    translate  <-1735.0, -202.368473, -1069.170707>
  }
  sphere { // sphere233_235
    <0,0,0>,1
    scale 12.0
    translate  <1535.0, -530.751344, 1247.550404>
  }
  sphere { // sphere234_236
    <0,0,0>,1
    scale 11.0
    translate  <-1163.0, -744.098221, 1512.631098>
  }
  sphere { // sphere235_237
    <0,0,0>,1
    scale 3.0
    translate  <-814.0, 853.615163, 1674.230914>
  }
  sphere { // sphere236_238
    <0,0,0>,1
    translate  <-218.0, 1589.666795, 1272.68986>
  }
  sphere { // sphere237_239
    <0,0,0>,1
    scale 3.0
    translate  <-1806.0, 230.178437, -937.915714>
  }
  sphere { // sphere238_240
    <0,0,0>,1
    translate  <-1100.0, -17.713765, 1727.423>
  }
  sphere { // sphere239_241
    <0,0,0>,1
    scale 6.0
    translate  <-665.0, -853.361264, 1738.923102>
  }
  sphere { // sphere240_242
    <0,0,0>,1
    scale 6.0
    translate  <1739.0, 218.608042, -1059.430755>
  }
  sphere { // sphere241_243
    <0,0,0>,1
    scale 10.0
    translate  <1848.0, 85.34139, 878.587985>
  }
  sphere { // sphere242_244
    <0,0,0>,1
    scale 12.0
    translate  <380.0, 1489.429629, -1353.330477>
  }
  sphere { // sphere243_245
    <0,0,0>,1
    scale 10.0
    translate  <1815.0, 415.067159, -853.110927>
  }
  sphere { // sphere244_246
    <0,0,0>,1
    scale 6.0
    translate  <-1328.0, -1475.908132, -502.40938>
  }
  sphere { // sphere245_247
    <0,0,0>,1
    scale 10.0
    translate  <-1491.0, -1363.383768, -335.272576>
  }
  sphere { // sphere246_248
    <0,0,0>,1
    scale 10.0
    translate  <1145.0, 538.197552, -1610.472724>
  }
  sphere { // sphere247_249
    <0,0,0>,1
    translate  <1401.0, -768.975308, -1280.695114>
  }
  sphere { // sphere248_250
    <0,0,0>,1
    scale 5.0
    translate  <-1922.0, -203.406988, 677.381427>
  }
  sphere { // sphere249_251
    <0,0,0>,1
    scale 2.0
    translate  <-828.0, -1190.959741, 1445.79905>
  }
  sphere { // sphere250_252
    <0,0,0>,1
    scale 2.0
    translate  <104.0, -577.379103, 1962.172615>
  }
  sphere { // sphere251_253
    <0,0,0>,1
    scale 10.0
    translate  <-1509.0, -1303.676097, -466.531492>
  }
  sphere { // sphere252_254
    <0,0,0>,1
    scale 8.0
    translate  <289.0, -620.849646, 1930.111063>
  }
  sphere { // sphere253_255
    <0,0,0>,1
    scale 2.0
    translate  <1771.0, 915.904233, -467.955591>
  }
  sphere { // sphere254_256
    <0,0,0>,1
    scale 11.0
    translate  <1229.0, 1294.581452, -1003.953119>
  }
  sphere { // sphere255_257
    <0,0,0>,1
    scale 6.0
    translate  <-458.0, 194.691025, 1986.614055>
  }
  sphere { // sphere256_258
    <0,0,0>,1
    scale 8.0
    translate  <1840.0, 867.115533, 238.358245>
  }
  sphere { // sphere257_259
    <0,0,0>,1
    scale 6.0
    translate  <-1508.0, -837.153826, 1104.270561>
  }
  sphere { // sphere258_260
    <0,0,0>,1
    scale 12.0
    translate  <-1107.0, -74.352225, 1721.431598>
  }
  sphere { // sphere259_261
    <0,0,0>,1
    scale 3.0
    translate  <1976.0, -282.568823, 458.129742>
  }
  sphere { // sphere260_262
    <0,0,0>,1
    scale 7.0
    translate  <-65.0, -710.516871, 1919.699137>
  }
  sphere { // sphere261_263
    <0,0,0>,1
    scale 3.0
    translate  <-622.0, -1290.876428, -1463.235472>
  }
  sphere { // sphere262_264
    <0,0,0>,1
    scale 9.0
    translate  <981.0, 1103.739831, 1419.049466>
  }
  sphere { // sphere263_265
    <0,0,0>,1
    scale 11.0
    translate  <1093.0, -1508.797586, 850.402755>
  }
  sphere { // sphere264_266
    <0,0,0>,1
    scale 11.0
    translate  <-1867.0, -26.46016, -841.376765>
  }
  sphere { // sphere265_267
    <0,0,0>,1
    scale 10.0
    translate  <166.0, 424.722902, 1996.586701>
  }
  sphere { // sphere266_268
    <0,0,0>,1
    scale 2.0
    translate  <805.0, 978.933426, 1608.716366>
  }
  sphere { // sphere267_269
    <0,0,0>,1
    translate  <1173.0, -1606.870579, -486.150123>
  }
  sphere { // sphere268_270
    <0,0,0>,1
    scale 12.0
    translate  <-946.0, -1568.415442, -916.221044>
  }
  sphere { // sphere269_271
    <0,0,0>,1
    scale 12.0
    translate  <473.0, -1709.619282, -1023.609745>
  }
  sphere { // sphere270_272
    <0,0,0>,1
    translate  <-666.0, -999.785157, -1658.667429>
  }
  sphere { // sphere271_273
    <0,0,0>,1
    scale 4.0
    translate  <-1342.0, -1333.833013, -783.727946>
  }
  sphere { // sphere272_274
    <0,0,0>,1
    scale 2.0
    translate  <612.0, -1627.331924, -1082.382007>
  }
  sphere { // sphere273_275
    <0,0,0>,1
    scale 2.0
    translate  <256.0, -1307.538566, 1555.349124>
  }
  sphere { // sphere274_276
    <0,0,0>,1
    scale 4.0
    translate  <1060.0, -582.474175, -1652.70319>
  }
  sphere { // sphere275_277
    <0,0,0>,1
    translate  <1528.0, 184.271472, 1351.134347>
  }
  sphere { // sphere276_278
    <0,0,0>,1
    scale 8.0
    translate  <2046.0, 24.427888, 87.127942>
  }
  sphere { // sphere277_279
    <0,0,0>,1
    translate  <-1253.0, 1551.447235, -466.16143>
  }
  sphere { // sphere278_280
    <0,0,0>,1
    scale 4.0
    translate  <-1003.0, -332.834504, 1754.285094>
  }
  sphere { // sphere279_281
    <0,0,0>,1
    translate  <-494.0, 904.480567, -1769.797419>
  }
  sphere { // sphere280_282
    <0,0,0>,1
    scale 12.0
    translate  <-599.0, -543.520812, 1881.512192>
  }
  sphere { // sphere281_283
    <0,0,0>,1
    scale 8.0
    translate  <1621.0, -383.1235, 1191.586918>
  }
  sphere { // sphere282_284
    <0,0,0>,1
    scale 4.0
    translate  <-892.0, -533.010823, 1764.805786>
  }
  sphere { // sphere283_285
    <0,0,0>,1
    scale 11.0
    translate  <-1640.0, -964.844725, 757.481786>
  }
  sphere { // sphere284_286
    <0,0,0>,1
    scale 8.0
    translate  <1307.0, -1558.534353, -238.800485>
  }
  sphere { // sphere285_287
    <0,0,0>,1
    scale 11.0
    translate  <-858.0, 393.50947, 1817.495611>
  }
  sphere { // sphere286_288
    <0,0,0>,1
    scale 10.0
    translate  <1352.0, 325.801901, -1503.413822>
  }
  sphere { // sphere287_289
    <0,0,0>,1
    scale 12.0
    translate  <174.0, 771.450531, -1889.151153>
  }
  sphere { // sphere288_290
    <0,0,0>,1
    scale 4.0
    translate  <-363.0, -1904.977402, 658.480142>
  }
  sphere { // sphere289_291
    <0,0,0>,1
    scale 10.0
    translate  <-1112.0, -1069.740228, 1346.631295>
  }
  sphere { // sphere290_292
    <0,0,0>,1
    scale 2.0
    translate  <-69.0, -1816.967891, 942.428078>
  }
  sphere { // sphere291_293
    <0,0,0>,1
    scale 5.0
    translate  <1894.0, 115.13133, 770.592484>
  }
  sphere { // sphere292_294
    <0,0,0>,1
    scale 12.0
    translate  <-355.0, 639.421699, 1912.960765>
  }
  sphere { // sphere293_295
    <0,0,0>,1
    scale 8.0
    translate  <-2039.0, 44.587652, -186.534022>
  }
  sphere { // sphere294_296
    <0,0,0>,1
    scale 5.0
    translate  <1861.0, 177.737204, -836.296889>
  }
  sphere { // sphere295_297
    <0,0,0>,1
    scale 2.0
    translate  <504.0, 1224.278891, -1562.507343>
  }
  sphere { // sphere296_298
    <0,0,0>,1
    scale 11.0
    translate  <-914.0, -671.61409, 1705.239723>
  }
  sphere { // sphere297_299
    <0,0,0>,1
    scale 12.0
    translate  <-1239.0, 210.904152, -1617.004155>
  }
  sphere { // sphere298_300
    <0,0,0>,1
    scale 7.0
    translate  <-539.0, -321.019154, -1949.546025>
  }
  sphere { // sphere299_301
    <0,0,0>,1
    scale 7.0
    translate  <-666.0, -413.011272, 1892.133634>
  }
  sphere { // sphere300_302
    <0,0,0>,1
    scale 2.0
    translate  <443.0, 1106.664438, -1665.33745>
  }
  sphere { // sphere301_303
    <0,0,0>,1
    scale 8.0
    translate  <-1691.0, -422.253923, -1075.418349>
  }
  sphere { // sphere302_304
    <0,0,0>,1
    scale 4.0
    translate  <-1724.0, 253.163585, -1076.120904>
  }
  sphere { // sphere303_305
    <0,0,0>,1
    scale 2.0
    translate  <-250.0, 2009.855947, -303.781293>
  }
  sphere { // sphere304_306
    <0,0,0>,1
    scale 10.0
    translate  <-965.0, -1779.828274, 308.691294>
  }
  sphere { // sphere305_307
    <0,0,0>,1
    scale 7.0
    translate  <1921.0, -185.423493, 685.33286>
  }
  sphere { // sphere306_308
    <0,0,0>,1
    scale 5.0
    translate  <-809.0, -81.072868, -1879.694175>
  }
  sphere { // sphere307_309
    <0,0,0>,1
    scale 9.0
    translate  <1399.0, -331.747741, -1458.439727>
  }
  sphere { // sphere308_310
    <0,0,0>,1
    scale 11.0
    translate  <-1674.0, -986.994593, 646.428397>
  }
  sphere { // sphere309_311
    <0,0,0>,1
    scale 5.0
    translate  <-575.0, -98.257222, -1963.166961>
  }
  sphere { // sphere310_312
    <0,0,0>,1
    scale 4.0
    translate  <-643.0, 1607.511472, -1093.966117>
  }
  sphere { // sphere311_313
    <0,0,0>,1
    scale 3.0
    translate  <-650.0, -1234.09066, -1499.608029>
  }
  sphere { // sphere312_314
    <0,0,0>,1
    scale 12.0
    translate  <-675.0, -1680.541104, 956.274332>
  }
  sphere { // sphere313_315
    <0,0,0>,1
    scale 6.0
    translate  <-220.0, 1681.712184, -1147.932111>
  }
  sphere { // sphere314_316
    <0,0,0>,1
    scale 4.0
    translate  <816.0, -944.482051, 1623.699989>
  }
  sphere { // sphere315_317
    <0,0,0>,1
    scale 10.0
    translate  <1320.0, 1000.928131, 1204.178922>
  }
  sphere { // sphere316_318
    <0,0,0>,1
    scale 11.0
    translate  <-980.0, -757.01389, 1631.206293>
  }
  sphere { // sphere317_319
    <0,0,0>,1
    scale 6.0
    translate  <849.0, -908.888648, 1627.090786>
  }
  sphere { // sphere318_320
    <0,0,0>,1
    scale 5.0
    translate  <1335.0, -1314.87236, -826.552888>
  }
  sphere { // sphere319_321
    <0,0,0>,1
    scale 12.0
    translate  <61.0, -280.375549, -2027.799929>
  }
  sphere { // sphere320_322
    <0,0,0>,1
    scale 10.0
    translate  <-2027.0, 242.663763, -163.368597>
  }
  sphere { // sphere321_323
    <0,0,0>,1
    scale 7.0
    translate  <-1632.0, -190.22991, 1222.576207>
  }
  sphere { // sphere322_324
    <0,0,0>,1
    scale 11.0
    translate  <1381.0, -691.182217, -1345.143168>
  }
  sphere { // sphere323_325
    <0,0,0>,1
    translate  <1928.0, 52.994299, -688.702842>
  }
  sphere { // sphere324_326
    <0,0,0>,1
    scale 12.0
    translate  <-1239.0, -1001.570781, -1286.871777>
  }
  sphere { // sphere325_327
    <0,0,0>,1
    scale 10.0
    translate  <978.0, -740.009709, 1640.184633>
  }
  sphere { // sphere326_328
    <0,0,0>,1
    scale 2.0
    translate  <1754.0, 728.024304, -766.66069>
  }
  sphere { // sphere327_329
    <0,0,0>,1
    scale 5.0
    translate  <1653.0, -850.435539, 859.450053>
  }
  sphere { // sphere328_330
    <0,0,0>,1
    scale 11.0
    translate  <-486.0, -670.654625, 1873.053756>
  }
  sphere { // sphere329_331
    <0,0,0>,1
    scale 6.0
    translate  <-274.0, 708.819782, -1901.789293>
  }
  sphere { // sphere330_332
    <0,0,0>,1
    scale 6.0
    translate  <1237.0, 960.063666, 1320.004833>
  }
  sphere { // sphere331_333
    <0,0,0>,1
    translate  <241.0, -899.829305, -1823.877798>
  }
  sphere { // sphere332_334
    <0,0,0>,1
    scale 3.0
    translate  <1076.0, -458.401443, -1681.1889>
  }
  sphere { // sphere333_335
    <0,0,0>,1
    scale 5.0
    translate  <-1843.0, 681.61097, -577.114794>
  }
  sphere { // sphere334_336
    <0,0,0>,1
    scale 3.0
    translate  <1537.0, 292.606283, 1321.482714>
  }
  sphere { // sphere335_337
    <0,0,0>,1
    scale 10.0
    translate  <1072.0, -232.72, 1729.439621>
  }
  sphere { // sphere336_338
    <0,0,0>,1
    scale 3.0
    translate  <-727.0, 1773.5723, 721.260213>
  }
  sphere { // sphere337_339
    <0,0,0>,1
    scale 2.0
    translate  <-1855.0, 422.145163, -758.335322>
  }
  sphere { // sphere338_340
    <0,0,0>,1
    scale 3.0
    translate  <215.0, 280.814676, 2017.2313>
  }
  sphere { // sphere339_341
    <0,0,0>,1
    scale 2.0
    translate  <-801.0, -1641.891101, -925.687102>
  }
  sphere { // sphere340_342
    <0,0,0>,1
    scale 12.0
    translate  <1313.0, 27.532135, -1571.488779>
  }
  sphere { // sphere341_343
    <0,0,0>,1
    scale 6.0
    translate  <-1550.0, -577.133126, 1207.775375>
  }
  sphere { // sphere342_344
    <0,0,0>,1
    scale 7.0
    translate  <-637.0, 97.653436, 1943.964713>
  }
  sphere { // sphere343_345
    <0,0,0>,1
    scale 7.0
    translate  <1348.0, 167.695196, -1532.670324>
  }
  sphere { // sphere344_346
    <0,0,0>,1
    scale 12.0
    translate  <913.0, -95.667254, -1830.732852>
  }
  sphere { // sphere345_347
    <0,0,0>,1
    scale 2.0
    translate  <-552.0, 1515.989595, 1261.497344>
  }
  sphere { // sphere346_348
    <0,0,0>,1
    scale 10.0
    translate  <-1588.0, -569.596666, 1161.085543>
  }
  sphere { // sphere347_349
    <0,0,0>,1
    scale 5.0
    translate  <1466.0, 698.80824, -1247.723945>
  }
  sphere { // sphere348_350
    <0,0,0>,1
    scale 7.0
    translate  <351.0, -488.168499, 1957.752414>
  }
  sphere { // sphere349_351
    <0,0,0>,1
    scale 2.0
    translate  <1378.0, -952.371081, -1178.307822>
  }
  sphere { // sphere350_352
    <0,0,0>,1
    scale 9.0
    translate  <-1140.0, -830.441869, -1484.947912>
  }
  sphere { // sphere351_353
    <0,0,0>,1
    scale 10.0
    translate  <-1503.0, 122.523665, 1385.742744>
  }
  sphere { // sphere352_354
    <0,0,0>,1
    scale 8.0
    translate  <1735.0, -406.19809, -1009.495969>
  }
  sphere { // sphere353_355
    <0,0,0>,1
    translate  <1865.0, 63.011579, -843.865239>
  }
  sphere { // sphere354_356
    <0,0,0>,1
    translate  <1579.0, 241.123497, -1281.765368>
  }
  sphere { // sphere355_357
    <0,0,0>,1
    scale 5.0
    translate  <1706.0, 346.064897, -1078.937944>
  }
  sphere { // sphere356_358
    <0,0,0>,1
    scale 5.0
    translate  <-1651.0, -243.413893, 1187.119487>
  }
  sphere { // sphere357_359
    <0,0,0>,1
    scale 7.0
    translate  <513.0, -988.329129, -1718.819517>
  }
  sphere { // sphere358_360
    <0,0,0>,1
    scale 6.0
    translate  <-90.0, -703.195013, 1921.385118>
  }
  sphere { // sphere359_361
    <0,0,0>,1
    scale 8.0
    translate  <-358.0, 1702.994187, -1079.792017>
  }
  sphere { // sphere360_362
    <0,0,0>,1
    scale 9.0
    translate  <-1035.0, -1372.877263, -1112.783457>
  }
  sphere { // sphere361_363
    <0,0,0>,1
    scale 6.0
    translate  <-38.0, -189.467377, 2038.862946>
  }
  sphere { // sphere362_364
    <0,0,0>,1
    scale 11.0
    translate  <-1642.0, 809.21684, -918.318085>
  }
  sphere { // sphere363_365
    <0,0,0>,1
    scale 8.0
    translate  <1893.0, -164.624355, 764.037841>
  }
  sphere { // sphere364_366
    <0,0,0>,1
    scale 9.0
    translate  <1283.0, 1125.525334, -1131.99281>
  }
  sphere { // sphere365_367
    <0,0,0>,1
    scale 4.0
    translate  <-1083.0, 1108.774167, 1338.669058>
  }
  sphere { // sphere366_368
    <0,0,0>,1
    scale 5.0
    translate  <-1333.0, -1168.475327, 1025.70971>
  }
  sphere { // sphere367_369
    <0,0,0>,1
    scale 4.0
    translate  <-1348.0, 136.26411, -1535.783869>
  }
  sphere { // sphere368_370
    <0,0,0>,1
    scale 8.0
    translate  <647.0, 771.007636, 1783.603719>
  }
  sphere { // sphere369_371
    <0,0,0>,1
    scale 4.0
    translate  <-699.0, 1741.024793, -821.301206>
  }
  sphere { // sphere370_372
    <0,0,0>,1
    scale 3.0
    translate  <-539.0, -883.465937, 1767.277833>
  }
  sphere { // sphere371_373
    <0,0,0>,1
    scale 4.0
    translate  <511.0, 1015.458857, 1703.533478>
  }
  sphere { // sphere372_374
    <0,0,0>,1
    scale 9.0
    translate  <-664.0, 829.626334, -1750.750738>
  }
  sphere { // sphere373_375
    <0,0,0>,1
    scale 7.0
    translate  <-1531.0, 598.108378, -1221.723933>
  }
  sphere { // sphere374_376
    <0,0,0>,1
    scale 9.0
    translate  <376.0, -19.537169, -2013.093713>
  }
  sphere { // sphere375_377
    <0,0,0>,1
    translate  <-617.0, 283.439475, 1932.169005>
  }
  sphere { // sphere376_378
    <0,0,0>,1
    scale 10.0
    translate  <192.0, 1011.525302, -1770.383168>
  }
  sphere { // sphere377_379
    <0,0,0>,1
    scale 5.0
    translate  <916.0, -745.706979, 1673.071756>
  }
  sphere { // sphere378_380
    <0,0,0>,1
    scale 2.0
    translate  <-454.0, -1610.775589, 1180.50413>
  }
  sphere { // sphere379_381
    <0,0,0>,1
    scale 10.0
    translate  <699.0, 918.214925, 1691.91736>
  }
  sphere { // sphere380_382
    <0,0,0>,1
    scale 9.0
    translate  <-963.0, -1404.581479, -1137.57895>
  }
  sphere { // sphere381_383
    <0,0,0>,1
    scale 8.0
    translate  <-50.0, -1167.401932, 1681.956221>
  }
  sphere { // sphere382_384
    <0,0,0>,1
    scale 12.0
    translate  <-72.0, 2040.487847, -159.779051>
  }
  sphere { // sphere383_385
    <0,0,0>,1
    scale 12.0
    translate  <533.0, 299.317466, -1954.641669>
  }
  sphere { // sphere384_386
    <0,0,0>,1
    scale 9.0
    translate  <582.0, -1772.527958, 844.822252>
  }
  sphere { // sphere385_387
    <0,0,0>,1
    scale 9.0
    translate  <617.0, -1173.329769, -1561.061259>
  }
  sphere { // sphere386_388
    <0,0,0>,1
    scale 11.0
    translate  <1040.0, 1387.716657, 1089.470734>
  }
  sphere { // sphere387_389
    <0,0,0>,1
    scale 2.0
    translate  <474.0, 876.171154, 1789.39993>
  }
  sphere { // sphere388_390
    <0,0,0>,1
    scale 9.0
    translate  <-1423.0, -280.659841, 1445.892477>
  }
  sphere { // sphere389_391
    <0,0,0>,1
    scale 8.0
    translate  <1581.0, -1135.916805, 635.952838>
  }
  sphere { // sphere390_392
    <0,0,0>,1
    scale 5.0
    translate  <-200.0, 1067.124865, 1736.533479>
  }
  sphere { // sphere391_393
    <0,0,0>,1
    scale 2.0
    translate  <-573.0, 982.024069, -1703.409442>
  }
  sphere { // sphere392_394
    <0,0,0>,1
    scale 5.0
    translate  <-1866.0, -174.426762, -825.786476>
  }
  sphere { // sphere393_395
    <0,0,0>,1
    scale 4.0
    translate  <-944.0, -170.830776, -1809.415609>
  }
  sphere { // sphere394_396
    <0,0,0>,1
    scale 5.0
    translate  <1610.0, 959.302658, -825.798045>
  }
  sphere { // sphere395_397
    <0,0,0>,1
    scale 9.0
    translate  <1902.0, 363.527485, 666.744155>
  }
  sphere { // sphere396_398
    <0,0,0>,1
    scale 3.0
    translate  <497.0, 1566.359742, 1222.216085>
  }
  sphere { // sphere397_399
    <0,0,0>,1
    translate  <129.0, 880.872342, 1844.377108>
  }
  sphere { // sphere398_400
    <0,0,0>,1
    scale 9.0
    translate  <-171.0, 1921.76588, 686.934425>
  }
  sphere { // sphere399_401
    <0,0,0>,1
    scale 8.0
    translate  <-1624.0, -582.302452, -1103.563253>
  }
  sphere { // sphere400_402
    <0,0,0>,1
    scale 9.0
    translate  <-467.0, -1528.881338, 1280.131577>
  }
  sphere { // sphere401_403
    <0,0,0>,1
    scale 9.0
    translate  <-2030.0, 97.663743, 252.716824>
  }
  sphere { // sphere402_404
    <0,0,0>,1
    scale 8.0
    translate  <-1471.0, 508.00128, 1331.314275>
  }
  sphere { // sphere403_405
    <0,0,0>,1
    scale 8.0
    translate  <-1757.0, 857.339077, 610.102211>
  }
  sphere { // sphere404_406
    <0,0,0>,1
    scale 7.0
    translate  <307.0, -1408.527888, 1454.683535>
  }
  sphere { // sphere405_407
    <0,0,0>,1
    scale 9.0
    translate  <-1330.0, 390.198205, 1507.696707>
  }
  sphere { // sphere406_408
    <0,0,0>,1
    scale 9.0
    translate  <-211.0, 1967.598456, 527.578731>
  }
  sphere { // sphere407_409
    <0,0,0>,1
    scale 11.0
    translate  <1294.0, 783.822053, 1380.39523>
  }
  sphere { // sphere408_410
    <0,0,0>,1
    scale 12.0
    translate  <-1567.0, -776.665588, -1065.647955>
  }
  sphere { // sphere409_411
    <0,0,0>,1
    scale 6.0
    translate  <-1025.0, -1007.40056, 1459.048701>
  }
  sphere { // sphere410_412
    <0,0,0>,1
    scale 5.0
    translate  <1756.0, 533.912186, -908.683541>
  }
  sphere { // sphere411_413
    <0,0,0>,1
    scale 9.0
    translate  <535.0, 1743.771923, 931.310088>
  }
  sphere { // sphere412_414
    <0,0,0>,1
    scale 4.0
    translate  <205.0, 1956.996601, 567.840913>
  }
  sphere { // sphere413_415
    <0,0,0>,1
    scale 9.0
    translate  <521.0, 775.010182, -1822.696414>
  }
  sphere { // sphere414_416
    <0,0,0>,1
    scale 6.0
    translate  <-1619.0, -1090.732034, -619.230676>
  }
  sphere { // sphere415_417
    <0,0,0>,1
    scale 10.0
    translate  <600.0, 1397.133297, -1371.977605>
  }
  sphere { // sphere416_418
    <0,0,0>,1
    scale 6.0
    translate  <1707.0, -900.13286, -685.722856>
  }
  sphere { // sphere417_419
    <0,0,0>,1
    scale 6.0
    translate  <836.0, -1459.827023, -1168.038126>
  }
  sphere { // sphere418_420
    <0,0,0>,1
    scale 7.0
    translate  <-1644.0, -111.142262, -1216.229994>
  }
  sphere { // sphere419_421
    <0,0,0>,1
    scale 7.0
    translate  <1189.0, 1080.969403, 1269.680334>
  }
  sphere { // sphere420_422
    <0,0,0>,1
    scale 8.0
    translate  <-1281.0, 1568.659575, -304.384852>
  }
  sphere { // sphere421_423
    <0,0,0>,1
    scale 6.0
    translate  <1641.0, 840.392124, 891.71973>
  }
  sphere { // sphere422_424
    <0,0,0>,1
    scale 9.0
    translate  <931.0, 940.134789, -1563.230495>
  }
  sphere { // sphere423_425
    <0,0,0>,1
    scale 10.0
    translate  <-562.0, -1846.414526, 684.99153>
  }
  sphere { // sphere424_426
    <0,0,0>,1
    scale 8.0
    translate  <-1130.0, -1426.356002, -939.634267>
  }
  sphere { // sphere425_427
    <0,0,0>,1
    scale 10.0
    translate  <-713.0, -941.893714, -1672.952848>
  }
  sphere { // sphere426_428
    <0,0,0>,1
    scale 5.0
    translate  <-623.0, 765.897184, 1794.317838>
  }
  sphere { // sphere427_429
    <0,0,0>,1
    scale 5.0
    translate  <1592.0, 237.948021, 1266.183533>
  }
  sphere { // sphere428_430
    <0,0,0>,1
    translate  <1350.0, 970.155248, -1196.078089>
  }
  sphere { // sphere429_431
    <0,0,0>,1
    scale 3.0
    translate  <1976.0, 203.097368, -498.47714>
  }
  sphere { // sphere430_432
    <0,0,0>,1
    scale 12.0
    translate  <-1072.0, 1263.291495, -1203.833293>
  }
  sphere { // sphere431_433
    <0,0,0>,1
    scale 8.0
    translate  <-400.0, -716.186159, -1876.534408>
  }
  sphere { // sphere432_434
    <0,0,0>,1
    scale 7.0
    translate  <1654.0, -537.002039, 1081.765598>
  }
  sphere { // sphere433_435
    <0,0,0>,1
    scale 4.0
    translate  <1708.0, 321.899359, -1083.245495>
  }
  sphere { // sphere434_436
    <0,0,0>,1
    scale 5.0
    translate  <1197.0, -804.110685, -1454.269922>
  }
  sphere { // sphere435_437
    <0,0,0>,1
    scale 3.0
    translate  <1304.0, -810.518414, -1355.340511>
  }
  sphere { // sphere436_438
    <0,0,0>,1
    scale 2.0
    translate  <-1043.0, 1528.322386, 877.887056>
  }
  sphere { // sphere437_439
    <0,0,0>,1
    scale 10.0
    translate  <-1117.0, -425.894771, -1662.897665>
  }
  sphere { // sphere438_440
    <0,0,0>,1
    scale 9.0
    translate  <-782.0, -1687.75973, 856.882194>
  }
  sphere { // sphere439_441
    <0,0,0>,1
    translate  <196.0, -535.77939, -1966.933767>
  }
  sphere { // sphere440_442
    <0,0,0>,1
    scale 2.0
    translate  <-1937.0, -239.257656, -620.556826>
  }
  sphere { // sphere441_443
    <0,0,0>,1
    scale 7.0
    translate  <-708.0, 925.089832, 1684.413489>
  }
  sphere { // sphere442_444
    <0,0,0>,1
    translate  <657.0, 813.835796, 1760.774346>
  }
  sphere { // sphere443_445
    <0,0,0>,1
    scale 7.0
    translate  <-1989.0, 265.645773, 409.408504>
  }
  sphere { // sphere444_446
    <0,0,0>,1
    scale 3.0
    translate  <-102.0, -1493.39436, 1397.738633>
  }
  sphere { // sphere445_447
    <0,0,0>,1
    scale 9.0
    translate  <-503.0, 43.379302, 1984.795515>
  }
  sphere { // sphere446_448
    <0,0,0>,1
    scale 9.0
    translate  <474.0, -1500.861122, 1310.360215>
  }
  sphere { // sphere447_449
    <0,0,0>,1
    scale 12.0
    translate  <-1115.0, -4.089169, -1717.865617>
  }
  sphere { // sphere448_450
    <0,0,0>,1
    scale 8.0
    translate  <1165.0, 378.015324, 1641.396788>
  }
  sphere { // sphere449_451
    <0,0,0>,1
    scale 5.0
    translate  <-866.0, 1848.532605, 165.15208>
  }
  sphere { // sphere450_452
    <0,0,0>,1
    scale 8.0
    translate  <-1607.0, 1175.361243, 479.980153>
  }
  sphere { // sphere451_453
    <0,0,0>,1
    scale 6.0
    translate  <-1768.0, -349.520799, -972.787341>
  }
  sphere { // sphere452_454
    <0,0,0>,1
    scale 7.0
    translate  <1247.0, 314.129846, 1593.931441>
  }
  sphere { // sphere453_455
    <0,0,0>,1
    scale 6.0
    translate  <-1205.0, -896.822223, -1392.116698>
  }
  sphere { // sphere454_456
    <0,0,0>,1
    scale 11.0
    translate  <-1161.0, 1129.416611, 1253.316049>
  }
  sphere { // sphere455_457
    <0,0,0>,1
    scale 10.0
    translate  <-233.0, 1826.066176, -897.495026>
  }
  sphere { // sphere456_458
    <0,0,0>,1
    scale 4.0
    translate  <79.0, -1142.149308, 1698.104225>
  }
  sphere { // sphere457_459
    <0,0,0>,1
    scale 11.0
    translate  <1524.0, -75.737108, 1366.013137>
  }
  sphere { // sphere458_460
    <0,0,0>,1
    scale 10.0
    translate  <-1396.0, -161.794317, 1489.735077>
  }
  sphere { // sphere459_461
    <0,0,0>,1
    translate  <1906.0, 21.63235, -748.99936>
  }
  sphere { // sphere460_462
    <0,0,0>,1
    scale 7.0
    translate  <1484.0, 261.536151, 1386.955962>
  }
  sphere { // sphere461_463
    <0,0,0>,1
    scale 2.0
    translate  <1182.0, -377.491498, 1629.318928>
  }
  sphere { // sphere462_464
    <0,0,0>,1
    scale 5.0
    translate  <-1812.0, -156.471672, -941.528872>
  }
  sphere { // sphere463_465
    <0,0,0>,1
    scale 6.0
    translate  <-750.0, -1099.423397, 1556.622046>
  }
  sphere { // sphere464_466
    <0,0,0>,1
    scale 6.0
    translate  <1593.0, -263.644096, 1259.820142>
  }
  sphere { // sphere465_467
    <0,0,0>,1
    scale 3.0
    translate  <280.0, 345.227552, 1999.180316>
  }
  sphere { // sphere466_468
    <0,0,0>,1
    scale 10.0
    translate  <1130.0, 1386.219541, 997.897482>
  }
  sphere { // sphere467_469
    <0,0,0>,1
    scale 8.0
    translate  <1835.0, 491.354528, -765.277549>
  }
  sphere { // sphere468_470
    <0,0,0>,1
    scale 9.0
    translate  <1406.0, 968.234757, 1131.36619>
  }
  sphere { // sphere469_471
    <0,0,0>,1
    scale 7.0
    translate  <-424.0, 1516.173628, 1309.864699>
  }
  sphere { // sphere470_472
    <0,0,0>,1
    scale 12.0
    translate  <409.0, 725.460629, 1871.023751>
  }
  sphere { // sphere471_473
    <0,0,0>,1
    scale 11.0
    translate  <-937.0, 37.012932, -1820.704546>
  }
  sphere { // sphere472_474
    <0,0,0>,1
    scale 7.0
    translate  <-1438.0, 647.680832, 1306.510444>
  }
  sphere { // sphere473_475
    <0,0,0>,1
    scale 7.0
    translate  <2033.0, 247.371349, 4.734506>
  }
  sphere { // sphere474_476
    <0,0,0>,1
    scale 7.0
    translate  <-1861.0, 568.748615, 638.363543>
  }
  sphere { // sphere475_477
    <0,0,0>,1
    scale 2.0
    translate  <-2027.0, 253.483735, 146.01711>
  }
  sphere { // sphere476_478
    <0,0,0>,1
    translate  <1451.0, -342.271646, 1404.191269>
  }
  sphere { // sphere477_479
    <0,0,0>,1
    translate  <-1982.0, -438.265591, -271.851562>
  }
  sphere { // sphere478_480
    <0,0,0>,1
    scale 6.0
    translate  <305.0, 998.11883, -1762.111745>
  }
  sphere { // sphere479_481
    <0,0,0>,1
    scale 12.0
    translate  <1339.0, -326.215033, -1514.914767>
  }
  sphere { // sphere480_482
    <0,0,0>,1
    scale 3.0
    translate  <263.0, 1513.860785, 1354.016441>
  }
  sphere { // sphere481_483
    <0,0,0>,1
    scale 8.0
    translate  <-1090.0, 439.59807, 1677.187389>
  }
  sphere { // sphere482_484
    <0,0,0>,1
    scale 6.0
    translate  <-2.0, 46.999978, -2047.459646>
  }
  sphere { // sphere483_485
    <0,0,0>,1
    translate  <1983.0, 396.183734, -324.119498>
  }
  sphere { // sphere484_486
    <0,0,0>,1
    scale 10.0
    translate  <-454.0, -730.242645, 1858.745189>
  }
  sphere { // sphere485_487
    <0,0,0>,1
    scale 7.0
    translate  <-24.0, -431.345379, 2001.916373>
  }
  sphere { // sphere486_488
    <0,0,0>,1
    scale 12.0
    translate  <1478.0, -232.76138, 1398.442755>
  }
  sphere { // sphere487_489
    <0,0,0>,1
    scale 5.0
    translate  <-1925.0, -48.469689, -697.373422>
  }
  sphere { // sphere488_490
    <0,0,0>,1
    scale 10.0
    translate  <1818.0, -904.459842, 266.70657>
  }
  sphere { // sphere489_491
    <0,0,0>,1
    translate  <1131.0, 856.086326, 1477.24717>
  }
  sphere { // sphere490_492
    <0,0,0>,1
    scale 4.0
    translate  <221.0, 804.897316, -1870.188041>
  }
  sphere { // sphere491_493
    <0,0,0>,1
    scale 11.0
    translate  <-696.0, -586.743152, 1834.562747>
  }
  sphere { // sphere492_494
    <0,0,0>,1
    scale 12.0
    translate  <1740.0, 780.504524, 746.670401>
  }
  sphere { // sphere493_495
    <0,0,0>,1
    scale 12.0
    translate  <-792.0, 1854.193762, -359.173347>
  }
  sphere { // sphere494_496
    <0,0,0>,1
    translate  <-37.0, -1369.401462, 1522.391091>
  }
  sphere { // sphere495_497
    <0,0,0>,1
    scale 2.0
    translate  <11.0, -1148.608432, -1695.547602>
  }
  sphere { // sphere496_498
    <0,0,0>,1
    scale 5.0
    translate  <-816.0, 1309.869803, 1346.36143>
  }
  sphere { // sphere497_499
    <0,0,0>,1
    translate  <-1571.0, -562.951076, 1187.160093>
  }
  sphere { // sphere498_500
    <0,0,0>,1
    scale 3.0
    translate  <-1736.0, 907.366012, 597.741516>
  }
  sphere { // sphere499_501
    <0,0,0>,1
    scale 11.0
    translate  <-214.0, 1120.208894, 1701.070261>
  }
  sphere { // sphere500_502
    <0,0,0>,1
    scale 8.0
    translate  <590.0, -981.185572, 1698.080938>
  }
  sphere { // sphere501_503
    <0,0,0>,1
    scale 5.0
    translate  <1858.0, 121.039829, -852.929868>
  }
  sphere { // sphere502_504
    <0,0,0>,1
    scale 10.0
    translate  <1139.0, 819.964664, 1491.52303>
  }
  sphere { // sphere503_505
    <0,0,0>,1
    scale 6.0
    translate  <-1564.0, -1255.055294, 415.985828>
  }
  sphere { // sphere504_506
    <0,0,0>,1
    scale 10.0
    translate  <563.0, -1190.542894, -1568.420421>
  }
  sphere { // sphere505_507
    <0,0,0>,1
    scale 3.0
    translate  <1859.0, -594.712989, 620.273699>
  }
  sphere { // sphere506_508
    <0,0,0>,1
    scale 10.0
    translate  <-1733.0, -230.270368, 1066.766402>
  }
  sphere { // sphere507_509
    <0,0,0>,1
    scale 8.0
    translate  <786.0, -351.823321, -1858.151864>
  }
  sphere { // sphere508_510
    <0,0,0>,1
    scale 8.0
    translate  <-885.0, -1173.482667, -1426.18983>
  }
  sphere { // sphere509_511
    <0,0,0>,1
    scale 7.0
    translate  <1962.0, -195.307212, 553.818646>
  }
  sphere { // sphere510_512
    <0,0,0>,1
    scale 5.0
    translate  <291.0, -347.809867, -1997.160809>
  }
  sphere { // sphere511_513
    <0,0,0>,1
    scale 4.0
    translate  <-810.0, -1058.757776, -1554.746272>
  }
  sphere { // sphere512_514
    <0,0,0>,1
    scale 12.0
    translate  <1457.0, -477.701952, 1357.665587>
  }
  sphere { // sphere513_515
    <0,0,0>,1
    translate  <-1944.0, 372.585009, 525.688511>
  }
  sphere { // sphere514_516
    <0,0,0>,1
    translate  <101.0, 407.129004, -2004.581995>
  }
  sphere { // sphere515_517
    <0,0,0>,1
    scale 5.0
    translate  <1961.0, -94.116244, -583.030988>
  }
  sphere { // sphere516_518
    <0,0,0>,1
    scale 9.0
    translate  <-1606.0, 1025.742399, 750.280301>
  }
  sphere { // sphere517_519
    <0,0,0>,1
    scale 7.0
    translate  <468.0, -1823.319187, -806.713792>
  }
  sphere { // sphere518_520
    <0,0,0>,1
    scale 8.0
    translate  <544.0, 1336.932987, 1452.920572>
  }
  sphere { // sphere519_521
    <0,0,0>,1
    scale 8.0
    translate  <1880.0, -283.656271, -761.211613>
  }
  sphere { // sphere520_522
    <0,0,0>,1
    scale 11.0
    translate  <1199.0, 1146.747994, -1200.696481>
  }
  sphere { // sphere521_523
    <0,0,0>,1
    scale 9.0
    translate  <258.0, 1080.20017, -1720.728797>
  }
  sphere { // sphere522_524
    <0,0,0>,1
    scale 2.0
    translate  <-860.0, -271.247072, 1838.78466>
  }
  sphere { // sphere523_525
    <0,0,0>,1
    scale 7.0
    translate  <-1946.0, -363.311871, 524.77851>
  }
  sphere { // sphere524_526
    <0,0,0>,1
    scale 4.0
    translate  <-2034.0, 196.582516, 136.026889>
  }
  sphere { // sphere525_527
    <0,0,0>,1
    scale 7.0
    translate  <-1846.0, -512.57549, -723.777844>
  }
  sphere { // sphere526_528
    <0,0,0>,1
    scale 6.0
    translate  <-1459.0, 107.985053, -1433.165109>
  }
  sphere { // sphere527_529
    <0,0,0>,1
    scale 9.0
    translate  <-1961.0, -105.687027, -581.044966>
  }
  sphere { // sphere528_530
    <0,0,0>,1
    scale 6.0
    translate  <-492.0, -1353.783288, -1455.85398>
  }
  sphere { // sphere529_531
    <0,0,0>,1
    scale 6.0
    translate  <-514.0, 211.627505, 1971.121965>
  }
  sphere { // sphere530_532
    <0,0,0>,1
    scale 5.0
    translate  <-1191.0, 1651.945295, -216.563483>
  }
  sphere { // sphere531_533
    <0,0,0>,1
    scale 9.0
    translate  <-1183.0, 1091.895202, 1265.930436>
  }
  sphere { // sphere532_534
    <0,0,0>,1
    scale 3.0
    translate  <840.0, -794.821307, -1690.255333>
  }
  sphere { // sphere533_535
    <0,0,0>,1
    scale 6.0
    translate  <-714.0, -304.609301, -1895.183678>
  }
  sphere { // sphere534_536
    <0,0,0>,1
    scale 11.0
    translate  <-687.0, -1856.208103, 526.143021>
  }
  sphere { // sphere535_537
    <0,0,0>,1
    scale 12.0
    translate  <519.0, 195.164251, 1971.510567>
  }
  sphere { // sphere536_538
    <0,0,0>,1
    scale 9.0
    translate  <1755.0, 400.293361, 976.751875>
  }
  sphere { // sphere537_539
    <0,0,0>,1
    scale 10.0
    translate  <215.0, -429.7372, -1990.830214>
  }
  sphere { // sphere538_540
    <0,0,0>,1
    scale 4.0
    translate  <-911.0, -1561.285896, -962.688605>
  }
  sphere { // sphere539_541
    <0,0,0>,1
    translate  <-1762.0, -89.197689, -1040.049889>
  }
  sphere { // sphere540_542
    <0,0,0>,1
    scale 6.0
    translate  <-1469.0, 443.674499, 1356.280185>
  }
  sphere { // sphere541_543
    <0,0,0>,1
    translate  <1461.0, 756.490414, -1219.633246>
  }
  sphere { // sphere542_544
    <0,0,0>,1
    scale 7.0
    translate  <-1118.0, 43.358808, -1715.371684>
  }
  sphere { // sphere543_545
    <0,0,0>,1
    scale 7.0
    translate  <1715.0, -166.572379, -1106.947443>
  }
  sphere { // sphere544_546
    <0,0,0>,1
    scale 8.0
    translate  <165.0, 420.752774, -1997.509976>
  }
  sphere { // sphere545_547
    <0,0,0>,1
    scale 7.0
    translate  <1250.0, -618.059941, 1499.935302>
  }
  sphere { // sphere546_548
    <0,0,0>,1
    translate  <1904.0, -554.411629, -511.581612>
  }
  sphere { // sphere547_549
    <0,0,0>,1
    scale 8.0
    translate  <-416.0, -1443.393643, -1392.071403>
  }
  sphere { // sphere548_550
    <0,0,0>,1
    scale 5.0
    translate  <1672.0, 622.810018, 1005.399265>
  }
  sphere { // sphere549_551
    <0,0,0>,1
    scale 3.0
    translate  <294.0, -372.847769, 1992.197917>
  }
  sphere { // sphere550_552
    <0,0,0>,1
    scale 6.0
    translate  <150.0, -677.300995, 1926.932111>
  }
  sphere { // sphere551_553
    <0,0,0>,1
    scale 12.0
    translate  <-118.0, -1821.219465, 929.268347>
  }
  sphere { // sphere552_554
    <0,0,0>,1
    scale 10.0
    translate  <584.0, -1113.155923, -1616.827724>
  }
  sphere { // sphere553_555
    <0,0,0>,1
    scale 11.0
    translate  <-356.0, -1109.227074, -1684.394045>
  }
  sphere { // sphere554_556
    <0,0,0>,1
    scale 3.0
    translate  <643.0, -1881.304678, -491.475034>
  }
  sphere { // sphere555_557
    <0,0,0>,1
    translate  <2043.0, 6.311289, 142.881656>
  }
  sphere { // sphere556_558
    <0,0,0>,1
    scale 8.0
    translate  <1501.0, 526.061646, -1290.179114>
  }
  sphere { // sphere557_559
    <0,0,0>,1
    scale 8.0
    translate  <763.0, -797.971456, 1724.927985>
  }
  sphere { // sphere558_560
    <0,0,0>,1
    scale 2.0
    translate  <628.0, 1454.270181, 1298.082525>
  }
  sphere { // sphere559_561
    <0,0,0>,1
    scale 5.0
    translate  <-652.0, 505.97904, 1874.349277>
  }
  sphere { // sphere560_562
    <0,0,0>,1
    scale 7.0
    translate  <605.0, -1898.201811, -474.456408>
  }
  sphere { // sphere561_563
    <0,0,0>,1
    scale 8.0
    translate  <1281.0, -869.375246, 1340.719837>
  }
  sphere { // sphere562_564
    <0,0,0>,1
    scale 10.0
    translate  <-1138.0, -854.686303, 1472.674887>
  }
  sphere { // sphere563_565
    <0,0,0>,1
    scale 2.0
    translate  <-1891.0, 432.077733, 657.063035>
  }
  sphere { // sphere564_566
    <0,0,0>,1
    scale 5.0
    translate  <1491.0, 485.110969, -1317.531915>
  }
  sphere { // sphere565_567
    <0,0,0>,1
    scale 11.0
    translate  <-1654.0, 1038.031945, 617.314897>
  }
  sphere { // sphere566_568
    <0,0,0>,1
    scale 10.0
    translate  <1155.0, -995.706901, 1367.057705>
  }
  sphere { // sphere567_569
    <0,0,0>,1
    scale 9.0
    translate  <991.0, -7.001045, -1792.253884>
  }
  sphere { // sphere568_570
    <0,0,0>,1
    scale 11.0
    translate  <979.0, -731.441761, 1643.428109>
  }
  sphere { // sphere569_571
    <0,0,0>,1
    scale 11.0
    translate  <1234.0, 1452.821978, -748.903399>
  }
  sphere { // sphere570_572
    <0,0,0>,1
    scale 7.0
    translate  <832.0, 1712.389931, 754.851457>
  }
  sphere { // sphere571_573
    <0,0,0>,1
    scale 10.0
    translate  <-1882.0, 208.826847, -780.238007>
  }
  sphere { // sphere572_574
    <0,0,0>,1
    scale 12.0
    translate  <346.0, 305.790289, -1995.264469>
  }
  sphere { // sphere573_575
    <0,0,0>,1
    scale 3.0
    translate  <-423.0, -510.255172, 1937.78602>
  }
  sphere { // sphere574_576
    <0,0,0>,1
    scale 2.0
    translate  <-1251.0, -538.491813, 1529.486701>
  }
  sphere { // sphere575_577
    <0,0,0>,1
    scale 6.0
    translate  <-625.0, -965.628182, -1694.473728>
  }
  sphere { // sphere576_578
    <0,0,0>,1
    scale 9.0
    translate  <1147.0, -194.686455, -1685.464976>
  }
  sphere { // sphere577_579
    <0,0,0>,1
    scale 3.0
    translate  <-529.0, -1805.816152, -808.387918>
  }
  sphere { // sphere578_580
    <0,0,0>,1
    scale 10.0
    translate  <-1505.0, -215.926788, -1372.09862>
  }
  sphere { // sphere579_581
    <0,0,0>,1
    scale 10.0
    translate  <-12.0, 150.87241, -2042.39994>
  }
  sphere { // sphere580_582
    <0,0,0>,1
    scale 11.0
    translate  <75.0, 1883.360836, 801.018701>
  }
  sphere { // sphere581_583
    <0,0,0>,1
    scale 9.0
    translate  <113.0, -996.479703, -1785.654838>
  }
  sphere { // sphere582_584
    <0,0,0>,1
    scale 3.0
    translate  <441.0, -1805.257909, -860.736244>
  }
  sphere { // sphere583_585
    <0,0,0>,1
    scale 6.0
    translate  <-1170.0, 1545.983204, 659.802949>
  }
  sphere { // sphere584_586
    <0,0,0>,1
    translate  <-611.0, 1215.146518, -1531.143997>
  }
  sphere { // sphere585_587
    <0,0,0>,1
    scale 7.0
    translate  <-1375.0, 1113.328283, -1031.590585>
  }
  sphere { // sphere586_588
    <0,0,0>,1
    scale 2.0
    translate  <-103.0, -1007.972802, -1779.799379>
  }
  sphere { // sphere587_589
    <0,0,0>,1
    scale 3.0
    translate  <-1614.0, 1143.489364, 530.79193>
  }
  sphere { // sphere588_590
    <0,0,0>,1
    scale 11.0
    translate  <-1793.0, 587.800264, -796.207165>
  }
  sphere { // sphere589_591
    <0,0,0>,1
    scale 8.0
    translate  <-1873.0, -825.677186, -66.574652>
  }
  sphere { // sphere590_592
    <0,0,0>,1
    scale 10.0
    translate  <768.0, -313.913777, 1872.415056>
  }
  sphere { // sphere591_593
    <0,0,0>,1
    scale 2.0
    translate  <-674.0, 23.843437, 1933.76821>
  }
  sphere { // sphere592_594
    <0,0,0>,1
    scale 7.0
    translate  <1670.0, -578.566707, 1034.729223>
  }
  sphere { // sphere593_595
    <0,0,0>,1
    scale 11.0
    translate  <234.0, -1298.564811, -1566.294171>
  }
  sphere { // sphere594_596
    <0,0,0>,1
    scale 7.0
    translate  <791.0, -1162.688114, 1488.885271>
  }
  sphere { // sphere595_597
    <0,0,0>,1
    scale 11.0
    translate  <555.0, 987.727861, 1706.069363>
  }
  sphere { // sphere596_598
    <0,0,0>,1
    scale 5.0
    translate  <986.0, 1071.053834, -1440.469258>
  }
  sphere { // sphere597_599
    <0,0,0>,1
    scale 4.0
    translate  <-2030.0, -200.999458, -181.667878>
  }
  sphere { // sphere598_600
    <0,0,0>,1
    scale 6.0
    translate  <732.0, 1521.976928, 1158.475823>
  }
  sphere { // sphere599_601
    <0,0,0>,1
    scale 12.0
    translate  <1287.0, -1372.367489, 809.037993>
  }
  sphere { // sphere600_602
    <0,0,0>,1
    scale 12.0
    translate  <-1772.0, -463.890377, 916.038055>
  }
  sphere { // sphere601_603
    <0,0,0>,1
    scale 3.0
    translate  <-551.0, -1744.104733, -921.304336>
  }
  sphere { // sphere602_604
    <0,0,0>,1
    scale 3.0
    translate  <1799.0, 69.055562, 976.285988>
  }
  sphere { // sphere603_605
    <0,0,0>,1
    scale 10.0
    translate  <-360.0, 1005.717535, -1747.351207>
  }
  sphere { // sphere604_606
    <0,0,0>,1
    scale 7.0
    translate  <218.0, -512.819796, -1970.734852>
  }
  sphere { // sphere605_607
    <0,0,0>,1
    scale 5.0
    translate  <10.0, 820.865214, 1876.268717>
  }
  sphere { // sphere606_608
    <0,0,0>,1
    scale 4.0
    translate  <-1402.0, -1263.993811, -794.367451>
  }
  sphere { // sphere607_609
    <0,0,0>,1
    scale 8.0
    translate  <679.0, 838.246547, 1740.8635>
  }
  sphere { // sphere608_610
    <0,0,0>,1
    scale 12.0
    translate  <-1972.0, 300.65959, 463.814414>
  }
  sphere { // sphere609_611
    <0,0,0>,1
    scale 7.0
    translate  <-1322.0, 1184.009122, 1022.12641>
  }
  sphere { // sphere610_612
    <0,0,0>,1
    scale 3.0
    translate  <1523.0, -857.770845, 1067.241387>
  }
  sphere { // sphere611_613
    <0,0,0>,1
    scale 5.0
    translate  <-272.0, -477.853942, 1972.809066>
  }
  sphere { // sphere612_614
    <0,0,0>,1
    scale 3.0
    translate  <-209.0, -1165.508169, 1670.991833>
  }
  sphere { // sphere613_615
    <0,0,0>,1
    scale 6.0
    translate  <1227.0, 1262.137926, 1046.796473>
  }
  sphere { // sphere614_616
    <0,0,0>,1
    scale 10.0
    translate  <1690.0, -1082.812654, 407.088143>
  }
  sphere { // sphere615_617
    <0,0,0>,1
    scale 6.0
    translate  <-1054.0, -1302.071046, -1178.13369>
  }
  sphere { // sphere616_618
    <0,0,0>,1
    scale 9.0
    translate  <-1816.0, -72.640344, 944.018739>
  }
  sphere { // sphere617_619
    <0,0,0>,1
    scale 3.0
    translate  <-781.0, -148.371288, 1887.413299>
  }
  sphere { // sphere618_620
    <0,0,0>,1
    scale 3.0
    translate  <-1654.0, -401.664257, 1138.970511>
  }
  sphere { // sphere619_621
    <0,0,0>,1
    scale 2.0
    translate  <-1606.0, -59.028279, 1269.481651>
  }
  sphere { // sphere620_622
    <0,0,0>,1
    scale 10.0
    translate  <1728.0, -11.606924, -1099.174817>
  }
  sphere { // sphere621_623
    <0,0,0>,1
    scale 10.0
    translate  <-1637.0, 370.836817, 1173.462848>
  }
  sphere { // sphere622_624
    <0,0,0>,1
    scale 4.0
    translate  <1827.0, -329.235082, 864.857942>
  }
  sphere { // sphere623_625
    <0,0,0>,1
    scale 4.0
    translate  <-877.0, -198.017403, -1840.09894>
  }
  sphere { // sphere624_626
    <0,0,0>,1
    translate  <-1050.0, 1336.150534, -1143.024825>
  }
  sphere { // sphere625_627
    <0,0,0>,1
    scale 10.0
    translate  <-449.0, -740.534552, -1855.885659>
  }
  sphere { // sphere626_628
    <0,0,0>,1
    scale 6.0
    translate  <950.0, 894.763801, 1578.354124>
  }
  sphere { // sphere627_629
    <0,0,0>,1
    scale 3.0
    translate  <473.0, -1329.79848, 1483.984839>
  }
  sphere { // sphere628_630
    <0,0,0>,1
    scale 12.0
    translate  <964.0, 766.270304, 1636.410041>
  }
  sphere { // sphere629_631
    <0,0,0>,1
    scale 6.0
    translate  <1827.0, 150.5817, -913.071822>
  }
  sphere { // sphere630_632
    <0,0,0>,1
    translate  <427.0, 395.977143, -1963.460492>
  }
  sphere { // sphere631_633
    <0,0,0>,1
    translate  <413.0, -1036.50884, -1717.377194>
  }
  sphere { // sphere632_634
    <0,0,0>,1
    scale 4.0
    translate  <-1257.0, -1509.495801, 579.376757>
  }
  sphere { // sphere633_635
    <0,0,0>,1
    scale 11.0
    translate  <273.0, -1947.215841, -572.822369>
  }
  sphere { // sphere634_636
    <0,0,0>,1
    translate  <-1623.0, 513.152334, 1138.793081>
  }
  sphere { // sphere635_637
    <0,0,0>,1
    scale 6.0
    translate  <1633.0, 1051.52266, -649.549918>
  }
  sphere { // sphere636_638
    <0,0,0>,1
    scale 7.0
    translate  <1101.0, -1251.732618, 1189.650559>
  }
  sphere { // sphere637_639
    <0,0,0>,1
    scale 7.0
    translate  <-1090.0, 1100.265078, -1340.007746>
  }
  sphere { // sphere638_640
    <0,0,0>,1
    scale 7.0
    translate  <1359.0, 1058.669811, -1107.538366>
  }
  sphere { // sphere639_641
    <0,0,0>,1
    scale 9.0
    translate  <-584.0, 463.545395, 1907.45214>
  }
  sphere { // sphere640_642
    <0,0,0>,1
    scale 8.0
    translate  <1970.0, 186.42609, -527.87244>
  }
  sphere { // sphere641_643
    <0,0,0>,1
    scale 6.0
    translate  <-677.0, 897.773327, 1711.717866>
  }
  sphere { // sphere642_644
    <0,0,0>,1
    scale 11.0
    translate  <237.0, 204.616002, -2023.923737>
  }
  sphere { // sphere643_645
    <0,0,0>,1
    scale 4.0
    translate  <-926.0, 838.091665, -1623.092838>
  }
  sphere { // sphere644_646
    <0,0,0>,1
    scale 4.0
    translate  <2010.0, 315.008584, -234.464479>
  }
  sphere { // sphere645_647
    <0,0,0>,1
    scale 3.0
    translate  <1481.0, -1069.630239, 925.653364>
  }
  sphere { // sphere646_648
    <0,0,0>,1
    scale 6.0
    translate  <203.0, -1057.889512, 1741.828>
  }
  sphere { // sphere647_649
    <0,0,0>,1
    scale 4.0
    translate  <-1982.0, -69.975178, 510.963281>
  }
  sphere { // sphere648_650
    <0,0,0>,1
    scale 3.0
    translate  <-1310.0, -1075.462053, -1149.602267>
  }
  sphere { // sphere649_651
    <0,0,0>,1
    scale 7.0
    translate  <2041.0, 104.293924, -133.213278>
  }
  sphere { // sphere650_652
    <0,0,0>,1
    scale 4.0
    translate  <-395.0, 1436.266781, -1405.495191>
  }
  sphere { // sphere651_653
    <0,0,0>,1
    scale 7.0
    translate  <702.0, -615.084002, 1822.956848>
  }
  sphere { // sphere652_654
    <0,0,0>,1
    scale 4.0
    translate  <231.0, 803.092162, 1869.755594>
  }
  sphere { // sphere653_655
    <0,0,0>,1
    scale 3.0
    translate  <2036.0, -188.908625, 115.418939>
  }
  sphere { // sphere654_656
    <0,0,0>,1
    scale 8.0
    translate  <-1395.0, 435.5328, 1434.778791>
  }
  sphere { // sphere655_657
    <0,0,0>,1
    scale 12.0
    translate  <1552.0, 376.965921, 1281.98935>
  }
  sphere { // sphere656_658
    <0,0,0>,1
    scale 11.0
    translate  <-1961.0, -542.81751, 232.663171>
  }
  sphere { // sphere657_659
    <0,0,0>,1
    scale 4.0
    translate  <1029.0, 224.042393, 1756.493099>
  }
  sphere { // sphere658_660
    <0,0,0>,1
    scale 12.0
    translate  <1963.0, -304.279017, 498.346546>
  }
  sphere { // sphere659_661
    <0,0,0>,1
    scale 10.0
    translate  <-13.0, 883.857193, 1847.412099>
  }
  sphere { // sphere660_662
    <0,0,0>,1
    scale 2.0
    translate  <-1925.0, -533.80658, -451.364082>
  }
  sphere { // sphere661_663
    <0,0,0>,1
    scale 7.0
    translate  <1939.0, -157.403822, 640.161727>
  }
  sphere { // sphere662_664
    <0,0,0>,1
    scale 7.0
    translate  <-1343.0, 673.903244, 1391.585217>
  }
  sphere { // sphere663_665
    <0,0,0>,1
    scale 3.0
    translate  <-962.0, 995.260133, -1509.409576>
  }
  sphere { // sphere664_666
    <0,0,0>,1
    scale 4.0
    translate  <725.0, -1372.938109, 1335.559788>
  }
  sphere { // sphere665_667
    <0,0,0>,1
    scale 2.0
    translate  <-482.0, -1400.036795, 1414.877017>
  }
  sphere { // sphere666_668
    <0,0,0>,1
    scale 3.0
    translate  <1413.0, 806.114405, -1244.152147>
  }
  sphere { // sphere667_669
    <0,0,0>,1
    scale 11.0
    translate  <-1556.0, 122.643417, -1325.943661>
  }
  sphere { // sphere668_670
    <0,0,0>,1
    scale 2.0
    translate  <955.0, 397.416487, -1767.580022>
  }
  sphere { // sphere669_671
    <0,0,0>,1
    scale 9.0
    translate  <1257.0, -565.468811, 1514.760715>
  }
  sphere { // sphere670_672
    <0,0,0>,1
    scale 6.0
    translate  <1895.0, 235.231742, -740.23309>
  }
  sphere { // sphere671_673
    <0,0,0>,1
    scale 7.0
    translate  <-769.0, 137.517977, 1893.153931>
  }
  sphere { // sphere672_674
    <0,0,0>,1
    scale 2.0
    translate  <709.0, -546.011392, -1842.144012>
  }
  sphere { // sphere673_675
    <0,0,0>,1
    scale 10.0
    translate  <450.0, 217.306324, -1986.097168>
  }
  sphere { // sphere674_676
    <0,0,0>,1
    scale 3.0
    translate  <-1650.0, -1107.959093, 494.196973>
  }
  sphere { // sphere675_677
    <0,0,0>,1
    scale 2.0
    translate  <2007.0, 336.294059, -230.567356>
  }
  sphere { // sphere676_678
    <0,0,0>,1
    scale 10.0
    translate  <-1160.0, -1505.67853, 762.650748>
  }
  sphere { // sphere677_679
    <0,0,0>,1
    scale 11.0
    translate  <-641.0, -672.427947, 1825.174966>
  }
  sphere { // sphere678_680
    <0,0,0>,1
    scale 5.0
    translate  <604.0, 143.328205, 1951.651871>
  }
  sphere { // sphere679_681
    <0,0,0>,1
    scale 5.0
    translate  <-405.0, 77.194821, -2006.070776>
  }
  sphere { // sphere680_682
    <0,0,0>,1
    scale 4.0
    translate  <-317.0, -1833.508281, 855.606443>
  }
  sphere { // sphere681_683
    <0,0,0>,1
    scale 8.0
    translate  <-1896.0, 373.617421, 678.157816>
  }
  sphere { // sphere682_684
    <0,0,0>,1
    scale 12.0
    translate  <1275.0, 1063.125678, -1199.350988>
  }
  sphere { // sphere683_685
    <0,0,0>,1
    scale 9.0
    translate  <-531.0, -1688.585661, -1030.058962>
  }
  sphere { // sphere684_686
    <0,0,0>,1
    scale 11.0
    translate  <1470.0, 1358.522946, -433.381364>
  }
  sphere { // sphere685_687
    <0,0,0>,1
    scale 7.0
    translate  <-1937.0, 182.386266, -639.585999>
  }
  sphere { // sphere686_688
    <0,0,0>,1
    translate  <-1681.0, -349.0835, 1116.549914>
  }
  sphere { // sphere687_689
    <0,0,0>,1
    scale 6.0
    translate  <-1199.0, -1458.668312, -793.088744>
  }
  sphere { // sphere688_690
    <0,0,0>,1
    scale 4.0
    translate  <1586.0, -1173.22433, -549.956973>
  }
  sphere { // sphere689_691
    <0,0,0>,1
    scale 7.0
    translate  <960.0, 1417.083559, 1124.534654>
  }
  sphere { // sphere690_692
    <0,0,0>,1
    scale 3.0
    translate  <440.0, -382.357862, -1963.289705>
  }
  sphere { // sphere691_693
    <0,0,0>,1
    scale 12.0
    translate  <838.0, -472.080798, -1808.092841>
  }
  sphere { // sphere692_694
    <0,0,0>,1
    scale 6.0
    translate  <360.0, -494.183484, -1954.606529>
  }
  sphere { // sphere693_695
    <0,0,0>,1
    scale 9.0
    translate  <-843.0, -1298.908823, 1340.332373>
  }
  sphere { // sphere694_696
    <0,0,0>,1
    scale 5.0
    translate  <-1935.0, 95.079448, -664.107596>
  }
  sphere { // sphere695_697
    <0,0,0>,1
    scale 12.0
    translate  <-505.0, -1146.107814, -1620.406084>
  }
  sphere { // sphere696_698
    <0,0,0>,1
    scale 2.0
    translate  <-569.0, -695.61596, -1840.288411>
  }
  sphere { // sphere697_699
    <0,0,0>,1
    scale 10.0
    translate  <-217.0, 1180.318032, 1659.537388>
  }
  sphere { // sphere698_700
    <0,0,0>,1
    scale 8.0
    translate  <-643.0, -214.334863, -1932.592965>
  }
  sphere { // sphere699_701
    <0,0,0>,1
    scale 7.0
    translate  <425.0, -875.149796, -1802.163099>
  }
  sphere { // sphere700_702
    <0,0,0>,1
    scale 4.0
    translate  <941.0, -1127.67066, -1427.298806>
  }
  sphere { // sphere701_703
    <0,0,0>,1
    scale 8.0
    translate  <385.0, -575.306822, -1927.459743>
  }
  sphere { // sphere702_704
    <0,0,0>,1
    scale 11.0
    translate  <-704.0, -339.705389, 1892.95754>
  }
  sphere { // sphere703_705
    <0,0,0>,1
    scale 9.0
    translate  <1338.0, 1032.659321, -1156.578889>
  }
  sphere { // sphere704_706
    <0,0,0>,1
    scale 7.0
    translate  <-482.0, -1058.410323, 1685.748376>
  }
  sphere { // sphere705_707
    <0,0,0>,1
    scale 12.0
    translate  <-301.0, -706.493642, -1898.570445>
  }
  sphere { // sphere706_708
    <0,0,0>,1
    translate  <1751.0, 218.29111, 1039.544127>
  }
  sphere { // sphere707_709
    <0,0,0>,1
    scale 10.0
    translate  <-164.0, 190.885015, -2032.479006>
  }
  sphere { // sphere708_710
    <0,0,0>,1
    scale 7.0
    translate  <1967.0, -158.232167, 547.884642>
  }
  sphere { // sphere709_711
    <0,0,0>,1
    scale 10.0
    translate  <-1916.0, -157.086836, -706.096117>
  }
  sphere { // sphere710_712
    <0,0,0>,1
    scale 11.0
    translate  <-546.0, 747.191245, -1826.990214>
  }
  sphere { // sphere711_713
    <0,0,0>,1
    translate  <699.0, 1241.088196, -1471.530866>
  }
  sphere { // sphere712_714
    <0,0,0>,1
    scale 2.0
    translate  <1093.0, -245.458418, -1714.469354>
  }
  sphere { // sphere713_715
    <0,0,0>,1
    scale 9.0
    translate  <1588.0, -973.824011, -851.015156>
  }
  sphere { // sphere714_716
    <0,0,0>,1
    scale 6.0
    translate  <-963.0, 614.476817, 1699.809766>
  }
  sphere { // sphere715_717
    <0,0,0>,1
    scale 6.0
    translate  <754.0, -51.020626, -1903.466547>
  }
  sphere { // sphere716_718
    <0,0,0>,1
    scale 3.0
    translate  <14.0, 243.869302, -2033.380378>
  }
  sphere { // sphere717_719
    <0,0,0>,1
    scale 7.0
    translate  <577.0, -1019.219626, 1680.04951>
  }
  sphere { // sphere718_720
    <0,0,0>,1
    scale 10.0
    translate  <124.0, -780.315766, 1889.453705>
  }
  sphere { // sphere719_721
    <0,0,0>,1
    translate  <1108.0, -145.49517, 1716.2375>
  }
  sphere { // sphere720_722
    <0,0,0>,1
    translate  <1103.0, -460.890207, 1662.911669>
  }
  sphere { // sphere721_723
    <0,0,0>,1
    translate  <-1674.0, -480.823209, -1077.421478>
  }
  sphere { // sphere722_724
    <0,0,0>,1
    scale 11.0
    translate  <-738.0, -452.999046, 1855.923453>
  }
  sphere { // sphere723_725
    <0,0,0>,1
    scale 6.0
    translate  <287.0, -420.929936, -1983.621181>
  }
  sphere { // sphere724_726
    <0,0,0>,1
    scale 9.0
    translate  <-1419.0, 19.46866, 1476.605557>
  }
  sphere { // sphere725_727
    <0,0,0>,1
    scale 12.0
    translate  <-927.0, -1635.591582, 812.290081>
  }
  sphere { // sphere726_728
    <0,0,0>,1
    scale 12.0
    translate  <1418.0, -355.985035, -1434.173858>
  }
  sphere { // sphere727_729
    <0,0,0>,1
    scale 8.0
    translate  <1685.0, 866.735529, 777.076909>
  }
  sphere { // sphere728_730
    <0,0,0>,1
    scale 3.0
    translate  <-538.0, -165.476721, -1969.131142>
  }
  sphere { // sphere729_731
    <0,0,0>,1
    scale 7.0
    translate  <-1841.0, -315.925545, 839.770236>
  }
  sphere { // sphere730_732
    <0,0,0>,1
    scale 11.0
    translate  <-782.0, 1290.340778, 1384.846806>
  }
  sphere { // sphere731_733
    <0,0,0>,1
    scale 6.0
    translate  <1155.0, -1409.019199, 935.384357>
  }
  sphere { // sphere732_734
    <0,0,0>,1
    scale 3.0
    translate  <1325.0, 1357.273498, 772.32613>
  }
  sphere { // sphere733_735
    <0,0,0>,1
    scale 9.0
    translate  <-1542.0, 208.042169, -1331.637509>
  }
  sphere { // sphere734_736
    <0,0,0>,1
    scale 8.0
    translate  <972.0, 1621.542068, 787.477824>
  }
  sphere { // sphere735_737
    <0,0,0>,1
    scale 2.0
    translate  <420.0, 605.965874, -1910.682956>
  }
  sphere { // sphere736_738
    <0,0,0>,1
    scale 4.0
    translate  <726.0, 1299.848859, 1406.279113>
  }
  sphere { // sphere737_739
    <0,0,0>,1
    scale 8.0
    translate  <1488.0, -1244.167015, 657.425615>
  }
  sphere { // sphere738_740
    <0,0,0>,1
    scale 11.0
    translate  <-1974.0, 77.950403, -539.955308>
  }
  sphere { // sphere739_741
    <0,0,0>,1
    scale 11.0
    translate  <-131.0, 119.50477, -2040.309195>
  }
  sphere { // sphere740_742
    <0,0,0>,1
    scale 2.0
    translate  <1706.0, -752.296952, -847.300003>
  }
  sphere { // sphere741_743
    <0,0,0>,1
    scale 6.0
    translate  <1515.0, 652.867748, -1213.60731>
  }
  sphere { // sphere742_744
    <0,0,0>,1
    scale 9.0
    translate  <1635.0, -312.018598, 1193.198808>
  }
  sphere { // sphere743_745
    <0,0,0>,1
    scale 9.0
    translate  <14.0, 223.869769, 2035.679328>
  }
  sphere { // sphere744_746
    <0,0,0>,1
    scale 6.0
    translate  <-96.0, 1077.439336, 1739.026302>
  }
  sphere { // sphere745_747
    <0,0,0>,1
    scale 4.0
    translate  <690.0, 1348.396389, 1378.416185>
  }
  sphere { // sphere746_748
    <0,0,0>,1
    scale 8.0
    translate  <-1059.0, -1080.399065, -1380.420538>
  }
  sphere { // sphere747_749
    <0,0,0>,1
    scale 3.0
    translate  <2044.0, 44.142493, -120.080974>
  }
  sphere { // sphere748_750
    <0,0,0>,1
    scale 8.0
    translate  <1823.0, -315.567791, 878.289229>
  }
  sphere { // sphere749_751
    <0,0,0>,1
    scale 7.0
    translate  <-225.0, -757.760122, 1889.30638>
  }
  sphere { // sphere750_752
    <0,0,0>,1
    scale 6.0
    translate  <-798.0, -766.126659, 1723.528341>
  }
  sphere { // sphere751_753
    <0,0,0>,1
    scale 12.0
    translate  <-106.0, -549.762146, -1969.982127>
  }
  sphere { // sphere752_754
    <0,0,0>,1
    scale 3.0
    translate  <1545.0, 323.615689, 1304.818718>
  }
  sphere { // sphere753_755
    <0,0,0>,1
    scale 6.0
    translate  <-1108.0, 1049.163144, -1365.978293>
  }
  sphere { // sphere754_756
    <0,0,0>,1
    scale 6.0
    translate  <-610.0, 847.098998, 1761.995257>
  }
  sphere { // sphere755_757
    <0,0,0>,1
    scale 9.0
    translate  <-693.0, -691.407057, -1798.891682>
  }
  sphere { // sphere756_758
    <0,0,0>,1
    scale 6.0
    translate  <-1015.0, -1142.90029, 1363.032622>
  }
  sphere { // sphere757_759
    <0,0,0>,1
    scale 11.0
    translate  <-279.0, 1090.611732, -1710.856233>
  }
  sphere { // sphere758_760
    <0,0,0>,1
    scale 2.0
    translate  <-674.0, -881.380908, 1721.393533>
  }
  sphere { // sphere759_761
    <0,0,0>,1
    scale 8.0
    translate  <-1019.0, 1286.18238, -1225.429674>
  }
  sphere { // sphere760_762
    <0,0,0>,1
    scale 4.0
    translate  <-1620.0, 207.322352, 1235.686628>
  }
  sphere { // sphere761_763
    <0,0,0>,1
    scale 10.0
    translate  <-1475.0, -963.013236, 1044.645637>
  }
  sphere { // sphere762_764
    <0,0,0>,1
    scale 2.0
    translate  <1989.0, -17.038504, -487.742442>
  }
  sphere { // sphere763_765
    <0,0,0>,1
    scale 4.0
    translate  <2023.0, -201.452699, 247.369784>
  }
  sphere { // sphere764_766
    <0,0,0>,1
    scale 9.0
    translate  <1474.0, 157.596485, 1413.078677>
  }
  sphere { // sphere765_767
    <0,0,0>,1
    scale 4.0
    translate  <-1718.0, -710.698883, 858.887128>
  }
  sphere { // sphere766_768
    <0,0,0>,1
    scale 9.0
    translate  <-1926.0, 689.921135, 94.004404>
  }
  sphere { // sphere767_769
    <0,0,0>,1
    scale 7.0
    translate  <1020.0, 1473.396428, -991.467078>
  }
  sphere { // sphere768_770
    <0,0,0>,1
    scale 3.0
    translate  <-377.0, 1506.065202, -1335.643144>
  }
  sphere { // sphere769_771
    <0,0,0>,1
    scale 8.0
    translate  <639.0, 1146.031893, 1572.448378>
  }
  sphere { // sphere770_772
    <0,0,0>,1
    scale 2.0
    translate  <1510.0, 549.990577, 1269.533129>
  }
  sphere { // sphere771_773
    <0,0,0>,1
    scale 8.0
    translate  <840.0, -1726.672908, -712.253234>
  }
  sphere { // sphere772_774
    <0,0,0>,1
    translate  <-238.0, -99.943221, -2031.667136>
  }
  sphere { // sphere773_775
    <0,0,0>,1
    scale 10.0
    translate  <1866.0, -309.187663, -785.334953>
  }
  sphere { // sphere774_776
    <0,0,0>,1
    scale 7.0
    translate  <-134.0, -1346.483535, -1537.312619>
  }
  sphere { // sphere775_777
    <0,0,0>,1
    scale 10.0
    translate  <1985.0, 212.251414, -457.19617>
  }
  sphere { // sphere776_778
    <0,0,0>,1
    scale 4.0
    translate  <-1650.0, 398.000409, 1146.036506>
  }
  sphere { // sphere777_779
    <0,0,0>,1
    scale 3.0
    translate  <-1416.0, 1023.192743, 1068.795869>
  }
  sphere { // sphere778_780
    <0,0,0>,1
    translate  <1019.0, 437.184906, -1721.863049>
  }
  sphere { // sphere779_781
    <0,0,0>,1
    scale 8.0
    translate  <438.0, -1983.764023, -259.114455>
  }
  sphere { // sphere780_782
    <0,0,0>,1
    scale 7.0
    translate  <-325.0, 1337.829754, 1516.209269>
  }
  sphere { // sphere781_783
    <0,0,0>,1
    scale 8.0
    translate  <-1217.0, 1047.586479, 1271.132396>
  }
  sphere { // sphere782_784
    <0,0,0>,1
    scale 8.0
    translate  <-939.0, 1808.941569, 200.781973>
  }
  sphere { // sphere783_785
    <0,0,0>,1
    scale 7.0
    translate  <531.0, -1586.693454, -1180.994023>
  }
  sphere { // sphere784_786
    <0,0,0>,1
    scale 4.0
    translate  <823.0, 328.279564, -1846.403945>
  }
  sphere { // sphere785_787
    <0,0,0>,1
    scale 12.0
    translate  <-1178.0, -82.108367, -1673.283663>
  }
  sphere { // sphere786_788
    <0,0,0>,1
    translate  <-136.0, -562.256169, 1964.605813>
  }
  sphere { // sphere787_789
    <0,0,0>,1
    scale 6.0
    translate  <-1512.0, 1286.342447, -503.471061>
  }
  sphere { // sphere788_790
    <0,0,0>,1
    translate  <-1266.0, 718.841904, 1440.421576>
  }
  sphere { // sphere789_791
    <0,0,0>,1
    translate  <-220.0, 84.50815, 2034.394842>
  }
  sphere { // sphere790_792
    <0,0,0>,1
    scale 7.0
    translate  <-1090.0, -752.311671, 1562.123923>
  }
  sphere { // sphere791_793
    <0,0,0>,1
    scale 5.0
    translate  <-1293.0, -1380.292933, -785.650316>
  }
  sphere { // sphere792_794
    <0,0,0>,1
    scale 8.0
    translate  <-1008.0, 1389.40959, 1117.041177>
  }
  sphere { // sphere793_795
    <0,0,0>,1
    scale 11.0
    translate  <-748.0, 926.493749, -1666.256083>
  }
  sphere { // sphere794_796
    <0,0,0>,1
    scale 3.0
    translate  <-1449.0, -582.227346, -1325.033704>
  }
  sphere { // sphere795_797
    <0,0,0>,1
    scale 3.0
    translate  <-61.0, -1646.019376, 1217.046923>
  }
  sphere { // sphere796_798
    <0,0,0>,1
    scale 7.0
    translate  <-137.0, -322.900097, -2017.738964>
  }
  sphere { // sphere797_799
    <0,0,0>,1
    scale 4.0
    translate  <-794.0, 1495.25468, -1152.424159>
  }
  sphere { // sphere798_800
    <0,0,0>,1
    scale 7.0
    translate  <-1732.0, -689.34711, 848.104099>
  }
  sphere { // sphere799_801
    <0,0,0>,1
    scale 11.0
    translate  <1150.0, -578.601987, 1592.803736>
  }
  sphere { // sphere800_802
    <0,0,0>,1
    scale 5.0
    translate  <841.0, -1139.288501, -1479.542061>
  }
  sphere { // sphere801_803
    <0,0,0>,1
    scale 2.0
    translate  <-1242.0, 357.607558, 1588.665111>
  }
  sphere { // sphere802_804
    <0,0,0>,1
    scale 8.0
    translate  <46.0, -1473.503173, -1421.610495>
  }
  sphere { // sphere803_805
    <0,0,0>,1
    scale 7.0
    translate  <1097.0, 109.355442, -1725.959556>
  }
  sphere { // sphere804_806
    <0,0,0>,1
    scale 9.0
    translate  <1039.0, 1556.437728, -832.036416>
  }
  sphere { // sphere805_807
    <0,0,0>,1
    scale 9.0
    translate  <181.0, 473.01678, -1984.388602>
  }
  sphere { // sphere806_808
    <0,0,0>,1
    scale 4.0
    translate  <-714.0, 261.143897, -1901.660292>
  }
  sphere { // sphere807_809
    <0,0,0>,1
    scale 11.0
    translate  <434.0, -1738.718055, 991.366494>
  }
  sphere { // sphere808_810
    <0,0,0>,1
    translate  <-185.0, 1639.519644, 1213.282463>
  }
  sphere { // sphere809_811
    <0,0,0>,1
    scale 8.0
    translate  <1130.0, -1472.017742, -866.353143>
  }
  sphere { // sphere810_812
    <0,0,0>,1
    scale 11.0
    translate  <-711.0, 367.853213, 1885.064194>
  }
  sphere { // sphere811_813
    <0,0,0>,1
    scale 4.0
    translate  <846.0, -1356.931153, -1279.58034>
  }
  sphere { // sphere812_814
    <0,0,0>,1
    scale 3.0
    translate  <1835.0, -444.283964, -793.530566>
  }
  sphere { // sphere813_815
    <0,0,0>,1
    scale 9.0
    translate  <1364.0, -777.826631, -1314.83601>
  }
  sphere { // sphere814_816
    <0,0,0>,1
    translate  <-765.0, 1893.61216, 152.682637>
  }
  sphere { // sphere815_817
    <0,0,0>,1
    scale 3.0
    translate  <1864.0, 430.421473, -731.126087>
  }
  sphere { // sphere816_818
    <0,0,0>,1
    scale 3.0
    translate  <-1997.0, -269.984466, 365.244285>
  }
  sphere { // sphere817_819
    <0,0,0>,1
    scale 10.0
    translate  <1066.0, -352.749635, 1712.750915>
  }
  sphere { // sphere818_820
    <0,0,0>,1
    scale 4.0
    translate  <1901.0, 270.322763, -712.34023>
  }
  sphere { // sphere819_821
    <0,0,0>,1
    scale 3.0
    translate  <-1966.0, -79.207858, 568.220129>
  }
  sphere { // sphere820_822
    <0,0,0>,1
    scale 12.0
    translate  <-1811.0, -715.852861, -634.143266>
  }
  sphere { // sphere821_823
    <0,0,0>,1
    scale 8.0
    translate  <-1434.0, -1291.270253, 685.980418>
  }
  sphere { // sphere822_824
    <0,0,0>,1
    scale 3.0
    translate  <-774.0, -557.467978, -1812.307218>
  }
  sphere { // sphere823_825
    <0,0,0>,1
    scale 7.0
    translate  <1662.0, -840.325013, 852.005794>
  }
  sphere { // sphere824_826
    <0,0,0>,1
    scale 11.0
    translate  <1165.0, 767.442043, 1499.370438>
  }
  sphere { // sphere825_827
    <0,0,0>,1
    scale 8.0
    translate  <1402.0, 126.654512, -1487.500802>
  }
  sphere { // sphere826_828
    <0,0,0>,1
    scale 8.0
    translate  <-1655.0, 301.660993, -1168.023821>
  }
  sphere { // sphere827_829
    <0,0,0>,1
    scale 9.0
    translate  <-381.0, 481.814567, 1953.713828>
  }
  sphere { // sphere828_830
    <0,0,0>,1
    scale 7.0
    translate  <-1836.0, 101.519639, -901.721555>
  }
  sphere { // sphere829_831
    <0,0,0>,1
    scale 8.0
    translate  <1218.0, 1579.015189, -466.359339>
  }
  sphere { // sphere830_832
    <0,0,0>,1
    scale 4.0
    translate  <1156.0, -1488.932716, -800.654337>
  }
  sphere { // sphere831_833
    <0,0,0>,1
    scale 12.0
    translate  <486.0, -473.088977, 1932.432358>
  }
  sphere { // sphere832_834
    <0,0,0>,1
    scale 7.0
    translate  <1974.0, 343.534521, -423.806599>
  }
  sphere { // sphere833_835
    <0,0,0>,1
    scale 8.0
    translate  <137.0, 447.869543, 1993.727131>
  }
  sphere { // sphere834_836
    <0,0,0>,1
    scale 11.0
    translate  <34.0, -174.225986, 2040.292456>
  }
  sphere { // sphere835_837
    <0,0,0>,1
    scale 10.0
    translate  <-1393.0, 754.490733, -1297.920928>
  }
  sphere { // sphere836_838
    <0,0,0>,1
    scale 5.0
    translate  <1354.0, 1162.635425, 1004.622749>
  }
  sphere { // sphere837_839
    <0,0,0>,1
    scale 10.0
    translate  <-1853.0, 261.802546, -831.958188>
  }
  sphere { // sphere838_840
    <0,0,0>,1
    scale 11.0
    translate  <1064.0, 1608.825274, -688.396135>
  }
  sphere { // sphere839_841
    <0,0,0>,1
    scale 5.0
    translate  <-963.0, -1168.278186, 1379.152305>
  }
  sphere { // sphere840_842
    <0,0,0>,1
    scale 7.0
    translate  <645.0, -373.000669, -1907.655499>
  }
  sphere { // sphere841_843
    <0,0,0>,1
    scale 11.0
    translate  <494.0, 32.632145, 1987.26021>
  }
  sphere { // sphere842_844
    <0,0,0>,1
    scale 11.0
    translate  <-1865.0, -595.304472, 601.408003>
  }
  sphere { // sphere843_845
    <0,0,0>,1
    scale 12.0
    translate  <-398.0, -1991.543355, 263.922458>
  }
  sphere { // sphere844_846
    <0,0,0>,1
    scale 10.0
    translate  <-713.0, -159.482128, 1913.243437>
  }
  sphere { // sphere845_847
    <0,0,0>,1
    scale 8.0
    translate  <-364.0, 483.059533, 1956.645468>
  }
  sphere { // sphere846_848
    <0,0,0>,1
    scale 10.0
    translate  <-608.0, 1159.865271, 1574.595997>
  }
  sphere { // sphere847_849
    <0,0,0>,1
    scale 5.0
    translate  <308.0, -1186.351984, 1640.734278>
  }
  sphere { // sphere848_850
    <0,0,0>,1
    scale 4.0
    translate  <1494.0, 160.224457, 1391.616371>
  }
  sphere { // sphere849_851
    <0,0,0>,1
    scale 7.0
    translate  <-1027.0, 697.333486, 1628.895641>
  }
  sphere { // sphere850_852
    <0,0,0>,1
    scale 7.0
    translate  <703.0, -282.711178, 1902.674273>
  }
  sphere { // sphere851_853
    <0,0,0>,1
    scale 11.0
    translate  <1862.0, -685.973549, 506.655988>
  }
  sphere { // sphere852_854
    <0,0,0>,1
    scale 6.0
    translate  <911.0, -1731.565248, -605.032884>
  }
  sphere { // sphere853_855
    <0,0,0>,1
    scale 8.0
    translate  <132.0, 667.484232, 1931.668916>
  }
  sphere { // sphere854_856
    <0,0,0>,1
    scale 4.0
    translate  <-539.0, -676.16619, -1856.497316>
  }
  sphere { // sphere855_857
    <0,0,0>,1
    scale 6.0
    translate  <-1983.0, 61.26617, 508.19431>
  }
  sphere { // sphere856_858
    <0,0,0>,1
    translate  <1818.0, 192.863184, 923.029681>
  }
  sphere { // sphere857_859
    <0,0,0>,1
    translate  <533.0, -1725.782439, -965.344483>
  }
  sphere { // sphere858_860
    <0,0,0>,1
    scale 8.0
    translate  <699.0, -1145.330657, -1547.230004>
  }
  sphere { // sphere859_861
    <0,0,0>,1
    scale 2.0
    translate  <1301.0, 1031.121519, 1199.371257>
  }
  sphere { // sphere860_862
    <0,0,0>,1
    scale 3.0
    translate  <1250.0, 458.148566, -1556.246732>
  }
  sphere { // sphere861_863
    <0,0,0>,1
    scale 11.0
    translate  <852.0, -1038.827234, -1545.716008>
  }
  sphere { // sphere862_864
    <0,0,0>,1
    scale 9.0
    translate  <-1727.0, -949.163436, -557.551586>
  }
  sphere { // sphere863_865
    <0,0,0>,1
    scale 9.0
    translate  <371.0, -652.030696, -1905.654473>
  }
  sphere { // sphere864_866
    <0,0,0>,1
    scale 9.0
    translate  <1765.0, 837.357393, 614.745148>
  }
  sphere { // sphere865_867
    <0,0,0>,1
    scale 10.0
    translate  <-531.0, 1704.038508, 1004.288686>
  }
  sphere { // sphere866_868
    <0,0,0>,1
    scale 2.0
    translate  <1859.0, 203.919578, 834.769313>
  }
  sphere { // sphere867_869
    <0,0,0>,1
    scale 2.0
    translate  <-859.0, 812.241543, 1672.329715>
  }
  sphere { // sphere868_870
    <0,0,0>,1
    scale 5.0
    translate  <-275.0, -984.378787, 1774.733051>
  }
  sphere { // sphere869_871
    <0,0,0>,1
    scale 8.0
    translate  <-1913.0, 682.026331, 263.770892>
  }
  sphere { // sphere870_872
    <0,0,0>,1
    scale 8.0
    translate  <-1697.0, 333.793526, 1096.848614>
  }
  sphere { // sphere871_873
    <0,0,0>,1
    scale 11.0
    translate  <-960.0, -426.096732, 1758.1654>
  }
  sphere { // sphere872_874
    <0,0,0>,1
    scale 12.0
    translate  <-1664.0, -588.134971, 1038.992423>
  }
  sphere { // sphere873_875
    <0,0,0>,1
    scale 8.0
    translate  <-280.0, -1286.926093, -1568.351119>
  }
  sphere { // sphere874_876
    <0,0,0>,1
    scale 9.0
    translate  <22.0, 922.196787, 1828.489291>
  }
  sphere { // sphere875_877
    <0,0,0>,1
    scale 3.0
    translate  <845.0, 1214.816848, 1415.803315>
  }
  sphere { // sphere876_878
    <0,0,0>,1
    scale 6.0
    translate  <-1495.0, 1254.334658, 621.227467>
  }
  sphere { // sphere877_879
    <0,0,0>,1
    scale 9.0
    translate  <-1356.0, -11.709488, 1534.74131>
  }
  sphere { // sphere878_880
    <0,0,0>,1
    scale 11.0
    translate  <-678.0, 1132.805689, 1565.685559>
  }
  sphere { // sphere879_881
    <0,0,0>,1
    scale 5.0
    translate  <-1967.0, -436.269684, -367.265249>
  }
  sphere { // sphere880_882
    <0,0,0>,1
    scale 3.0
    translate  <377.0, 1602.513332, -1218.247109>
  }
  sphere { // sphere881_883
    <0,0,0>,1
    translate  <867.0, 78.026749, 1853.787158>
  }
  sphere { // sphere882_884
    <0,0,0>,1
    scale 12.0
    translate  <1839.0, 506.27898, 745.697388>
  }
  sphere { // sphere883_885
    <0,0,0>,1
    scale 11.0
    translate  <1217.0, 423.357645, -1591.849021>
  }
  sphere { // sphere884_886
    <0,0,0>,1
    scale 9.0
    translate  <1373.0, 693.297575, 1352.225378>
  }
  sphere { // sphere885_887
    <0,0,0>,1
    scale 12.0
    translate  <979.0, -1266.134252, 1277.797737>
  }
  sphere { // sphere886_888
    <0,0,0>,1
    scale 12.0
    translate  <-1074.0, 1617.886859, 650.592124>
  }
  sphere { // sphere887_889
    <0,0,0>,1
    scale 11.0
    translate  <90.0, 110.767888, 2043.020919>
  }
  sphere { // sphere888_890
    <0,0,0>,1
    scale 9.0
    translate  <-974.0, -1173.148924, 1367.241604>
  }
  sphere { // sphere889_891
    <0,0,0>,1
    scale 5.0
    translate  <-1016.0, 1216.227749, 1297.242484>
  }
  sphere { // sphere890_892
    <0,0,0>,1
    scale 12.0
    translate  <-1072.0, -1120.357747, 1337.878364>
  }
  sphere { // sphere891_893
    <0,0,0>,1
    scale 2.0
    translate  <741.0, -1625.493308, -1001.496134>
  }
  sphere { // sphere892_894
    <0,0,0>,1
    scale 3.0
    translate  <810.0, -1828.659061, -440.69268>
  }
  sphere { // sphere893_895
    <0,0,0>,1
    scale 5.0
    translate  <-624.0, 1721.438612, 917.375117>
  }
  sphere { // sphere894_896
    <0,0,0>,1
    scale 4.0
    translate  <1765.0, 139.548998, -1029.371205>
  }
  sphere { // sphere895_897
    <0,0,0>,1
    translate  <-287.0, -1016.123132, -1754.830129>
  }
  sphere { // sphere896_898
    <0,0,0>,1
    scale 3.0
    translate  <113.0, 1165.471877, 1680.241145>
  }
  sphere { // sphere897_899
    <0,0,0>,1
    scale 8.0
    translate  <-1769.0, 498.596273, -903.517989>
  }
  sphere { // sphere898_900
    <0,0,0>,1
    scale 4.0
    translate  <-110.0, 2036.805673, 183.375703>
  }
  sphere { // sphere899_901
    <0,0,0>,1
    scale 9.0
    translate  <-103.0, 965.776269, -1803.044979>
  }
  sphere { // sphere900_902
    <0,0,0>,1
    scale 10.0
    translate  <-1632.0, 506.574926, 1128.832071>
  }
  sphere { // sphere901_903
    <0,0,0>,1
    scale 4.0
    translate  <-1129.0, 489.124331, -1637.198946>
  }
  sphere { // sphere902_904
    <0,0,0>,1
    scale 10.0
    translate  <622.0, 1295.759345, 1458.913199>
  }
  sphere { // sphere903_905
    <0,0,0>,1
    scale 12.0
    translate  <-745.0, 1149.340971, -1522.594606>
  }
  sphere { // sphere904_906
    <0,0,0>,1
    scale 2.0
    translate  <-270.0, 772.572264, -1877.374789>
  }
  sphere { // sphere905_907
    <0,0,0>,1
    scale 12.0
    translate  <445.0, -1423.165713, -1403.87975>
  }
  sphere { // sphere906_908
    <0,0,0>,1
    scale 6.0
    translate  <1400.0, -964.878511, -1141.627548>
  }
  sphere { // sphere907_909
    <0,0,0>,1
    scale 12.0
    translate  <141.0, -1641.595533, -1216.382796>
  }
  sphere { // sphere908_910
    <0,0,0>,1
    scale 2.0
    translate  <970.0, 1406.073323, 1129.761837>
  }
  sphere { // sphere909_911
    <0,0,0>,1
    scale 5.0
    translate  <-22.0, 1886.641136, 796.495588>
  }
  sphere { // sphere910_912
    <0,0,0>,1
    scale 8.0
    translate  <-1051.0, -717.735695, -1604.543072>
  }
  sphere { // sphere911_913
    <0,0,0>,1
    scale 10.0
    translate  <-1121.0, 1455.883669, 904.469867>
  }
  sphere { // sphere912_914
    <0,0,0>,1
    scale 3.0
    translate  <1269.0, 414.522624, -1553.098192>
  }
  sphere { // sphere913_915
    <0,0,0>,1
    scale 7.0
    translate  <1379.0, -1345.309019, -694.842891>
  }
  sphere { // sphere914_916
    <0,0,0>,1
    scale 2.0
    translate  <766.0, -691.970689, -1768.820105>
  }
  sphere { // sphere915_917
    <0,0,0>,1
    scale 3.0
    translate  <-751.0, 1778.344055, 683.955717>
  }
  sphere { // sphere916_918
    <0,0,0>,1
    scale 10.0
    translate  <1344.0, -987.414526, 1188.688586>
  }
  sphere { // sphere917_919
    <0,0,0>,1
    scale 2.0
    translate  <-1751.0, 757.89221, 744.246194>
  }
  sphere { // sphere918_920
    <0,0,0>,1
    scale 9.0
    translate  <1159.0, 1409.623141, -929.508258>
  }
  sphere { // sphere919_921
    <0,0,0>,1
    scale 3.0
    translate  <1382.0, -1328.393456, -720.937464>
  }
  sphere { // sphere920_922
    <0,0,0>,1
    scale 7.0
    translate  <205.0, -970.351921, -1791.841552>
  }
  sphere { // sphere921_923
    <0,0,0>,1
    scale 5.0
    translate  <1785.0, -112.26718, 997.734975>
  }
  sphere { // sphere922_924
    <0,0,0>,1
    scale 3.0
    translate  <807.0, -1473.993825, 1170.639656>
  }
  sphere { // sphere923_925
    <0,0,0>,1
    scale 12.0
    translate  <1504.0, -1379.801622, -168.628243>
  }
  sphere { // sphere924_926
    <0,0,0>,1
    scale 12.0
    translate  <-74.0, 685.676958, -1928.38666>
  }
  sphere { // sphere925_927
    <0,0,0>,1
    scale 5.0
    translate  <-1300.0, 1556.710269, 284.529681>
  }
  sphere { // sphere926_928
    <0,0,0>,1
    scale 12.0
    translate  <-670.0, 1220.905068, 1501.597421>
  }
  sphere { // sphere927_929
    <0,0,0>,1
    translate  <-914.0, 1632.389143, -833.194867>
  }
  sphere { // sphere928_930
    <0,0,0>,1
    scale 12.0
    translate  <-1933.0, 598.485172, -315.642992>
  }
  sphere { // sphere929_931
    <0,0,0>,1
    scale 7.0
    translate  <588.0, -1014.413777, -1679.144035>
  }
  sphere { // sphere930_932
    <0,0,0>,1
    scale 11.0
    translate  <-1136.0, -422.477835, 1650.854469>
  }
  sphere { // sphere931_933
    <0,0,0>,1
    scale 5.0
    translate  <1783.0, -224.774197, -982.187131>
  }
  sphere { // sphere932_934
    <0,0,0>,1
    scale 9.0
    translate  <-1395.0, 7.229899, 1499.408793>
  }
  sphere { // sphere933_935
    <0,0,0>,1
    scale 10.0
    translate  <8.0, -860.118438, -1858.611383>
  }
  sphere { // sphere934_936
    <0,0,0>,1
    translate  <1381.0, 397.928224, -1459.039454>
  }
  sphere { // sphere935_937
    <0,0,0>,1
    scale 3.0
    translate  <159.0, -675.82898, 1926.727326>
  }
  sphere { // sphere936_938
    <0,0,0>,1
    translate  <532.0, -1544.109038, 1235.721359>
  }
  sphere { // sphere937_939
    <0,0,0>,1
    translate  <-1197.0, -86.111248, -1659.542061>
  }
  sphere { // sphere938_940
    <0,0,0>,1
    scale 11.0
    translate  <893.0, 964.274601, -1570.678037>
  }
  sphere { // sphere939_941
    <0,0,0>,1
    scale 9.0
    translate  <864.0, 378.528047, -1817.835118>
  }
  sphere { // sphere940_942
    <0,0,0>,1
    scale 8.0
    translate  <-926.0, -1442.605834, 1120.587528>
  }
  sphere { // sphere941_943
    <0,0,0>,1
    scale 8.0
    translate  <1769.0, 269.579592, 996.127423>
  }
  sphere { // sphere942_944
    <0,0,0>,1
    scale 6.0
    translate  <-1681.0, 44.269129, 1169.009514>
  }
  sphere { // sphere943_945
    <0,0,0>,1
    scale 12.0
    translate  <153.0, 1428.247613, -1459.795792>
  }
  sphere { // sphere944_946
    <0,0,0>,1
    scale 9.0
    translate  <-350.0, -768.278825, -1865.891649>
  }
  sphere { // sphere945_947
    <0,0,0>,1
    scale 5.0
    translate  <1919.0, 22.922676, 714.994791>
  }
  sphere { // sphere946_948
    <0,0,0>,1
    scale 7.0
    translate  <-788.0, -1810.492566, -543.577655>
  }
  sphere { // sphere947_949
    <0,0,0>,1
    scale 6.0
    translate  <-1278.0, -521.295227, 1513.033802>
  }
  sphere { // sphere948_950
    <0,0,0>,1
    scale 8.0
    translate  <1696.0, 1138.183521, 149.754043>
  }
  sphere { // sphere949_951
    <0,0,0>,1
    scale 7.0
    translate  <2010.0, 129.282226, 370.796583>
  }
  sphere { // sphere950_952
    <0,0,0>,1
    scale 3.0
    translate  <1632.0, 631.406224, -1064.051775>
  }
  sphere { // sphere951_953
    <0,0,0>,1
    scale 3.0
    translate  <1154.0, 1527.931226, 726.645835>
  }
  sphere { // sphere952_954
    <0,0,0>,1
    scale 12.0
    translate  <1636.0, 834.287595, 906.516524>
  }
  sphere { // sphere953_955
    <0,0,0>,1
    scale 11.0
    translate  <269.0, -130.236815, -2026.075362>
  }
  sphere { // sphere954_956
    <0,0,0>,1
    scale 6.0
    translate  <-94.0, 1845.677809, -882.576583>
  }
  sphere { // sphere955_957
    <0,0,0>,1
    scale 5.0
    translate  <-1419.0, 101.309137, -1473.254716>
  }
  sphere { // sphere956_958
    <0,0,0>,1
    scale 9.0
    translate  <781.0, -940.493699, -1643.111257>
  }
  sphere { // sphere957_959
    <0,0,0>,1
    scale 10.0
    translate  <1372.0, 778.161121, -1306.286825>
  }
  sphere { // sphere958_960
    <0,0,0>,1
    scale 10.0
    translate  <-729.0, 1840.852764, 523.568622>
  }
  sphere { // sphere959_961
    <0,0,0>,1
    scale 7.0
    translate  <725.0, -1772.053462, -726.983856>
  }
  sphere { // sphere960_962
    <0,0,0>,1
    scale 2.0
    translate  <1923.0, -686.349163, 159.059192>
  }
  sphere { // sphere961_963
    <0,0,0>,1
    scale 12.0
    translate  <1105.0, 555.794263, 1632.290335>
  }
  sphere { // sphere962_964
    <0,0,0>,1
    scale 12.0
    translate  <1598.0, 1125.945725, 610.693233>
  }
  sphere { // sphere963_965
    <0,0,0>,1
    scale 5.0
    translate  <1230.0, 134.326116, 1631.980544>
  }
  sphere { // sphere964_966
    <0,0,0>,1
    translate  <860.0, 332.167054, -1828.761616>
  }
  sphere { // sphere965_967
    <0,0,0>,1
    scale 11.0
    translate  <1647.0, -1100.605829, -519.963276>
  }
  sphere { // sphere966_968
    <0,0,0>,1
    scale 11.0
    translate  <-1835.0, -794.870859, -441.881564>
  }
  sphere { // sphere967_969
    <0,0,0>,1
    scale 4.0
    translate  <-203.0, 667.944348, 1925.342917>
  }
  sphere { // sphere968_970
    <0,0,0>,1
    scale 2.0
    translate  <1694.0, -1004.264527, -562.246173>
  }
  sphere { // sphere969_971
    <0,0,0>,1
    scale 5.0
    translate  <1806.0, -412.376017, 873.277745>
  }
  sphere { // sphere970_972
    <0,0,0>,1
    scale 7.0
    translate  <-697.0, -1380.36822, -1342.787614>
  }
  sphere { // sphere971_973
    <0,0,0>,1
    scale 8.0
    translate  <1905.0, -154.371624, -735.831775>
  }
  sphere { // sphere972_974
    <0,0,0>,1
    scale 12.0
    translate  <700.0, -1647.775981, 994.554331>
  }
  sphere { // sphere973_975
    <0,0,0>,1
    scale 4.0
    translate  <-1305.0, 488.715493, 1500.811836>
  }
  sphere { // sphere974_976
    <0,0,0>,1
    scale 12.0
    translate  <1708.0, 186.918205, 1114.496112>
  }
  sphere { // sphere975_977
    <0,0,0>,1
    scale 6.0
    translate  <829.0, 1477.803803, -1150.286451>
  }
  sphere { // sphere976_978
    <0,0,0>,1
    scale 10.0
    translate  <347.0, 630.869821, -1917.263224>
  }
  sphere { // sphere977_979
    <0,0,0>,1
    scale 5.0
    translate  <-1601.0, -898.773091, 907.364277>
  }
  sphere { // sphere978_980
    <0,0,0>,1
    translate  <1083.0, -762.912165, 1561.851475>
  }
  sphere { // sphere979_981
    <0,0,0>,1
    scale 8.0
    translate  <2017.0, -180.331285, -305.770547>
  }
  sphere { // sphere980_982
    <0,0,0>,1
    scale 4.0
    translate  <-1688.0, -137.674767, -1151.523191>
  }
  sphere { // sphere981_983
    <0,0,0>,1
    scale 6.0
    translate  <-1604.0, 1217.573122, -372.83199>
  }
  sphere { // sphere982_984
    <0,0,0>,1
    scale 2.0
    translate  <43.0, 1838.844552, -900.614077>
  }
  sphere { // sphere983_985
    <0,0,0>,1
    scale 6.0
    translate  <330.0, 1101.910395, -1694.460823>
  }
  sphere { // sphere984_986
    <0,0,0>,1
    scale 8.0
    translate  <751.0, -1773.34348, -696.818415>
  }
  sphere { // sphere985_987
    <0,0,0>,1
    scale 12.0
    translate  <744.0, 162.578077, -1901.140807>
  }
  sphere { // sphere986_988
    <0,0,0>,1
    scale 6.0
    translate  <162.0, -1742.148926, -1064.41398>
  }
  sphere { // sphere987_989
    <0,0,0>,1
    scale 10.0
    translate  <-1138.0, 1251.683103, 1154.36104>
  }
  sphere { // sphere988_990
    <0,0,0>,1
    scale 11.0
    translate  <570.0, -1683.255772, 1017.867381>
  }
  sphere { // sphere989_991
    <0,0,0>,1
    scale 5.0
    translate  <-1706.0, -798.286792, 804.118274>
  }
  sphere { // sphere990_992
    <0,0,0>,1
    scale 11.0
    translate  <1831.0, -665.86808, 631.159805>
  }
  sphere { // sphere991_993
    <0,0,0>,1
    scale 8.0
    translate  <340.0, 1690.215032, 1105.38552>
  }
  sphere { // sphere992_994
    <0,0,0>,1
    scale 7.0
    translate  <-1350.0, 896.648669, 1252.128254>
  }
  sphere { // sphere993_995
    <0,0,0>,1
    scale 11.0
    translate  <1132.0, -810.231822, -1502.133281>
  }
  sphere { // sphere994_996
    <0,0,0>,1
    scale 7.0
    translate  <798.0, -824.377612, -1696.437901>
  }
  sphere { // sphere995_997
    <0,0,0>,1
    scale 7.0
    translate  <-1623.0, -398.415406, -1183.824381>
  }
  sphere { // sphere996_998
    <0,0,0>,1
    scale 8.0
    translate  <567.0, 238.065842, -1953.494217>
  }
  sphere { // sphere997_999
    <0,0,0>,1
    scale 3.0
    translate  <480.0, 354.104277, 1959.212638>
  }
  sphere { // sphere998_1000
    <0,0,0>,1
    scale 3.0
    translate  <976.0, -1615.530734, -794.851212>
  }
  sphere { // sphere999_1001
    <0,0,0>,1
    scale 10.0
    translate  <1975.0, -268.21546, -470.892203>
  }
  texture {
    White_Marble1
  }
  scale 0.25
  rotate <0.0, -90.0, -90.0>
}


