
// Persistence of Vision Ray Tracer Scene Description File
// File: Flight.pov
// Vers: 3
// Desc: Flying Gurnard (Dactylopterus volitans): not to be confused with
//       Exocoetus volitans ( common flying fish ): Not that this really
//       resembles either, but artistic liscense is authorized here.
// Date: 11/20/96
// Auth: Mark Honzell :) j.honzell@worldnet.att.com

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

global_settings { assumed_gamma 2.2 }

camera
{ location  <5.0 , 5.0 ,-9.0>
  look_at   <2.0 , 0.0 , 0.0> }

light_source { <-5,4,-10> color White shadowless}
light_source { <50,150,0> color White shadowless }

// Sun reflecting on water
light_source
{ <-620,1,1100>
  color rgb <0.85,0.85,0.65>
  spotlight
  point_at <0,0,0>
  radius 0.8
  tightness 100
  falloff 4
}

box { <-200,-0.5,-100>, <200,-9,10000>
      texture { pigment { dents
                          color_map {
                                     [0.0 rgbf <0.98, 0.98, 0.98, 1.0>]
                                     [1.0 rgbf <0.90, 0.90, 0.98, 0.7>] }
                          scale 2
                         }
                finish  { ambient 0.1
                          diffuse 0.1
                          reflection 0.15
                          refraction 1
                          ior 1.45
                          specular 0.8
                          roughness 0.0001
                          phong 1
                          phong_size 400
                         }
               }
    }
plane { y,-10 texture { pigment { dents
                                  color_map {
                                             [0.00 CornflowerBlue]
                                             [1.00 SkyBlue] }
                                  turbulence 1
                                 }
                        finish { phong 1
                                 phong_size 100 }
                       }
              translate <35,0,0>
       }

#declare Skin1 =
         texture {
         pigment { dents
                   color_map { [0.000 Copper]
                               [0.005 DarkBrown]
                               [0.700 Brown]
                               [0.795 VeryDarkBrown]
                               [0.800 Wheat]
                               [1.000 DarkBrown]
                              }
                   scale <0.1,0.1,1>
                   rotate -x*90
                  }
         finish { reflection 0.15
                  phong 1
                  phong_size 100 }
                }
#declare Skin2 =
         texture{
         pigment { dents
                   color_map { [0.000 Copper]
                               [0.005 DarkBrown]
                               [0.700 Brown]
                               [0.795 VeryDarkBrown]
                               [0.800 Wheat]
                               [1.000 DarkBrown]
                              }
                   scale <0.1,0.1,1>
                  }
         finish { reflection 0.15
                  phong 1
                  phong_size 100 }
         }
#declare I_cone = quadric { <-1 1 1> <0 0 0> <0 0 0> 0 }
#declare Spike =
         object { I_cone scale <1,0.05,0.05>
                  clipped_by { plane {  x, 0 }
                               plane { -x, 1 } }
                 }
#declare Wing =
         union {
           difference {
                polygon { 40,
                          <-1.00, 0.49>, <-0.90, 0.79>
                          <-0.90, 0.79>, <-0.75, 0.99>
                          <-0.75, 0.99>, <-0.60, 1.09>
                          <-0.60, 1.09>, <-0.45, 1.19>
                          <-0.45, 1.19>, <-0.25, 1.34>
                          <-0.25, 1.34>, < 0.00, 1.39>
                          < 0.00, 1.39>, < 0.25, 1.49>
                          < 0.25, 1.49>, < 0.50, 1.49>
                          < 0.50, 1.49>, < 0.70, 1.44>
                          < 0.70, 1.44>, < 0.85, 1.29>
                          < 0.85, 1.29>, < 1.05, 1.19>
                          < 1.05, 1.19>, < 1.20, 1.04>
                          < 1.20, 1.04>, < 1.35, 0.89>
                          < 1.35, 0.89>, < 1.50, 0.79>
                          < 1.50, 0.79>, < 1.60, 0.64>
                          < 1.60, 0.64>, < 1.65, 0.39>
                          < 1.65, 0.39>, < 1.40, 0.00>
                          < 1.40, 0.00>, < 1.25,-0.34>
                          < 1.25,-0.34>, <-0.45,-1.10>
                          <-0.45,-1.10>, <-1.00, 0.49>
                         }
                 union { cylinder { -z,z,0.08 rotate x*60 translate <-0.955, 0.65, 0> }
                         cylinder { -z,z,0.08 rotate x*60 translate <-0.810, 0.90, 0> }
                         cylinder { -z,z,0.07 rotate x*60 translate <-0.680, 1.05, 0> }
                         cylinder { -z,z,0.06 rotate x*60 translate <-0.530, 1.10, 0> }
                         cylinder { -z,z,0.10 rotate x*60 translate <-0.370, 1.30, 0> }
                         cylinder { -z,z,0.12 rotate x*40 translate <-0.155, 1.32, 0> }
                         cylinder { -z,z,0.12 rotate x*30 translate < 0.095, 1.42, 0> }
                         cylinder { -z,z,0.12 rotate x*30 translate < 0.350, 1.47, 0> }
                         cylinder { -z,z,0.12 rotate x*40 translate < 0.590, 1.50, 0> }
                         cylinder { -z,z,0.08 rotate x*40 translate < 0.750, 1.35, 0> }
                         cylinder { -z,z,0.12 rotate x*40 translate < 0.960, 1.30, 0> }
                         cylinder { -z,z,0.12             translate < 1.120, 1.15, 0> }
                         cylinder { -z,z,0.12             translate < 1.280, 1.00, 0> }
                         cylinder { -z,z,0.10             translate < 1.412, 0.85, 0> }
                         cylinder { -z,z,0.10             translate < 1.555, 0.72, 0> }
                         cylinder { -z,z,0.12             translate < 1.577, 0.49, 0> }
                         cylinder { -z,z,0.20             translate < 1.567, 0.12, 0> }
                         cylinder { -z,z,0.20             translate < 1.525,-0.15, 0> }
                           }
                        }
           object { Spike scale <1.5,1,1> rotate z*110 translate <-1.00, 0.50, 0> }
           object { Spike scale <1.8,1,1> rotate z*105 translate <-0.90, 0.80, 0> }
           object { Spike scale <2.0,1,1> rotate z*100 translate <-0.75, 1.00, 0> }
           object { Spike scale <2.1,1,1> rotate z*95  translate <-0.60, 1.10, 0> }
           object { Spike scale <2.2,1,1> rotate z*90  translate <-0.45, 1.20, 0> }
           object { Spike scale <2.3,1,1> rotate z*40  translate < 1.50, 0.80, 0> }
           object { Spike scale <2.3,1,1> rotate z*35  translate < 1.60, 0.65, 0> }
           object { Spike scale <2.3,1,1> rotate z*30  translate < 1.65, 0.40, 0> }
           object { Spike scale <1.9,1,1> rotate z*25  translate < 1.40, 0.00, 0> }
           object { Spike scale <1.7,1,1> rotate z*20  translate < 1.25,-0.35, 0> }
           object { Spike scale <2.3,1,1> rotate z*85  translate <-0.25, 1.35, 0> }
           object { Spike scale <2.4,1,1> rotate z*80  translate < 0.00, 1.40, 0> }
           object { Spike scale <2.5,1,1> rotate z*75  translate < 0.25, 1.50, 0> }
           object { Spike scale <2.5,1,1> rotate z*70  translate < 0.50, 1.50, 0> }
           object { Spike scale <2.5,1,1> rotate z*65  translate < 0.70, 1.45, 0> }
           object { Spike scale <2.5,1,1> rotate z*60  translate < 0.85, 1.30, 0> }
           object { Spike scale <2.5,1,1> rotate z*55  translate < 1.05, 1.20, 0> }
           object { Spike scale <2.4,1,1> rotate z*50  translate < 1.20, 1.05, 0> }
           object { Spike scale <2.3,1,1> rotate z*45  translate < 1.35, 0.90, 0> }
           sphere { 0,1 scale <0.25,0.1,0.20> translate <-0.45,-1.00,0> pigment { Wheat } }
           sphere { 0,1 scale <0.30,0.2,0.35> translate <-0.45,-1.10,0> pigment { Brown } }
                 }
#declare Dorsal_Rear =
         union {
           difference {
                polygon { 8,
                          <-0.8,0.0>,<-1.0,0.5>
                          <-1.0,0.5>,< 1.0,1.0>
                          < 1.0,1.0>,< 1.4,0.0>
                          < 1.4,0.0>,<-0.8,0.0>
                         }
                union { cylinder { -z, z, 0.16 rotate x*40 translate <-0.835,0.50,0> }
                        cylinder { -z, z, 0.16 rotate x*40 translate <-0.505,0.59,0> }
                        cylinder { -z, z, 0.16 rotate x*40 translate <-0.165,0.67,0> }
                        cylinder { -z, z, 0.16 rotate x*40 translate < 0.165,0.75,0> }
                        cylinder { -z, z, 0.16 rotate x*40 translate < 0.505,0.83,0> }
                        cylinder { -z, z, 0.16 rotate x*40 translate < 0.835,0.91,0> }
                       }
                       }
           object { Spike rotate z*110 translate <-1.00,0.50,0> }
           object { Spike rotate z*110 translate <-0.67,0.58,0> }
           object { Spike rotate z*110 translate <-0.33,0.66,0> }
           object { Spike rotate z*110 translate < 0.00,0.74,0> }
           object { Spike rotate z*110 translate < 0.33,0.82,0> }
           object { Spike rotate z*110 translate < 0.67,0.90,0> }
           object { Spike rotate z*110 translate < 1.00,1.00,0> }
              }
#declare Dorsal_Front =
         union {
           difference {
                polygon { 8,
                          <-0.8,-0.2>,<-1.0, 0.5>
                          <-1.0, 0.5>,< 1.0, 1.2>
                          < 1.0, 1.2>,< 1.0,-0.2>
                          < 1.0,-0.2>,<-0.8,-0.2>
                         }
                union { cylinder { -z, z, 0.16 translate <-0.835,0.51,0> }
                        cylinder { -z, z, 0.16 translate <-0.505,0.63,0> }
                        cylinder { -z, z, 0.16 translate <-0.165,0.75,0> }
                        cylinder { -z, z, 0.16 translate < 0.165,0.87,0> }
                        cylinder { -z, z, 0.16 translate < 0.505,0.99,0> }
                        cylinder { -z, z, 0.16 translate < 0.835,1.11,0> }
                       }
                       }
           object { Spike rotate z*110 translate <-1.00,0.50,0> }
           object { Spike rotate z*90  translate <-0.67,0.62,0> }
           object { Spike rotate z*90  translate <-0.33,0.74,0> }
           object { Spike rotate z*90  translate < 0.00,0.86,0> }
           object { Spike rotate z*90  translate < 0.33,0.98,0> }
           object { Spike rotate z*90  translate < 0.67,1.10,0> }
           object { Spike scale <1.2,1,1> rotate z*90  translate < 1.00,1.20,0> }
              }
#declare Pectoral =
         object { Wing
                  clipped_by { plane { -x, 0 rotate  z*20 }
                               plane {  x, 0 rotate -z*15 }
                              }
                  scale <1,0.4,1>
                 }
#declare Tail =
         polygon { 10,
                   <0.0, 0.4>,<1.0, 1.0>
                   <1.0, 1.0>,<0.9, 0.2>
                   <0.9, 0.2>,<1.0,-1.0>
                   <1.0,-1.0>,<0.0,-0.3>
                   <0.0,-0.3>,<0.0, 0.4>
                  }
#declare Body = // Made with Moray Modeller, instead of using 100 spheres
union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.719356, -0.053768, -0.502540>, <-2.719350, -0.056772, -0.502552>, <-2.719287, -0.056747, -0.508560>, <-2.719293, -0.053743, -0.508547>,
      <-2.618626, -0.066004, 0.782245>, <-2.616661, -1.065994, 0.778084>, <-2.595784, -1.059267, -0.828372>, <-2.597750, -0.059278, -0.824210>,
      <-0.618739, -0.062161, 0.803138>, <-0.616774, -1.062151, 0.798976>, <-0.595897, -1.055411, -0.810787>, <-0.597862, -0.055421, -0.806625>,
      <1.381148, -0.058318, 0.824030>, <1.383114, -1.058307, 0.819869>, <1.403990, -1.051554, -0.793201>, <1.402025, -0.051564, -0.789040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.719293, -0.053743, -0.508547>, <-2.719299, -0.050739, -0.508535>, <-2.719362, -0.050764, -0.502527>, <-2.719356, -0.053768, -0.502540>,
      <-2.597750, -0.059278, -0.824210>, <-2.599715, 0.940711, -0.820049>, <-2.620591, 0.933985, 0.786406>, <-2.618626, -0.066004, 0.782245>,
      <-0.597862, -0.055421, -0.806625>, <-0.599827, 0.944568, -0.802464>, <-0.620704, 0.937828, 0.807299>, <-0.618739, -0.062161, 0.803138>,
      <1.402025, -0.051564, -0.789040>, <1.400060, 0.948425, -0.784879>, <1.379183, 0.941671, 0.828191>, <1.381148, -0.058318, 0.824030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.381148, -0.058318, 0.824030>, <1.383114, -1.058307, 0.819869>, <1.403990, -1.051554, -0.793201>, <1.402025, -0.051564, -0.789040>,
      <3.381036, -0.054475, 0.844923>, <3.383001, -1.054464, 0.840761>, <3.403877, -1.047697, -0.775616>, <3.401912, -0.047708, -0.771455>,
      <5.380923, -0.049777, 0.660249>, <5.382888, -1.049766, 0.656088>, <5.403764, -1.044585, -0.579130>, <5.401799, -0.044595, -0.574969>,
      <8.107350, 0.907599, -0.290182>, <8.108191, 0.708835, -0.291950>, <8.130192, 0.710664, -0.870696>, <8.129351, 0.909211, -0.868928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.402025, -0.051564, -0.789040>, <1.400060, 0.948425, -0.784879>, <1.379183, 0.941671, 0.828191>, <1.381148, -0.058318, 0.824030>,
      <3.401912, -0.047708, -0.771455>, <3.399947, 0.952282, -0.767294>, <3.379071, 0.945514, 0.849084>, <3.381036, -0.054475, 0.844923>,
      <5.401799, -0.044595, -0.574969>, <5.399834, 0.955394, -0.570808>, <5.378958, 0.950213, 0.664410>, <5.380923, -0.049777, 0.660249>,
      <8.129351, 0.909211, -0.868928>, <8.128510, 1.107757, -0.867160>, <8.106510, 1.106362, -0.288415>, <8.107350, 0.907599, -0.290182>
    }
  }
  rotate -90.0*x
  texture {  hexagon
                      texture { pigment { gradient x
                                color_map { [0.0 DarkBrown]
                                            [1.0 VeryDarkBrown] } scale 0.5 }
                                finish { reflection 0.10
                                         phong 0.8
                                         phong_size 200 } }
                      texture { pigment { gradient x
                                color_map { [0.0 Copper]
                                            [1.0 Brown] } scale 0.3 }
                                finish { reflection 0.10
                                         phong 0.8
                                         phong_size 200 } }
                      texture { pigment { gradient x
                                color_map { [0.0 Gray35]
                                            [1.0 Gray25] } scale 0.1 }
                                finish { reflection 0.15
                                         phong 0.8
                                         phong_size 200 } }
            scale 0.025
           }
}
#declare Eye =
          union { sphere { 0,1
                           texture { pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
                                     finish  { ambient 0.1
                                               diffuse 0.1
                                               reflection 0.1
                                               refraction 1
                                               ior 1.45
                                               specular 0.8
                                               roughness 0.003
                                               phong 1
                                               phong_size 400
                                              }
                                    }
                          }
                  sphere { 0,0.9 pigment { DarkBrown } }
                  sphere { <0.21,0,0>,0.8 scale <0.9,1,1> pigment { Gray60 } }
                  sphere { <0.44,0,0>,0.7 scale <0.8,1,1> pigment { Sienna } }
                  sphere { <0.71,0,-0.005>,0.6 scale <0.7,1,1> pigment { Black } }
                  scale <0.15,0.25,0.3>
                 }

#declare Eye_Socket=
union {
  blob {
    threshold 0.6
    sphere { <-1.1,0,0>, 1.5, 0.8 scale <0.4,0.7,0.8> rotate <0,-15,-10>}
    sphere { < 1.1,0,0>, 1.5, 0.8 scale <0.4,0.7,0.8> rotate <0, 15, 10>}
    texture {  hexagon
                      texture { pigment { gradient x
                                color_map { [0.0 DarkBrown]
                                           [1.0 VeryDarkBrown] } scale 0.5 }
                                finish { reflection 0.15
                                         phong 0.8
                                         phong_size 200 } }
                      texture { pigment { gradient x
                                color_map { [0.0 Copper]
                                            [1.0 Brown] } scale 0.3 }
                                finish { reflection 0.15
                                         phong 0.8
                                         phong_size 200 } }
                      texture { pigment { gradient x
                                color_map { [0.0 Gray35]
                                            [1.0 Gray25] } scale 0.1 }
                                finish { reflection 0.15
                                         phong 0.8
                                         phong_size 200 } }
                      scale 0.025
           } }
  object { Eye rotate -y*5 translate <-0.55,0.13,-0.07> }
  object { Eye rotate  y*5 translate < 0.55,0.13,-0.07> }
  rotate y*90
  rotate -z*25
 }
#declare Wake =
         union { object { Spike scale <12,1.5,9> rotate y*177 }
                 object { Spike scale <12,1.5,9> rotate y*183 }
                 pigment { wrinkles
                           color_map { [0.0 SkyBlue]
                                       [0.4 Clear]
                                       [1.0 Wheat] }
                           turbulence 5
                          }
                }
#declare Stirred_up =
         julia_fractal { <-0.033,-0.027,-1,0.086>
                         quaternion
                         cube
                         max_iteration 8
                         precision 15
                         texture { wrinkles
                                   texture_map { [0.0 pigment { SkyBlue } ]
                                                 [0.3 pigment { rgbf <0.98,0.98,0.98,0.9> } 
                                                      finish { diffuse 0.1
                                                               ambient 0.1
                                                               reflection 0.1} ]
                                                 [1.0 pigment { White } ]
                                                }
                                   turbulence 5
                                  } 
                        }
#declare Wake2=
         union {
                object { Stirred_up translate <0,0,-1> }
                object { Stirred_up rotate y*180 translate <0,0,1> }
                object { Stirred_up rotate y*90 translate <1,0,0> }
                }
#declare Fish =
union {
       object { Wing scale <2,2.5,1> rotate < 80, 10,-5> translate <0.4,0.3, 2.6> texture { Skin1 } }
       object { Wing scale <2,2.5,1> rotate <-80,-10,-5> translate <0.4,0.3,-2.6> texture { Skin1 } }
       object { Dorsal_Rear rotate y*180 translate <3, 0.65,0>  texture { Skin2 } }
       object { Dorsal_Rear rotate <-135,180,0> translate <3.4,-0.25, 0.44>  texture { Skin1 } }
       object { Dorsal_Rear rotate < 135,180,0> translate <3.4,-0.25,-0.44>  texture { Skin1 } }
       object { Dorsal_Front rotate y*180 translate <0.2,0.8,0> texture { Skin2 } }
       object { Pectoral rotate < 135, 0, 0> translate <-1.2,-0.2, 0.6> texture { Skin1 } }
       object { Pectoral rotate <-135, 0, 0> translate <-1.2,-0.2,-0.6> texture { Skin1 } }
       object { Tail scale <1.5,1,1> rotate <0,15,-20> translate <7.2,-0.3,-0.9> texture { Skin2 } }
       object { Body }
       object { Eye_Socket translate <-1.6,0,0> }
     }

// Render the fish over the water *Flying*
object { Fish }
object { Fish rotate -z*20 translate <-10,0,10> }
       object { Wake2 rotate -y*10 scale <1.2,0.5,2.7> translate <-5.5,-0.2,8.5>}
object { Fish rotate -x*10 translate <2,0,20> }
       object { Wake translate < 1,-0.4,20.2 > }
       object { Wake translate < 1,-0.4,18.5 > }
       object { Wake2  scale <1,0.5,3> translate <10.5,-0.2,19>}
