// LASTFLGT.POV -- a crashed engine
// by Eran Bahana and Guy Rauscher

#include "colors.inc"
#include "textures.inc"

global_settings { assumed_gamma 2.2 }

#declare Cam1 = camera {
   location <0, 8, -12>
   look_at  <0, 0, 0>
}

#declare Cam2 = camera {
   location <6, 8, -11>
   look_at  <2, 0, 0>
}

#declare Cam3 = camera {
   location <6, 4, -11>
   look_at  <2, 0, 0>
}

camera { Cam2 }

// silver sky sphere to be reflected by engine
sky_sphere { pigment { color rgb<.95,.91,.91>*0.9 } }

light_source { <10,20,-15> color White }
light_source { <20,.2,-20> color White*.6 shadowless }

/********************************************************************/
// adapted from the Bucket image by Steve Gowers
#declare Sand = texture {
   pigment { bozo color_map {
      [ 0.0 colour rgb <0.7,0.5,0.3> ]
      [ 0.3 colour rgb <0.6,0.4,0.2> ]
      [ 0.6 colour rgb <0.95,0.75,0.55> ]
      [ 0.8 colour rgb <0.7,0.5,0.3> ] } scale 0.001 }
   normal { crackle 2.5 turbulence 0.6 scale 2 }
   finish { ambient 0.4 }
   scale 2 }
//   pigment { colour rgb <0.7,0.5,0.3> } }

plane { y, 0
   texture { Sand }
}

// a puddle of spilt oil
blob {
   threshold 0.6
 component 1, 1.06054, <-0.616034, 0, 0.092827>
 component 1, 1.21597, <-0.0590717, 0, 0.329114>
 component 1, 1.13368, <0.514768, 0, 0.835443>
 component 1, 1.0876, <0.835443, 0, 0.177215>
 component 1, 1.24828, <1.03797, 0, -0.531646>
 component 1, 1.0905, <0.14346, 0, -0.244726>
 component 1, 0.906334, <-0.632911, 0, -0.548523>
 component 1, 1.24372, <0.0759494, 0, -0.818565>
 component 1, 0.802029, <-0.531646, 0, -1.10549>
 component 1, 1.03338, <0.767932, 0, -1.18987>
 component 1, 0.620843, <1.13924, 0, 0.700422>
 component 1, 0.755789, <-0.565401, 0, 0.78481>
 component -1, 1.17367, <-1.00422, 0, 0.582278>
 component -1, 1.06707, <-0.869198, 0, -1.07173>
 component -1, 1.10432, <1.45992, 0, -0.0253165>

   texture {
      pigment { color rgbt<.9,.9,.9,.8> }
      finish {
//         Shiny
         diffuse 0.2
//         reflection 0.4
         irid {0.5 thickness .5 turbulence 0.5}
     }
   }
scale <5,0.5,5>
}

#declare Hf = height_field {
   tga "hf.tga"
   smooth
}

// height fields that simulate the pushing of the sand
object { Hf
   translate <-.5,0,0>
   scale <6,3,22>
   rotate y*-30
   translate <2.5,0,5.5>
   texture { Sand }
}
object { Hf
   translate <-.5,0,0>
   scale <2,3,26>
   rotate y*-30
   translate <-6,0,-3>
   texture { Sand }
}
object { Hf
   translate <-.5,0,-.5>
   scale <6,1,1>
   rotate y*-30
   translate <0,0,2>
   texture { Sand }
}
object { Hf
   translate <-.5,0,-.5>
   scale <6,0.8,3>
   rotate y*-90
   translate <1.5,0,4.5>
   texture { Sand }
}
object { Hf
   translate <-.5,0,-.5>
   rotate y*180
   scale <2,0.8,1>
   rotate y*-10
   translate <-1.2,0,-6>
   texture { Sand }
}
object { Hf
   translate <-.5,0,-.5>
   scale <2,2,8>
   rotate y*-20
   translate <-2,0,-2.5>
   texture { Sand }
}
// the height field on the right
object { Hf
   translate <-.5,0,-.5>
   scale <16,5,20>
   rotate y*-5
   translate <15,0,2>
   texture { Sand }
}

// the actual engine
union {
   #include "engine.inc"
   rotate x*100
   translate y*8.7
   rotate z*-10
   rotate y*60
   scale 0.27
   translate <-5,0,1>
}

// the other part of propeller
#declare Prop2nd = 1 // without text
object {
   #include "prop.inc"
   scale 0.27
   rotate x*87
   rotate z*-5
   translate y*.5
   rotate y*-16
   translate <-13,0,-2>
}
#declare Rock =
mesh {
   #include "rock.inc"
}
object { Rock
   scale <2,1,2>
   pigment { color rgb <0.8,0.6,0.4> }
   normal { granite .1 }
   rotate x*-45
   rotate y*10
   translate <6,1.5,18>
}
object { Rock
   scale <1,.8,1>
   pigment { color rgb <0.8,0.6,0.4> }
   normal { granite .1 }
   rotate y*-80
   translate <11,.9,17>
}
