/*
Golfly
by Ulrich Goeltner
December 1996
*/

#include "colors.inc"
#include "textures.inc"

camera {location <-5,-2,-15> look_at   <-5,-2,0>}

#declare R=4.8/2 //Ausbuchtungen
#declare R2=4.267/2 //Hauptkugel

#declare RK=0.3 //Durchmesser kleine Kugeln
#declare X=-90
#declare X2=90
#declare Y=0
#declare Y2=360
#declare Del=0.5 //Zusaetzlicher Abstand %
#declare Prog=0.8 //Progressiver Zaehler bei Rand der Kugel
#declare DX=360/((2*pi*R)/(2*Del*RK))
#declare Col1=rgb <1,1,1>


light_source{
<-3,2,-5> color rgb 1*<1,1,1>
}



#declare Golf=
difference{
sphere{<0,0,0>,R2
}

#while (X<X2)
#while (Y<Y2)

sphere{<0,0,0>,RK
translate <R,0,0>
rotate z*X
rotate y*Y}

#declare RX=abs(R*cos(radians(X)))
#declare DY=(360/((2*pi*RX)/(2*Del*RK)))
#declare Y=Y+DY
#end


#declare Y=0
#declare X=X+DX
#end
}
//End difference


union{
object {Golf
pigment {color Col1}
finish {phong .5 ambient 0.5}
no_shadow}

cone {<0,0,0>,1,<2,0,0>,0.5
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
    planar_mapping
      linear
      max_value .5
      color_map {
        [ 0 color rgbt <1, 0, 0, 0.3> ]
        [ 1 color rgbt <1, 1, 0, 0.8> ]
      }
      turbulence 2
      frequency 2
      samples 10
    }
    hollow
scale <12,4.5,1>
translate x*-25
}
rotate y*25
}//End union


plane {y,-3
texture{
pigment {color <0,.5,0>}
normal {bumps .3 turbulence 0.3}
finish {ambient 0.8}
scale 0.5}
hollow}


plane {y,20
texture{
pigment {Blue_Sky}
finish {ambient 1}
scale 10
}
hollow}

