// Source file jcHotAir.jpg
//  1996 Joel R. Cheves
// If you would like the texture maps that accompany this:
// please email me at jcheves@ix.netcom.com
//    Please visit my WWW pages:
// http://ourworld.compuserve.com/homepages/jcheves/mygallry.htm

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"	
#include "shapesq.inc"

// CAMERA POSITION
camera {
  right      < 1.33, 0, 0 > 
 up         < 0, 1, 0 > 
 direction  < 0, 0, 1 > 
 location   < 0, 4.2, -8.25>
 look_at    < -.5, 5.2, 0>
}

fog {color Pink distance 1500 }

light_source { < 20, 4, -20 >
color CoolCopper*.5 
}

light_source { < 20, 4, -20 > 
color White*.75
}

light_source { < -40, 10, -10 >
color SteelBlue
}


#declare Tex= 
   texture { 
    pigment{
      image_map {
        gif "baltex4.gif"
        map_type 2
        interpolate 2
      }
    }
  finish {
         crand .05
         phong .2 
         phong_size 30
         ambient 0.2
         diffuse 0.8
    }
  }
#declare Tex2=
  texture { 
    pigment {
     gradient x+y
     color_map {
        [0.00, 0.25 color Red   color Red]
        [0.25, 0.75 color White color White]
        [0.75, 1.00 color Red   color Violet]
       }
    }
  finish {
         phong .2
         phong_size 30
         ambient 0.2
         diffuse 0.7
    }
}
#declare Tex3=
   texture { 
    pigment{
      image_map {
        gif "baltex6.gif"
        map_type 2
        interpolate 2
      }
    }
  finish {
         phong .2
         phong_size 30
         ambient 0.2
         diffuse 0.7
    }
 }
#declare Section1=
object {
   Piriform
   sturm
   rotate <0, 0, 90>
   translate 0.5*y
  scale <2, 5.5, 2>

   texture { Tex2
   }
  rotate x*10
  no_shadow
}
#declare Balloon1=
  #declare Count=0
  #while (Count <18)
    object{Section1 rotate y*20*Count}
    #declare Count=Count+1
   #end

#declare Section2=
object {
   Piriform
   sturm
   rotate <0, 0, 90>
   translate 0.5*y
  scale <2, 5.5, 2>

   texture { Tex
   }
  rotate x*10
  no_shadow
}
#declare Balloon2=
  #declare Count=0
  #while (Count <12)
    object{Section2 rotate y*30*Count
    translate <-6.5, 0, 10>}
    #declare Count=Count+1
   #end

#declare Section3=
object {
   Piriform
   sturm
   rotate <0, 0, 90>
   translate 0.5*y
  scale <2, 5.5, 2>
   texture { Tex3
   }
  rotate x*10
  no_shadow
}
#declare Balloon3=
  #declare Count=0
  #while (Count <18)
    object{Section3 rotate y*20*Count
    translate <10.5, -2.5, 20>}
    #declare Count=Count+1
   #end


#declare top=
sphere {<0, 0, 0> 1
    texture { pigment {color Violet }
     }
    scale <1.6, .3, 1.6>
    translate <0, 8.05, 0>
  }
#declare top2=
sphere {<0, 0, 0> 1
    texture { pigment {color Gold }
     }
    scale <1.6, .3, 1.6>
    translate <0, 8.05, 0>
  }

#declare bottom=
 cone {
    <0, .285, 0>, .875
    <0, -.285, 0>, .7
    texture {
     pigment {
      image_map {
        gif "baltex7.gif"
        map_type 1
       once
      }
     }
  finish {
         crand .05
         phong .2
         phong_size 30
         ambient 0.2
         diffuse 0.8
    }
  }
    translate <0, 3.3, 0>
}

  cone {
    <0, .285, 0>, .6
    <0, -.285, 0>, .5
    texture {
      pigment { color White} }
    translate <0, 3.05, 0>
}

#declare basket=
difference {
union {
superellipsoid { <0.5, 0.5>
   scale <.35, .25, .35> 
    texture {
     pigment { 
      image_map {
        gif "basktex2.gif"
        map_type 1
        interpolate 2
        }
     }
   }
  no_shadow
}
superellipsoid { <0.5, 0.5>
   scale <.365, .05, .365> 
    texture { pigment {color Brown} }
    translate <0, .25, 0>
 }
   translate <0, 2, 0>
  no_shadow
}
superellipsoid { <0.5, 0.5>
   scale <.325, .35, .325> 
    texture { pigment {color DarkBrown}
    }
  translate <0, 2, 0>
  no_shadow
 }
} //end basket

#declare support=
//union {
  box {
    <-1, -1, -1>,
    < 1, 1,  1>
    texture { pigment {color DarkBrown }
     }
    scale <.02, .45, .02>
  }
#declare supports=
object {
   support
    translate <.26, 2.5, 0>
 }
object {
   support
    translate <-.26, 2.5, 0>
 }

#declare barpeople=
union {
sphere {<0, 0, 0> 1
    texture { pigment {color Flesh*.65 }
     }
    scale <.075, .095, .075>
    translate <-.06, 2.5, -.1>
  }
sphere {<0, 0, 0> 1
    texture { pigment {color Red*.5 }
     }
    scale <.155, .2, .075>
    translate <-.06, 2.25, -.1>
  }

sphere {<0, 0, 0> 1
    texture { pigment {color Flesh*.65 }
     }
    scale <.075, .095, .075>
    translate <.07, 2.55, 0>
  }
sphere {<0, 0, 0> 1
    texture { pigment {color Blue*.5 }
     }
    scale <.1, .2, .075>
    translate <.06, 2.3, 0>
  }
}
 //end barpeop..

union {
// object {
//  Balloon1 }
object {
  top }
object {
  bottom }
object {
  basket }
object {
  barpeople }
object {
  supports }
}


union {
// object {
//  Balloon2 }
union {
object {
  top2 }
  cone {
    <0, .285, 0>, .875 
    <0, -.285, 0>, .7
    texture {
     pigment {color Gold}
  finish {
         crand .05
         phong .2
         phong_size 30
         ambient 0.2
         diffuse 0.8
    }
   }
    translate <0, 3.3, 0>
 }
  cone {
    <0, .285, 0>, .6
    <0, -.285, 0>, .5
    texture {
      pigment { color Blue*1.25} }
    translate <0, 3.05, 0>
 }

object {
  basket }
object {
  barpeople }
object {
  supports }
}
 translate <-6.5, 0, 10>
}


union {
// object {
//  Balloon3 }
union {
object {
  top }
  cone {
    <0, .285, 0>, .875 
    <0, -.285, 0>, .7
    texture {
     pigment {color Coral*1.5}
  finish {
         crand .05
         phong .2
         phong_size 30
         ambient 0.2
         diffuse 0.8
    }
   }
    translate <0, 3.3, 0>
 }
  cone {
    <0, .285, 0>, .6
    <0, -.285, 0>, .5
    texture {
      pigment { color Violet} }
    translate <0, 3.05, 0>
 }

object {
  basket }
object {
  barpeople }
object {
  supports }
}
 translate <10.5, -2.5, 20>
}



#declare Mysky = sphere { 
  <0,0,0>,0.98
  texture {
    Apocalypse
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }  
}
difference {
     sphere { <0,0,0>,1}
     object {Mysky}

     scale <3000,500,3000>
     texture {
          Blue_Sky3
          finish {reflection 0.0 diffuse 0.0 ambient 1.0} 
     } 
     translate < 53, 20, 28> 
     no_shadow
}

height_field {
     gif "example2.gif"
       pigment { color rgb <1, .91, .90>*1.5 }
	translate <-.5, -.4, -.5>
        scale <170, 17.5, 170>
    smooth
}

