// ***************************
// *  Future flight Airport  *
// ***************************
// *   by : Dran Draggore    *
// ***************************

#ifndef ( LIGHTS_C )
#declare LIGHTS_C = 0
#end

// **T** **T** **T** **T** **T** **T** **T** **T**
// *
// * TEXTURES

#declare DustCloud =
sphere { 0, 1
  	pigment { color rgbt <1, 1, 1, 1> }
    halo {
      	attenuating
      	spherical_mapping
      	linear
		turbulence 1.2
      	color_map {
        	[ 0 color rgbt <0.5, 0.5, 0.5, 1> ]
        	[ 0.5 color rgbt <1, 1, 1, 0> ]
        	[ 1 color rgbt <0.5, 0.5, 0.5, 1> ]
      	}
		frequency 2
		samples 10
		scale 0.5
    }
    hollow
	scale <48, 12, 48>
}

#declare HalfBlack =
texture {
	pigment { color rgb <0.4, 0.4, 0.4> }
	normal { bumps 0.1 scale 0.2 }
	finish {
		ambient rgb <0.2, 0.2, 0.2>
		phong 1 phong_size 60
		brilliance 0.3
	}
}

#declare QYellow =
texture {
	pigment { color rgb <1, 1, 0> }
	normal { bumps 0.1 scale 0.2 }
	finish {
		ambient rgb <0.3, 0.3, 0>
		phong 1 phong_size 80
		brilliance 0.5
	}
}

#declare RedLight =
union {
	sphere { 0, 4
		pigment { color rgbt <1, 1, 1, 1> }
		halo {
			emitting
			spherical_mapping
			linear
			color_map {
				[0 color rgbt <1, 0, 0, 1> ]
				[0.5 color rgbt <1, 0.5, 0, -1> ]
			}
			samples 10
			scale 0.51
		}
	hollow
	}
	/*
	light_source { <0, 0, 0> color rgb <1, 0.5, 0>
		fade_distance 1
		fade_power 2
	}
	*/
}

#declare TowerBase =
texture {
	pigment { brick color rgb <0.4, 0.4, 0.3>, color rgb <0.7, 0.3, 0>
		mortar 0.4
		scale <2.5, 1.5, 2.5>
	}
	normal { brick normal { bumps 0.3 scale 0.4 }, normal { bumps 0.1 scale 0.1 }
		mortar 0.4
		scale <2.5, 1.5, 2.5>
	}
	finish { phong 0.2 phong_size 10 ambient <0.4, 0.4, 0.4> }
}
#declare TowerMid =
texture {
	pigment { color rgb <0.7, 0.7, 0.7> }
	normal { bumps 0.3 scale 0.2 }
	finish { ambient rgb <0.2, 0.2, 0.2> }
}
#declare TowerGlass =
texture {
	pigment { color rgbf <1, 1, 1, 1> }
	finish { phong 1 phong_size 120
		refraction 1 ior 1.5
		reflection 0.3
	}
}
#declare NoName =
texture {
	pigment { checker color rgb <1, 0, 0>, color rgb <1, 1, 1>
		scale 4
	}
	finish { phong 0.8 phong_size 60 }
}


// **1** **1** **1** **1** **1** **1** **1** **1**
// *
// * OBJECTS : level 1

// *--> landing pad parts
#declare Steps =
union {
	box { <-1, -1, -3>, <2, 10, 3> }
	box { <-1, 1, -3>, <3, 10, 3> }
	box { <-1, 2, -3>, <4, 10, 3> }
	box { <-1, 3, -3>, <7, 10, 3> }
}
#declare StepsAll =
union {
	object { Steps translate <0, 0, 13> }
	object { Steps rotate <0, 90, 0> translate <13, 0, 64> }
	object { Steps rotate <0, 180, 0> translate <64, 0, 51> }
	object { Steps rotate <0, 270, 0> translate <51, 0, 0> }
}
#declare Pad1 =
object {
	difference {
		box { <0, 0, 0>, <64, 4, 64> }
		union {
			box { <-10, -10, -10>, <0, 10, 74> rotate <0, 0, -45> }
			box { <-10, -10, -10>, <0, 10, 74> rotate <0, 0, -45> rotate <0, 90, 0> translate <0, 0, 64> }
			box { <-10, -10, -10>, <0, 10, 74> rotate <0, 0, -45> rotate <0, 180, 0> translate <64, 0, 64> }
			box { <-10, -10, -10>, <0, 10, 74> rotate <0, 0, -45> rotate <0, 270, 0> translate <64, 0, 0> }
			object { StepsAll }
		}
	}
}
#declare Pad2 =
object {
	union {
		difference {
			cylinder { <32, 0, 32>, <32, 4.01, 32>, 22 }
			cylinder { <32, -1, 32>, <32, 10, 32>, 20 }
		}
		difference {
			cylinder { <32, 0, 32>, <32, 4.01, 32>, 26 }
			cylinder { <32, -1, 32>, <32, 10, 32>, 24 }
		}
		box { <0, 0, -2>, <8, 4.01, 2> translate <11, 0, 32> }
		box { <0, 0, -2>, <8, 4.01, 2> rotate <0, 90, 0> translate <32, 0, 53> }
		box { <0, 0, -2>, <8, 4.01, 2> translate <45, 0, 32> }
		box { <0, 0, -2>, <8, 4.01, 2> rotate <0, -90, 0> translate <32, 0, 11> }
		cylinder { <32, 0, 32>, <32, 4.01, 32>, 2 }
	}
}
#declare Pad3 =
object {
	box { <16, -10, 0>, <48, 0.01, -68.1175455> }
	rotate <3.36646, 0, 0>
	translate <0, 0, 128>
}

// *--> airstrip
#declare AirStrip1 =
box { <0, -10, 0>, <768, 0.01, 64> }
#declare AirStrip2 =
union {
	#declare i = 0
	#while (i<24)
		box { <((i*32)+8), -10, -2>, <((i*32)+24), 0.02, 2> }
	#declare i = i+1
	#end
	translate <0, 0, 32>
}

// *--> tower
#declare Tower1 =
difference {
	union {
		cone { <0, 32, 0>, 32, <0, 128, 0>, 24 }
		box { <-32, 0, -32>, <32, 32, 32> }
		difference {
			box { <-32, 0, -32>, <32, 32, 32> }
			union {
				box { <-60, 0, -60>, <0, 60, 60> rotate <0, 0, -45> translate <-32, 0, 0> }
				box { <-60, 0, -60>, <0, 60, 60> rotate <0, 0, -45> rotate <0, 90, 0> translate <0, 0, 32> }
				box { <-60, 0, -60>, <0, 60, 60> rotate <0, 0, -45> rotate <0, 180, 0> translate <32, 0, 0> }
				box { <-60, 0, -60>, <0, 60, 60> rotate <0, 0, -45> rotate <0, 270, 0> translate <0, 0, -32> }
			}
			scale <1, 3, 1> translate <0, 32, 0>
		}
	}
	union {
		box { <-30, 2, -30>, <30, 30, 30> }
		box { <-40, 2, 8>, <40, 20, -8> }
	}
}
#declare Tower2 =
union {
	cone { <0, 128, 0>, 24, <0, 136, 0>, 32 }
	cone { <0, 152, 0>, 32, <0, 160, 0>, 24 }
}


// **2** **2** **2** **2** **2** **2** **2** **2**
// *
// * OBJECTS : level 2 ; with textures

#declare LandingPad =
object {
	union {
		object { Pad1 texture { HalfBlack } }
		object { Pad2 texture { QYellow } }
		object { Pad3 texture { HalfBlack } }
		#if ( LIGHTS_C = 1 )
		object { RedLight translate <56, 4.5, 56> }
		object { RedLight translate <8, 4.5, 56> }
		object { RedLight translate <56, 4.5, 8> }
		object { RedLight translate <8, 4.5, 8> }
		object { RedLight translate <24, 4.5, 24> }
		object { RedLight translate <24, 4.5, 40> }
		object { RedLight translate <40, 4.5, 24> }
		object { RedLight translate <40, 4.5, 40> }
		object { RedLight translate <32, 4.5, 32> }
		#end
		object { DustCloud translate <32, 2, 32> }
	}
}
#declare LandingPad2 =
object {
	union {
		object { Pad1 texture { HalfBlack } }
		object { Pad2 texture { QYellow } }
		object { Pad3 texture { HalfBlack } }
	}
}

#declare Runway =
union {
	object { AirStrip1 texture { HalfBlack } }
	object { AirStrip2 texture { QYellow } }
	#if (LIGHTS_C =1)
	#declare i = 0
	#while (i<12)
		object { RedLight scale 2 translate <((64*i)+32), 0.5, 4> }
		object { RedLight scale 2 translate <((64*i)+32), 0.5, 60> }
	#declare i = i+1
	#end
	#end
}

#declare Tower =
union {
	object { Tower1 texture { TowerBase } }
	object { Tower2 texture { TowerMid } }
	cone { <0, 160, 0>, 2, <0, 208, 0>, 0.25
		texture { NoName scale <10000, 1, 10000> translate <1000, 0, 1000> rotate <0, 0, 45> }
	}
	difference {
		cylinder { <0, 136, 0>, <0, 152, 0>, 30 }
		cylinder { <0, 0, 0>, <0, 200, 0>, 29.5 }
		texture { TowerGlass }
	}
	#declare i = 0
	#while (i<12)
		cylinder { <0, 0, 0>, <0, 16, 0>, 0.5 translate <-30, 136, 0> rotate <0, (i*24), 0>
			texture { QYellow }
		}
	#declare i = i + 1
	#end
	#if (LIGHTS_C = 1)
		object { RedLight scale 5 translate <0, 208.5, 0> }
	#end

}

// **2** **2** **2** **2** **2** **2** **2** **2**
// *
// * OBJECTS : level 2 ; with textures

// *--> Airport
#declare Airport =
union {
	object { Runway translate <0, 0, 128> }
	object { LandingPad2 translate <0, 0, 0> }
	object { LandingPad translate <128, 0, 0> }
	object { LandingPad2 translate <256, 0, 0> }
	object { LandingPad2 translate <384, 0, 0> }
	object { Tower translate <672, 0, 224> }
}
