// balloon.inc:  texture and object definitions for balloon.pov

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapesq.inc"

declare p1 = pigment {
  gradient y
  color_map {
    [0.0 color Red ]
    [0.4 color Red ]
    [0.4 color White ]
    [0.6 color White ]
    [0.6 color Yellow ]
    [1.0 color Yellow ]
  }
  scale <1,1.5,1>
}

declare p2 = pigment {
  image_map {
    gif "b_col1.gif"
    map_type 1
  }
  translate y*0.75
  rotate y*180
}

declare p3 = pigment {
  gradient y
  color_map {
    [0.0 color Blue ]
    [0.3 color Blue ]
    [0.3 color Red ]
    [0.35 color Red ]
    [0.35 color Yellow ]
    [0.45 color Yellow ]
    [0.45 color Red ]
    [0.5 color Red ]
    [0.5 color Yellow ]
    [0.7 color Yellow ]
    [0.7 color Red ]
    [0.75 color Red ]
    [0.75 color Blue ]
    [1.0 color Blue ]
  }
  scale <1,1.5,1>
}

declare p4 = pigment {
  radial
  color_map {
    [0.0 color Red ]
    [0.33333 color Red ]
    [0.33333 color Yellow ]
    [0.66666 color Yellow ]
    [0.66666 color Blue ]
    [1.0 color Blue ]
  }
  frequency 8
}

declare p5 = pigment {
  image_map {
    gif "b_col2.gif"
    map_type 1
  }
  translate y*0.75
}

declare p6 = pigment {
  image_map {
    gif "b_col3.gif"
    map_type 1
  }
  translate y*0.75
}

declare p7 = pigment {
  gradient y
  color_map {
    [0.0 color Turquoise ]
    [0.4 color Turquoise ]
    [0.4 color White ]
    [0.7 color White ]
    [0.7 color Turquoise ]
    [0.9 color Turquoise ]
    [0.9 color White ]
    [1.0 color White ]
      }
  scale <1,1.5,1>
}

declare p8 = pigment {
  image_map {
    gif "b_col4.gif"
    map_type 1
  }
  translate y*0.75
}

declare p9 = pigment {
  image_map {
    gif "b_col5.gif"
    map_type 1
  }
  translate y*0.75
}


declare b_tex = texture {
  pigment { White }
  finish { ambient 0.2 }
  normal {
    radial 0.1
    scallop_wave
    frequency 24
  }
}

declare e_tex = texture {
  pigment { White }
  finish { ambient 0.3 }
}

declare balloon = object {
  Piriform
  sturm
  rotate 90*z
  scale <1,1.5,1>

  bounded_by { box { <-1,0.2,-1>, <1,1.5,1> } }
  clipped_by { bounded_by }
} // end balloon

declare envelope = object {
  Piriform
  sturm
  rotate 90*z
  scale <1,1.5,1>

  bounded_by { box { <-1,0.2,-1>, <0,0.1,1> } }
  clipped_by { bounded_by }
} // end envelope

declare basket = union {
  torus {
    0.09, 0.002
    translate y*0.2
    texture { Aluminum }
  }

  torus {
    0.09, 0.002
    rotate x*90
    scale <1,0.5,1>
    translate y*0.2
    clipped_by { plane {-y,-0.2} }
    texture { Aluminum }
  }

  torus {
    0.09, 0.002
    rotate z*90
    scale <1,0.5,1>
    translate y*0.2
    clipped_by { plane {-y,-0.2} }
    texture { Aluminum }
  }

  cylinder {
    <0,0.2,0>, <0,0.25,0>, 0.04
    texture { Aluminum }
    normal {
      quilted
      scale 0.01
    }
  }

  cylinder {
    <0,0.25,0>, <0,0.29,0>, 0.025
    pigment { Gray10 }
  }

  cone {
    <0,0.26,0>, 0.035,
    <0,0.3,0>, 0.03
    open
    clipped_by { plane { x, -0.01 }}
    texture { Brass_Valley scale 0.02 }
  }

  cone {
    <0,0.26,0>, 0.035,
    <0,0.3,0>, 0.03
    open
    clipped_by { plane { -x, -0.01 }}
    texture { Brass_Valley scale 0.02 }
  }

  cylinder {
    <0,0.2,-0.09>, <0,0,-0.2>, 0.006
    pigment { Gray30 }
  }
  cylinder {
    <0,0.2,-0.09>, <0,0,-0.2>, 0.006
    pigment { Gray30 }
    rotate y*90
  }
  cylinder {
    <0,0.2,-0.09>, <0,0,-0.2>, 0.006
    pigment { Gray30 }
    rotate y*180
  }
  cylinder {
    <0,0.2,-0.09>, <0,0,-0.2>, 0.006
    pigment { Gray30 }
    rotate y*270
  }

  difference {
    superellipsoid { <0.25, 0.25> }
    superellipsoid { <0.25, 0.25> scale 0.9 translate y*0.2 }
    rotate y*45
    bounded_by { plane { y, 0 } }
    clipped_by {bounded_by}
    scale <0.16, 0.3, 0.16>
    pigment { color LightWood }
    finish { ambient 0.2 }
    normal {
      quilted
      scale 0.04
    }
  }
  rotate y*45
  scale 0.4
} // end basket




