
// Persistence of Vision Ray Tracer Scene Description File
// File: test.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3


#include "colors.inc"
#include "stones.inc"
#include "balloon.inc"

#declare r1=seed(0)

global_settings
{
  assumed_gamma 1.2
}

// ----------------------------------------
camera
{
  location  <0,0,0>
  direction z*1.8
  right     4/3*x
  look_at   <0, 5, 10>

}


sky_sphere  {
  pigment {
    gradient y
    color_map { [0.0 color rgb <1,1,1> ]
                [0.4 color rgb <0.8, 0.3, 0.3> ]
                [0.5 color rgb <1, 0.6, 0.6> ]
                [0.6 color rgb <0.6, 0.5, 0.6> ]
                [1.0 color rgb <0.2, 0.2, 0.6> ] }
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 0.1 color rgb <0.9, 0.85, 0.85>
               color rgb <0.8, 0.75, 0.75>*0.7]
      [0.1 0.5 color rgb <0.8, 0.75, 0.75>*0.7
               color rgbt <1, 1, 1, 1>]
      [0.5 1.0 color rgbt <1, 1, 1, 1>
               color rgbt <1, 1, 1, 1>]
    }
    scale <1, 0.2, 1>
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 0.9  blue 0.8  // light's color
  translate <300, 100, -100>*200
}

light_source
{
  <1,0,-1>*200
  color 0.5
}

light_source
{
  <-10,10,-10>*200
  color 0.1
}
// ----------------------------------------


// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field
{
  pot               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "test.pot"     // the file name to read
  texture { T_Stone8 scale <0.01 0.05 0.01>*0.1 }
  texture { pigment { 
      gradient y
      color_map {
        [ 0.7 0.72 rgbt <1,1,1,1>
                    color White*3 ]
      }
      scale <1,1.1,1>
      turbulence 0.1
    }
  }
  smooth
  translate <-0.5, -0.1, -0.5>
  rotate y*60
  scale <100,20,100>*2000
}


// fill in with balloons!
union {
  object { balloon
    texture { b_tex pigment {p1} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p1} }
  }
  object { basket }
  translate <-13,18,35>
  rotate y*rand(r1)*360
}

union {
  object { balloon
    rotate y*rand(r1)*360
    texture { b_tex pigment {p2} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p2} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <-10,26,40>
}
union {
  object { balloon
    texture { b_tex pigment {p3} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p3} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <-8,24,45>
}
union {
  object { balloon
    texture { b_tex pigment {p4} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p4} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <5,18,22>
}
union {
  object { balloon
    rotate y*rand(r1)*360
    texture { b_tex pigment {p5} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p5} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <2,8,22>
}
union {
  object { balloon
    rotate y*rand(r1)*360
    texture { b_tex pigment {p6} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p6} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <4,8,12>
}
union {
  object { balloon
    texture { b_tex
      pigment {p7}
      finish { specular 0.4 roughness 0.2 }
      normal { radial 0.2 scallop_wave frequency 12 }
    }
  }
  object { envelope
    texture { e_tex pigment {p7} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <-4,8,11>
}
union {
  object { balloon
    texture { b_tex pigment {p8} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p8} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <-1.5,0.7,5>
}
union {
  object { balloon
    texture { b_tex pigment {p2} finish { specular 0.4 roughness 0.2 } }
  }
  object { envelope
    texture { e_tex pigment {p5} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <-0.1,1.8,7>
}
union {
  object { balloon
    texture { b_tex
      pigment {p3}
      finish { specular 0.4 roughness 0.2 }
      normal { radial 0.2 scallop_wave frequency 12 }
    }
  }
  object { envelope
    texture { e_tex pigment {p4} }
  }
  object { basket }
  rotate y*rand(r1)*360
  translate <1.5,3,7>
}
