#include "colors.inc"
#include "textures.inc"
#include "glider1.inc"
#include "glider2.inc"
#include "dolphin.inc"
#include "pinetree.inc"

camera {
  location <0, 40, 55>
  look_at <0, 15, 0>
}

light_source { <-10000, 100000, 100000>  color White }

default { finish { diffuse 1 ambient 0.1 } }

#declare Moon_Surface = texture {
  pigment {
   bozo
   turbulence 0.2
   color_map {
      [0.000, 0.171   color rgbf <0.725, 0.659, 0.455, 0.000>
                      color rgbf <0.682, 0.549, 0.420, 0.000>]
      [0.171, 0.274   color rgbf <0.682, 0.549, 0.420, 0.000>
                      color rgbf <0.557, 0.451, 0.322, 0.000>]
      [0.274, 0.393   color rgbf <0.557, 0.451, 0.322, 0.000>
                      color rgbf <0.725, 0.659, 0.455, 0.000>]
      [0.393, 0.564   color rgbf <0.725, 0.659, 0.455, 0.000>
                      color rgbf <0.682, 0.549, 0.420, 0.000>]
      [0.564, 0.701   color rgbf <0.682, 0.549, 0.420, 0.000>
                      color rgbf <0.482, 0.392, 0.278, 0.000>]
      [0.701, 1       color rgbf <0.482, 0.392, 0.278, 0.000>
                      color rgbf <0.725, 0.659, 0.455, 0.000>]
   }
   scale <0.2, 0.2, 1>
   scale 2
 }
}
// Sandalwood layer 2
texture {
 pigment {
   bozo
   turbulence 0.8
   color_map {
      [0.000, 0.087   color rgbf <0.682, 0.604, 0.380, 1.000>
                      color rgbf <0.761, 0.694, 0.600, 0.020>]
      [0.087, 0.226   color rgbf <0.761, 0.694, 0.600, 0.020>
                      color rgbf <0.635, 0.553, 0.325, 1.000>]
      [0.226, 0.348   color rgbf <0.635, 0.553, 0.325, 1.000>
                      color rgbf <0.761, 0.694, 0.600, 0.020>]
      [0.348, 0.496   color rgbf <0.761, 0.694, 0.600, 0.020>
                      color rgbf <0.682, 0.604, 0.380, 1.000>]
      [0.496, 0.565   color rgbf <0.682, 0.604, 0.380, 1.000>
                      color rgbf <0.761, 0.694, 0.600, 0.020>]
      [0.565, 0.661   color rgbf <0.761, 0.694, 0.600, 0.020>
                      color rgbf <0.682, 0.604, 0.380, 1.000>]
      [0.661, 0.835   color rgbf <0.682, 0.604, 0.380, 1.000>
                      color rgbf <0.761, 0.694, 0.600, 0.020>]
      [0.835, 1       color rgbf <0.761, 0.694, 0.600, 0.020>
                      color rgbf <0.682, 0.604, 0.380, 1.000>]
   }
   scale 0.2
   scale 2
 }
}

/*
#declare Moon_surface = texture {
  pigment {
    leopard
    turbulence 0.2
    color_map {
      [0.0 color red 0.05 green 0.05 blue 0.05]
      [0.5 color red 0.25 green 0.25 blue 0.25]
      [0.8 color red 0.50 green 0.55 blue 0.55]
      [0.9 color red 0.75 green 0.75 blue 0.75]
      [1.01 color red 1.0 green 1.0  blue 1.0]
    }
    scale 5
  }
  finish {
      specular 0.5 
      roughness 0.15
  }
  normal {
      dents 5
      scale <1, 0.5, 0.5>
  }
}
*/

#declare Moon_texture = texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.000 color rgbf <0.784, 0.627, 0.522, 0.000>]
      [0.053 color rgbf <0.784, 0.627, 0.624, 0.000>]
      [0.263 color rgbf <0.824, 0.557, 0.376, 0.000>]
      [0.281 color rgbf <0.643, 0.380, 0.376, 0.000>]
      [0.425 color rgbf <0.839, 0.722, 0.722, 0.000>]
      [0.711 color rgbf <0.784, 0.627, 0.522, 0.000>]
      [0.798 color rgbf <0.769, 0.380, 0.376, 0.000>]
      [0.895 color rgbf <0.824, 0.557, 0.376, 0.000>]
      [0.982 color rgbf <0.784, 0.627, 0.522, 0.000>]
      [1.001 color rgbf <0.784, 0.627, 0.522, 0.000>]
    }
  scale <1, 1, 2> 
  rotate <40, 0, 0> 
  rotate <0, 0, 30>
  }
}
texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0.000 color rgbf <0.784, 0.627, 0.522, 0.500>]
      [0.053 color rgbf <0.784, 0.627, 0.624, 0.500>]
      [0.263 color rgbf <0.824, 0.557, 0.376, 0.500>]
      [0.281 color rgbf <0.643, 0.380, 0.376, 0.500>]
      [0.325 color rgbf <0.839, 0.722, 0.722, 0.500>]
      [0.711 color rgbf <0.784, 0.627, 0.522, 0.500>]
      [0.798 color rgbf <0.769, 0.380, 0.376, 0.500>]
      [0.895 color rgbf <0.824, 0.557, 0.376, 0.500>]
      [0.982 color rgbf <0.784, 0.627, 0.522, 0.500>]
      [1.001 color rgbf <0.784, 0.627, 0.522, 0.500>]
    }
  scale <2, 1, 2> 
  rotate <40, 0, 0> 
  rotate <0, 0, 30>
  }
}
texture { 
  pigment {
    marble
    turbulence 0.85
    color_map {
      [0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
      [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
      [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
    }
    scale <1, 2, 1.5> 
    rotate <0, 0, 40>
  }
}
texture {
  pigment { color Yellow filter 0.9 }
    finish {
      phong 1.0 
      phong_size 90
    }  // tint to liking
}

#declare Mountains = texture {
  pigment {
    bozo
    turbulence 0.5
    color_map {
      [0.00 color rgb <0.79, 0.71, 0.66>]
      [0.29 color rgb <0.83, 0.69, 0.62>]
      [0.31 color rgb <0.76, 0.66, 0.61>]
      [0.43 color rgb <0.88, 0.76, 0.73>]
      [0.64 color rgb <0.70, 0.60, 0.55>]
      [0.69 color rgb <0.87, 0.71, 0.66>]
      [1.01 color rgb <0.79, 0.71, 0.66>]
    }
  }
  normal {
    bumps 5 
    //scale <1, 0.2, 1>
  }
}

#declare Mountains2 = texture {
  pigment {
    marble
    turbulence 0.8
    color_map { 
      [0.00 color rgbf <0.79, 0.71, 0.66, 0.5>]
      [0.20 color rgbf <0.53, 0.39, 0.32, 0.5>]
      [0.40 color rgbf <0.76, 0.66, 0.61, 0.5>]
      [0.60 color rgbf <0.88, 0.76, 0.73, 0.5>]
      [0.80 color rgbf <0.50, 0.40, 0.25, 0.5>]
      [1.01 color rgbf <0.79, 0.71, 0.66, 0.5>]
    }
  }
  finish {ambient 0.02}
  normal {wrinkles 0.9}
  //scale <0.1,0.5,0.5>
  rotate <0,0,90>
}

//land form
height_field {
  gif "c:\povray3\include\isle.gif"
  smooth        
  texture { Moon_texture 
    scale .1
  }
  translate <-.5, -.5, -.5>
  scale <100, 75, 100>
  translate <-35, 2, -20>
}

//water
sphere { <0, 0, 0>, 4000
  translate <0, -4000, 0>
  pigment { Turquoise }
  normal { ripples 0.5
    scale 3
    turbulence .4
    translate <10, 0, -30>
  }
}

object {Glider1
  rotate <0, 125, 0>
  scale 0.7
  translate <-40, 35, -45>
}

object {Glider1
  rotate <0, 305, 0>
  scale 0.4
  translate <0, 15, 15>
}

object {Glider2
  rotate <0, -215, 0>
  scale 0.5
  translate <10, 30, 10>
}

object {Glider2
  rotate <55, 45, 0>
  scale 0.5
  translate <70, 30, -100>
}

height_field {
  pot "c:\povray3\include\terrain3.pot"
  smooth        
  texture { Mountains2 }
  translate <-.5, -.5, -.5>
  scale <450, 15, 450>
}

/*
//planet
difference {
  sphere { <-1500, 100, -10000>, 1000  //was <2000, ...
    texture { Moon_texture 
      normal {
        wrinkles 1
        scale 5000
      }
      scale 1000
    }
  }
  // crater right in the middle
  sphere { <-1500, 100, -10000>, 500
    texture { Moon_texture 
      normal {
        wrinkles 1
        scale 5000
      }
      scale 500
    }
    scale <1, 1, .5>
    translate <0, 0, 1000>
  }
}
*/

//background
plane { z, -20000
  pigment {
    image_map {
      tga "c:\povray3\include\galaxy.tga"
    }
    scale 18000
    translate <-5000, 5100, 0>
  }
}

object { Dolphin2
  texture {Bronze_Metal}
  scale 4
  translate <25, 10, -40>
  rotate <0, 35, -50>
}

object { Pinetree
  texture { Gold_Metal }
  scale .015
  translate <-20, 0, 0>
}

object { Pinetree
  texture { Gold_Metal }
  scale <.015, .02, .015>
  translate <-30, 0, 0>
}

object { Pinetree
  texture { Gold_Metal }
  scale <.02, .015, .02>
  translate <30, 0, 0>
}

object { Pinetree
  texture { Gold_Metal }
  scale .01
  translate <20, 0, -40>
}

object { Pinetree
  texture { Gold_Metal }
  scale .01
  translate <40, 0, -70>
}

object { Pinetree
  texture { Gold_Metal }
  scale .006
  translate <30, 0, -80>
}

//clouds using height_field
height_field {
  gif "clouds2.gif"
  smooth
  translate <-.5, 0, -.5>
  texture {
    pigment {
      gradient y
      color_map {
        [0 color rgbf <1, 1, 1, 1>]
        [.6 color rgbf <1, 1, 1, 1>]
        [.75 color rgbf <1, 1, 1, 0>]
      }
    }
    finish {
      ambient .2
      diffuse .8
    }
    normal {
      bumps 1
      scale .2
    }
  }
  scale <400, 4, 100>
  translate <0, 3, -150>
}

//Moon
sphere { <-1500, 80, -10000>, 1500
  texture { Moon_Surface 
    scale 2500
    rotate <0, -45, 0>
  }
}

