// genwin.cpp
//
// Used to generate random windows for the Bespin scene
//
// Written by: Henry Wagner (henryw@panix.com)
// Started: 12/15/1996

#include <stdio.h>
#include <stdlib.h>

void main (int argc, char *argv[])
{
   FILE *o;
   int nWindows, radius, c;

   if (argc < 5) {
      printf( "\nERROR: You must pass in the output filename, the name of the window object, the number of windows, and the radius\n");
      printf( "FORMAT: genwin filename.inc objname nwindows radius\n" );
      exit(0);
   }
   else {
      o = fopen(argv[1], "w");
      nWindows = atoi(argv[3]);
      radius = atoi(argv[4]);

      randomize();

      fprintf(o, "// %s\n", argv[1]);
      fprintf(o, "//\n" );
      fprintf(o, "// Generated by: Henry Wagner (henryw@panix.com)\n\n" );

      fprintf(o, "#declare %s = union {\n", argv[2] );
      for (c = 0; c < nWindows; c++) {
	 fprintf(o, "   box {\n" );
	 fprintf(o, "      < -4, -5, %d >,\n", radius - 10 );
	 fprintf(o, "      <  4,  5, %d >\n",  radius + 10 );
	 fprintf(o, "      rotate < 0, %.1f, 0 >\n", (float) random(3600)/10.0);
	 fprintf(o, "   }\n" );
      }

      fprintf(o, "}\n" );

      fclose(o);
   }
}