
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"

#include "Sandy.inc"
#include "Coin.pov"

#declare Environment = on
#declare Impact = on
#declare Grass = on
#declare Marbles = on

camera {
	location <0,.5,-2>
	look_at  <0,.25,0>
#if (Environment = on)
	aperture .025
	blur_samples 100
#end
}

light_source {<100,100,-100> color White}

plane{ y, 0
	texture{Sandy scale .25}
	normal{bumps .75 scale .02}
	#if (Environment = on)
		finish{phong .5 crand .5 ambient .3 diffuse .7}
	#end
}

sky_sphere {S_Cloud1}

#if (Marbles = on)
	#include "marbles.pov"
#else
	#declare Marble_large1 = sphere {<0,0,0>,.2 pigment{Red}}
	#declare Marble_large2 = sphere {<0,0,0>,.2 pigment{Yellow}}
	#declare Marble_small1 = sphere {<0,0,0>,.15 pigment{Green}}
	#declare Marble_small2 = sphere {<0,0,0>,.15 pigment{Blue}}
#end

object {Marble_large1 rotate<10,13,5> translate<0,.2,-1>}

object {Marble_small2 rotate<30,10,13> translate<.8,.15,0>}
object {Marble_large1 rotate<0,13,130> translate<1,.2,-.5>}
object {Marble_small1 rotate<88,120,25> translate<-.5,.15,-.5>}
object {Marble_large2 rotate<120,93,99> translate<-.95,.2,0>}
object {Marble_large1 rotate<15,73,127> translate<-.3,.2,0>}
object {Marble_large2 rotate<177,55,12> translate<.5,.2,-.2>}
object {Marble_large1 rotate<99,40,0> translate<-.6,.2,-1.1>}

object {Marble_small1 rotate<10,40,50> translate<.2,.9,.1>}
object {Coin scale .75 rotate<0,135,0> translate<.5,-.015,-1.1>}

#if (Grass = on)

#declare Blade1 =
cone {<0,0,0>,.05<0,1.5,0>,0 pigment{Green}finish{phong 1}}

#declare Blade2 =
cone {<0,0,0>,.03<0,1.1,0>,0 pigment{DarkGreen}finish{phong 1}}

#declare Blade3 =
cone {<0,0,0>,.03<0,.8,0>,0 pigment{DarkOliveGreen}finish{phong 1}}

#declare Blade4 =
cone {<0,0,0>,.02<0,.5,0>,0 pigment{LimeGreen}finish{phong 1}}

#declare Flower_head =
union {
	sphere {<0,0,0>,.1 scale<1,.5,1> pigment{Yellow} normal{bumps .5 scale .01} finish{phong 1}}
	#declare Count = 0
	#while (Count < 13)
		sphere {<0,0,0>,.05 scale <4,.1,1>
			pigment{White}
			normal{ripples 1 scale <1,.05,.05>}
			finish{phong 1}
			translate <-.2,0,0> rotate <0,((360 / 13) * Count),0>}
		#declare Count = Count + 1
	#end
}

#declare Flower1 =
union {
	cylinder {<0,0,0><0,1.4,0>,.03 pigment{Green}}
	object {Flower_head rotate<-55,0,0> translate<0,1.4,0>}
}

object {Flower1 translate<0,0,1>}

#declare Count = 1
#declare Blades = 300
#declare R1 = seed(13)

#while (Count < Blades)
	object {Blade1 translate <
		(rand(R1) * 10),
		0,
		((rand(R1) * 10) + 1)
	>}
	object {Blade1 translate <
		(rand(R1) * -10),
		0,
		((rand(R1) * 10) + 1)
	>}

	object {Blade2 translate <
		(rand(R1) * 10),
		0,
		((rand(R1) * 10) + 1)
	>}
	object {Blade2 translate <
		(rand(R1) * -10),
		0,
		((rand(R1) * 10) + 1)
	>}

	object {Blade3 translate <
		(rand(R1) * 8),
		0,
		((rand(R1) * 8) + .8)
	>}
	object {Blade3 translate <
		(rand(R1) * -8),
		0,
		((rand(R1) * 8) + .8)
	>}

	object {Blade4 translate <
		(rand(R1) * 5),
		0,
		((rand(R1) * 5) + .75)
	>}
	object {Blade4 translate <
		(rand(R1) * -5),
		0,
		((rand(R1) * 5) + .75)
	>}

	#declare Count = Count + 1
#end

#declare Count = 1
#declare Flowers = 20
#declare R2 = seed(15)

#while (Count < Flowers)
	object {Flower1 rotate <0,(-20 * rand(R2)),0>
		translate <
		(rand(R2) * -5),
		0,
		((rand(R2) * 12) + 1)
	>}
	object {Flower1 rotate <0,(20 * rand(R2)),0>
		translate <
		(rand(R2) * 5),
		0,
		((rand(R2) * 12) + 1)
	>}
	#declare Count = Count + 1
#end

#end

#if (Impact = on)

#declare Count = 1
#declare Dirt = 1000
#declare R3 = seed(103)

#declare Splat =
union {
#while (Count < Dirt)
	sphere {<0,0,0>,(rand(R3) * 0.005)
	translate <(rand(R3) * .5),0,(rand(R3) * .4)>
	rotate <((rand(R3) * -10) - 5),0,0>
	translate <0,0,.02>
	texture{Sandy scale .25}
	}
	sphere {<0,0,0>,(rand(R3) * 0.005)
	translate <(rand(R3) * .5),0,(rand(R3) * .15)>
	rotate <((rand(R3) * -10) - 6),0,0>
	translate <0,0,.02>
	texture{Sandy scale .25}
	}
	#declare Count = (Count + 1)
#end
}

#declare Count = 1
#declare Dirt = 1000
#declare R4 = seed(333)

#declare Splat2 =
union {
#while (Count < Dirt)
	sphere {<0,0,0>,(rand(R4) * 0.005)
	translate <(rand(R3) * .5),0,(rand(R4) * -.4)>
	rotate <((rand(R4) * 10) + 5),0,0>
	translate <0,0,-.02>
	texture{Sandy scale .25}
	}
	sphere {<0,0,0>,(rand(R4) * 0.005)
	translate <(rand(R3) * .5),0,(rand(R4) * -.15)>
	rotate <((rand(R4) * 10) + 6),0,0>
	translate <0,0,-.02>
	texture{Sandy scale .25}
	}
	#declare Count = (Count + 1)
#end
}

object {Splat rotate <0,105,0> translate <0,0,-1>}
object {Splat2 rotate <0,105,0> translate <0,0,-1>}

#declare Furrow =
union {
	difference {
		union {
			difference {
				cylinder {<0,0,0><0,.1,0>,.07}
				cylinder {<0,-1,0><0,1,0>,.03}
				torus {.03,.01 sturm}
				torus {.07,.01 sturm}
			}
			torus {.05,.01 sturm}
		}
		box {<0,-1,1><1,1,-1>}
	}
	difference {
		box {<0,0,.07><1,.01,.03>}
		cylinder {<-1,.01,.07><2,.01,.07>,.01}
		cylinder {<-1,.01,.03><2,.01,.03>,.01}
	}
	difference {
		box {<0,0,-.07><1,.01,-.03>}
		cylinder {<-1,.01,-.07><2,.01,-.07>,.01}
		cylinder {<-1,.01,-.03><2,.01,-.03>,.01}
	}
	cylinder {<0,.01,.05><1,.01,.05>,.01}
	cylinder {<0,.01,-.05><1,.01,-.05>,.01}
}

object {Furrow rotate <0,105,0> translate <0,0,-1>
	texture{Sandy scale .25}
	normal{bumps 1 scale .01}
	#if (Environment = on)
		finish{phong .5 crand .5 ambient .3 diffuse .7}
	#end
}

#end

#include "Ant.pov"

object {Ant rotate <0,135,0> scale .01 translate <.55,.04,-1.1>}
object {Ant rotate <0,-60,0> scale .01 translate <-.3,.02,-1.1>}
object {Ant rotate <0,20,0> scale .01 translate <.55,.02,-.8>}

object {Ant_flat rotate <0,-80,0> scale .01 translate <-.06,0,-1.1>}
object {Ant_scared rotate <0,-10,0> scale .01 translate <.25,.02,-1.07>}
