// GlassBlock
// (c) Copyright 1997 J. Alan Langford
//
// This is a working file to develop an architectural glass block.
//
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

light_source { <5, 0, 50> color 5*White }
light_source { <2.25, 2.25, -10> color White }


camera
{
  location  <2.25, 2.25, -10>
  look_at   <2.25, 2.25, 0.00>
}

plane { y, 0
   pigment {
      checker colour RichBlue colour Green
      scale 10
   }
   finish {
      ambient 0.2
      diffuse 0.8
   }
   translate y*-10
   rotate <-10, 0, 0>
}

// Unit length (z) cube for chamfering/filleting unit corners
#declare Trim1_00 = object {
    difference {
        box { <-0.01, -0.01, 0.00> <1.00, 1.00, 1.00> }
        cylinder { <1.00, 1.00, -0.01> <1.00, 1.00, 1.01> 1.00 }
    }
}

#declare F_GlassBlock =
finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    refraction 1
    reflection 0.1
    ior 1.45
}

#declare T_GlassBlock =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.997> }
    finish { F_GlassBlock }
}

#declare BaseBlock = object {
    difference {
        box { <0.00, 0.00, 0.00> <5.50, 5.50, 1.25> }
        union {
            // Slice off a 0.25 deep outer jacket behind the front face
            box { <-0.01, -0.01, 0.75> <0.25, 5.51, 1.26> }
            box { < 5.25, -0.01, 0.75> <5.51, 5.51, 1.26> }
            box { <-0.01, -0.01, 0.75> <5.51, 0.25, 1.26> }
            box { <-0.01,  5.25, 0.75> <5.51, 5.51, 1.26> }
            // Fillets from behind the front face to the rear extrusion
            cylinder { <-0.01, 0.00, 0.75> <5.51, 0.00, 0.75> 0.25 }
            cylinder { <-0.01, 5.50, 0.75> <5.51, 5.50, 0.75> 0.25 }
            cylinder { <0.00, -0.01, 0.75> <0.00, 5.51, 0.75> 0.25 }
            cylinder { <5.50, -0.01, 0.75> <5.50, 5.51, 0.75> 0.25 }
            // Hollow out the inside
            box { <0.5, 0.5, 0.5> <5.00, 5.00, 1.26> }
        }
    }
}

#declare Waves = object {
    // Wavy section on the inside of a block
    intersection {
        box { <0.49, 0.49, 0.49> <5.01, 5.01, 1.0> }
        blob {
            threshold 0.45
            cylinder { <-3, -1, 0.0>, <-1, 6, -0.75>, 1.5, 1 }
            cylinder { <-2, -1, -0.5>, < 0, 6, 0.00>, 1.5, 1 }
            cylinder { <-1, -1, 0.0>, < 1, 6, -0.75>, 1.5, 1 }
            cylinder { <-0, -1, -0.5>, < 2, 6, 0.00>, 1.5, 1 }
            cylinder { < 1, -1, 0.0>, < 3, 6, -0.75>, 1.5, 1 }
            cylinder { < 2, -1, -0.5>, < 4, 6, 0.00>, 1.5, 1 }
            cylinder { < 3, -1, 0.0>, < 5, 6, -0.50>, 1.5, 1 }
            cylinder { < 4, -1, -0.5>, < 6, 6, 0.00>, 1.5, 1 }
            cylinder { < 5, -1, 0.0>, < 7, 6, -0.50>, 1.5, 1 }
            cylinder { < 6,  2, -1.0>, <-1, 5, -0.25>, 1.5, 1 }
        }
    }
    //scale <1, 1, 0.5>
}

#declare BlockCement = object {
    difference {
        box { <0.25, 0.25, 1.24> <5.25, 5.25, 1.51> }
        box { <0.50, 0.50, 1.23> <5.00, 5.00, 1.52> }
    }
    pigment { colour <0.98, 0.98, 0.95> }
}

#declare GlassFace2 = object {
    union {
        object { BaseBlock }
        object { Waves }
    }
}

#declare GlassBlock1 = union {
    object { BaseBlock texture { T_GlassBlock } }
    object { BaseBlock texture { T_GlassBlock } rotate 180*x translate <0, 5.5, 2.75> }
    object { BlockCement }

}

#declare GlassBlock2 = union {
    object { GlassFace2 texture { T_GlassBlock } }
    object { GlassFace2 texture { T_GlassBlock } rotate 180*x translate <0, 5.5, 2.75> }
    object { BlockCement }
}


background { colour Gray50 }


object {
    GlassBlock2
    rotate 45*y
    translate <4.5, 0, 5>
}

object {
    GlassBlock2
    rotate -90*y
    translate <4, 2, 5>
}

object {
    GlassBlock2
    rotate 135*y
    translate <-1, 0, 5>
}
