/******************************************************************
*********************** Try 486DX2 on this ************************
******************************************************************/

#include "colors.inc"
#include "glass.inc"
#include "textures.inc"
#include "skies.inc"
#include "woods.inc"
#include "metals.inc"
#include "stones.inc"
#include "ttex.inc"	// POVTextureEditor file

#include "ship.inc"

/****** Overall effects ******/

global_settings { 
 max_trace_level 15 
 adc_bailout 5/255
 assumed_gamma 2.2
 radiosity {
  brightness 0.3
  count 600
  distance_maximum 15
  error_bound 0.35
  gray_threshold 0.4
  low_error_factor 0.6
  minimum_reuse 6
  nearest_count 8
  recursion_limit 1 
 }
}

/******** Use 1 in final render ********/

#declare Cam = 1
#declare LIGHT = 1
#declare FOG = 1
#declare SKY = 1
#declare GLASS = 1
#declare TREE = 1
#declare STUFF = 1

#if (LIGHT = 1)
 #debug "\nArea lights on\n"
#else #debug "\nArea lights off\n"
#end
#if (FOG = 1)
 #debug "Fog on\n"
#else #debug "Fog off\n"
#end
#if (SKY = 1)
 #debug "Sky on\n"
#else #debug "Sky off\n"
#end
#if (GLASS = 1)
 #debug "Glass on\n"
#else #debug "Glass off\n"
#end
#if (TREE = 1)
 #debug "Trees on\n"
#else #debug "No trees\n"
#end
#if (STUFF = 1)
 #debug "Objects visible\n"
#else #debug "Fast mode on\n"
#end

/*********** Different angles ***********/

#if (Cam=1)
camera { location <2,27,-7> look_at <-10,21,-10.5> }
#end
#if (Cam=2)
camera { location <-15,20,-30> look_at <-10,20,0> }
#end
#if (Cam=3)
camera { location <4,14.5,-11> look_at <-10,14.5,-11> }
#end
#if (Cam=4)
camera { location <0,45,-20> look_at <0,0,-20> }
#end
#if (Cam=5)
camera { location <-12,19,-20> look_at <-15,15,-20> }
#end

/******* With or without area lights *******/

#if (LIGHT = 1)

 light_source {
  <0,35,-18> 
  White
  area_light <3,0,0>,<0,3,0>,6,6
  adaptive 1
  jitter
 } 

 light_source {
  <10,20,-3> 
  White
  shadowless 
  fade_distance 20
  fade_power 1
 }
#else
 light_source { <0,36,-17> White }
 light_source { <10,20,-3> White shadowless fade_distance 20 fade_power 1 }
#end

/****** Basic sky ******/

#if (SKY = 1)
 sky_sphere { S_Cloud3 }
#end

/****** Fog *******/

#if (FOG = 1)
 fog {
  fog_type 1
  distance 150
  color rgbft<0.5,0.5,0.8,0.02,0.8>
 }
#end

/******* Fill the gaps between the trees (if any) *******/

plane { y,0
 pigment { rgb<0.6,1,0.6> }
 rotate z*5
}

/******* The jungle outside *******/

#if (TREE = 1)
 #include "tree1.inc"
 object { Tree scale 1.7 translate <-63,0,-45>}
 object { Tree scale 1.7 rotate y*-50 translate <-60,0,-65> }
 object { Tree scale 1.7 rotate y*20 translate <-70,0,-60> }
#end

/******* A perfect mirror ********/

#declare Mirror_finish =
 finish { ambient 0 diffuse 0 reflection 1 }

/************* Declaring a bottle ***********/

#declare Outer =		// Bottle shape
union {
 blob {
  threshold 0.1
  cylinder { <0,-2,0>,<0,0,0>,1,0.5 }
  cylinder { <0,1,0>,<0,1.4,0>,0.4,0.3 }
  sphere { <0,0.3,0>,0.8,0.5 }
  sphere { <0,0.8,0>,0.4,0.5 }
  component -0.5,0.8,<0,-2.7,0>
 }  // blob
 superellipsoid { <0.1,1> 
  texture { T_Wood35 }
  scale .3 translate <0,1.7,0>
 }  // sellipsoid
}   // union

#declare Bottle =		// Cut out the inner part
difference {
 object { Outer } 
 object { Outer scale <0.93,0.97,0.93> }
 rotate z*90
}

#declare Restp1 =		
difference {
 cone { <0,0,0>,7,<0,-11,0>,12 }
 box { <0.8,20,20>,<20,-20,-20> }
 box { <-0.8,20,20>,<-20,-20,-20> }
}
   
#declare Plate_end =		// Part of the golden plate 
difference {
 sphere { <0,0,0>,1 }
 box { <-3,-3,-3>,<3,3,-0.55> }
 box { <3,3,3>,<-3,-3,0> }
}

#declare Bottle_rest =		// Bottle rack
difference {
 union {
  object { Restp1 }
  object { Restp1 translate <17,0,0> }
  box { <0,0,-0.5>,<17,3,0.5> rotate x*25 translate <0,-11.3,-11.6> }
  box { <0,0,-0.5>,<17,3,0.5> rotate x*-25 translate <0,-11.3,11.6> }
  union {
   box { <2,0.5,-0.55>,<15,2.5,0> }
   object { Plate_end translate <2,1.5,0> }
   object { Plate_end translate <15,1.5,0> }
   texture { 
    pigment { BrightGold }
    finish { 
     metallic
     phong 0.8
     phong_size 80
     brilliance 4
     ambient 0.2
     diffuse 0.7
     reflection 0.1
    }
   }
   rotate x*25 translate <0,-11.3,-11.6>
  }  // union
 }   // union
 object { Outer rotate z*90 scale 10 }
}    // difference


#declare Dude_in_bottle =
union {
 #if (GLASS = 1)
  #include "dude.inc"		// Human declarations
  #include "collect.inc"	// See human.pov for details
  object { human scale .4 rotate z*80 translate <19.5,-2.3,1.8> }
  object { Bottle 
   texture { 
    pigment { rgbf<1,1,1,0.8> }
    finish { 
     ambient 0
     diffuse 0
     reflection 0.15
     refraction 1
     ior 1.5
     caustics 0.2
     specular 0.05
    }   // finish
   }    // texture
   scale 10 
  }     // object
  box { <6,-0.5,-4.6>,<12,3.2,-4.7> 
   pigment { 
    image_map { gif "help.gif" }	// "Help"
    scale 6 translate <0,-2,0> 
   }   // pigment
  }    // box
 #end
 object { Bottle_rest pigment { DMFWood2 } }
 scale .4
 rotate y*-80
}    // union


#declare Ship_in_bottle =
union {
 #if (GLASS = 1)
  object { 
   Bottle
   texture { 
    pigment { rgbf <0.9,0.9,1,0.95> }
    finish { F_Glass1 caustics 0.1 }
   }  // texture 
   scale 10
  }   // object
  object { Ship scale 0.35 rotate y*90 translate <10,-2,0> }
 #end  // End of GLASS
 object { Bottle_rest pigment { DMFWood1 } }
 scale 0.15
 rotate y*90
}   // union

#declare Wallpaper =
pigment {
 image_map {
  tga "wallpaper.tga"		// See wallpaper.pov
 }
 scale 5
}

/************** Room **************/

difference {
 union {
  box { <-33,0,3>,<33,-3,-100> }
  box { <-33,50,3>,<33,53,-100> }
  box { <-33,0,0>,<33,53,3> pigment { Wallpaper } }
  box { <-30,53,3>,<-33,0,-100> pigment { Wallpaper rotate y*-90 } }
  box { <30,53,3>,<33,0,-100> pigment { Wallpaper rotate y*90 } }
 }
 box { <-10,17,-10>,<10,37,10> }	// Window holes
 box { <-35,17,-45>,<-25,37,-25> }	// Only one visible
 pigment { White }
}

/*********** Windows *********/

#declare Window_frame =
union {
 cylinder { <-10,-10,0>,<10,-10,0>,.599 }
 cylinder { <-10,-10,0>,<-10,10,0>,.599 }
 cylinder { <10,10,0>,<10,-10,0>,.599 }
 cylinder { <10,10,0>,<-10,10,0>,.599 }
 pigment { White }
}

union {
 #if (GLASS = 1)
  union {
   box { <-10,17,.5>,<10,37,.7> }
   box { <-10,17,2.3>,<10,37,2.5> }
   box { <-30.7,17,-45>,<-30.5,37,-25> }
   box { <-32.3,17,-45>,<-32.5,37,-25> }
   pigment { rgbf <1,1,1,0.85> } 
   finish { 
    ambient 0
    diffuse 0
    reflection 0.1
    refraction 1
    ior 1.5
   }   // finish
  }    // texture
 #end  // End of GLASS
 object { Window_frame translate <0,27,.6> }
 object { Window_frame translate <0,27,2.4> }
 object { Window_frame rotate y*90 translate <-30.6,27,-35> }
 object { Window_frame rotate y*90 translate <-32.4,27,-35> }
 box { <-30,17,-47>,<-25,16,-23> pigment { White } }
}   // union

/***************** Table ******************/

union {
 box { <-10,13,-17>,<10,14,17> }	// base
 box { <-10,14,-17>,<10,14.001,17>	// reflecting layer
  texture {
   pigment { Silver }
   finish { Mirror_finish }
  }
 }
 box { <-10,14,-17>,<10,14.5,17>	// multicolored glass
  #if (GLASS = 1)
   texture { TLasi1 scale 10 }		// ttex.inc
  #else pigment { rgbf<0,1,0,0> }
  #end  // End of GLASS
 }	// box
 cylinder { <-8,13,-14>,<-8,0,-14>,1 }
 cylinder { <-8,13,14>,<-8,0,14>,1 }
 cylinder { <8,13,-14>,<8,0,-14>,1 }
 cylinder { <8,13,14>,<8,0,14>,1 }
 sphere { <8,0,-14>,1.5 scale <1,2,1> }
 sphere { <8,0,14>,1.5 scale <1,2,1> }
 sphere { <-8,0,-14>,1.5 scale <1,2,1> }
 sphere { <-8,0,14>,1.5 scale <1,2,1> }
 texture { Grnt11 }		// base texture
 texture { 
  pigment { Clear }
   finish { 
   specular 1
   roughness 0.001
   reflection 0.1
  }	// finish
 }	// texture

 translate <-19,0,-18>
}	// union

/****************** Chair *****************/

#if (STUFF = 1)
union {	
 superellipsoid { <0.1,0.1>
  clipped_by { plane { -y,-0.9 } }
  scale 10
 }
 #declare Chpiece =
 union {
  cone { <0,0,0>,0.5,<1.5,6.5,0>,1 }
  sphere { <1.5,6.5,0>,1 }
  cone { <1.5,6.5,0>,1,<2.5,12.5,0>,0.5 }
 }	// End of Chpiece
 union {
  cylinder { <-18,-0.5,7.5>,<-19.5,-9.5,10>,1 }
  object { Chpiece translate <0,0,-1> }
  object { Chpiece translate <0,0,2> }
  object { Chpiece rotate z*10 translate <0,0,8> }
  object { Chpiece rotate z*5 translate <0,0,5> }
  difference {
   torus { 8,0.8 scale <1,1,1.2> }
   box { <3,10,-20>,<-10,-10,20> }
   translate <-4,12.5,0>
  }
  translate <9.5,9.5,0>
 }	// union
 texture { T_Wood6 scale 2 }
 texture { 
  pigment { 
   bozo 
   color_map {
    [ 0 rgbf<1,1,1,1> ]
    [ 0.7 rgbf<1,1,1,0.85> ]
    [ 1 rgbf <1,1,1,0.9> ]
   }	// color_map
  }	// pigment
  finish { 
   specular 1
   roughness 0.001
  }	// finish
  scale 2
 }	// texture
 scale <0.4,1,0.7>
 rotate y*15
 translate <-9,0,-20>
}	// union
#end // End of STUFF

/******************* Ship painting *************/

#if (STUFF = 1)
union {
 box { <0,0,0>,<0.01,9,12>
  pigment {
   image_map {
    tga "ship.tga"		// See ship.pov
   } 
   rotate y*-90
   scale <1,9,12>
  }   // pigment
 }    // box
 #if (GLASS = 1)
  box { <0,0,0>,<0.15,9,12>
   texture {
    pigment { rgbf<1,1,1,0.85> }
    finish { F_Glass1 }
   }    // texture
  }     // box
 #end	// End GLASS
 translate <-30,17.5,-24>
}	// union

union {	// Frames of painting
 cylinder { <0,0,0>,<0,0,12>,0.25 }
 cylinder { <0,0,0>,<0,9,0>,0.25 }
 cylinder { <0,9,0>,<0,9,12>,0.25 }
 cylinder { <0,0,12>,<0,9,12>,0.25 }
 sphere { <0,0,0>,0.25 }
 sphere { <0,9,0>,0.25 }
 sphere { <0,0,12>,0.25 }
 sphere { <0,9,12>,0.25 }
 pigment { Brown }
 translate <-30,17.5,-24>
}
#end	// end STUFF

/*************** Mirror ****************/

#if (STUFF = 1)
union {
 torus { 4,0.5 }
 #if (GLASS = 1)
  cylinder { <0,0,0>,<0,0.2,0>,4
   pigment { rgbf<1,1,1,0.8> }
   finish { F_Glass1 }
  }
  cylinder { <0,0,0>,<0,0.01,0>,4
   pigment { Silver }
   finish { Mirror_finish }
  }
 #end	// end GLASS
 pigment { SkyBlue }
 rotate x*-90
 translate <-20,19,0>
}    // union

/************** Big bottles ***********/

object { Dude_in_bottle translate <-20,18.9,-13> }
object { Ship_in_bottle translate <-28,18.65,-33> }

/*************** Glasses (eye ones) **************/

#declare Lens =
union {
 torus { 1,0.1 }
 #if (GLASS = 1)
  sphere { <0,0,0>,1 scale <1,0.1,1>
   texture { 
    pigment { rgbf <1,1,1,1> }
    finish { F_Glass4 }
   }	// texture
  }	// sphere
 #end
}	// end Lens

#declare Frame =
union {
 cylinder { <0,0,0>,<-2,0.5,0>,0.1 }
 difference {
  torus { 0.75,0.1 rotate x*90 }
  box { <0,5,-5>,<5,-5,5> }
  translate <-2,-0.25,0>
 }
 sphere { <-2,-1,0>,0.1 }
}	// end Frame

union { 
 object { Frame rotate z*-4 translate <0,0,2.5> }
 object { Frame rotate z*-4 translate <0,0,-2.5> }
 object { Lens rotate z*90 translate <0,0,1.5> }
 object { Lens rotate z*90 translate <0,0,-1.5> }
 difference {
  torus { 0.5,0.1 rotate z*90 }
  box { <-5,0,-5>,<5,-5,5> }
 }	// difference
 texture { T02 }	// Gold
 rotate y*-60
 scale 0.8
 translate <-11,15.33,-13> 
}	// union

/********* Ship ********/

union {
 object { Ship scale 0.1 rotate y*-90 }
 object { Bottle_rest 
  pigment { DMFWood3 }
  scale 0.1
  translate <-0.9,0,0> 
 }	// object
 rotate y*57
 translate <-11,15.5,-5> 
}	// union
#end	// end of STUFF

/************* Shelf ************/

union {
 box { <0,0,0>,<5,0.3,10> }
 box { <0,-4,0>,<5,-3.7,10> }
 box { <0,-9,0>,<5,-8.7,10> }
 box { <0,0,0>,<5,-8.7,-0.3> }
 box { <0,0,10>,<5,-8.7,10.3> }
 sphere { <5,0,0>,0.3 }
 sphere { <5,0,10>,0.3 }
 sphere { <5,-8.7,10>,0.3 }
 sphere { <5,-8.7,0>,0.3 }
 cylinder { <5,0,0>,<5,0,10>,0.3 }
 cylinder { <5,0,0>,<5,-8.7,0>,0.3 }
 cylinder { <5,-8.7,10>,<5,-8.7,0>,0.3 }
 cylinder { <5,-8.7,10>,<5,0,10>,0.3 }
 cylinder { <5,-3.85,0>,<5,-3.85,10>,0.3 }
 box { <2,0,0>,<2.1,-8.8,10> }
 texture { T_Wood10 }
 texture { 
  pigment { Clear }
  finish { 
   specular 1
   roughness 0.001
  }    // finish
  scale 2
 }    // texture
 translate <-31,27,-10.5> 
}	// union

/*********** Crystall ball ***********/

#if (GLASS = 1)
 union {
  difference {
   cone { <0,0,0>,2,<0,2,0>,1 }
   sphere { <0,2,0>,2 }
   pigment { Sapphire_Agate }
  }	// difference
  difference {
   sphere { <0,2,0>,2 }
   sphere { <0,2,0>,1.9 }
   texture { 
    pigment { rgbf <1,1,1,0.9> }
    finish { 
     ambient 0
     diffuse 0
     reflection 0.1
     refraction 1
     ior 1.5
     caustics 0.1
    }	// finish
   }	// texture
  }	// difference
  sphere { <0,0,0>,1.9
   hollow
   pigment { Clear }
   halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.7
    color_map {
     [ 0 color rgbt <0,0,1,1> ]
     [ 1 color rgbt <1,0,0,-0.1> ]
    }	// color_map
    samples 20
    scale 2
   }	// halo
   translate <0,1.5,0>
  } 	// halo container
  scale 0.7
  translate <-28,23.3,-2.2>
 }	// union
#end	// End of GLASS

/********* Little bottles ***********/

#if (GLASS = 1)

#declare LBF =	// Bottle finish
finish { 
 ambient 0.0
 diffuse 0.0
 reflection 0.1
 refraction 1
 ior 1.5
 caustics 0.1
}

#declare Lil_shape = 	// Bottle shape
blob {
 threshold 0.1
 cylinder { <0,-2,0>,<0,0,0>,1,0.5 }
 cylinder { <0,1,0>,<0,1.4,0>,0.4,0.3 }
 sphere { <0,0.3,0>,0.8,0.5 }
 sphere { <0,0.8,0>,0.4,0.5 }
 component -0.5,0.8,<0,-2.7,0>
 scale <0.9,1,0.9>
}

#declare Lil_bottle =
difference {
 object { Lil_shape }
 object { Lil_shape scale 0.9 }
}

#declare Lil_label = 	// Bottle label
difference {
 cylinder { <0,-0.2,0>,<0,-1.5,0>,0.75 }
 cylinder { <0,-0.4,0>,<0,-1.6,0>,0.74 }
 box { <0.3,-2,-2>,<-2,2,2> }
 scale <0.9,1,0.9>
}

union {
 object { Lil_bottle 
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Green } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0,-2>,<2,2,2> }
  pigment { Green filter 0.4 }
 }
 translate <-28.5,20.5,-1.2>
}

union {
 object { Lil_bottle
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { White } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0.1,-2>,<2,2,2> }
  pigment { White filter 0.4 }
 }
 translate <-28,20.5,-2.6>
}

union {
 object { Lil_bottle
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Blue } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0.35,-2>,<2,2,2> }
   pigment { Blue filter 0.4 }
 }
 translate <-28.5,20.5,-4>
}

union {
 object { Lil_bottle 
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Red } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0.15,-2>,<2,2,2> }
  pigment { Red filter 0.4 }
 }
 translate <-28,20.5,-5.4>
}

union {
 object { Lil_bottle 
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Cyan } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0.2,-2>,<2,2,2> }
  pigment { Cyan filter 0.4 }
 }
 translate <-28.5,20.5,-6.8>
}

union {
 object { Lil_bottle 
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Brown } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0.2,-2>,<2,2,2> }
  pigment { Brown filter 0.4 }
 }
 translate <-28,20.5,-8.2>
}

union {
 object { Lil_bottle 
  texture { 
   pigment { White filter 0.85 transmit 0.05 }
   finish { LBF }
  }
 }
 object { Lil_label pigment { Yellow } }
 difference {
  object { Lil_shape scale 0.88 }
  box { <-2,0,-2>,<2,2,2> }
  pigment { Yellow filter 0.4 }
 }
 translate <-28.5,20.5,-9.6>
}

#end // End of GLASS

/********* Magnifier **************/

#if (STUFF = 1)
union {
 torus { 2,0.1 scale <1,3,1> }
 #if (GLASS = 1)
  sphere { <0,0,0>,2 scale <1,0.15,1> 
   texture { T_Glass4 }
  }	// sphere
 #end	// end of GLASS
 cylinder { <0,0,-2>,<0,0,-6>,0.3 }

 #include "dude2.inc"
 #include "collect.inc"
 object { 
  human
  scale 0.055
  rotate y*180
  translate <0.6,0.85,-5.2>
  rotate x*-30
 }
 texture { T_Silver_3A }
 scale 0.5
 rotate x*30
 rotate y*40
 translate <-13,15.2,-19>
}	//union

box { <0,0,0>,<4,0.001,3.5>
 pigment {
  image_map {
   gif "text_magn.gif"
  }	// image_map
  rotate y*-90
  rotate z*90
  scale 5
  translate <-0.15,0,0>
 }	// pigment 
 finish { ambient 1 }
 rotate y*15
 translate <-16,14.5,-21>
}	// box
box { <0,0,0>,<4,-0.001,3.5>	// Removes text from other side of  
 texture {			// the paper.
  pigment { White }
  finish { ambient 1 }
 }	// texture
 rotate y*15
 translate <-16,14.5,-21>
}	// box

/********* Books ***********/

union {
 cylinder { <0,0,0>,<0,3,0>,0.5 
  pigment {
   image_map {
    gif "book5.gif"
    map_type 2
   }
   rotate y*-78
   scale <1,4,1>
   translate <0,-1,0>
  }
  scale <0.5,1,1>
 }

 cylinder { <0,0,0>,<0,3,0>,0.5
  pigment {
   image_map {
    gif "book4.gif"
    map_type 2
   }
   rotate y*-75
   scale <1,4,1>
   translate <0,-1,0>
  }
  scale <0.5,1,1>
  translate <0,0,1>
 }

 cylinder { <0,0,0>,<0,3,0>,0.5
  pigment {
   image_map {
    gif "book3.gif"
    map_type 2
   }
   rotate y*-80
   scale <1,4,1>
   translate <0,-1,0>
  }
  scale <0.5,1,1>
  translate <0,0,2>
 }

 cylinder { <0,0,0>,<0,3,0>,0.5
  pigment {
   image_map {
    gif "book2.gif"
    map_type 2
   }
   rotate y*-80
   scale <1,3.3,1>
   translate <0,-0.5,0>
  }
  scale <0.5,1,1>
  rotate x*-16
  translate <0,0.1,3.8>
 }

 cylinder { <0,0,0>,<0,3,0>,0.5 
  pigment {
   image_map {
    gif "book1.gif"
    map_type 2
   }
   rotate y*-80
   scale <1,4,1>
   translate <0,-1,0>
  }
 scale <0.5,1,1>
  rotate x*-30
  translate <0,0.2,5.55>
 }
 translate <-27,23.3,-9.8>
}	// union
#end	// End of STUFF
