//  JOINTS2.INC  "Thrower"

// This file contains the rotations for all the joints of the body,
// and color of the figure.
// All rotations follow the left hand rule.
// +x is to the right, +y is to the rear, and +z is up.
// Created by Will Wagner

define x frame
define headrot		<10,0,0>		// <-45/45,-10/10,-80/80>
define neckrot		<5,0,0>			// <-30/30,-10/10,-20/20>
define torsorot		<0,0,9>
define abdomenrot	<0,0,90>		// <0,-5/5,0>

// Left arm rotations
define laupperrot	<0,70,90>		// <-180/45,-45/180,-90/45>
define lalowerrot	<0,30,10>		// <-165/0,0,0>
define lhandrot		<0,45,0>		// <-20/20,-90/20,-90/180>
define lfingerrot	<0,0,0>			// <0,-90/0,0>

// Right arm rotations
if (frame <= 9) {
	define raupperrot	<0,-80,0-8*x>	// <-180/45,-180/45,-45/90>
	define ralowerrot	<0,-90+7*x,-10-7*x>		// <-165/0,0,0>
	}
else    {
	define raupperrot	<0,-80,-80>
	define ralowerrot	<0,-7,-80>		// <-165/0,0,0>
        }
define rhandrot		<0,-15,0>		// <-20/20,-20/90,-180/90>
define rfingerrot	<0,0,0>		// <0,0/90,0>

// Left leg rotations
define lthighrot	<-20,0,-50>		// <-90/15,0/45,-45/0>
define lcalfrot		<20,0,0>		// <0/160,0,0>
define lfootrot		<0,0,0>		// <-5/50,-5/5,-10/10>

// Right leg rotations
define rthighrot	<-10,0,0>		// <-90/15,-45/0,0/45>
define rcalfrot		<30,0,0>		// <0/160,0,0>
define rfootrot		<0,0,0>		// <-5/50,-5/5,-10/10>
