include "colors.inc"

// Names of the various shading flags
define shadow_check       1
define reflect_check      2
define transmit_check     4
define two_sided_surface  8
define cast_shadows      16
define primary_rays      32

// Default shading flags during raytracing - everything gets checked.
define all_shading_flags
   shadow_check + reflect_check + transmit_check + cast_shadows +
   two_sided_surface + primary_rays

//
// Define a set of shading flags for surfaces that shouldn't have their
// backsided illuminated
define one_sided_surface
   all_shading_flags - two_sided_surface

// Useful definitions to use with noise surfaces.  These
// will come in handy below when we declare marble and
// wood textures.
define position_plain       0
define position_objectx     1
define position_worldx      2
define position_cylindrical 3
define position_spherical   4
define position_radial      5

define lookup_plain    0
define lookup_sawtooth 1
define lookup_cos      2
define lookup_sin      3

define plain_normal  0
define bump_normal   1
define ripple_normal 2
define dented_normal 3

define blue_ripple
texture {
   noise surface {
      color <0.4, 0.4, 1.0>
      normal 2
      frequency 100
      bump_scale 2
      ambient 0.3
      diffuse 0.4
      specular white, 0.7
      reflection 0.5
      microfacet Reitz 10
      }
   scale <10, 1, 10>
   }

// The standard sort of marble texture
define white_marble
texture {
   noise surface {
      color white
      position_fn position_objectx
      lookup_fn lookup_sawtooth
      octaves 3
      turbulence 3
      ambient 0.3
      diffuse 0.8
      specular 0.3
      microfacet Reitz 5
      color_map(
	 [0.0, 0.8, <1, 1, 1>, <0.6, 0.6, 0.6>]
	 [0.8, 1.0, <0.6, 0.6, 0.6>, <0.1, 0.1, 0.1>])
      }
   }
define red_marble
texture {
   noise surface {
      color red
      position_fn position_objectx
      lookup_fn lookup_sawtooth
      octaves 3
      turbulence 3
      ambient 0.3
      diffuse 0.8
      specular 0.3
      microfacet Reitz 5
      color_map([0, 0.8, <1, 0.8, 0.8>, <1, 0.4, 0.4>]
      		[0.8, 1, <1, 0.4, 0.4>, <1, 0.1, 0.1>])
      }
   }

// Nice blue agate texture
define sapphire_agate
texture {
   noise surface {
      ambient 0.4
      diffuse 0.6
      specular white, 0.2
      microfacet Cook 4
      position_fn position_objectx
      position_scale 1.1
      lookup_fn lookup_sawtooth
      octaves 3
      turbulence 2
      color_map(
	 [0.0, 0.3, <0, 0, 0.9>, <0, 0, 0.8>]
	 [0.3, 1,   <0, 0, 0.8>, <0, 0, 0.4>])
      }
   scale <0.5, 0.5, 0.5>
   }

// Simple color map texture
define whorl_texture
texture {
   noise surface {
      color green
      ambient 0.3
      diffuse 0.8
      lookup_fn lookup_sawtooth
      octaves 2
      turbulence 2
      color_map(
	 [0.0, 0.3, green,   blue]
	 [0.3, 0.6, blue,    skyblue]
	 [0.6, 0.8, skyblue, orange]
	 [0.8, 1.0, orange,  red])
      }
   scale <0.5, 0.5, 0.5>
   }

// Create a wood texture.  Concentric rings of color
// are wrapped around the z-axis.  There is some turbulence
// in order to keep the rings from looking too perfect.
define light_wood <0.6, 0.24, 0.1>
define median_wood <0.3, 0.12, 0.03>
define dark_wood <0.05, 0.01, 0.005>

define wooden
texture {
   noise surface {
      position_fn position_cylindrical
      position_scale 1
      lookup_fn lookup_sawtooth
      octaves 1
      turbulence 1
      ambient 0.2
      diffuse 0.7
      specular white, 0.5
      microfacet Reitz 10
      color_map(
	 [0.0, 0.2, light_wood, light_wood]
	 [0.2, 0.3, light_wood, median_wood]
	 [0.3, 0.4, median_wood, light_wood]
	 [0.4, 0.7, light_wood, light_wood]
	 [0.7, 0.8, light_wood, median_wood]
	 [0.8, 0.9, median_wood, light_wood]
	 [0.9, 1.0, light_wood, dark_wood])
      }
   }

define light_white_wood <0.908235, 0.908235, 0.908235>
define median_white_wood <0.702941, 0.702941, 0.702941>
define dark_white_wood <0.209804, 0.209804, 0.209804>

define woodenwhite
texture {
   noise surface {
      position_fn position_cylindrical
      position_scale 1
      lookup_fn lookup_sawtooth
      octaves 1
      turbulence 1
      ambient 0.2
      diffuse 0.7
      specular white, 0.5
      microfacet Reitz 10
      color_map(
	 [0.0, 0.2, light_white_wood, light_white_wood]
	 [0.2, 0.3, light_white_wood, median_white_wood]
	 [0.3, 0.4, dark_white_wood, median_white_wood]
	 [0.4, 0.7, light_white_wood, light_white_wood]
	 [0.7, 0.8, median_white_wood, dark_white_wood]
	 [0.8, 0.9, median_white_wood, light_white_wood]
	 [0.9, 1.0, light_white_wood, dark_white_wood])
      }
   }

// Define a texture using a color wheel
define xz_wheel_texture
texture {
   special surface {
      color color_wheel(x, y, z)
      ambient 0.2
      diffuse 0.8
      specular white, 0.2
      microfacet Reitz 10
      }
   }

// This is an example of a gradient texture.
define mountain_colors
texture {
   noise surface {
      ambient 0.2
      diffuse 0.8
      specular 0.2
      position_fn position_objectx
      color_map(
	 [-128,   0, blue,  blue]
	 [   0,  20, green, green]
	 [  20,  40, green, tan]
	 [  40,  90, tan,   tan]
	 [  90, 128, white, white])
      }
   rotate <0, 0, 90>
   }

define mountain_colors1
texture {
   noise surface {
	 ambient 0.3
      diffuse 0.1
	 specular 0.1
      position_fn position_objectx
      color_map(
	 [-128,   20, darkgreen,  darkgreen]
	 [   20,  40, darkgreen, forestgreen]
	 [  40,  60, forestgreen, grey]
	 [  60,  70, grey,   grey]
	 [  70, 128, white, white])
      }
   rotate <0, 0, 90>
   }

// Red dented/wrinkled appearance
define dented_red
texture {
   noise surface {
      color <1, 0.2, 0.2>
      normal 1
      frequency 2
      bump_scale 3
      ambient 0.2
      diffuse 0.5
      specular 0.7
      microfacet Reitz 10
      }
   scale <0.2, 0.2, 0.2>
   }

// When used on a big sphere, this makes a nice cloudy sky.  You will
// probably need to scale to make it look good.
define cloudy_sky
texture {
   noise surface {
      ambient 0.9
      diffuse 0
      specular 0
      turbulence 6.0
      position_fn 2
      lookup_fn 1
      octaves 4
      color_map(
	 [0.0, 0.6, <0.4, 0.4, 0.4>, <1, 1, 1>]
	 [0.6, 0.8, <1, 1, 1>, <0.196078, 0.6, 0.8>]
	 [0.8, 1.0, <0.196078, 0.6, 0.8>, <0.196078, 0.6, 0.8>])
      }
   }

define BlueSkyMap
      color_map(
	 [0.0, 0.5, <0.25, 0.25, 0.5>, <0.25, 0.25, 0.5>]
	 [0.5, 0.6, <0.25, 0.25, 0.5>, <0.7, 0.7, 0.7>]
	 [0.6, 1.0, <0.7, 0.7, 0.7>, <0.3, 0.3, 0.3>])

define cloudy_blue_sky
texture {
   special surface {
      color BlueSkyMap[bozo_fn]
      ambient 0.5
      diffuse 0.3
      specular 0
	 turbulence 100  //100
	 octaves 3 //3
	 microfacet Reitz 10 //10
      }
	 scale <45, 5, 5>
      translate<0, 0, 5>
   }

define cloudy_midnight_sky
texture {
   special surface {
      color BlueSkyMap[bozo_fn]
      ambient 0.7
      diffuse 0
      specular 0
      turbulence 100
      octaves 3
      microfacet Reitz 10
      }
      scale <15, 1, 1>
      translate<0, 0, 5>
   }

// This makes a nice texture to use on leaves
define bumpy_green
texture {
   special surface {
      normal N + dnoise(3*W)
      ambient green, 0.2
      diffuse green, 0.3
      specular white, 0.7
      microfacet Reitz 10
      }
   scale <0.02, 0.02, 0.02>
   }


// This makes a nice texture to use on leaves
define bumpy_Dgreen
texture {
   special surface {
	 normal N + dnoise(4*W)
      ambient darkgreen, 0.2
      diffuse green, 0.3
      specular white, 0.7
      microfacet Reitz 10
      }
   scale <0.02, 0.02, 0.02>
   }

define bumpy_Agreen
texture {
   special surface {
      normal N + dnoise(3*W)
      ambient darkgreen, 0.2
      diffuse darkgreen, 0.3
      specular white, 0.7
      microfacet Reitz 10
      }
   scale <0.02, 0.02, 0.02>
   }

define bumpy_Mgreen
texture {
   special surface {
      normal N + dnoise(3*W)
      ambient springgreen, 0.2
      diffuse green, 0.3
      specular white, 0.7
      microfacet Reitz 10
      }
   scale <0.02, 0.02, 0.02>
   }
/* Tigers eye colors */
static define tigers_eye_colors2 color_map(
   [0.000, 0.115, <0.698, 0.533, 0.122>, 0.000, <0.529, 0.173, 0.071>, 0.000]
   [0.115, 0.230, <0.529, 0.173, 0.071>, 0.000, <0.698, 0.533, 0.122>, 0.000]
   [0.230, 0.336, <0.698, 0.533, 0.122>, 0.000, <0.424, 0.325, 0.075>, 0.000]
   [0.336, 0.460, <0.424, 0.325, 0.075>, 0.000, <0.698, 0.533, 0.122>, 0.000]
   [0.460, 0.628, <0.698, 0.533, 0.122>, 0.000, <0.306, 0.235, 0.055>, 0.000]
   [0.628, 0.708, <0.306, 0.235, 0.055>, 0.000, <0.698, 0.341, 0.122>, 0.000]
   [0.708, 0.796, <0.698, 0.341, 0.122>, 0.000, <0.000, 0.000, 0.000>, 0.000]
   [0.796, 0.858, <0.000, 0.000, 0.000>, 0.000, <0.596, 0.373, 0.106>, 0.000]
   [0.858, 0.982, <0.596, 0.373, 0.106>, 0.000, <0.494, 0.376, 0.086>, 0.000]
   [0.982, 1.000, <0.494, 0.376, 0.086>, 0.000, <0.698, 0.533, 0.122>, 0.000])

/* Tigers_Eye1 - A noisy tigers eye texture */
static define Tigers_Eye1
texture {
   special shiny {
      color tigers_eye_colors2[marble_fn]
      }
   }

/* Tigers_Eye2 - A fractured tigers eye matrix */
static define noisy_x x + 1.5 * dnoise(P)[0]
static define noisy_y y + 1.5 * dnoise(P)[1]
static define noisy_z y + 1.5 * dnoise(P)[2]
static define noisy_x1 noisy_x - floor(noisy_x)
static define noisy_y1 noisy_y - floor(noisy_y)
static define noisy_z1 noisy_z - floor(noisy_z)
static define noisy_checker3_fn fmod((noisy_x1+noisy_y1+noisy_z1)/3, 1)
static define Tigers_Eye2 texture {
   special shiny { color tigers_eye_colors2[noisy_checker3_fn] }
   scale <0.5, 0.5, 0.5>
   }

/* Bumpy_Silver - */
static define bumpy_silver
texture {
   special surface {
      color 0.9*white
      normal N + 0.2 * (dnoise(5*W) - <0.5,0.5,0.5>)
      ambient 0.05
      diffuse 0.1
      specular 0.9*white, 0.3
      reflection 0.8
      microfacet Cook 5
      }
   }
