// Persistence of Vision Raytracer
// Chope de bire. Travail norme commenc en 1993 sur Amiga 4000/030
//  max_trace_level 8 est indispensable... mais adc_bailout devrait limiter la casse.

#declare Ecl_Std = 0
#declare Ecl_Etendu = 1
//#declare Eclairage = Ecl_Std
#declare Eclairage = Ecl_Etendu

/******************************************************************************

        Gnralits

******************************************************************************/

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

global_settings {
   max_trace_level 8
   adc_bailout 1/128
   assumed_gamma 1.9
   }

camera {
   orthographic
   location -166*z
   up            y*50
   right     4/3*y*50
   direction     z*1
   look_at <0, 0, 0>
   translate <5, 5, 0>
   }

#declare Lampes=union{
#if (Eclairage = Ecl_Etendu)
object {
   light_source {
      <-180, 250, -75> // light's position
      color White
      area_light
      <10, 0, 0> <0, 0, 10> // lights spread out across this distance (x * z)
      4, 4                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 2          // 0,1,2,3... 1 est insuffisant.
      jitter              // adds random softening of light
      spotlight
      point_at <0, 0, 0>
      radius 5
      falloff 10
      tightness 10
      }
   }
object {
   light_source {
      <180, 10, -125>
      color White
      area_light
      <8, 0, 0> <0, 8, 0> // lights spread out across this distance (x * y)
      4, 4                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
      spotlight
      point_at <0, 0, 0>
      radius 7
      falloff 12
      tightness 5
      }
   }
object {
   light_source {
      <0, 100, -25>
      color White
      spotlight
      point_at <0, 100, -100>
      radius 90
      falloff 90
      tightness 10
      }
   }
#else

object {
   light_source {
      <-180, 250, -75>
      color White
      }
   }


object {
   light_source {
      <180, 10, -125>
      color White
      }
   }
#end
}

/******************************************************************************
        Constitution de la scne
******************************************************************************/

#include "chope.inc"
#include "Bar.inc"
#include "Fond.inc"

#declare Scene = union {
   object {Chope translate <15, 0, -3>}
   object {Bar}
   object {Goutte translate <13-7.5, -10, -5>}
   object {Pression}
   object {Fond}
   }
union {
   object {Scene translate -10*x rotate <0, 20, 0>}
   object {Lampes}
   rotate   -20*x
   rotate   2.5*y
   scale <-1,1,1>
   }

