//  Ashtray definition
// ********  TEXTURES  *******

#declare tAshTray = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.000, 0.000, 0.000> ]
       [ 1.000  color rgb<0.154, 0.136, 0.151> ]
     }
     turbulence 0.700
     omega 0.600
   }
   finish {
     diffuse 0.500
     ambient 0.200
     phong 0.640
     phong_size 72.600
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'tCigFilter'
#declare tCigFilter = texture {
   pigment {
     granite
     color_map {
       [ 0.000  color rgb<0.930, 0.710, 0.532> ]
       [ 0.600  color rgb<0.980, 0.810, 0.600> ]
       [ 0.600  color rgb<0.500, 0.300, 0.200> ]
       [ 0.650  color rgb<0.500, 0.300, 0.200> ]
       [ 0.650  color rgb<0.800, 0.530, 0.460> ]
       [ 1.000  color rgb<0.850, 0.750, 0.350> ]
     }
     scale     <0.2500, 0.2500, 0.2500>
   }
   finish {
     specular 0.100
     roughness 0.5000
   }

}



//  $MRY$: 'tCigPaper'
#declare tCigPaper = texture {
   pigment {
     gradient z
     color_map {
       [ 0.000  color rgb<0.505, 0.505, 0.505> ]
       [ 0.050  color rgb<1.000, 1.000, 1.000> ]
       [ 0.950  color rgb<1.000, 1.000, 1.000> ]
       [ 1.000  color rgb<0.505, 0.505, 0.505> ]
     }
     frequency 5.000
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.100
     roughness 0.0100
   }

}




// ********  REFERENCED OBJECTS  *******

#declare Ashtray1 = intersection {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 2.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 2.0>
    rotate -45.0*z
  }
  translate  2.0*z
}

#declare Asht_hole1 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1
    scale <0.4, 0.4, 1.0>
    rotate -90.0*x
    translate  <0.0, 3.25, 2.5>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 1.0>
    translate  <0.0, 3.75, 3.5>
  }
  translate  1.0*z
}





#declare Smoke = sphere { // Smoke
  0, 1
  hollow
  no_shadow
  pigment { color rgbf <1,1,1,1>}
  halo {
        linear
        max_value 0.10
        cylindrical_mapping
        attenuating
        turbulence 0.75
        octaves 6
        omega (1/1.618)
        lambda 1.618
        colour_map {
             [0.0 color rgbt <1, 1, 1, 1>]
             [0.5 color rgbt <1, 1, 1, 0.65>]
             [1.0 color rgbt <0, 0, 0.2, 0>]
        }
        scale <0.4, 0.4, 0.9>
        samples 10
        aa_level 0
        aa_threshold 0.3
  }
  scale <10.0, 10.0, 50.0>
  translate  <-1.69607, 0.0, 52>
}


#declare Cigarette = union { // Cigarette
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.4, 0.4, 7.0>
    texture {
      tCigPaper
    }
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      tCigFilter
    }
    scale <0.4, 0.4, 2.0>
    translate  7.0*z
  }
  rotate 69.187683*y
  translate  <-1.849997, 0.0, 1.662655>
}




#declare AshtrayB = difference { // AshTrayB
  object { Ashtray1 }
  object { Ashtray1 scale <0.9, 0.9, 1.0> translate  1.0*z }
  object { Asht_hole1 }
  object { Asht_hole1 rotate  -45.0*z }
  object { Asht_hole1 rotate  -90.0*z }
  object { Asht_hole1 rotate -135.0*z }
  object { Asht_hole1 rotate  180.0*z }
  object { Asht_hole1 rotate  135.0*z }
  object { Asht_hole1 rotate   90.0*z }
  object { Asht_hole1 rotate   45.0*z }
  texture { tAshTray }
}

#declare Ashtray = union {
         object {AshtrayB}
         object {Cigarette}
         object {Smoke}
}

