
// Persistence of Vision Ray Tracer Scene Description File
// File: bs-frag.pov
// Vers: 1
// Desc: Scene for Internet RayTracing Competition--Glass Theme. A desk, ancient papyrus
//       fragment, magnifying lens, a few oil lamps a glass of red wine.
// Date: 2/27/97
// Auth: Bob Sewell

global_settings { max_trace_level 5 assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "glass.inc"
#include "golds.inc"
#include "woods.inc"
#include "table.inc"
#include "chair.inc"
#include "lamps.inc"
#include "cabinet.inc"
#include "magglass.inc"
#include "wineglas.inc"

camera {
  location  <14.4, -23.0, 10.0>
  direction <0.0,     0.0,  1.6>
  sky       <0.0,     0.0,  1.0>
  up        <0.0,     0.0,  1.0>
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 6.0>
}

/*
light_source {   // Temporary - for adjustments only!
  <-3.100, -19.100, 16.900>
  color rgb <0.850, 0.850, 0.850>
}
*/

#declare wall = object {
  polygon
  {
    5, <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
  }
  texture { pigment { image_map
   {
    gif "roses.gif"
    map_type 0
    interpolate 2
   } scale 4 } }
  rotate <90, 0, 0>
  scale <10, 1, 10>
}

#declare ceiling = object {
polygon {
  5, <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
}
texture { pigment { rgb <0.9, 1, 0.9> }}
scale <20, 20, 1>
translate <-35, 41, 19>
}

#declare page1 = object {
  polygon
  {
    5, <0, 0>, <0, 3.85>, <4.15, 3.85>, <4.15, 0>, <0, 0>
  }
  texture { pigment { image_map
   {
    gif "greek1.gif"
    map_type 0
    interpolate 2
    filter 12, 1.0
   }
   rotate <0, 0, 90>
   scale 4} }
}

background { color red 0.2 green 0.2 blue 0.2 }

object {
  wall
  translate <-40, 41, 20>
}

object {
  wall
  rotate <0, 0, -90>
  translate <-35, 61, 20>
}

object {
  ceiling
}

object {
  WallCandle
  scale 0.8
  translate <-10, 38.25, 8>
}

object {
  Lamp
  scale 0.95
  rotate <0, 0, 100>
  translate <-7, -3.2, 0.55>
}

light_source
{
  0*x
  color rgb <0.2,0.2,0.1>
  spotlight
  translate <-7, -3.2, 7>
  point_at <-7, -3.2, 0.55>
  radius 180 
  tightness 1
  falloff 8
}

object {
  Magnifying_Glass
  scale 0.9
  rotate <90, 90, -80>
  translate <8, -2, 2.65>
  rotate <0, 15, 0>
}

object {
  table
  translate <0, -3.5, 0>
}

object {
  page1
  scale <1.5, 1, 1.5>
  rotate <0, 0, 90>
  rotate <0, 0, 45>
  translate <6, -3, 0.35>
}

object {
  chair
  scale 0.7
  rotate <0, 0, 175>
  translate <3, 6, -12>
}

object {
  Cabinet
  rotate <0, 0, 90>
  translate <-32, 28, -14>
}

object {
  WineGlass
  scale < 0.7, 0.7, 1 >
  translate <0, -7, 1.5>
}

atmosphere {
  type 1
  samples 20
  distance 5000
  scattering 0.015
  aa_level 8
  aa_threshold 0.1
  jitter 0.1
}
