// Lifted from Dan Farmer's MATCHES.POV file included with POVray for Windows.
// Modified slightly by Bob Sewell.

// FadeDst controls the size of the flame element
#declare FadeDst = 1.25 //2, 1.75

// FadePwr determines spread of the glow
#declare FadePwr = 3.25   //3

// The match flame is an array of light sources.  I initially used
// spheres to help me set up the positions and sizes (FadeDst ~= radius)
// Flames are arranged in three columns.  The first is the major flame
// on the leftmost (burning) match.  The last is the new flame bursting
// from the match next to it, and the center column is just a little
// "fill" between the two.
#declare Flame1 =
union {

    light_source {<0.0, 0,   6.550> Red    * 0.5 fade_distance FadeDst fade_power FadePwr * 1.25}
    light_source {<0.0, 0,   6.525> Red    * 1.0 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.500> Yellow * 1.2 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.475> Red    * 1.2 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.450> Orange * 1.3 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.425> Orange * 1.4 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.400> Yellow fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.375> Orange fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.350> NeonBlue fade_distance 0.75 * FadeDst fade_power 1.5}
}

#declare Flame2 =
union {

    light_source {<0.0, 0,   6.550> Red    * 0.5 fade_distance FadeDst fade_power FadePwr * 1.25}
//  light_source {<0.0, 0,   6.525> Red    * 1.0 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.500> Yellow * 1.2 fade_distance FadeDst fade_power FadePwr}
//  light_source {<0.0, 0,   6.475> Red    * 1.2 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.450> Orange * 1.3 fade_distance FadeDst fade_power FadePwr}
//  light_source {<0.0, 0,   6.425> Orange * 1.4 fade_distance FadeDst fade_power FadePwr}
    light_source {<0.0, 0,   6.400> Yellow fade_distance FadeDst fade_power FadePwr}
//  light_source {<0.0, 0,   6.375> Orange fade_distance FadeDst fade_power FadePwr}
//  light_source {<0.0, 0,   6.350> NeonBlue fade_distance 0.75 * FadeDst fade_power 1.5}
}
