
#declare Glass_finish=
finish
 {
  specular 1
  roughness 0.01
  ambient 0
  diffuse 0
  reflection 0.1

  fade_distance 1
  fade_power 1.5

  refraction 1
  ior 1.5
 }//finish



#declare Glass_pigment=
pigment
{
 color rgbf<1.0, 1.0, 1.0, 0.9>
}

#declare Glass_texture=
texture
{
 finish{ Glass_finish}
 pigment{ Glass_pigment quick_color Pink}
}//texture

#declare Screw_texture=
texture
{
 T_Brass_3E normal{ dents .4 scale 0.09}
 pigment {quick_color Blue}
}

#declare Windungen=15
#declare Durchm=.55
#declare Tiefe=0.08
#declare Steigung=Tiefe*1.05

#declare Quad_Torus=
union
{
difference
{
 #declare SC=sqrt(Durchm*Durchm+Steigung*Steigung)
 torus{ Durchm/2, Tiefe}
 union
 {
  box  { <-Durchm/2-Tiefe-0.01, -Tiefe-0.01, 0>, <Durchm/2+Tiefe+0.01, Tiefe+0.01, Durchm/2+Tiefe+0.01>}
  box  { <0, -Tiefe-0.01, -Durchm/2-Tiefe-0.01>, <Durchm/2+Tiefe+0.01, Tiefe+0.01, 0.01>}
  rotate -45*y
 }
} //difference
sphere{ <0,0,0>, Tiefe translate <-Durchm/2/sqrt(2), 0, -Durchm/2/sqrt(2)>}
sphere{ <0,0,0>, Tiefe translate < Durchm/2/sqrt(2), 0, -Durchm/2/sqrt(2)>}
matrix < 1,     Steigung/4*sqrt(2),      0,
                 0,     1,      0,
                 0,     0,      1,
                 0,     0,      0>
}//union

#declare Gewinde=
union
{
 #declare CNT=0
 #while (CNT<Windungen)
       object
       {
        Quad_Torus
        rotate -90*y*mod(CNT,4)
        translate Steigung/4*y*CNT
       }
 #declare CNT=CNT+1
 #end
 cylinder { <0,-sqrt(2)*Steigung/4,0>, <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4,0>, Durchm/2+Tiefe*0.1  hollow}
 cone   { <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4,0>, Durchm/2+Tiefe*0.1, <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.1 ,0>, 0.36 hollow}
 difference
 {
  cylinder { <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.1 ,0>, <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.2 ,0>, 0.36}
  cylinder { <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.1-0.01 ,0>, <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.2+0.01 ,0>, 0.3}
 }
 cone   { <0,-sqrt(2)*Steigung/4,0>, Durchm/2+Tiefe*0.1, <0,-sqrt(2)*Steigung/4-.1,0>, (Durchm/2+Tiefe*0.1)*0.66 hollow}
}


#declare Light_Color=
color rgb <1, .9, .35>

#declare Light_Raster= 5

#declare Birne=
object
{
union
{
 difference         //Kolben
 {
  blob
  {
   threshold 0.6
   sphere{ <0,0,0>, 1, 1 scale <1.2,0.6,1.2>
           pigment{image_map{ gif "osram.gif" interpolate 2 filter 0 .97 filter 1 .03 map_type 1} rotate <0,0,-90> quick_color Blue}
           }
   cylinder{ <0,-.4,0>,<0,-.8,  0>, 0.66, 1 }
   scale <1.2, 1, 1.2>
//   sturm
  }
  blob
  {
   threshold 0.6
   sphere{ <0,0,0>, 1, 1 scale <1.2,0.6,1.2>}
   cylinder{ <0,-.4,0>,<0,-.8,  0>, 0.66, 1}
   texture{Glass_texture}
   scale <1.19,.99,1.19>
//   sturm
  }
  texture{ Glass_texture}
 } //difference
 blob          //Glasnippel in Mitte
 {
  threshold 0.3
  cylinder {<0,-1.1,0>,<0,-.9,0>, 0.1,1}
  cylinder {<0,-.8,0>,<0,-.65,0>, 0.1, 1 scale <0.3,1,1.4>}
  texture{ Glass_texture}
//  sturm
 } //blob

 //Drahtanschluesse
 cylinder { <0,-1.2, .04>, <0,-.65, .04>, .015 texture{ T_Copper_1D}  }
 cylinder { <0,-1.2,-.04>, <0,-.65,-.04>, .015 texture{ T_Copper_1D}  }
 cylinder { <0,-.65, .04>, <.2,   -.1, .3 >, .015 texture{ T_Copper_1D}  }
 cylinder { <0,-.65,-.04>, <.2,   -.1,-.3 >, .015 texture{ T_Copper_1D}  }
 cylinder { <0,-.65, -.01>, <-.3, -.1,-.2 >, .01 texture{ T_Copper_1D}  }
 cylinder { <0,-.65,  .01>, <-.3, -.1, .2 >, .01 texture{ T_Copper_1D}  }
 torus    { .045, .01 rotate 90*z rotate -35*y translate  <-.3, -.1, .2 > texture{ T_Copper_1D}  }
 torus    { .045, .01 rotate 90*z rotate  35*y translate  <-.3, -.1,-.2 > texture{ T_Copper_1D}  }


 light_source                   //Gluehfaden
 {
  <0,0,0>
  color Light_Color
  area_light <1, 0, 0>, <0, 1, 0>, Light_Raster, Light_Raster
//  adaptive 2
  shadowless


  looks_like
  {
   union
   {
    cylinder {< .2,  -.1, .3 >, <-.3, -.1,  .2 >, .03 }
    cylinder {< .2,  -.1,-.3 >, <-.3, -.1, -.2 >, .03 }
    cylinder {<-.3, -.1, -.2 >, <-.3, -.1,  .2 >, .03 }
    sphere   {<-.3, -.1,  .2 >, .03 }
    sphere   {<-.3, -.1, -.2 >, .03 }
    sphere   {< .2,  -.1, .3 >, .03 }
    sphere   {< .2,  -.1,-.3 >, .03 }
    texture
    {
     pigment {color Light_Color}
     finish {ambient .8 diffuse .6}
     normal {dents 0.2 scale 0.1}
    }
   }//union
  }//looks_like
 }//light_source
 object
 {
   Gewinde
   texture{ Screw_texture}
   translate <0,-1.35,0>
 }
 cone
 {
  <0,-sqrt(2)*Steigung/4-.1,0>, (Durchm/2+Tiefe*0.1)*0.62, <0,-sqrt(2)*Steigung/4-.18,0>, (Durchm/2+Tiefe*0.1)*0.3
  hollow
  texture
  {
   finish{reflection 0.1 diffuse 0.2}
   pigment{ rgb <0.92, 0.92, 0.96> quick_color Black}
  }
  translate <0,-1.35,0>
 }
 cylinder
 {
  <0,-sqrt(2)*Steigung/4-.18,0>, <0,-sqrt(2)*Steigung/4-.2,0>, (Durchm/2+Tiefe*0.1)*0.28
  hollow
  texture{ Screw_texture}
  translate <0,-1.35,0>
 }
 disc
 {
  <0,Steigung/4*(Windungen-1)+sqrt(2)*Steigung/4+0.13 ,0>, <0,1,0>, 0.3
  translate <0,-1.35,0>
  pigment {rgb <.1, .05,.02>}
 }
 //
}//union
}//object
