#include "colors.inc"
#include "metals.inc"
#include "stones.inc"

#include "bulb.inc"

#declare M_Wood11A =
color_map {
    [0.000, 0.222 color rgb <0.80, 0.67, 0.25>
                  color rgb <0.80, 0.67, 0.25>]
    [0.222, 0.342 color rgb <0.80, 0.67, 0.25>
                  color rgb <0.60, 0.34, 0.04>]
    [0.342, 0.393 color rgb <0.60, 0.34, 0.04>
                  color rgb <0.80, 0.67, 0.25>]
    [0.393, 0.709 color rgb <0.80, 0.67, 0.25>
                  color rgb <0.80, 0.67, 0.25>]
    [0.709, 0.821 color rgb <0.80, 0.67, 0.25>
                  color rgb <0.53, 0.29, 0.02>]
    [0.821, 1.000 color rgb <0.53, 0.29, 0.02>
                  color rgb <0.80, 0.67, 0.25>]
}
#declare M_Wood11B =
color_map {
    [0.000, 0.120 color rgbf <1.00, 1.00, 1.00, 1.00>
                  color rgbf <0.70, 0.41, 0.11, 0.60>]
    [0.120, 0.231 color rgbf <0.70, 0.41, 0.11, 0.60>
                  color rgbf <0.70, 0.46, 0.11, 0.60>]
    [0.231, 0.496 color rgbf <0.70, 0.46, 0.11, 0.60>
                  color rgbf <1.00, 1.00, 1.00, 1.00>]
    [0.496, 0.701 color rgbf <1.00, 1.00, 1.00, 1.00>
                  color rgbf <1.00, 1.00, 1.00, 1.00>]
    [0.701, 0.829 color rgbf <1.00, 1.00, 1.00, 1.00>
                  color rgbf <0.70, 0.46, 0.11, 0.60>]
    [0.829, 1.000 color rgbf <0.70, 0.46, 0.11, 0.60>
                  color rgbf <1.00, 1.00, 1.00, 1.00>]
}


#declare P_WoodGrain11A =
pigment {
    wood
    turbulence 0.02
    scale 0.1
    translate <0, 0, 0>
}

#declare P_WoodGrain11B =
pigment {
    wood
    turbulence 0.01
    scale 0.5
    translate <0, 0, 0>
}


 // Soft pine (light yellow, smooth grain)
#declare T_Wood11 =
    texture {  pigment{ P_WoodGrain11A color_map { M_Wood11A }}}
    texture {  pigment{ P_WoodGrain11B color_map { M_Wood11B }}}



camera
{
 location <15,20,-10>
 look_at <0,-.2,0>
 angle 8
}

light_source{ <.55,1.8,.6> 0.4*Light_Color}// shadowless}
//light_source{ <-1,1,0> White}
//background { 0.3*Light_Color }
//background { 0.3*White }

object
{
 plane
 {
  y, -.3
 }
 texture
 {
  T_Wood11
  finish{ reflection 0.1 diffuse 0.4}
  rotate 10*y
  rotate 1*x
  scale <3,1,1>
  translate -2*z-x
 }
}

object
{
 superellipsoid{ <.2, .2>}
 scale <1.1, .3, 1.4>
 translate -.3*y
 texture { T_Stone8 pigment {quick_color Green}}
}


object
{
 Birne
 rotate 40*y
 rotate 75.90*x
 rotate 180*y
 translate .667*y
 translate -0.6*z
}
