#include "Colors.inc"
#include "textures.inc"
#include "Sky.inc"
#include "Bottle.inc"
#include "Ship.inc"

// the ground
plane {y,-1 pigment {color Tan}}
height_field { tga "Marble.tga" 
        pigment {color White }
        translate <-.5,0,-.5>
        scale <2000,311,1810> 
        translate z*1000
}
height_field { tga "Marble.tga" 
        pigment {color White }
        translate <-.5,0,-.5> rotate y*163
        scale <2000,411,1110> 
        translate <-1575,0,1000>
}

// the room
difference{
        box{<-21,-1,-21><21,11,21>}//exterior
        union{
                box{<-20,-.1,-20><20,10,20>}//room cavity
                box{<-18,3,-22><18,9,22>}//window
                box{<-22,3,-18><22,9,18>}//window
        }
        
        pigment{color White}
}
// the floor
box{<-20,-1,-20><20,0,20>
        texture{White_Marble turbulence 1.45634}
        finish{Shiny}
}

// the lights
#declare Light=union{
        cylinder{<0,10,0>,<0,9,0>,.5 open}
        light_source{<0,9.5,0> color White
                looks_like{
                        sphere{ <0,0,0>,.2
                                pigment{color White} 
                                finish{ambient 1} 
                                no_shadow
                        }
                }
        }
        texture{Glass3}
}
object{Light}
object{Light translate <2,0,0>}
object{Light translate <-2,0,0>}

object{Light translate <-5,0,5>}
object{Light translate <-5,0,-5>}
object{Light translate <5,0,5>}
object{Light translate <5,0,-5>}

//desktop
#declare Grout = cylinder{<-100,0,0><100,0,0>,.02 pigment {color White} scale<1,.4,1>}
difference{
        box{<-5,3,-2><5,2.75,2>
                texture {
                        pigment{color Black}
                        normal{bumps .1 scale .2}
                        finish{phong 1 reflection .3}
                }
        }
        union{
                object{Grout translate<0,3,-1>}
                object{Grout translate<0,3,0>}
                object{Grout translate<0,3,1>}
        
                object{Grout rotate y*90 translate<-4,3,0>}
                object{Grout rotate y*90 translate<-3,3,0>}
                object{Grout rotate y*90 translate<-2,3,0>}
                object{Grout rotate y*90 translate<-1,3,0>}
                object{Grout rotate y*90 translate< 0,3,0>}
                object{Grout rotate y*90 translate< 1,3,0>}
                object{Grout rotate y*90 translate< 2,3,0>}
                object{Grout rotate y*90 translate< 3,3,0>}
                object{Grout rotate y*90 translate< 4,3,0>}
        }
}
//trim
// .01 bigger than the edge of the desk
union{
        box{<-5.1,2.74,-1.9><5.1,3.01,-2.1>}
        box{<-5.1,2.74,1.9><5.1,3.01,2.1>}
        box{<-5.1,2.74,-2.1><-4.9,3.01,2.1>}
        box{<5.1,2.74,-2.1><4.9,3.01,2.1>}
        texture {New_Brass}
}
//the base and legs
union{
        box{<-4.8,2.75,1.8><4.8,2.25,-1.8>}//underside
        box{<-4.8,2.75,-1.8><-4.5,0,-1.4>}
        box{<4.8,2.75,-1.8><4.5,0,-1.4>}
        box{<-4.8,2.75,1.8><-4.5,0,1.4>}
        box{<4.8,2.75,1.8><4.5,0,1.4>}

        texture {New_Brass}
}

object{BottleAndStand scale .15 translate y*3}
object{TheShip scale <.08,.043,.04> translate <-1,3.2,0>}

camera{location <2,4,-3.2> look_at<0,3,0>}
light_source{<-400,1000,30> color White}

