#include "dagger.inc"
#include "cross.inc"
#include "bowl.inc"

#declare face = union {
difference {
box { <-1,-1,0> <1,1.3,0.3> }

box { <-0.9,-0.9,-0.1> <0.9,1,0.1> }  //first level cut out

box { <-0.8,-0.8,-0.11> <0.8,1,0.2> } //second level cut out
box { <-0.2,-0.8,-0.21> <0.2,0.7,0.31> } //third level cut out
box { <-0.6,-0.8,-0.21> <0.6,0.2,0.31> } //third level cut out
cone { <0,0.6,0.19>, 0.4 <0,0.6,0.6>, 0 } //third level cone cut out
cone { <-0.4,0.2,0.19>, 0.4 <-0.4,0.2,0.6>, 0 } //third level cone cut out
cone { <0.4,0.2,0.19>, 0.4 <0.4,0.2,0.6>, 0 } //third level cone cut out

cylinder { <0.5,0.8,0.19> <0.5,0.8,0.31> 0.055 }  //upper right circles
cylinder { <0.6,0.8,0.19> <0.6,0.8,0.31> 0.055 }
cylinder { <0.525,0.7,0.19> <0.525,0.7,0.31> 0.055 }

cylinder { <-0.5,0.8,0.19> <-0.5,0.8,0.31> 0.055 } //upper left circles
cylinder { <-0.6,0.8,0.19> <-0.6,0.8,0.31> 0.055 }
cylinder { <-0.525,0.7,0.19> <-0.525,0.7,0.31> 0.055 }

texture { pigment { DMFWood5 }
         translate x*1.5
         rotate x*20
         scale 1.5 }
}

cylinder { <-0.8,-0.8,0.1> <-0.8,-0.8,0.3> 0.1 } //curved corner 2nd level
cylinder { <0.8,-0.8,0.1> <0.8,-0.8,0.3> 0.1 } //curved corner 2nd level


box { <-0.9,-1,0.29> <0.9,1.3,0.3>                 //backing board
     texture { pigment { DMFWood1 } 
      translate x*1 
       rotate x*15 
       scale 1.5 }
    }


   box { <-0.1,-0.7,0.2> <0.1,0.5,0.3> }       //cross
   box { <-0.4,0,0.2> <0.4,0.2,0.3> }


texture { pigment { DMFWood5 }
          translate x*1.5
          rotate x*20
          scale 1.5 } 
}

#declare back_panel = difference {
box { <-3.075,0,0> <3.075,0.6,0.15> }
box { <-3.025,-0.1,-0.1> <3.025,0.5,0.075> }  //first level cut out

#declare cutout = -2                       //cut out circles
   #while (cutout <= 2)
       cylinder { <cutout,0.325,0> <cutout,0.325,0.145>, 0.1 } 
       cylinder { <cutout - 0.06,0.175,0> <cutout - 0.06,0.175,0.145>, 0.1 } 
       cylinder { <cutout + 0.06,0.175,0> <cutout + 0.06,0.175,0.145>, 0.1 } 
       #declare cutout = cutout + 1
   #end
texture { pigment { DMFWood5 } scale 3 }   //scale up to scale down normal
}


#declare alter = union {
box { <-1,0.2,-0.8> <1,1,0> }       //alter 
object { face 
         scale 1/3
         translate <0,1/3 + 0.2,-0.9> }

object { face
         scale 1/3
         translate <-2/3,1/3 + 0.2,-0.9> }
object { face
         scale 1/3
         translate <2/3,1/3 + 0.2,-0.9> }

box { <-1.025,0.925,-0.925> <1.025,1,0> 
texture { pigment { DMFWood5 scale 0.75 } rotate x*15 } }           //table top

object { back_panel
         scale 1/3
         translate <0,1,-0.05> }
object { dagger
         rotate x*92
         rotate y*135
         translate <0.6,1.03,-0.3> } 
object { cross                      //cross
         scale 0.35
         translate <0,1,-0.06> }
object { bowl                       //blood filled bowl
         scale 0.5
         translate <-0.3,1.15,-0.6> }
texture { pigment { DMFWood5 } }
}