// Picture by Andreas Hirczy <ahi@sbox.tu-graz.ac.at>
// January 1996
//
// Modeled by inspiration of Ren Magrittes "La corde sensible" (1960)
// 

#include "colors.inc"
#include "textures.inc"


// Camera
camera {
	location	<  0, 0.5,-5>
	direction	<  0, 0  , 1>
	up		<  0, 1  , 0>
	right		<4/3, 0  , 0>
	look_at		<  0, 0.6, 0>
	angle		43
}

// Main light:
object {
        light_source { <0, 0, -10>
                color rgb <1, 1, 1>
        }
        rotate<50,60,0>
}


background { color SkyBlue }


// Underground:
plane { y, 0
	texture { 
		pigment { 
			bozo
			color_map{
			  [0.10 color Khaki]
			  [0.80 color SpringGreen]
			}
			scale 0.3
			quick_color NeonPink
		}
		normal { bumps 0.35  scale 0.3 }
	}
}

//Background:
height_field { png "hf01.png"
	smooth 
	translate <-0.5, -0.01, 0>
	scale <7, 0.7, 5>
	texture { 
                pigment {
                        gradient y
			turbulence 0.1
			octaves 2
                        color_map{
                          [0.2  color SpringGreen]
//                        [0.5  color ForestGreen]
                          [0.7  color MediumForestGreen]
                          [0.95 color Gray90]
                        }
			translate <-0.5, -0.01, 0>
			scale <7, 0.7, 5>
			quick_color NeonPink
                }
		normal { bumps 0.3  scale 0.3 }
	}
}

// points to keep orientation: lower and upper middle of glas
//sphere {<0,0,0> 0.02 pigment{ color Red } finish {ambient 1}}
//sphere {<0,1,0> 0.02 pigment{ color Red } finish {ambient 1}}


#include "cup_glas.inc"
#include "cloud.inc"
#include "trees.inc"


// some white boxes to reflect in glass
/*
box{ <-30,0,-6.1>,<30,30,-6> no_shadow
	texture { pigment { color White } finish  { ambient 1 }	}
	rotate <0,-50,0>
}
box{ <-5,0,-2.1>,<0,5,-2> no_shadow
	texture { pigment { color White } finish  { ambient 1 } }
	rotate <0,50,0>
}
*/




