// Glass Dice.
// Assembled by: Robert E. Bolin

#version 3.0
global_settings { assumed_gamma 2.2 }

//#include "debug.inc"
//#include "atmos.inc"
#include "chars.inc"
#include "colors.inc"
#include "finish.inc"
#include "glass.inc"
//#include "golds.inc"
#include "metals.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "shapesq.inc"
#include "skies.inc"
//#include "stars.inc"
//#include "stones.inc"
#include "textures.inc"
//#include "woods.inc"

//Original include files by Robert E. Bolin, TCG Software
#include "rebshapes.inc"

// Declarations Section
#declare BulbDist=80.0
#declare BulbPower=2

// Camera Placement
camera {
   location <0, 0, -15>
   direction <0, 0, 2.25>
   right x*4/3
   look_at <0,0,0>
}

// Lighting Placement

light_source {
  0*x
  color rgb <1,1,1>
  translate <0, 2000, 3000>
}

light_source {
  0*x
  color rgb <1,1,1>
  translate <0, 2000, -3000>
}

light_source {
  0*x
  color rgb <1,1,1>
  spotlight
  translate <10, -10, -10>
  point_at <0, 0, 0>
  radius 5
  tightness 50
  falloff 5
}

light_source {
  0*x
  color rgb <1,1,1>
  spotlight
  translate <-10, -10, -10>
  point_at <0, 0, 0>
  radius 5
  tightness 50
  falloff 5
}

light_source {
  0*x
  color rgb <1,1,1>
  spotlight
  translate <10, 10, 10>
  point_at <0, 0, 0>
  radius 5
  tightness 50
  falloff 5
}

light_source {
  0*x
  color rgb <1,1,1>
  spotlight
  translate <-10, 10, 10>
  point_at <0, 0, 0>
  radius 5
  tightness 50
  falloff 5
}

// Objects
sky_sphere {
  S_Cloud5
  rotate <0,35,0>
}

sphere {
  <0,-50000,0>
  49900
  texture {
    pigment {
      checker
        color rgbf <1,0,0,0>
        color rgbf <0,0,0,0>
      scale 150
    }
    finish {
      roughness .001
      phong 0.8
      brilliance 0.9
    }
    rotate <0,30,0>
  }
}

// Decahedron (10 sided) numbered dice
light_source {
  0*x
  color rgb <1,1,1>
  translate <2, 2, 2>
}
difference {

object {
  Decahedron
  texture {
    pigment {
      color rgbf <.6, .3, 1, .9>
    }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      refraction 1
      ior 1.5
      specular 1
      roughness .001
      phong 0.8
      brilliance 0.9
    }
  }
}

union {
  object {
    char_1
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,180,0>
  }
  object {
    char_3
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,108,0>
  }
  object {
    char_6
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,36,0>
  }
  object {
    char_9
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,-36,0>
  }
  object {
    char_4
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,-108,0>
  }
  object {
    char_7
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,72,0>
  }
  object {
    char_2
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,144,0>
  }
  object {
    char_5
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,-144,0>
  }
  object {
    char_8
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,-72,0>
  }
  object {
    char_0
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,0,0>
  }
  texture {
    pigment {color White}
    finish {F_MetalA}
  }
}
scale .75
rotate <0, 36, 0>
translate <2, 2, 2>
}

// Octahedron (8 sided) numbered dice
light_source {
  0*x
  color rgb <1,1,1>
  translate <-2, 2, 2>
}

difference {

object {
  Octahedron
  texture {
    pigment {
      color rgbf <1, 1, 0, .9>
    }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      refraction 1
      ior 1.5
      specular 1
      roughness .001
      phong 0.8
      brilliance 0.9
    }
  }
}

union {
  object {
    char_1
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,90,0>
  }
  object {
    char_6
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,180,0>
  }
  object {
    char_4
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,270,0>
  }
  object {
    char_7
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <35.26438968275,0,0>
  }
  object {
    char_5
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,90,0>
  }
  object {
    char_2
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,180,0>
  }
  object {
    char_8
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,270,0>
  }
  object {
    char_3
    scale .1
    translate -z*1.06
    translate -y*.2
    rotate <-35.26438968275,0,0>
  }
  texture {
    pigment {color White}
    finish {F_MetalA}
  }
}
scale .75
rotate <0, 45, 0>
translate <-2, 2, 2>
}

// Standard Cube (6 sided) spotted dice
light_source {
  0*x
  color rgb <1,1,1>
  translate <-2, -2, 2>
}

difference {

  superellipsoid {
    <.1,.1>
    texture {
      pigment {
        color rgbf <1, .5, 0, .9>
      }
      finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness .001
        phong 0.8
        brilliance 0.9
      }
    }
  }

union {
// 1 dot
  sphere {
    <0, 0, -1.61>
    .64
  }
// 2 dots
  sphere {
    <.5, 1.61, .5>
    .64
  }
  sphere {
    <-.5, 1.61, -.5>
    .64
  }
// 3 dots
  sphere {
    <1.61, 0, 0>
    .64
  }
  sphere {
    <1.61, .5, .5>
    .64
  }
  sphere {
    <1.61, -.5, -.5>
    .64
  }
// 4 dots
  sphere {
    <-1.61, .5, .5>
    .64
  }
  sphere {
    <-1.61, .5, -.5>
    .64
  }
  sphere {
    <-1.61, -.5, .5>
    .64
  }
  sphere {
    <-1.61, -.5, -.5>
    .64
  }
// 5 dots
  sphere {
    <0, -1.61, 0>
    .64
  }
  sphere {
    <.5, -1.61, .5>
    .64
  }
  sphere {
    <-.5, -1.61, .5>
    .64
  }
  sphere {
    <.5, -1.61, -.5>
    .64
  }
  sphere {
    <-.5, -1.61, -.5>
    .64
  }
// 6 dots
  sphere {
    <-.5, .5, 1.61>
    .64
  }
  sphere {
    <-.5, 0, 1.61>
    .64
  }
  sphere {
    <-.5, -.5, 1.61>
    .64
  }
  sphere {
    <.5, .5, 1.61>
    .64
  }
  sphere {
    <.5, 0, 1.61>
    .64
  }
  sphere {
    <.5, -.5, 1.61>
    .64
  }
  texture {
    pigment {color White}
    finish {F_MetalA}
  }
}

rotate <45, -45, 0>
translate <-2, -2, 2>
}


//Dodecahedron (12-sided) numbered dice
light_source {
  0*x
  color rgb <1,1,1>
  translate <2, -2, 2>
}

difference {

object {
  Dodecahedron
  texture {
    pigment {
      color rgbf <0, 0, 1, .9>
    }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      refraction 1
      ior 1.5
      specular 1
      roughness .001
      phong 0.8
      brilliance 0.9
    }
  }
}

union {

  object {
    char_1
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <90,0,0>
  }
  object {
    char_6
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,180,0>
  }
  object {
    char_9
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,108,0>
  }
  object {
    char_3
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,36,0>
  }
  object {
    char_8
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,-36,0>
  }
  object {
    char_1
    scale .075
    translate -x*.225
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,-108,0>
  }
  object {
    char_1
    scale .075
    translate x*.225
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <26.56505117708,-108,0>
  }
  object {
    char_1
    scale .075
    translate -x*.225
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <-90,0,0>
  }
  object {
    char_2
    scale .075
    translate x*.225
    translate -z*1.045
    translate -y*.15
    rotate <0,0,180>
    rotate <-90,0,0>
  }
  object {
    char_7
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,0,0>
  }
  object {
    char_4
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,-288,0>
  }
  object {
    char_2
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,-72,0>
  }
  object {
    char_1
    scale .075
    translate -x*.225
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,-216,0>
  }
  object {
    char_0
    scale .075
    translate x*.225
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,-216,0>
  }
  object {
    char_5
    scale .075
    translate -z*1.045
    translate -y*.15
    rotate <-26.56505117708,-144,0>
  }


  texture {
    pigment {color White}
    finish {F_MetalA}
  }
}

rotate <90, 0, 0>
rotate < 0, 0, 180>
translate <2, -2, 2>
}

//Icosahedron (20-sided) numbered dice
light_source {
  0*x
  color rgb <1,1,0>
}

difference {

object {
  Icosahedron
  texture {
    pigment {
      color rgbf <1, 1, 1, .9>
    }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      refraction 1
      ior 1.5
      specular 1
      roughness .001
      phong 0.8
      brilliance 0.9
    }
  }
}


union {

// Top Half of the Numbers
  object {
    char_1
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,0,0>
  }
  object {
    char_9
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,-72,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,-144,0>
  }
  object {
    char_7
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,-144,0>
  }
  object {
    char_5
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,144,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,72,0>
  }
  object {
    char_3
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <52.6625,72,0>
  }
  object {
    char_6
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,0,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,-72,0>
  }
  object {
    char_4
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,-72,0>
  }
  object {
    char_2
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,-144,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,144,0>
  }
  object {
    char_0
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,144,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,72,0>
  }
  object {
    char_8
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <10.8125,72,0>
  }

// Bottom Half of the Numbers
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,-180,0>
  }
  object {
    char_6
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,-180,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,-180,0>
  }
  object {
    char_1
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,-180,0>
  }
  object {
    char_4
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,-108,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,-108,0>
  }
  object {
    char_9
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,-108,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,-36,0>
  }
  object {
    char_2
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,-36,0>
  }
  object {
    char_7
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,-36,0>
  }
  object {
    char_2
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,36,0>
  }
  object {
    char_0
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,36,0>
  }
  object {
    char_1
    scale .05
    translate -x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,36,0>
  }
  object {
    char_5
    scale .05
    translate x*.15
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,36,0>
  }
  object {
    char_8
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <-10.8125,108,0>
  }
  object {
    char_3
    scale .05
    translate -z*1.02
    translate -y*.1
    rotate <-52.6625,108,0>
  }
  texture {
    pigment {color White}
    finish {F_MetalA}
  }
}

rotate <0, -36, 0>
}
