// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  El momento decisivo.
//--
// This file contains:
//  The decisive moment.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.

// 1 POVUnit = 1 cm

// Due to my "fast" computer and its current OS (486DX2-66 with DOS 6.2),
//  I have to reduce the quality of the scene. :(
// I hope to put Linux in line in a week ;)
//  (the HD crashed and I lost Linux). :(
// I would like to buy a new computer in the next months. :)
//  "Which one?" is the question. :?
// So in few time I hope to be able to render at high quality.
// Obviously if you have a fast computer, you can render this scene
//  after changing some values, just search "// #desired".


global_settings {
    assumed_gamma 2.4
    max_trace_level 10
}


#include "colors.inc"
#include "metals.inc"
#include "golds.inc"
background { White*.5 }


#declare T_Dice =
    texture {
        pigment { color rgbf <1, 0, 0, .85> }
        finish {
            reflection .01
            refraction 1
            ior 1.6
            phong .5
            phong_size 35
            caustics 2
            fade_distance 5
            fade_power 1
        }
    }

#declare T_Hole =
    texture {
        pigment { Gray90 }
        normal { granite .1 scale .1 }
    }


// Basic hole/point
#declare Hole =
    sphere {
        <0, 0, 0>, .2
        texture { T_Hole }
    }

// Groups
#declare GroupFace1 =
    object { Hole translate <0, -1, 0> }

#declare GroupFace2 =
    union {
        object { Hole translate <.5, 0, -.5> }
        object { Hole translate <-.5, 0, .5> }
        rotate 90*x
        translate <0, 0, 1>
    }

#declare GroupFace3 =
    union {
        object { Hole }
        object { Hole translate <.5, 0, -.5> }
        object { Hole translate <-.5, 0, .5> }
        bounded_by {
            box { <-1.1, -.21, -.21>, <1.1, .21, .21> rotate 45*y }
        }
        rotate -90*z
        translate <1, 0, 0>
    }

#declare GroupFace4 =
    union {
        object { Hole translate <-.5, 0, -.5> }
        object { Hole translate <.5, 0, -.5> }
        object { Hole translate <-.5, 0, .5> }
        object { Hole translate <.5, 0, .5> }
        bounded_by { box { <-.71, -.21, -.71>, <.71, .21, .71> } }
        rotate 90*z
        translate <-1, 0, 0>
    }

#declare GroupFace5 =
    union {
        object { Hole }
        object { Hole translate <-.5, 0, -.5> }
        object { Hole translate <.5, 0, -.5> }
        object { Hole translate <-.5, 0, .5> }
        object { Hole translate <.5, 0, .5> }
        bounded_by { box { <-.71, -.21, -.71>, <.71, .21, .71> } }
        rotate -90*x
        translate <0, 0, -1>
    }

#declare GroupFace6 =
    union {
        object { Hole translate <-.5, 0, -.5> }
        object { Hole translate <0, 0, -.5> }
        object { Hole translate <.5, 0, -.5> }
        object { Hole translate <-.5, 0, .5> }
        object { Hole translate <0, 0, .5> }
        object { Hole translate <.5, 0, .5> }
        bounded_by { box { <-.71, -.21, -.71>, <.71, .21, .71> } }
        translate <0, 1, 0>
    }

// Dice that renders fast
#declare FastDice =
    difference {
        box {
            -1, 1
            texture { T_Dice }
        }
        object { GroupFace1 }
        object { GroupFace2 }
        object { GroupFace3 }
        object { GroupFace4 }
        object { GroupFace5 }
        object { GroupFace6 }
    }

// Dice that renders slow, but with smooth edges
#declare SlowDice =
    difference {
        superellipsoid {
            <.2, .2>
            texture { T_Dice }
        }
        object { GroupFace1 }
        object { GroupFace2 }
        object { GroupFace3 }
        object { GroupFace4 }
        object { GroupFace5 }
        object { GroupFace6 }
    }

// Green cloth
#declare TableSurface =
    box {
        <-75, -10, -125>, <75, 0, 125>
        texture {
            pigment { rgb <.13, .46, .13> }
            finish {
                reflection .01
                specular .2
                roughness .1
                //phong .2
                //phong_size 5
            }
            normal {
                wrinkles .1
                scale <.1, .2, .1>
            }
        }
    }

// Wood, rest your hands here ;)
//#declare TableSideTop = not used

// Soft pyraminds, that are in the "wall"
#declare Pyramid =
    prism {
        conic_sweep linear_spline
        0, 1,    // Full pyramid
        5        // Four sides
        <.5, .5>, <-.5, .5>, <-.5, -.5>, <.5, -.5>, <.5, .5>

        rotate 90*x translate <0, 0, -1>    // Put against wall
        scale <1, 1, .4>                    // .4 units tall
        translate <.5, .5, 0>               // Realocate, needed for loops
    }

// Starting values for loops
#declare PosX = -75
#declare PosY = 0

// Lots of soft pyramids!
#declare TableSide =
    union {
        box { <-75, 0, 125>, <75, 25, 130> }

      #while (PosY < 25)       // (while#1) From 0 to 25
        #declare PosX = -75    // Reset
      #while (PosX < 75)       // (while#2) From -75 to 75

        object {
            Pyramid
            translate <PosX, PosY, 125>
        }
        #declare PosX = PosX + 1

      #end    // (while#1)
        #declare PosY = PosY + 1
      #end    // (while#2)

        texture {
            pigment { rgb <.13, .46, .13> }
            finish {
                specular .25
                roughness .05
            }
        }
    }

// White line
#declare WhiteLine =
    box {
        <-75, 0, -.25>, <75, .01, .25>
        texture {
            pigment { White }
            normal {
                wrinkles .1
                scale <.1, .2, .1>
            }
        }
    }

// Numbers
#declare Num100 =
    height_field {
        gif "100.gif"
        smooth
        water_level .001
        translate <-.5, 0, -.5>
        scale <6, .2, 6>
        texture { T_Silver_3C }
    }

#declare Num500 =
    height_field {
        gif "500.gif"
        smooth
        water_level .001
        translate <-.5, 0, -.5>
        scale <6, .2, 6>
        texture { T_Gold_3C }
    }

// Token$ $)
#declare YellowToken =
    union {
        difference {
            intersection {
                sphere { <0, 0, 0>, 2 scale <1, .5, 1> }
                cone { <0, -.2, 0>, 2.1, <0, .2, 0>, 2.1 }
            }
            cone { <0, .15, 0>, 1.75, <0, .21, 0>, 1.85 }
        }
        object { Num100 }
        texture {
            pigment { Yellow }
        }
    }

#declare BlueToken =
    union {
        difference {
            intersection {
                sphere { <0, 0, 0>, 2 scale <1, .5, 1> }
                cone { <0, -.2, 0>, 2.1, <0, .2, 0>, 2.1 }
            }
            cone { <0, .15, 0>, 1.75, <0, .21, 0>, 1.85 }
        }
        object { Num500 }
        texture {
            pigment { Blue }
        }
    }
       

// Put things
object {
    SlowDice
    rotate 90*y
    rotate -15*x rotate -10*z
    translate <3, 2, 2>
}
object {
    SlowDice
    rotate -30*y rotate 25*z
    translate <-2, 3, -1>
}
object { TableSurface translate <-25, 0, -115> }
object { TableSide translate <-25, 0, -115> }
object { WhiteLine translate <-25, 0, -2.5> }
object { YellowToken rotate -95*y translate <0, .6, -7.5> }
object { BlueToken rotate 95*y translate <1.5, .2, -6.5> }


light_source { <0, 100, -100> Gray90 }
light_source {
    <0, 100, -100> White*.6
    spotlight
    point_at <.5, 2.5, .5>
    radius 5*.5
    falloff 20*.5
    area_light <20, 0, 0>, <0, 0, 20>, 5, 5    // #desired 17, 17
    adaptive 0    // #desired none or maybe 2
    jitter
}

camera {
    right <16/9, 0, 0>
    up <0, 1, 0>
    location <0, 6, -30>
    look_at <0, 2, 0>
    angle 25
    rotate -65*y

    aperture .5
    focal_point <.5, 2.5, .5>
    blur_samples 7     // #desired 37
    confidence .6      // #desired .975
    variance 1/64      // #desired 1/255
}


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
