// File: heartgls.pov
// Vers: 3
// Desc: Heart of Glass: Breakup Postanalysis
// Date: 26-Jan-96
// Auth: SjG

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// Include the massive file to construct The Depressed Guy.
#include "dg2.inc"


// Some cameras
#declare StdCam = camera
	{
	location  <0.0, 0, -6.0>
	direction 2.0*z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}

#declare ZoomCam = camera
	{
	location  <3.0, 0, -4.0>
	direction 2.0*z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}


// and lights
#declare mainLight = light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <-100,15,-80>
}

#declare spotLightOne = light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1, 0.89>
  spotlight
  translate <6, 5, -10>
  point_at <-1.5,-1,0>
  radius 6 
  tightness 20
  falloff 12 
}

#declare spotLightTwo = light_source
{
  0*x                     // light's position (translated below)
  color rgb <0.7, 0.7, 0.683>
  spotlight
  translate <1, 15, -1>
  point_at <0, 0, 0>
  radius 2
  tightness 20
  falloff 8
}

// and some textures...

#declare crystalGlass = texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
	finish {
		ambient 0.1
		diffuse 0.1
		reflection .15
		refraction 1
		ior 1.4
		specular 1
		roughness 0.001
		irid
			{
			0.03
			thickness 0.2
			turbulence 0.7
			}
		}
}

#declare windowGlass = texture {
    pigment { color rgbf <0.88, 0.88, 0.88, 0.8> }
	finish {
		ambient 0.1
		diffuse 0.1
		reflection 0
		refraction 1
		ior 1.4
		specular 1
		roughness 0.001
		irid
			{
			0.03
			thickness 0.2
			turbulence 0.7
			}
		}
}

#declare dullCloud =
pigment {
    wrinkles
    turbulence 0.77
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgb <0.78, 0.25, 0.37>
                    color rgb <0.50, 0.20, 0.12>]
        [0.1, 0.5   color rgbt <0.50, 0.20, 0.12, 0>
                    color rgbt <0.1258, 0.1258, 0.2435, 0.2>  ]
        [0.5, 1.001 color rgbt <0.1258, 0.1258, 0.2435, 0.2>
                    color rgbt <0.1258, 0.1258, 0.2435, 0.5> ]
    }
    scale <6, 1, 6>
}
#declare darkerCloud =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color rgb <0.01, 0.01, 0.01>
                    color rgb <0.12, 0.12, 0.125>]
        [0.1, 0.5   color rgbt <0.12, 0.12, 0.125, 0>
                    color rgbt <0.184, 0.184, 0.309, 0.3> ]
        [0.5, 1.001 color rgbt <0.184, 0.184, 0.309, 0.3>
                    color rgbt <0.1, 0.1, 0.2, 0.3>]
    }
    turbulence 0.6
    octaves 6
    omega 0.71
    lambda 2.2
    scale <6, 4, 6>
}

// The following definition is tweaked from Grnt6 from stones.inc,
// among other things...

#declare StonyLand =
texture{
	pigment
 		{
		granite
  		turbulence 0.65
		color_map
		{[0.000, 0.153   color rgbf <0.545, 0.380, 0.345, 0.000>
			color rgbf <0.588, 0.475, 0.333, 0.000>]
		[0.153, 0.398   color rgbf <0.588, 0.475, 0.333, 0.000>
			color rgbf <0.675, 0.478, 0.404, 0.000>]
		[0.398, 0.559   color rgbf <0.675, 0.478, 0.404, 0.000>
			color rgbf <0.757, 0.635, 0.522, 0.000>]
		[0.559, 0.729   color rgbf <0.757, 0.635, 0.522, 0.000>
			color rgbf <0.659, 0.549, 0.443, 0.000>]
		[0.729, 1.001   color rgbf <0.659, 0.549, 0.443, 0.000>
			color rgbf <0.545, 0.380, 0.345, 0.000>]
		}
		scale <1.5, 3, 2> rotate <0, 0, 40>
	}
	finish{diffuse 0.5}
  	normal { agate 0.5 scale <0.2, 2, 0.2> }
}

// Predefine a sky sphere. Why not just use it? I dunno.
#declare twilitSky =
sky_sphere {
	pigment {
		granite
		frequency 1.18
		turbulence 0.25
		color_map {
        [0.01	color Blue]
		[0.04	color White]
        [0.041	color Black]
    	}
	scale <0.025,0.025,0.025>
	}
   pigment {
		gradient y
			pigment_map {
				[0.01 rgbt <0.23, 0.1, 0.2, 0.001> ] // horizon
				[0.25 dullCloud scale 0.25 rotate z*5]
				[0.60 darkerCloud scale <0.25, 0.15, 0.25> rotate z*10]
		}
    }
}


// Some height fields: mountains, and fracture cracks
#declare distantMountains = height_field
	{
	tga "mountrange.tga"
	smooth
	translate <-0.5,0,-0.5>
   	scale <-200,15, 200>
	rotate <0,5,0>  //85
	translate <0,-5,30>  // -100, -5, 30
   	texture {StonyLand scale <10,10,10>}
}

#declare theCracks = height_field
	{
	gif "shatter1.gif"
	smooth
	water_level 0.01
	translate <-0.5, -0.5, -0.5>
	rotate <90,0,0>
	scale <2,2,3>
}

// Minor adjustments on the DXF guy.
#declare depressedGuy = object {
    theGuy rotate <0,180,0> scale <5,5,5> translate <0, -2, 0>
texture {windowGlass}
}

// declared here, so I can change it to an irregular shape
// at some later date
#declare poppedCone = cone
{
  <0,0,0>,0.0, <0,0,1>, 2.0
}


// Front portion
#declare brokenHeart1 = difference
	{
	// polynomial equasion for a heart-shape
	// taken from scene by Tore Nordstrand (tore@maxwell.fi.uib.no)
	poly { 6, <8, 0, 0, 0, 12, 0, 0, 12, 0, -12, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 12, 0, -12, 0, 0, 0, 
	0, 6, -0.1, -12, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 0, 
	-3, 0, 0, 0, 0, 3, -1, -6, 0, 3, 0, 0, 0, 0, 0, 0, 
	1, 0, -3, 0, 3, 0, -1>
	sturm
	rotate <0,90,0>
	rotate <0,0,90>
	scale <0.8,0.8, 0.7>
	translate <0,1,0> // to help with bug?
	}
	object {poppedCone scale <3,3,3> translate <0.25, 1.15, 0>}
	object {theCracks translate <0.25, 1.15, 0>}
	translate <0,-1,0> // see above.
 }


// Back portion
#declare brokenHeart2 = intersection
	{
	// polynomial equasion for a heart-shape
	// taken from scene by Tore Nordstrand (tore@maxwell.fi.uib.no)
	poly { 6, <8, 0, 0, 0, 12, 0, 0, 12, 0, -12, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 12, 0, -12, 0, 0, 0, 
	0, 6, -0.1, -12, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 0, 
	-3, 0, 0, 0, 0, 3, -1, -6, 0, 3, 0, 0, 0, 0, 0, 0, 
	1, 0, -3, 0, 3, 0, -1>
	sturm
	rotate <0,90,0>
	rotate <0,0,90>
	scale <0.8,0.8, 0.7>
	translate <0,1,0> // to help with root solving bug.
	}
	object {poppedCone scale <3,3,3> translate <0.25, 1.15, 0>}
	translate <0,-1,0> // see above.
 }


// The heart
#declare brokenHeart = union {
	object {brokenHeart1}
	object {brokenHeart2 translate <0,0,0.2>}
	texture {crystalGlass}
}


// The analysis station (billboard?)
#declare measureWall = box {
	<-3.15,-14.8,0>,<3.15,-2.4,0.2>
	texture  {pigment{ image_map { gif "grid.gif" }} scale <4,4,4>}	
}

#declare pictWall = box
	{<-3.15,-2.4,0>, <3.15,2.4,0.2>
	texture  {pigment{ image_map { gif "depress.gif"  once}
			translate <-0.5, -0.5, 0>}
			scale <-6.3, 4.8, 1>}	
}

// ----------------
// And now for the actual scene...
// ----------------
sky_sphere{twilitSky}
camera{StdCam}
object{mainLight}
object{spotLightOne}
object{spotLightTwo}

object {brokenHeart}
object {measureWall translate <7.5,4.5,28>}
object {pictWall translate <7.5,4.5,28>} // 19.8
object {distantMountains}
object {depressedGuy scale <-0.5, 0.5, 0.5> rotate <0,-20,0> translate <-1.5,-1,0>}


