// mountain.tga creator script 2. SjG 1997.
// This creates fairly jagged peaks with nice valleys.
//
// For good results, render into something like a 500x200 rectangle.
//
#include "colors.inc"

#declare hotWhite = color rgb <2,2,2>

camera {
  location  <35, 20, -70>
  direction <0, 0, 1>
  up        <0, 1, 0>
  right     <1, 0, 0>
  look_at   <35, 20, 0>
}

light_source {<0,5,-15>
			color White
              spotlight
              point_at <28, 39,2>
              radius 15
              falloff 30
              tightness 50 }

light_source {<34,0,-8>
			color White
              spotlight
              point_at <34,30,-2>
              radius 15
              falloff 30
              tightness 50 }

light_source {<50,-23,-8>
			color White
              spotlight
              point_at <48,30,-2>
              radius 15
              falloff 30
              tightness 50 }

light_source {<60,-5,-15>
			color White
              spotlight
              point_at <60,30,-2>
              radius 15
              falloff 30
              tightness 50 }

light_source {<70,20,-8>
			color hotWhite
              spotlight
              point_at <50,35,-2>
              radius 15
              falloff 30
              tightness 50 }

light_source {<75,25,-8>
			color White
              spotlight
              point_at <55,40,-2>
              radius 15
              falloff 30
              tightness 50 }

/*
// Frame Reference
sphere{<0,0,0>,1 texture {pigment{color Red} finish {ambient 1}}}
sphere{<0,40,0>,1 texture {pigment{color Red} finish {ambient 1}}}
sphere{<70,0,0>,1 texture {pigment{color Red} finish {ambient 1}}}
sphere{<70,40,0>,1 texture {pigment{color Red} finish {ambient 1}}}
*/

plane { -z, 0
  pigment {
	bozo
	turbulence 0.6 // 0.4 // 0.3
	color_map {
	   [0.0 rgbt <0,0,0,1> ]
	   [0.4 rgbt <0,0,0,1> ]
	   [1.001 rgbt <0.8,0.8,0.8,0.1>]
	}
	scale <8,5,5>
	rotate <0,0,36>
  }
   finish { ambient 0.1 specular 0.9 reflection 0 }

}

plane { -z, 0.01
  pigment {
	marble
	turbulence 0.6 // 0.4 // 0.3
	color_map {
	   [0.0,	0.8 color Gray30 color Gray80]
	   [0.8,	1.001 color Gray90 color White]
	}
	scale <16,5,1>
	rotate <0,0,-36>
  }
   finish { ambient 0.1 specular 0.9 reflection 0 }

}
