#declare SIZE=6
#declare XF=20
#declare YF=50
#declare ZF=20
//scaling factors
#declare R=seed(1303)

mesh {
#declare Count=0
#while ( Count < 4000 )
// 4000 triangles
  triangle { 
#declare X=rand(R)*2-1.5
#declare Y=rand(R)*2-1
#declare Z=rand(R)*2-1
// X,Y and Z in a box
<X,Y,Z>,
<X+(rand(R)*2-1)/(XF*SIZE),Y+(rand(R)*2-1)/(YF*SIZE),Z+(rand(R)*2-1)/(ZF*SIZE)>,
<X+(rand(R)*2-1)/(XF*SIZE),Y+(rand(R)*2-1)/(YF*SIZE),Z+(rand(R)*2-1)/(ZF*SIZE)>
}
#declare Count=Count+1
#end

  scale <XF,YF,ZF>
  rotate <0,0,-18.43>
  translate <680,-585,ZF>  
  texture { 
    pigment { 
      color rgbf <.9,.9,.92,.1> 
    }
    finish {
      ambient 1
      metallic
    } 
  }
}

#include"textures.v2"


sphere { // Sphere002
  <0,0,0>,1
  texture {
    pigment { color rgbt <1,1,1,1> }
  }
  hollow
  halo {
    attenuating
    linear
    spherical_mapping
    turbulence 3.5
    color_map {
      [ 0.0 color rgbt <1,1,1,1> ]
      [ 0.7 color rgbt <1,1,1,-.6>]
      [ 1.0 color rgbt <.5,.5,1,-1> ]
    }
    translate <0,0,-.05>
    scale <.3,.3,.07>
  }
  halo {
    attenuating
    linear
    spherical_mapping
    turbulence .3
    color_map {
      [ 0.0 color rgbt <0,.45,.45,1> ]
      [ 0.7 color rgbt <0,.40,.45,-1> ]
      [ 1.0 color rgbt <0,.40,.45,-1> ]
    }
    translate <0,0,-.05>
    scale <.5,.5,.15>
  }
  halo {
    attenuating
    linear
    spherical_mapping
    turbulence 3
    color_map {
      [ 0.0 color rgbt <1,1,1,1> ]
      [ 0.7 color rgbt <1,1,1,-.6>]
      [ 1.0 color rgbt <.7,.7,1,-1> ]
    }
    translate <0,0,-.05>
    scale <.35,.55,.06>
  }
  scale <0.777799, 3.047519, 1.0>
  rotate 30.0*z
  translate  <694.0, -596.2, 0.0>
}


sphere { // Halocontainer1
  <0,0,0>,1
  pigment { color rgbt <1,1,1,1> }
  hollow
  halo {
    attenuating
    linear
    spherical_mapping
//    samples 20
    turbulence .3
    color_map {
      [ 0.0 color rgbt <0,.45,.45,1> ]
      [ 0.7 color rgbt <0,.40,.45,-1> ]
      [ 1.0 color rgbt <0,.40,.45,-1> ]
    }
    translate <0,0,-.05>
    scale <.5,.5,.15>
  }
  halo {
    attenuating
    linear
    spherical_mapping
//    samples 20
    turbulence 3.5
    color_map {
      [ 0.0 color rgbt <1,1,1,1> ]
      [ 0.7 color rgbt <1,1,1,-.6>]
      [ 1.0 color rgbt <.5,.5,1,-1> ]
    }
    translate <0,0,-.05>
    scale <.3,.3,.07>
  }
  scale <1,1,.5>
  translate  <694.95, -597.7, 0>
}

background { color <0.81,0.80,.82> } 
sphere { //lucht
  <0,0,0>,1
  hollow
  texture {
    pigment { 
      wrinkles 
      turbulence 0.9
      octaves 6 
      omega 0.7 
      lambda 2 
      color_map { 
        [0.0   color rgbf <.9,.95,.9,.3>] 
        [0.3   color rgbf <.7,.7,.7,.4>]
        [0.5   color rgbf <0.9, 0.9, 0.9,.5>]
        [0.7   color rgbf <0.6, 0.6, 0.6,.3> ] 
        [1.0   color rgbf <0.6, 0.6, 0.6,.3> ] 
      } 
    }
    finish { ambient .7 }
  }
  scale <50000,50000,2000>
  translate <384,-384,-1000>
}

#declare Binnenindeonderzeeboot = 
pigment {
  color rgb <.6,.4,.4>
}

#declare Rubber = pigment { color .3 }
#declare Glass = texture { Glass3 }
#declare IJzer = texture { 
  Brass_Texture 
  pigment { color rgb <.5,.5,.6> }
  finish { irid { .35 thickness .45 turbulence 1.1 } }
  scale .01
  translate <0,0,-1> 
}

#declare IJS = texture {
   pigment {
     color rgbf<0.9, 0.95, 1.000, 0.3>
   }
   normal {
     crackle 1.0000
     turbulence .200
//     omega 2.000
//    lambda 0.500
   }
   finish {
     diffuse 0.330
     ambient .5
     reflection 0.100
     specular 0.300
     roughness 0.000100
   }

}

#declare Water1 = texture {
   pigment {
     color rgbf<0.550, 0.650, .700, 0.800>
   }
   normal { 
     ripples 1.0
     frequency 20.000 
   } 
   finish {
     reflection 0.200
     ior 1.330
   }
   scale <2,4,1>
}

