/*
  Items of Glass (and other materials too)
  By Smilodon, 1997
  Created for IRTC, Jan-Feb 1997
  Standard IRTC disclaimers/copyrights apply.
  
  Feel free to use the objects, as long as I'm credited in 
  the scene file.
  */

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"

global_settings {
  assumed_gamma 2.2
  adc_bailout 1/64    
  max_trace_level 10
    // was 25 for the competition image
}

#declare GTexture = 
texture { Glass3 }

/* quick or alternate textures */
// texture { pigment { color Yellow } finish { Phong_Shiny }}
// texture { pigment { color rgbf < 1,1,1,0.9 > } }

#declare GTexture2 = 
texture { NBglass }

/* same here. */ 
// { GTexture finish { Phong_Shiny ior 1.3 }}
// texture { pigment { color Red } finish { Phong_Shiny }}

#declare GTexture3 = 
texture { Green_Glass }
/* and more. */
// texture { pigment { color Cyan } finish { Phong_Shiny }}

/* Inside_texture - the liquid inside the bottle.
   the threshold between Copper and Clear controls the
   surface height of the liquid. 
*/

#declare Inside_texture = texture { 
   pigment { 
     gradient y 
       scale 21
       color_map { 
       [ 0 Copper filter 0.4 ]
       [ 0.7 Copper filter 0.4  ]
       [ 0.7 Clear ]
       [ 1 Clear ]
     }
   }
   finish {	
     ior 1.2
       }	
}	

#declare tinyobject = object { 
   Pyramid 
   translate 2*y
   scale 1 - 0.5 * y
   rotate -90*x+45*z 
   scale sqrt(2)
 }

/* These #whiles would probably have been better to put 
   into a nested #while, but here they are. 
   */

#declare p_row = object {
  merge {
    #declare N = 0
    #while (N < 4)
    object { tinyobject translate (2+N*4)*x }
    object { tinyobject translate (2+N*4)*x translate <2,2,0> }
    #declare N = N + 1
    #end
     object { tinyobject translate (2+N*4)*x } // fifth.
    texture { GTexture }
  }
}

#declare p_plate = object {
  merge {
    #declare N = 0
    #while (N < 4)
    object { p_row scale <1,10/9,1> translate (N*4+2)*y*10/9 }
    #declare N = N + 1
    #end
    box { <0,0,1>,<20,20,-1> }
    texture { GTexture }
  }
  translate <-10,-10,0 >
}

// test object

/*
#declare p_plate =
box { 
  <-10,-10,1>,
  <10,10,-1> 
  pigment { color White }
}
*/

/* Bottom of the carafe */

/* Why bother do cumbersome calculations when we have the parser? */

#declare d = tan(20/180*pi) * 5 * y

#declare bottom_section =  
intersection {
  box {  
    <-6,-0.5,0>,<6,0.5,6> 
    texture { GTexture} 
    rotate 20*x
  }
  plane { -x-z,0 }
  plane { x-z,0 }
  translate d
    }

#declare bottom = intersection {
  merge {
    object { bottom_section }
    object { bottom_section rotate 90*y }
    object { bottom_section rotate 180*y }
    object { bottom_section rotate 270*y }
    cylinder { d,<5,0,5> ,0.51 }
    cylinder { d,<5,0,-5>,0.51 }
    cylinder { d,<-5,0,5>,0.51 }
    cylinder { d,<-5,0,-5>,0.51 }
    texture { GTexture }
  }
  box { -5,5 texture { GTexture }}
}

#declare bottom_isection =
intersection {
  box { 
    <-6,-0.5,-4>,<6,5,6>
    texture { Inside_texture }
    rotate 20*x
      }
  plane { -x-z,0 }
  plane { x-z,0}
  translate d 
}

/* Inside of the carafe - liquid */

#declare inside = intersection {
  merge {
    object { bottom_isection }
    object { bottom_isection rotate 90*y }
    object { bottom_isection rotate 180*y }
    object { bottom_isection rotate 270*y }
    box { <-6,21,-6>,d+<6,0,6> }
    texture { Inside_texture }
  }
  box { <-5,-1,-5>,<5,20,5> texture { Inside_texture }}
  hollow
}

/* Top of the carafe - pyramid and bottleneck */

#declare d2 = tan(35/180*pi) * 5 * y

#declare top_section = intersection {

  box { 
    <-5,-0.5,0>, <6,.5,6> 
    texture { GTexture } 
    rotate 35*x 
  }
  plane { -x-z,0 }
  plane { x-z,0 }
  translate d2 
}
    
#declare top_csg = intersection {
  merge {
    object { top_section }
    object { top_section rotate 90*y }
    object { top_section rotate 180*y }
    object { top_section rotate 270*y }
    cylinder { d2,<5,0,5> ,.51}
    cylinder { d2,<5,0,-5>,.51 }
    cylinder { d2,<-5,0,5>,.51 }
    cylinder { d2,<-5,0,-5>,.51 }
    texture { GTexture }
  }
  box { -5,5 texture { GTexture }}
}

#declare Bottleneck = merge {
  cylinder { 5*y,4*y,2.5 }
  cylinder { 4*y,-y,1.6 }
  texture { GTexture }
}

/* The top of the bottle has a hole through it, of course. */

#declare Top = 
difference {
  union {
    object { top_csg }
    object { Bottleneck translate d2 }
  }
  merge {
    cone { 5.1*y,1.5,3*y,1 }
    cylinder { 3*y,-y,1 }
    texture { GTexture }
    translate d2*y
  }
}

/* Here's the funky bottle, framed with cylinders and spheres. */

#declare Carafe = union {
  object { bottom translate -0.4*y }
  object { p_plate scale <.5,1,1> translate 10*y-5*z }
  object { p_plate scale <.5,1,1> translate 10*y-5*z rotate 90*y }
  object { p_plate scale <.5,1,1> translate 10*y-5*z rotate 180*y }
  object { p_plate scale <.5,1,1> translate 10*y-5*z rotate 270*y }
  cylinder { < 5,20, 5>,< 5,0, 5>,1 texture { GTexture } }
  cylinder { <-5,20, 5>,<-5,0, 5>,1 texture { GTexture } }
  cylinder { < 5,20,-5>,< 5,0,-5>,1 texture { GTexture } }
  cylinder { <-5,20,-5>,<-5,0,-5>,1 texture { GTexture } }
  cylinder { < 5,0, 5>,<-5,0, 5>,1 texture { GTexture }}
  cylinder { <-5,0, 5>,<-5,0,-5>,1 texture { GTexture }}
  cylinder { <-5,0,-5>,< 5,0,-5>,1 texture { GTexture }}
  cylinder { < 5,0,-5>,< 5,0, 5>,1 texture { GTexture }}
  cylinder { < 5,20, 5>,<-5,20, 5>,1 texture { GTexture }}
  cylinder { <-5,20, 5>,<-5,20,-5>,1 texture { GTexture }}
  cylinder { <-5,20,-5>,< 5,20,-5>,1 texture { GTexture }}
  cylinder { < 5,20,-5>,< 5,20, 5>,1 texture { GTexture }}
  sphere { < 5,0, 5>,1 texture { GTexture }}
  sphere { <-5,0, 5>,1 texture { GTexture }}
  sphere { < 5,0,-5>,1 texture { GTexture }}
  sphere { <-5,0,-5>,1 texture { GTexture }}
  sphere { < 5,20, 5>,1 texture { GTexture }}
  sphere { <-5,20, 5>,1 texture { GTexture }}
  sphere { < 5,20,-5>,1 texture { GTexture }}
  sphere { <-5,20,-5>,1 texture { GTexture }}
  object { Top translate 20.5*y }
  object { inside }
}

/* The cap of the carafe, just a rather simple CSG. 
   Some of the details of this remain unseen in the scene though.
   */

#declare Cap = merge {
  cone { 5.1*y,1.5,3*y,1 }
  intersection { 
    object { Hyperboloid_Y scale 0.7 }
    cylinder { -0.5/0.7 *y,1.5*y,1.5 }
    scale <1.1,0.7,1.1>
    translate 5.6*y 
  }
  cylinder { 12*y,15*y,0.4 }
  sphere { 9*y,3 }
  sphere { 15*y,1 }
  sphere { 14*y,0.7 }
  sphere { 12*y,0.7 }
  texture { GTexture }
  translate -9*y
 }

/* The bottle in the grip - Yeah, it is a blob. */

#declare Bottle = union {
  intersection {
    difference {
      blob {
	sphere { 0,6,1 }
	cylinder { 0,10*y,2,1 }
	threshold 0.1
	  texture { GTexture2 }
      }
      
      blob {
	sphere { 0,5.8,1 }
	cylinder { 0,10*y,1.8,1 }
	threshold 0.1
	  texture { GTexture2 }
      }
    }
    cylinder { -7*y ,10*y ,7 texture { GTexture2 }}
  }
  torus { 1.8,0.2 translate 10*y texture { GTexture2 }}
}

/* The ugly brown-speckled blue texture. */

#declare Painted_Steel = 
texture {
  pigment {
    granite
      turbulence 0.4
      color_map { 
        [ 0 SteelBlue ]
	[ 0.6 SteelBlue ]
	[ 0.7 Sienna ]
	[ 1.0 Sienna ]  
	}
  }
  finish {
    Phong_Shiny
    reflection 0.2
      }
}

/* Yeah, I cheated here - the screw isn't really a screw. 
   Though I don't think anyone will notice anything.
 */

#declare Screw = 
union {
  merge {
    cone { 0,1,2*y,0.3 }
    sphere { 2*y,0.3 }
    intersection {
      merge {
	cone { <-1,2,0>,0.8,0,0.6 }
	sphere { <-1,2,0>,0.8 }
	cone { <1,2,0>,0.8,0,0.6 }
	sphere { <1,2,0>,.8 }
      }
      box { <-5,5,-0.2>,<5,0,0.2> }
    }
    cylinder { 0,0.3*y,1.1 }
    texture { pigment { color Gray80 } finish { Metal } }
  }
  merge {
    #declare N = 0
    #while (N < 20)
    cone { -y*N/10,0.7,-y*(N+1)/10,0.6 }
    cone { -y*(N+1)/10,0.6,-y*(N+2)/10,0.7 }
    #declare N = N +2
    #end
    cone { -y*2,0.5,-y*2.6,0.1 }
    texture { Chrome_Metal }
  }
}

#declare Footing = 
union {
  merge {
    box { <-6,1,-10>,<6,0,10> }
    box { <-7,0,-11>,<7,-1,11> }
    cylinder { <-6,0, 10>,< 6,0, 10>,1 }
    cylinder { < 6,0,-10>,< 6,0, 10>,1 }
    cylinder { <-6,0,-10>,< 6,0,-10>,1 }
    cylinder { <-6,0,-10>,<-6,0, 10>,1 }
    sphere { <-6,0, 10>,1 }
    sphere { <-6,0,-10>,1 }
    sphere { < 6,0, 10>,1 }
    sphere { < 6,0,-10>,1 }
    cone { <-6,1,-10>,1,<-6,-1,-10>,2 }
    cone { < 6,1,-10>,1,< 6,-1,-10>,2 }
    cone { <-6,1, 10>,1,<-6,-1, 10>,2 }
    cone { < 6,1, 10>,1,< 6,-1, 10>,2 }

    cone { 7*z,3,7*z+4*y,2 }
    texture { Painted_Steel }
  }
  object { Screw rotate -90*z rotate 30*x translate <3.5,3,7> }
  cylinder { 7*z,<0,30,7>,1 texture { Chrome_Metal }}
  translate y-7*z
}

/* This is the thingy that holds the grip and the bar. */

#declare Holder_section = 
difference {
  cylinder { -0.5*y,0.5*y,1 texture { Painted_Steel }}
  merge { 
    cylinder { -y*2,y*2,0.5 }
    box { <-.5,-1.5,0>,<.5,1.5,2> rotate 30*y }
    texture { Painted_Steel }
  }
  scale 2
}

#declare Holder = 
union {
  object { Holder_section }
  object { Screw rotate -90*z translate 3.5*x rotate -55*x }

  object { Holder_section rotate 90*x+180*z translate -6*x }
  object { Screw rotate 90*z translate -8.5*x rotate 44*x }

  cylinder { -2*x,-4*x,1.2 texture { Painted_Steel }}
  sphere { -2*x,1.2 texture { Painted_Steel }}
  sphere { -4*x,1.2 texture { Painted_Steel }}
}

#declare Holder_width = -6*x 

// The one centered at 0 is for the vertical bar.

/* Another ugly texture - Matta gray paint. 
   But that's what they use on labware, anyway.
 */

#declare Dull_Iron = 
texture {
  pigment { color Gray45 }
  finish { Phong_Dull }
}

/* The jaws that bite, the claws that catch! 
   Once again, more details that will be visible 
   within the scene.
 */

#declare Grip = 
union {
  // oriented Y-axis, grip up.
  cylinder { -15*y,0,1 texture { Chrome_Metal }}
  merge {
    cylinder { -y,y,1.2 scale 1+x }
    cylinder { x,x+6*y,0.5 }
    cylinder { 0.5*x,-0.5*x,0.7 translate 3.5*y-x }
    cylinder { 0.7*x,-0.7*x,0.7 translate 3.5*y+x }
    cylinder {-x+2*y,-x+6*y,0.5 }
    cylinder { 2*y+x,2*y-x,0.5 }
    box { -1,1 scale 0.7 translate 2*y+x }
    box { -1,1 scale 0.6 translate 2*y-x }
    sphere { <-1,2,-0.4>,0.4 }
    sphere { <-1,2,0.4>,0.4 }
    texture { Dull_Iron }
  }
  cylinder { 
    1.5*x,-0.7*x,0.65*0.8 
    translate 3.5*y 
    texture { 
    pigment { 
      gradient x 
      scale 0.1 
      color_map { [ 0 Gray25 ] [ 1 Gray65 ] }
    }
    finish { Metal }
    }
  }
  difference {
    cylinder { -z,z,2.6 texture { Dull_Iron }}
    merge {
      cylinder { -2*z,2*z,2.1 }
      box { <-0.5,-5,-5>,<0.5,5,5> }
      texture { Dull_Iron }
    }
    translate 8*y
  }
  difference {
    cylinder { -0.8*z,0.8*z,2.1 texture { Cork }}
    merge {
      cylinder { -z,z,1.8 }
      box { <-0.5,-5,-5>,<0.5,5,5> }
      texture { Cork }
    }
    translate 8*y
  }
  object { Screw rotate 90*z scale 0.8 translate -2.6*x+3.5*y }
  rotate -90*x // re-align to Z axis, jaws forward.
}

#declare Grip_xlat = -8*z

/* This is a very complicated object. */

#declare Plug = 
cone { 
  0,1.5,4*y,2.5 
    pigment { color Gray40 }
}

/* This thing looks nice, but doesn't view so well in the scene.
   But then, which does?
   */

#declare Distiller = 
union {
  difference {
    merge { 
      cylinder { -10*x,10*x,2 }
      sphere { -10*x,2 }
      sphere { 10*x,2 }
      texture { GTexture2 }
    }
    merge {
      cylinder { -9.8*x,9.8*x,1.8 }
      sphere { -9.8*x,1.8 }
      sphere { 9.8*x,1.8 }
      texture { GTexture2 }
    }
  }
  difference {
    cylinder { <9,2,0>,<9,5,0>,0.3 texture { GTexture2 }}
    cylinder { <9,2,0>,<9,5,0>,0.25 texture { GTexture2 }}
  }
  difference {
    cylinder { <-9,2,0>,<-9,5,0>,0.3 texture { GTexture2 }}
    cylinder { <-9,2,0>,<-9,5,0>,0.25 texture { GTexture2 }}
  }
  difference { 
    blob {
      #declare N = -3
      #while (N < 4)
      sphere { N*3*x,1.7,0.5 }
      #declare N = N + 1
      #end
      cylinder { -12*x,12*x,0.5,0.5 }
      threshold 0.1
      texture { GTexture2 }
    }
    blob {
      #declare N = -3
      #while (N < 4)
      sphere { N*3*x,1.6,0.5 }
      #declare N = N + 1
      #end
      cylinder { -12*x,12*x,0.4,0.5 }
      threshold 0.1
      texture { GTexture2 }
    }
  }
  difference {
    cylinder { -15*x,15*x,0.3 texture { GTexture2 }}
    cylinder { -15*x,15*x,0.2 texture { GTexture2 }}
  }
}

/* The glass.. I could have used just an open cone here
   and spared a few hours of rendering time. 
*/

#declare Target = 
merge {
  #declare N = 90
  #while ( N > 0 )
  #declare pos = <sin(N*4/180*pi)*6,6,cos(N*4/180*pi)*6>  
  cylinder { 0, pos, 0.5 }
  sphere { pos,0.6 }
  #declare N = N -1
  #end
  sphere { 0,1 }
  sphere { -y,0.7 }
  cylinder { y,-6*y,0.5 }
  sphere { -6*y,0.7 }
  sphere { -7*y,1 }
  cone { -7*y,0,-7.8*y,5 }
  cylinder { -8*y,-8.2*y,5 }
  torus { 5,0.2 translate -8*y }

  texture { GTexture3 }
  translate 8.2*y
}

/* A simple little object here, too. But nice. */

#declare Magnifying_glass =
union {
  merge {
    cylinder { -6*z,0,0.5 }
    sphere { -6*z,0.5 }
    sphere { 0,0.5 }
    texture { 
      pigment { color Gray10 }
      finish { Shiny reflection 0.5 }
    }
  }
  cylinder { 
    0,2*z,0.3 
    texture { 
      pigment {
	radial 
	frequency 30 
	color_map { 
	[ 0 White ]
	[ 0.5 Gray30 ]
	[ 1 White ]
	}
      }
      finish { Metal }
    }
  }
  sphere { 2*z,0.4 texture { Chrome_Metal }}
  cylinder { 2*z,2.4*z,0.3 texture { Chrome_Metal }}
  cylinder { 
    -0.5*y,0.5*y,4 open 
    texture { Chrome_Metal }
    translate 6.4*z
  }
  object { Sphere scale 4-3.5*y texture { Glass3 } translate 6.4*z }
  translate 0.5*y
}

/* The round bottle arrangement */
    
#declare Thing1 = 
union {
  object { Footing }
  object { Holder 
	     translate 25*y 
	     rotate 10*y
	     }
  object { Grip 
	     translate -10*z 
	     rotate -75*z 
	     translate 25*y+Holder_width 
	     rotate 10*y 
	     }
  object { Bottle 
	     translate -6.8*y 
	     rotate -75*z 
	     translate 25*y-10*z+Holder_width+Grip_xlat
	     rotate 10*y
	     }
}

#declare Thing2 =
object { Distiller 
	   scale 1.2
	   rotate -110*x
	   translate 2.4*y
	   }

#declare Thing3 = 
object { Plug 
	   rotate 75*x
	   rotate 33*y
	   translate 1.3*y
	   }


/* More practical scene elements: The table */

#declare TableLeg = 
union {
  cylinder { -y,-30*y,5 texture { Chrome_Metal }}
  cylinder { -y,-5*y ,8 texture { Chrome_Metal }}
  cone { 
    -20*y,7,
    -28*y,9 
       texture { pigment { color Gray20 } finish { Shiny }}
  }
  torus { 
    8.5,1 
      translate -29*y 
      texture { pigment { color Gray20 } finish { Shiny }}
  }
}

/* 
   DMFWood4, and some stains added.
   Translating the wood in Y direction slightly would probably 
   have looked better.
   */

#declare TableTxt = 
texture {
  pigment { 
    DMFWood4 
      warp { repeat x*2 offset y*0.2 } 
    scale 20 
    rotate x 
  }
}
texture {
  pigment { 
    leopard
    scale 15
    color_map {
      [ 0 color rgbt < 0.2,0.23,0.2,0.5 > ]
      [ 0.05 color rgbt < 0.3,0.1,0.2,0.9 > ]
      [ 0.06 color Clear ]
      [ 1 color Clear ]
    }
    turbulence 2.4
  }
}

#declare TableSheet =
merge {
  box {
    <-90,0,-90>,<90,-5,90>
  }
  cylinder { <90,-2.5,-90>,<-90,-2.5,-90>,2.5 }
  cylinder { <90,-2.5,-90>,< 90,-2.5, 90>,2.5 }
  cylinder { <-90,-2.5,90>,<-90,-2.5,-90>,2.5 }
  cylinder { <-90,-2.5,90>,< 90,-2.5, 90>,2.5 }
  sphere { < 90,-2.5,-90>,2.5 }
  sphere { <-90,-2.5,-90>,2.5 }
  sphere { <-90,-2.5, 90>,2.5 }
  sphere { < 90,-2.5, 90>,2.5 }
  texture { TableTxt }
}

#declare Tabletop = 
union {
  object { TableSheet }
  object { TableLeg translate <-80,0,-80> }
  object { TableLeg translate < 80,0,-80> }
  object { TableLeg translate <-80,0, 80> }
  object { TableLeg translate < 80,0, 80> }
}

/* The font doesn't show well enough, really. 
 */

#declare Titleboard = 
union {
  box { <-10,0,-1>,<10,4,0> texture { GTexture2 }}
  text { 
    ttf "eklektic.ttf","Items of glass",0.5,0
    scale 1.8-z
    translate -8.6*x 
    texture { Gold_Metal }
    translate -z+y
  }
  rotate 90*x
}  

/* The wall texture and the corners.
   Crand is for wimps.. No irreproducable effects here! 
 */

#declare Walltexture =
texture {
  pigment { color Gray70 }
  normal { granite scale 8 turbulence 0.8 }
  finish { Phong_Dull }
}

/* Here begins the arrangement of the scene itself. */

plane { x,-93 texture { Walltexture }}
plane { -z,-93 texture { Walltexture }}

object { Tabletop }

/* Looks kinda flat with the small angle, admittedly. */

camera {
  location <150,200,-500> 
    look_at 9*y 
    angle 24 
    }

light_source { 
  <120,190,-200> 
  color White 
  area_light 5*y,-5*x+z,2,2
  adaptive 1 
}

light_source {
  120*y+z+x
  color White
  spotlight
  point_at 0
  radius 30
  falloff 45
}

object { Titleboard scale 4-2*y translate -80*z }
object { Thing1 scale 2 translate 50*z }
object { Thing2 scale 2 rotate -40*y translate -50*x+10*z }
object { Thing3 scale 2 translate -30*z }
object { Target scale 1.8 translate 50*x-40*z }
object { Magnifying_glass scale 3 rotate 27*y translate -60*x-50*z }

/* Keeping these two objects together. */

union {
  object { Carafe rotate 20*y translate y }
  object { Cap rotate 70*x+60*y translate 10*x-20*z+3*y }
  scale 1.6
  translate 60*x-10*z
}

// Weird floor plane:..

plane { 
    -y,30 
    hollow 
    texture {
    pigment { 
      checker DarkSlateBlue,NeonPink
	rotate 45*y 
	scale 1+x
	scale 40 
	}
    finish { Shiny reflection 0.3 }
  }
}

// Ceiling :

plane { 
  y,220
  hollow
  texture {
    brick
    texture { Silver3 }
    texture { pigment { Pine_Wood rotate x }}
    scale 200
      }
}

/* This doesn't show up anywhere, really. */

sky_sphere { 
  pigment { gradient y frequency 20 triangle_wave
	      color_map { [ 0 White ] [ 1 Red ] }}
}


