// Persistence of Vision Ray Tracer Scene Description File
// File: Jars.pov
// Vers: 3
// Desc: Jars and an oil lamp on a shelf
// Date: 02/14/97
// Auth: Benny Wilkie
//

#version 3

#include "colors.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"
#include "jars.inc"
#include "lamp.inc"
#include "oldjar.inc"
#include "web.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location         <0.0, 6, -15.0>

  look_at          <1, 1.5,  0.0>
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}




light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

//-------- White Tan & thin Reds
#declare T_Grnt29 =
texture {
pigment
 {marble
  turbulence 0.5
  color_map
   {[0.000, 0.053   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.624, 0.000>]
    [0.053, 0.263   color rgbf <0.784, 0.627, 0.624, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.263, 0.281   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.643, 0.380, 0.376, 0.000>]
    [0.281, 0.325   color rgbf <0.643, 0.380, 0.376, 0.000>
                    color rgbf <0.839, 0.722, 0.722, 0.000>]
    [0.325, 0.711   color rgbf <0.839, 0.722, 0.722, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.711, 0.798   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.769, 0.380, 0.376, 0.000>]
    [0.798, 0.895   color rgbf <0.769, 0.380, 0.376, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.895, 0.982   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.982, 1.001   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
   }
 }
 }



box
{
  <-20, -20, .2>
  < 20,  20,  1>
  texture { T_Grnt29}
normal  {granite}
finish{ roughness 1}
}





box
{
  <-10, -.5, -8>
  < 10,  0, -.05>
 texture {T_Wood7
 rotate y*90}
}



object{Mason_Jar
scale <1.55, 1.55, 1.55>
texture {T_Green_Glass}//
rotate y*-15
translate <-.5, 2.3, -2.3>


}

object{Atlas_Jar
scale <.75, 1.25, .75>
texture {T_Vicksbottle_Glass}//
rotate y*-30
translate <-5, 1.9, -4>

}

object{Kerr_Jar

texture {T_Old_Glass}//
rotate y*-35
translate <-8, 1.5, -2>
}

object{Mason_Jar

texture {T_Glass3}//
rotate y*-17
translate <2, 1.5, -4.3>
}

object{Mason_Jar

texture {T_Glass3}//
rotate y*-15
translate <-5, 1.5, -6.5>
}

object{Mason_Jar

texture {T_Green_Glass}//
rotate y*5
translate <8.5, 1.5, -2>
}

object{Kerr_Jar

texture {T_Green_Glass} //
rotate y*-5
translate <-2.55, 1.5, -5>
}

object{Ball_Jar
scale <.75, 1.25, .75>
texture {T_Glass3}//
rotate y*-13
translate <-.3, 1.9, -5.2>

}

object{Ball_Jar

texture {T_Green_Glass}//
rotate y*41
translate <7.5, 1.5, -5>
}

object {Oldjar
texture {T_Vicksbottle_Glass}//
rotate y*12
translate <2.6, .2, -1.75>
}

object {Oldjar
texture {T_Green_Glass}//
rotate y*-83
translate <-3.65, .2, -2>
}

object {Oldjar
texture {T_Glass3}//
rotate y*-72
rotate z*90
rotate y*-15
translate <4.5, 1.035, -6>
}

 object {lamp
rotate y*35
 translate <5, 4.1, -3>

 }

 ////////////////////add a spider just for fun//////////////////////

 object {SpiderW
 rotate y*160
  rotate z*10
 rotate x*25

 scale <.1, .1, .1>
  translate <-2, 5.75, -5.65>
 }




