

// Persistence of Vision Ray Tracer Scene Description File
// File: lamp.inc
// Vers: 3
// Desc: objects to make oil lamp
// Date: 1/16/97
// Auth: Benny Wilkie wilkie@intplsrv.net

/////////////////////////////////Globe of lamp////////////////////////////////////

#declare solid=

merge{

difference{
sphere{ <0, 0, 0> 1 }
sphere{ <0, 1.5, 0> 1 }//lose this sphere in hollow mold below
torus{ 1.35, 1 }
}//diff

cylinder
{ -2.0*y,  -2.5*y,  .65 }
sphere{ <0, -1.475635291, 0> 1 }

}//merge

//////////////////////////////////////////////////////////////////

#declare hollow_globe=

difference{

object {solid}

difference{
sphere{ <0, 0, 0> 1 }
torus{ 1.35, 1 }
}//diff

cylinder
{ -1.9*y,  -3*y,  .65 }

sphere{ <0, -1.475635291, 0> 1 }



scale <.99, 1, .99>

}//diff

///////////////////////////////////////////////////////////////////////////////

#declare globe=

merge{

#declare Revolve = 0
#while (Revolve < 360)
#declare Revolve = Revolve+10 // increment our counter

 sphere
  {
    <1,0,0>,
    0.1
    rotate y*Revolve
    scale <.65, .65, .65>
    translate y*.75

  }

 #end

  object {hollow_globe



}
scale <1, 1.5, 1>

}

/////////////////////////////////////end globe////////////////////////////////////////////////////
#declare Wick_Holder=
/////////////////////////wick holder???????or what ever its called :o)/////////////////////////////

union{

#declare X=0
#while (X <360)
difference{

cylinder{  -.1*x,  .1*x,  .4 }

cylinder{  -.11*x,  .11*x,  .39 }
box { <-.2, -.5, -.35>, <.2, .5, .5> }
sphere {<0,-.05, 0>.15 scale <.5, 1.3, 3> }
clipped_by
{sphere {<0, -.1, 0> .45
scale <.4, 1, 1>}
}

rotate x*20
translate z*1.25
rotate y*X
scale <1, 2, 1>


}//dif

  #declare X = X+15
#end

difference{
cylinder {-.15*y, -.12*y, .85 }
cylinder {-.16*y, .13*y, .39 }
}

torus {.85, .05 translate -.13*y }///////////////////////////////

difference{
cylinder {-.25*y, .2*y, .4 }
cylinder {-.26*y, .19*y, .39 }
}

difference{
sphere{ <0, .2, 0> .4 }
sphere{ <0, .2, 0> .39 }
cylinder {-.26*y, .19*y, .39 }
box { <1, 1, .1>, <-1, -1, -.1> }
}// diff


}//union

//////////////////////////////end wick holder//////////////////////////////////
#declare Knob=
///////////////////////////////////knob/////////////////////////////////////
union{
cylinder {0*x, 1.1*x, .02}

difference{

cylinder {1.1*x, 1.11*x, .25}


#declare Z=0
#while (Z <360)
sphere { <1.12, .25, 0> .05
rotate x*Z
}
  #declare Z = Z+45
#end

#declare Y=0
#while (Y <360)
sphere { <1.12, .15, 0> .04
rotate x*45
rotate x*Y
}
  #declare Y = Y+45
#end


}//dif

sphere { <1.11, 0, 0> .075 }
translate y*-.2

}//union




////////////////////////////////////////////////////////////
#declare Metal_Base=

 union{
 object {Wick_Holder}
 object {Knob}
cylinder {y*-1.5, y*.65  .3 ///wick
 scale  <1, 1, .01>
pigment {Gray}
}
 }

//////////////////////////////////Glass Base///////////////////////////////////

#declare Solid_Glass=
/////////////////////////solid////////////////////////////
merge{


sphere { <0,0,0> 1

}

torus {.5, .05
translate y*-1
}



cylinder
{
  1.1*y,  0*y,  .40

}


}//merge
///////////////////////////end solid///////////////////////////////////////


#declare Glass=

difference{

object {Solid_Glass}
object {Solid_Glass
scale <.99, .99, .99>

}
texture {T_Glass3}//pigment {Red}  //
}//diff


/////////////////////////////////////////////////////////////////////////////////

#declare Oil=

difference{
object {Solid_Glass
scale <.99,.99,.99>
}
box{  <-1, -1, -1>   < 1,  1,  1>
 translate y*1

}
texture {T_Orange_Glass}
}
////////////////////////////////////////////////////////////////////////////////

#declare Glass_Base=

merge{
object {Glass}
object {Oil}
scale <1.5, 1.1, 1.5>
}
/////////////////////////////////End Glass Base////////////////////////////////////

////////////////////////////lamp////////////////////////////////////////////
#declare lamp=
union{
object {globe
texture {T_Glass3}//pigment {Yellow} //
translate y*2.1

}



object {Metal_Base
texture {T_Brass_1A}//pigment {Blue}  //
rotate y*15
translate y*-2
scale <.80, .80, .80>
}

object {Glass_Base
translate y*-2.9

}

}//union

////////////////////////////////////end of lamp file/////////////////////////////////////
