
// Persistence of Vision Ray Tracer Scene Description File
// File: web.inc
// Vers: 3
// Desc: Spider on a web for jars.pov
// Date: 02/18/97
// Auth: Benny Wilkie wilkie@intplsrv.net
//


#declare Web=
union{

#declare Radius = 0
#while ( Radius< 25)

#declare Turn = 0
#while ( Turn< 360)


sphere {<0,0,0>1

   scale <.04, .04, .2>

   translate x*Radius
  rotate y*Turn


}



  #declare Turn = Turn + 1
  #declare Radius = Radius + .01
#end
#end
/////////////////////////////////////////////////


#declare Spokes = 0
#while (Spokes < 360)


cylinder
{
  -25*x,  25*x,  .04
  rotate y*Spokes

}

  #declare Spokes = Spokes+12 // increment our counter
#end



torus
{
  1000,
  0.04
  translate <-350, 0, 965>
}

torus
{
  200,
  0.04
  translate <225, 0, 0>
}

torus
{
  800,
  0.04
  translate <0, 0, -825>
}
}//end union web





#declare SpiderW=

union{

object {Web
pigment {White}
  finish {phong 1  phong_size 200}
rotate x*90
translate z*-1
}
 ///////////////////////////////////spider starts here

// SPHERE _sphere0
sphere {  < 0, 0, 0 > 1
 pigment {Black}
 finish {phong 1  phong_size 200}
 scale  < 1.2, 1.3, 1.1 >
 translate  < -0.0852273, 2.21496, 0.5 >
 }


// SPHERE _sphere1
sphere {  < 0, 0, 0 > 1
 pigment {Black}
 finish {phong 1  phong_size 200}
 scale  < 0.4, 1, 0.4 >
 translate  < -0.0625, 0.952967, -0.0833333 >
 }


// CYLINDER _cylinder0
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -30, 0, 60 >
 translate  < 0.8125, 0.217933, 0.416667 >
 }


// CYLINDER _cylinder0_0
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -50, 0, 120 >
 translate  < 0.712233, 1.17686, 0.555556 >
 }


// CYLINDER _cylinder0_1
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 40, 0, 80 >
 translate  < -0.949198, 1.0809, 0.444444 >
 }


// CYLINDER _cylinder0_2
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 35, 0, 95 >
 translate  < -1.02034, 0.765987, 0.377778 >
 }


// CYLINDER _cylinder0_3
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -24, 0, 90 >
 translate  < 0.944853, 0.834912, 0.361111 >
 }


// CYLINDER _cylinder0_4
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -20, 0, -60 >
 translate  < -0.992647, 0.222426, 0.222222 >
 }


// CYLINDER _cylinder0_5
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 50, 0, 110 >
 translate  < -0.895722, 0.522523, 0.555556 >
 }


// CYLINDER _cylinder0_6
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -35, 0, 70 >
 translate  < 0.852272, 0.497493, 0.444444 >
 }


// CYLINDER _cylinder0_7
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 0, 0, 20 >
 translate  < -1.77569, 1.8745, 0.927778 >
 }


// CYLINDER _cylinder0_7_8
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 20, 0, 60 >
 translate  < 2.0621, -0.0726199, 0.605555 >
 }


// CYLINDER _cylinder0_7_9
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -20, 0, -25 >
 translate  < 1.41825, 2.05632, 0.894444 >
 }


// CYLINDER _cylinder0_7_9_10
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -40, 0, -45 >
 translate  < 2.06522, 1.24571, 0.177778 >
 }


// CYLINDER _cylinder0_7_9_11
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 30, 0, 25 >
 translate  < 1.6334, -0.693684, 0.427778 >
 }


// CYLINDER _cylinder0_7_9_12
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < -20, 0, 35 >
 translate  < -2.03781, 1.28359, 0.494444 >
 }


// CYLINDER _cylinder0_7_9_13
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 20, 0, -25 >
 translate  < -1.92418, -0.761866, 0.227777 >
 }


// CYLINDER _cylinder0_7_9_13_14
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 pigment {Black}
 scale  < 0.05, 0.75, 0.05 >
 rotate  < 10, 0, -45 >
 translate  < -1.87872, -0.170957, 0.961111 >
 }


// CONE _cone0
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -20, -40, 0 >
 translate  < 1.76917, 2.99833, 0.533333 >
 }


// CONE _cone0_15
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -40, -40, 0 >
 translate  < 2.59475, 1.88399, -0.438889 >
 }


// CONE _cone0_16
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -20, 0, 0 >
 translate  < -2.03316, 2.86073, 0.838889 >
 }


// CONE _cone0_17
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -50, 20, 0 >
 translate  < -2.52153, 2.07003, 0.0333333 >
 }


// CONE _cone0_18
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -30, 0, 160 >
 translate  < -2.31465, -1.64185, -0.188889 >
 }


// CONE _cone0_18_19
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -30, 0, 160 >
 translate  < -2.48907, -0.934975, 0.672222 >
 }


// CONE _cone0_18_20
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -30, 0, 200 >
 translate  < 2.00173, -1.54173, -0.161111 >
 }


// CONE _cone0_18_20_22
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 pigment {Black}
 scale  < 0.05, 0.3, 0.05 >
 rotate  < -30, 0, 200 >
 translate  < 2.75996, -0.653644, 0.144444 >
 }

}//end union spider



