// ***
// *** CROWN SCENE
// ***

// *###* *###* CONTROL VARIABLES *###* *###*

#declare PREVIEW = 0			// 1 = preview textures; 0 = real textures & halos.
#declare CAMERA = 1				// 0 = view num.0; 1 = view num.1; ...
#declare REDLIGHT = 1			// 0 = light off; 1 = light on

// *###* *###* INCLUDES *###* *###*

#include "colors.inc"
#include "skies.inc"
#include "crwntext.inc"
#include "krunaobj.inc"
#include "waterbwl.inc"
#include "stnwrks.inc"
#include "center.inc"
#include "sword.inc"
#include "shield.inc"

// #***# #***# #***# #***# SCENE #***# #***# #***# #***#

// *** SETTINGS

#if (CAMERA = 0)
camera {
	location <270, 140, -15>
	direction <0, 0, 2>
	look_at <-(360+180), 105, 0>
}
#end

#if (CAMERA = 1)
camera {
	location <135, 127, -15>
	direction <0, 0, 2>
	look_at <-(360+180), 105, 0>
}
#end

#if (CAMERA = 2)
camera {
	location <37, 110, -37>
	direction <0, 0, 1>
	look_at <-7, 95, 0>
}
#end


light_source { <20000, 8000, -2000> color rgb <0.3, 0.3, 0.3>
    area_light <0, 0, -1000>, <0, 300, 1000>, 5, 2
    adaptive 1
    jitter
}

global_settings { ambient_light color rgb 2 }

background { color rgb <0.1, 0.2, 0.3> }

// *** OBJECTS

sky_sphere {
	pigment { gradient y
		pigment_map {
		[ 0
			gradient y
			color_map {
				[ 0 color rgb <0.2, 0.3, 0.4> ]
				[ 0.1 color rgb <0.1, 0.25, 0.37> ]
				[ 0.4 color rgb <0.1, 0.2, 0.3> ]
				[ 1 color rgb <0.1, 0.2, 0.3> ]
			}
		]
		[ 0.25 P_Cloud1 scale 0.25 ]
		}
	}
}

object { Shield scale 1.5 rotate <10, 0, 0> rotate <0, -85, 0> translate <-684, 0, -180> }

object { Sword scale 0.15 rotate <7, 0, 0> translate <0, 108, -29.5> rotate <0, -55, 0> }

object { KRUNA scale 0.7 translate <0, 97.92, -20> rotate <0, -115, 0> }

object { FloorBase }

object { Floor133 }

object { Floor100 translate <-360, 0, 0> }
object { Floor100 translate <-720, 0, 0> }

object { Hand rotate <0, 15, 0> scale 2.5 translate <-720, 0, 0> }


plane { y, -80
	texture {
		pigment { color rgbf <0, 0, 0.1, 0.3> }
		normal {
			bumps 0.1
 			turbulence 0.4
			scale 10
		}
		finish {
			brilliance 5
			diffuse 0
			phong 1 phong_size 60
			ambient 0.3
			refraction 1 ior 1.33
			reflection 0.8
		}
	}
}

height_field {
	gif "place2.gif"
	smooth
	translate <-0.5, 0, -0.5> rotate <0, -90, 0> scale <5000, 400, 10000>
	translate <-1000, -((130/256)*400), 150>
	texture {
		pigment { gradient y
			pigment_map {
				[ 0.5 wrinkles
					color_map {
						[ 0 color rgb <0.2, 0.45, 0.45> ]
						[ 0.5 color rgb <0.7, 0.5, 0.1> ]
						[ 1 colo rgb <0.9, 0.6, 0> ]
					}
					scale 3
				]
				[ 1 wrinkles
					color_map {
						[ 0 color rgb <0.53, 0.58, 0.1> ]
						[ 0.5 color rgb <0.45, 0.4, 0.1> ]
						[ 0.7 color rgb <0.55, 0.5, 0.1> ]
						[ 1 color rgb <0.42, 0.48, 0> ]
					}
					rotate y*45 scale 1
				]
			}
			scale 100
		}
		normal { dents scale 10 turbulence 0.4 }
		finish {
			diffuse 0.4
			ambient 0.2
		}
	}
}

height_field {
	gif "place3.gif"
	water_level 0.1
	smooth
	translate <-0.5, 0, -0.5>
	scale <200, 50, 200>
	texture {
		pigment { gradient y
			pigment_map {
				[ 0.4 wrinkles
					color_map {
						[ 0 color rgb <0, 0.5, 0.2> ]
						[ 0.5 color rgb <0, 0.6, 0.1> ]
						[ 0.8 color rgb <0, 0.5, 0.1> ]
						[ 0.95 color rgb <0.1, 0.4, 0.05> ]
					}
				]
				[ 0.6 marble
					color_map {
						[ 0 color rgb <0.7, 0.7, 0.7> ]
						[ 0.5 color rgb <0.5, 0.5, 0.5> ]
						[ 1 color rgb <0.5, 0.6, 0.6> ]
					}
				]
			}
			scale 30
			translate <0, 37, 0>
		}
		normal { bumps turbulence 0.4 }
		finish {
			diffuse 0.4
			ambient 0.2
		}
	}
	scale 100
	translate <-40000, -1000, -10000>
}
