//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 3 textures and 7 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 01/27/1997    (27.01.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//


#include "colors.inc"


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 15
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color rgb 1 }

fog {
  fog_type 1
  distance 20
  color Black
}

camera {  //  Camera StdCam
  location  <0.000, -6.396, 2.579>
  direction <0.0,     0.0,  2.1798>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.033, -3.011, 1.399>
  angle 45
}


#declare LiteVec = <-3.367, 7.289, 6.985>
#declare LiteRot = 30
#declare cfac = 1.333

light_source {   // Light1
  LiteVec
  color cfac * Red 
  rotate (LiteRot)*x
}

light_source {   // Light1
  LiteVec
  color cfac * Green 
  rotate (LiteRot+.5)*x
}

light_source {   // Light1
  LiteVec
  color cfac * Blue 
  rotate (LiteRot+1)*x
}


// ********  TEXTURES  *******
//

#include "krystlkl.inc"
#default { texture {Glass1}}



// ********  REFERENCED OBJECTS  *******

#declare ridge_normal = normal {
  gradient z
  frequency 4
  triangle_wave
}

#declare back_normal = normal {
  wood 1
  frequency .5
  normal_map {
    [0.0
      radial
      frequency 24
      triangle_wave
      scale <1,2,1>
      rotate <90,0,7.5>
    ]
    [0.78
      radial
      frequency 24
      triangle_wave
      scale <1,2,1>
      rotate <90,0,7.5>
    ]
    [0.95
      radial
      frequency 24
      slope_map{
        [0.0 <.9,1>]
        [0.05 <1,1>]
        [0.05 <1,0>]
        [0.95 <1,0>]
        [0.95 <1,-1>]
        [1.0 <.9,-1>]
      }
      scale <1,2,1>
      rotate <90,0,7.5>
    ]
    [0.95 bumps 0 scale 1]
    [1.0  bumps 0 scale 1]
  }
}

#declare Xscale=1.7
#declare Xunscale= 1 / Xscale

#declare front_normal =   normal {
    average
    normal_map {
      [0.5 radial 1 triangle_wave frequency 60 rotate 90*x ]
      [0.5
        wood 1
        ramp_wave
        frequency 3.9
        slope_map{
          [0.00 <1,0>]
          [0.80 <1,0>]
          [0.80 <1,-1>]
          [0.90 <0,-1>]
          [0.90 <0,1>]
          [1.00 <1,1>]
        }
      ]
    }
    scale <Xscale,1,1>
        warp { black_hole <0,0,0>, 1
          falloff 1
          strength 1 
          inverse
        }
  }


// ********  OBJECTS  *******


plane { // ground
  z,0
  texture {
    myWhite
    normal {granite .15 scale .6}
  }
}


plane { // wall behind camera
  y,0
  rotate <45,0,30> 
  translate <5,-10,6> 
  pigment { Black }
}

#declare cylinders = merge {
  cylinder { // Cylndr001 --> main clock body
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass1
      normal {ridge_normal }
    }
    scale <2.0, 1.0, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.5, 0.9>
  }

  cylinder { // frontface
    <0,0,1>, <0,0,0>, 1
    scale <Xscale,1,1> 
    texture {
      Glass1
      normal {front_normal translate 0.95*z}
    }
    scale <2*Xunscale, 1.0, 0.1> 
    rotate 90.0*x
    translate  <0.0, -0.4997, 0.9>
  }

  cylinder { // backface
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass1
      normal {back_normal translate 0.95*z }
    }
    scale <2.0, 1.0, 0.1>
    rotate -90.0*x
    translate  <0.0, 0.4997, 0.9>
  }
}

difference { // clockobj
  object { cylinders }
  box { // bottomcut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass1 finish {caustics 0}
    }
    scale <1.5, 1.0, 1.0>
    translate  -1.0*z
  }
  cylinder { // facebore
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass1
      normal {bumps .4 scale .002}
    }
    scale <0.65, 0.65, 1.0>
    rotate 90.0*x
    translate  0.95*z
  }
  translate  z * .01 
  translate y*.5
  normal {ripples 1 scale .1}
  rotate 35*z
}

