#include "colors.inc"
#include "glass.inc"
#include "metals.inc"
#include "objects.inc"
#include "woods.inc"
#include "stones1.inc"

camera {
        location <28, 12.6, -20>
        look_at <16,7.5,0>
       }

light_source { <20.00, 30.00, -300.00> color Gold shadowless}
light_source { <40.00, 80.00, -300.00> color White shadowless}

sky_sphere {
           pigment { SkyBlue }
           pigment {
                    bozo
                    turbulence 0.85
                    omega 0.8
                    color_map {
                               [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                                        color rgb <0.75, 0.75, 0.75> ]
                               [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                                        color rgbt <1, 1, 1, 1> ]
                               [0.5 0.8 color rgbt <1, 1, 1, 1>
                                        color rgbt <1, 1, 1, 1> ]
                              }
                     scale <0.4 , 0.3, 0.2>
                   }
           }  // end of sky_sphere

/******** makes the room and takes out the box where the door will be **********/
difference {
            box { <-161,-141,-501>, <100,120,12> }     //main room
            box { <-160,-140,-500>, <99,119,11.5> }      //cuts out main room



            box { <-162,-139,-350>, <-159,60,-100> }   //cuts out patio door
            box { <-100,-80, -499>, <70,60,-502> }     //cuts out window
            pigment { White }
            finish { crand 0.1 diffuse 0.5}
           }


 /****** the wall-papered wall ******/
 box { <-160,-140,11.5>, <99,119,11>
       pigment {
                gradient x color_map {
                                      [0.0 HuntersGreen ]
                                      [1.0 White ]
                                     }
                scale 2
               }
     }


/*************** makes the mirror on the wall ******************/
cylinder { <0,4,10.5>, <0,4,11>,16
          pigment { White }
          finish { reflection 1.0 ambient 0 diffuse 0 }
          scale <1.8,1,1>
         }

torus { 16,0.25
        texture { T_Gold_4C }
        rotate x*90
        translate <0,4,10.5>
        scale <1.8,1,1>
      }
cylinder { <0,4,10.6>, <0,4,11>,18
          finish { reflection rgb <0.5,0.5,0.5> diffuse 0 }
          scale <1.8,1,1>
         }
torus { 18,0.25
        texture { T_Winebottle_Glass }
        rotate x*90
        translate <0,4,10.5>
        scale <1.8,1,1>
      }



/********* makes the bay window ***************/

difference {
            box { <-105,-85,-499>, <75,65,-500> }
            box { <-100,-80,-498>, <70,60,-501> }
            texture { pigment { P_WoodGrain1A color_map { M_Wood1A }} scale 40 }
            texture { pigment { P_WoodGrain1B color_map { M_Wood1B }} scale 40 }
           }

union {
       difference {
                   box { <-5,-5,-5>, <5,5,5> }
                   box { <-4.8,-5.1,-5.1>, <5.1,5.1,4.8> }


                   rotate y*45
                   clipped_by { plane { z,3 } }
                  }

       box { <-4,-5,3>, <4,5,3.2> }
       cylinder { <-4,-5,3>, <-4,5,3>, 0.2 pigment { Gray80 } }
       cylinder { <4,-5,3>, <4,5,3>, 0.2 pigment { Gray80 } }

       union {
              box { <-5,-5,-5>, <5,-5.1,5> }
              box { <-5,5,-5>, <5,5.1,5> }
              pigment { White }
              finish { crand 0.1 diffuse 0.5}
              rotate y*45
              clipped_by { plane { z,0 inverse } plane { z,3 } }
             }

       pigment { rgbt <1,1,1, 0.9> }
       finish { reflection 0.1 ior 1.5}

       rotate y*180
       scale <12,13.9,12.7>
       translate <-15,-10,-500>
      }


/********* makes the patio door ***************/
difference {
            box { <-168,-139,-350>, <-159,60,-100> }
            box { <-169,-134,-345>, <-158,55,-105> }
            texture { pigment { P_WoodGrain1A color_map { M_Wood1A }} scale 20 }
            texture { pigment { P_WoodGrain1B color_map { M_Wood1B }} scale 20 }
           }

difference {
            box { <-166,-134,-215>, <-161,55,-345> }
            box { <-167,-129,-225>, <-160,50,-335> }
            pigment { Gray80 }
           }

difference {
            box { <-164.2,-132,-215>, <-165,55,-109> }
            box { <-166,-129,-212>, <-164,52,-111> }
            pigment { Gray80 }
           }

box { <-164,-134,-345>, <-163,55,-105>
      pigment { rgbt <1,1,1, 0.9> }
      finish { reflection 0.1 ior 1.5}
    }



/*********  makes the hardwood floor **********/
box { <-160,-140,-500>, <99,-139,11>
      pigment{image_map{gif "c:\pov-ray\images\fwood.gif"}  rotate x*90 scale 45}
    }




plane { y,-150                    /******** ocean ***********/
        pigment { SummerSky }

        normal { waves 0.08
                 scale <5,5,5>
               }
        finish { reflection 0.3 }
      }

box { <-165,-140,-800>, <-500,-143,0>  /**** beach ****/
      rotate y*-25
      pigment { Wheat }
      finish { crand 0.2 }
    }
light_source { <-300,100,-100> color White }






/******** makes a rug under the table ********/
cylinder { <0,0,0>, <0,0.1,0>, 15
           pigment { image_map { gif "c:\incoming\rtile.gif" } scale 6 rotate x*90 }
           scale 5
           translate <-15,-135,-270>
         }

object { table  scale <15,15,20> translate <-15,-90,-250>  }
object { Art scale <3,7,3> translate <-130,-140,-460> }
object { Lantern }
object { Shelf }
object { Plant  scale 10   translate <-10,-78,-520> }

height_field {
    gif "c:\pov-ray\images\fract001.gif"
    smooth
    texture { T_Stone22 scale 0.5}
    scale <6000, 1200, 6000>
    translate <-6000, -700, -8500 >
  }
