/***********************************************************/
/*                                                         */
/* This file contains declarations for the objects used in */
/* lantern.pov                                             */
/*                                                         */
/***********************************************************/


#declare Lantern =
union {

      sor {
            19
            <0,-0.5>, <4,0>, <4.5,0.5>, <5,1>, <4.8,2>, <5,2.25>, <4.8,2.5>,
            <4.8,3>, <4.8,3.5>, <5.1,3.75>, <4.8,4>, <4,4.5>, <3,5>, <2.7,5.5>,
            <2.5,5.9>, <2,6>, <2,6.7>, <4,7>, <0,7.8>
            texture { T_Brass_3A }
            translate <0,-7,0>
          }
      sor {
            16
            <0,-0.5>, <4,0>, <3.9,1>, <3.8,2>, <3.9,3>, <4,4>, <4.5,4.5>, <4.8,5>,
            <5.6,5.2>, <6,6>, <6.2,7>, <6,8>, <5.5,8.5>, <5,9>, <4,9.5>, <3.8,10>
            open
            texture { T_Glass2 }
          }

      cylinder { <0,9.5,0>,<0,13,0>,3.8
                 open
                 texture { T_Glass2 }
               }

      sphere { <0.00, 1.00, 0.00>,1.5
               texture { T_Brass_5A }
             }
      box { <-0.7,1,-.3>, <0.7,4,0.2>
            pigment { White }
            normal{
                   crackle 0.6
                   scale 0.2
                  }
          }
 } //end of #declare lantern

#declare Shelf =
union {
       cylinder { <0,-7,11>, <0,-8,11>, 15
                  texture { T_Winebottle_Glass }
                  scale <1,1,1.8>
                }

       union {
              torus { 14.9, 0.3
                      translate <0,-5,11>
                      scale <1,1,1.8>
                    }
              torus { 14.7, 0.5
                      translate <0,-7.5,11>
                      scale <1,1,1.8>
                    }

              cylinder { <0,-7,-7.2>, <0,-5.2,-7.2>, 0.3 }
              cylinder { <-7,-7,-4>, <-7,-5.2,-4>, 0.3 }
              cylinder { <7,-7,-4>, <7,-5.2,-4>, 0.3 }
              cylinder { <-14,-7.2,10.5>, <-14,-5.2,10.5>, 0.3 }
              cylinder { <14,-7.2,10.5>, <14,-5.2,10.5>, 0.3 }
              cylinder { <-14,-7.2,10.5>, <14,-7.2,10.5>, 0.3 }
              texture { T_Gold_4C }
            }
      } //end of #declare shelf

#declare jug=
union {
       sor {
            10
            <0,-0.1>, <1,0.1>, <2,1>, <2,2>, <1.5,3>, <1,3.5>, <0.8,4>, <0.9,5>,
            <1.5,5.7>, <1.8,6.2>
           }

       torus { 1.3,0.2
               clipped_by { plane { x,0.5 } }
               rotate <90,0,-15>
               translate <-1.5,3,0>
             }

       texture { T_Glass2 }
      } // end of #declare jug

#declare Glass=
union {
       difference {
                   cylinder { <0,0,0>, <0,4,0>, 1 }
                   cylinder { <0,0.2,0>, <0,4.1,0>, 0.9 }
                   texture { T_Glass2 }
                  }
       cylinder { <0,0,0>, <0,-0.1,0>,1.7
                  texture { T_Gold_4C }
                }
      }

#declare table=
union {
       difference {
                   superellipsoid { <0.5,0.4>
                                    texture { T_Gold_4C }
                                    scale <3.1,0.2,3.1>
                                  }
                   superellipsoid { <0.5,0.4>
                                    scale <3,0.3,3>
                                  }
                  }
      superellipsoid { <0.1,0.4>
                       texture { T_Winebottle_Glass }
                       scale <3,0.1,3>
                     }
       union {
              torus { 2.5, 0.2 rotate <90,45,0> }
              torus { 2.5, 0.2 rotate <90,-45,0> }
              texture { T_Gold_4C }
              scale <1,0.5,1,>
              translate <0,-1.35,0>
             }
      object { jug  scale 0.3 }

      object { Glass  scale 0.3 translate <-1.8,0.1,1> }
      object { Glass  scale 0.3 translate <1.8,0.1,-1> }
     }

#declare HalfTorus=
torus { 2,0.3
        clipped_by { plane {x.0} }
      }

#declare PartArt=
union {
       #declare Height=0
       #declare Angle=0
       #declare Count=0

       #while (Count<20)
         object { HalfTorus
                  rotate <15,Angle,0>
                  translate y*Height
                }
         #declare Count=Count+1
         #declare Height=Height+1.1
         #declare Angle=Angle+180

       #end
      }

#declare Art=
union {
object { PartArt
         texture { T_Gold_4C }
       }
object { PartArt
         texture { T_Winebottle_Glass }
         translate y*0.5
       }
object { PartArt
         texture { T_Gold_4C }
         translate y*1
       }
cylinder { <0,11,0>, <0,11.5,0>, 10
          texture { T_Winebottle_Glass }
         }
torus { 10,0.25
        texture { T_Gold_4C }
        translate y*11.25
      }
cone { <0,22.5,0>,4, <0,24.5,0>,7
       open
       texture { T_Winebottle_Glass }
     }
cone { <0,24.5,0>,7, <0,25,0>,9
       open
       texture { T_Gold_4C }
     }
cone { <0,22,0>,2, <0,22.5,0>,4
       texture { T_Gold_4C }
     }
cone { <0,0.5,0>,2, <0,0,0>,5
       texture { T_Gold_4C }
     }
light_source { <0,23,0> color White
               fade_distance 30
               fade_power 1
             }

    }


#declare Leaf=
union {
       sphere { <5,0,0>, 5 hollow }
       sphere { <-5,0,0>, 5 }

       clipped_by { plane { x,0.1 inverse }
                    plane { z,0.7 rotate y*5 }
                    plane { z,-0.7  inverse rotate y*-5 }
                    plane { y,0 inverse }
                  }
       rotate <0,0,0>
       scale <0.6,1,0.6>
       pigment { ForestGreen }
      }

#declare Plant=
union {
       #declare Count=0
       #while (Count<14)
         object { Leaf rotate y*25*Count }
         #declare Count=Count+1
       #end

       #declare Count=0
       #while (Count<10)
         object { Leaf rotate y*40*Count translate <0,1,0> }
         #declare Count=Count+1
       #end

       cone { <0,3,0>,2, <0,0,0>,1 open texture { T_Gold_4C } }
       cone { <0,2.8,0>, 1.95, <0,2.7,0>,1 pigment { Brown } }
       torus { 2,0.2 translate <0,3,0> texture { T_Winebottle_Glass } }
       torus { 1,0.2 translate <0,0,0> texture { T_Winebottle_Glass } }
      }

#declare bowl=
difference {
            sphere { <0,0,0>, 5 }
            sphere { <0,0,0>,4 }
            box { <-5,1,-5>, <5,5,5> }
            box { <-5,-4.2,-5>, <5,-5,5> }
            scale <1.5,1,1.5>
            texture { T_Glass1 }
           }
