// Melting Glass

//#declare TESTING = 1

#version 3.0
global_settings { assumed_gamma 2.2 }
global_settings { max_trace_level 10 }

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "woods.inc"

/* Texture declarations for object 'glass' */
#declare glass_texture = texture {
  pigment { rgbft < 0.9, 0.9, 0.95, 0.1, 0.9 > }
  finish {
    #ifndef (TESTING)
      reflection .1
      refraction 1
      ior 1.5
      specular 1
      roughness .001
    #else
      reflection 0
      refraction 0
    #end
    ambient 0
  }
}

#declare molten_glass_plane = halo {
  emitting
  planar_mapping
  linear
  color_map { 
    [ 0.0 color rgbt <0.0, 0.0, 0.0, 1.0> ]
    [ 0.5 color rgbt <0.8, 0.2, 0.0, 0.8> ]
    [ 1.0 color rgbt <1.0, 0.7, 0.0, 0.4> ]
  }
  samples 10
}

#declare molten_glass_cylinder = halo {
  emitting
  cylindrical_mapping
  linear
  color_map {
    [ 0.0 color rgbt <0.0, 0.0, 0.0, 1.0> ]
    [ 0.5 color rgbt <0.8, 0.2, 0.0, 0.8> ]
    [ 1.0 color rgbt <1.0, 0.7, 0.0, 0.4> ]
  }
  samples 10
}

#declare goblet_top = object {
  merge {
    intersection {
      difference {
        sphere { 0, 1 scale <2,6,2> }
        sphere { 0, 1 scale <1.9,5.9,1.9> }
      }
      box { <-2,-6,-2>, <2,2,2> }
      translate <0,12,0>
    }
    torus { 1.836, 0.08 translate y*14 }
    cylinder { <0,0.002,0>, <0,6,0>, 0.2 }
    torus { 0.4, 0.2 translate y*5.9 }
    torus { 0.2, 0.2 translate y*5.7 }
  }
  hollow
}


#declare goblet_base = object {
  merge {
    cylinder { <0,0.002,0>, <0,6,0>, 0.2 }
    cylinder { <0,0.001,0>, <0,0.3,0>, 2 }
    torus { 0.4, 0.2 translate y*5.9 }
    torus { 0.2, 0.2 translate y*5.7 }
    torus { 0.4, 0.2 translate y*0.3 }
    torus { 0.2, 0.2 translate y*0.5 }
    torus { 2, 0.15 translate y*0.15 }
  }
  hollow
}

#declare puddle1 = object {
  height_field {
    gif "puddle1.gif"
    smooth
    translate <-0.4, -0.1, -0.5 >
    scale <19,0.2,7>
    hollow
  }
  hollow
}      

union {
  object { puddle1 scale 10 texture { glass_texture} halo { molten_glass_plane scale 10 } }
  object { goblet_base rotate z*-120 translate <-6,1,0> scale 10 texture { glass_texture} halo { molten_glass_plane scale 10 } }
  object { goblet_top rotate z*-80 translate <-6,-1,0> scale 10 texture { glass_texture} halo { molten_glass_plane scale 10 } }
  rotate y*20
}

union {
//  plane { y, 0 hollow }
  box { <-17,-1,-20>, <17,0,90> }
  box { <-19,-1,-20>, <-17,0.5,90> }
  box { <17,-1,-20>, <19,0.5,90> }
  cylinder { <-18,0,20>, <-18,1,20>, 1.5 }
  cylinder { <-18,0,20>, <-18,20,20>, 1 }
  
  #declare a=-5
  #while (a<=5)
    #declare b=-10
    #while (b<=30)
      #declare c=mod((a+b),2)
      #if (c=0)
        sphere { 0, 1 scale <1,0.1,0.25> translate <a*3,0,b*3> }
      #else
        sphere { 0, 1 scale <0.25,0.1,1> translate <a*3,0,b*3> }
      #end
      #declare b=b+1
    #end
    #declare a=a+1
  #end
  
//  texture { pigment { Green } }
//  texture { pigment { checker color Black color White scale 4 } }
//  texture { checker texture { wood1 } texture { wood2 } scale 4 }
  texture {
    pigment { 
      bozo
      color_map {
        [ 0.0 color Gray40 ]
//        [ 0.5 color Gray30 ]
        [ 1.0 color Gray30 ]
      }
    }
    finish { Dull metallic }
    scale 5
  }
  scale 10
}

camera {
   location <10, 20, -45>
   right x*1.333
   up y
   direction z
//   angle 46
   angle 28
   look_at <1, 2, 0>
  scale 10
}

union {
  #declare a=-3
  #while (a<=3)
    light_source { <0, 100, a*100> color Gray40 }
    #declare a=a+1
  #end
  scale 10
  pigment { color rgbt <1,1,1,1> }
}

/*
light_source { <0, 100, 0> color Gray85 }
light_source { <90, 30, -20> color Gray80 }
light_source { <-15, 200, -300> color Gray75 }

sky_sphere { pigment { rgb <0.5, 0.5, 0.75> } }
*/
