
// Persistence of Vision Ray Tracer Scene Description File
// File: mtn.pov
// Vers: 3
// Desc:glass mountain
// Date:feb 15 1997   
// Auth:Terry Lyons Sr.

   
#include "colors.inc"
#include "textures.inc"

camera
{
  location  <0,  .00, -1.2> // <X Y Z>
  look_at   <0, 0.222, 0> // point center of view at this point <X Y Z>
}


light_source { <-300, 300, -10> color red 0.75 green 0.5 blue 0.3 }
light_source { <-300, 210, 5>   color red 0.25 green 0.1 blue 0.0 }
light_source { <0, 150, 0>     color red 0.15 green 0.25 blue 0.1 }
light_source { <62, 150, 184>     color red 1 green 1 blue 1 }
light_source { <0, 1, -1.2>     color red .8 green .7 blue .8 }


plane {y,-5 hollow texture { Water scale <40,50,70> } }

merge {
object{
         height_field {tga "output.tga" }
         scale < 1, .1, 1 >      // reduce height
         translate <-.5, 0, -.5>
         texture {
           Glass2
         }
       }

object{
         height_field {tga "output.tga" }
         scale < 1, .706, 1 >      // reduce height
         translate <-.5, 0, -.5>
         texture {
	   Glass3
           finish {phong 0.1 ambient 0.2 refraction 1 ior 1.24 }
         }
       }

translate <0,-.25,.9>
scale 125
}
sphere { 0,1 hollow pigment {
gradient y
 color_map {
[0.0color  Red]
[1 color Black]
}
scale .603
}
scale 8000
}
plane { y,800 hollow pigment { Clouds scale 119 }}
plane { y,600 hollow pigment { Clouds scale 92 }}
plane { y,400 hollow pigment { Clouds scale 108 }}
plane { y,200 hollow pigment { Clouds scale 91 }}
