//  Persistance of Vision Raytracer V3.0
//  Texture include file for nkreflct.pov
//
//  ---------------------------------------------------------
//
//  Scene    : Reflections - texture include file
//  Author   : Nathan Kopp
//  Date     : February 22, 1997
//  Filename : NKReflct.inc
//
//  ---------------------------------------------------------
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

// *******  T E X T U R E S  *******




// Textures from previous exports [MRY]

//  $MRX$: 'WindowSnowTex'
#declare WindowSnowTex = texture {
   pigment {
     color rgbf<1,1,1,1>
   }
   halo {
    attenuating
    linear  // constant
    spherical_mapping
    max_value 1
    color_map {
      [0.0 color rgbt<.92,.92,.92,1>]
      [0.1 color rgbt<.92,.92,.92,.2>]
      [1.0 color rgbt<.92,.92,.92,0>]
    }
    samples 10
    turbulence .2
    //lambda 3
    omega .7
  }
}

//  $MRX$: 'WindowPaneTex'
#declare WindowPaneTex = texture {
   pigment {
     image_map {
       gif "D:\POV\MORAY25\..\WINDOW\WINDOW2.GIF"
       map_type 0  // Planar
       #declare index = 0
       #while (index <= 255)
         transmit index, (1-.5*index/256)
         #declare index = index + 1
       #end
       interpolate 2  // Bilinear (2)
     }
   }
   normal {
     bumps 0.0010
     omega 2.000
     lambda 0.500
     scale     0.1000
   }
   finish {
     ambient .5
     diffuse .3
     reflection 0.1
     refraction 1
     ior 1.500
     specular 0.200
     roughness 0.0100
   }

}

#declare CrackPigment = pigment {
     granite
     color_map {
       [ 0.000  color rgb<0.387, 0.387, 0.387> ]
       [ 1.000  color rgb<0.726, 0.726, 0.726> ]
     }
     turbulence 1.000
     scale     <0.1000, 0.1000, 0.1000>
}

//  $MRX$: 'WindowTex1'
#declare WindowTex1 = texture {
   pigment {
     crackle
     pigment_map {
      [ 0.00  CrackPigment ]
      [ 0.003  CrackPigment ]
      [ 0.006  color rgb<0.903, 0.900, 0.877> ]
      [ 1.00  color rgb<0.903, 0.900, 0.877> ]
     }
   }
   finish {
     diffuse 0.600
     ambient 0.150
     specular 0.400
     roughness 0.0100
   }
   scale <.4,.4,.4>
}


//  $MRX$: 'FallingSnowTex'
#declare FallingSnowTex = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       [ 0.999  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       [ 1.000  color rgbf<1.000, 1.000, 1.000, 0.200> ]
     }
     turbulence 0.000
     scale     <0.0400, 0.0400, 0.0400>
   }
   finish {
     diffuse 1.00
     ambient 0.300
   }

}






// Textures exported in this run [MRY]



//  $MRY$: 'InsideWindow'
#declare InsideWindow = texture {
   pigment {
     granite
     color_map {
       [ 0.000  color rgb<0.287, 0.287, 0.287> ]
       [ 1.000  color rgb<0.426, 0.426, 0.426> ]
     }
     turbulence 1.000
     scale     <0.1000, 0.1000, 0.1000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'WallTex1'
#declare WallTex1 = texture {
   pigment {
     color rgb<0.000, 0.000, 0.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
   }

}



//  $MRY$: 'ShingleTexture'
#declare ShingleTexture =    texture { // Layer1
     pigment {
       bozo
       color_map {
         [ 0.000  color rgb<0.250, 0.250, 0.250> ]
         [ 0.874  color rgb<0.270, 0.270, 0.270> ]
         [ 1.000  color rgb<0.300, 0.300, 0.300> ]
       }
       turbulence 5.000
       scale     <0.4000, 0.4000, 0.4000>
     }
     finish {
       ambient 0.300
     }

   }

   texture { // Layer4
     pigment {
       gradient z
       color_map {
         [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
         [ 0.240  color rgbf<1.000, 1.000, 1.000, 1.000> ]
         [ 0.242  color rgbf<0.200, 0.200, 0.200, 0.500> ]
         [ 0.259  color rgb<0.200, 0.200, 0.200> ]
         [ 1.000  color rgb<0.200, 0.200, 0.200> ]
       }
       scale     <0.3100, 0.3100, 0.3100>
       translate <0.0000, 0.0000, 0.1500>
     }
     finish {
       ambient 0.300
     }

   }

   texture { // Layer2
     pigment {
       gradient y
       color_map {
         [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
         [ 0.748  color rgbf<0.400, 0.400, 0.400, 0.797> ]
         [ 0.860  color rgbf<0.200, 0.200, 0.200, 0.300> ]
         [ 0.953  color rgbf<0.170, 0.170, 0.170, 0.200> ]
         [ 1.000  color rgbf<0.170, 0.170, 0.170, 0.200> ]
       }
       turbulence 0.100
       scale     <1.0000, 6.0000, 1.0000>
       translate <0.0000, 2.8000, 0.0000>
     }
     normal {
       wrinkles 2.0000
       turbulence 4.000
       omega 2.000
       lambda 0.500
       scale     0.5000
     }
     finish {
       ambient 0.300
     }

   }



//  $MRY$: 'SkySphereTex'
#declare SkySphereTex = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.600, 0.600, 0.600> ]
       [ 0.421  color rgb<0.500, 0.500, 0.500> ]
       [ 0.712  color rgb<0.500, 0.500, 0.500> ]
       [ 1.000  color rgb<0.400, 0.400, 0.400> ]
     }
     turbulence 2.000
     scale     <0.5000, 0.5000, 0.5000>
   }
   finish {
     diffuse 0.000
     ambient 0.600
   }

}



//  $MRY$: 'SnowTex'
#declare SnowTex = texture {
   pigment {
     marble
     color_map {
       [ 0.000  color rgb<0.700, 0.700, 0.700> ]
       [ 0.800  color rgb<0.500, 0.500, 0.500> ]
       [ 0.800  color rgb<0.715, 0.715, 0.715> ]
       [ 1.000  color rgb<0.502, 0.498, 0.502> ]
     }
     turbulence 1.800
     scale     <0.5000, 0.5000, 0.5000>
   }

}



//  $MRY$: 'IceTexture'
#declare IceTexture = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<1.000, 1.000, 1.000, 0.990> ]
       [ 0.914  color rgbf<1.000, 1.000, 1.000, 0.990> ]
       [ 1.000  color rgbf<1.000, 1.000, 1.000, 0.699> ]
     }
     turbulence 1.000
     scale     <0.0100, 0.0100, 0.0100>
   }
   normal {
     bumps 0.1000
     omega 2.000
     lambda 0.500
     scale     0.0500
   }
   finish {
     phong 1.000
     phong_size 89.700
     reflection 0.100
     refraction 1
     ior 1.430
   }

}



//  $MRY$: 'IceTexture2'
#declare IceTexture2 = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<1.000, 1.000, 1.000, 0.889> ]
       [ 0.910  color rgbf<1.000, 1.000, 1.000, 0.887> ]
       [ 1.000  color rgbf<1.000, 1.000, 1.000, 0.699> ]
     }
     turbulence 1.000
     scale     <0.0100, 0.0100, 0.0100>
   }
   normal {
     bumps 0.1000
     omega 2.000
     lambda 0.500
     scale     0.0500
   }
   finish {
     phong 1.000
     phong_size 89.700
     refraction 1
     ior 1.430
   }

}



//  $MRY$: 'DMFWood5'
#declare DMFWood5 = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.888, 0.600, 0.300> ]
       [ 0.100  color rgb<0.888, 0.600, 0.300> ]
       [ 0.900  color rgb<0.600, 0.400, 0.200> ]
       [ 1.000  color rgb<0.600, 0.400, 0.200> ]
     }
     turbulence 0.500
     octaves 3
     scale     <0.0500, 0.0500, 1.0000>
   }

}



//  $MRY$: 'WhiteMetalTex'
#declare WhiteMetalTex = texture {
   pigment {
     color rgb<1.000, 1.000, 1.000>
   }
   finish {
     phong 0.300
     phong_size 51.000
     specular 0.100
     roughness 0.0100
   }

}



//  $MRY$: 'PinTex'
#declare PinTex = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.930, 0.922, 0.870> ]
       [ 0.856  color rgb<0.930, 0.922, 0.870> ]
       [ 0.953  color rgb<0.441, 0.269, 0.269> ]
       [ 0.975  color rgb<0.441, 0.269, 0.269> ]
       [ 1.000  color rgb<0.563, 0.432, 0.419> ]
     }
     turbulence 2.000
     scale     <0.0700, 0.0700, 0.0700>
   }
   normal {
     wrinkles 0.1000
     turbulence 5.000
     scale     0.0500
   }
   finish {
     diffuse 0.740
     ambient 0.150
     specular 0.100
     roughness 0.1390
     brilliance 6.000
   }

}



//  $MRY$: 'WhitePlastic'
#declare WhitePlastic = texture {
   pigment {
     color rgbf<0.820, 0.820, 0.780, 0.101>
   }
   finish {
     diffuse 0.500
     ambient 0.300
     specular 0.260
     roughness 0.0520
   }

}



//  $MRY$: 'Switch2Tex'
#declare Switch2Tex = texture {
   pigment {
     radial
     color_map {
       [ 0.000  color rgb<0.426, 0.426, 0.426> ]
       [ 0.388  color rgb<0.145, 0.145, 0.145> ]
       [ 1.000  color rgb<0.145, 0.145, 0.145> ]
     }
     frequency 10.000
     rotate -90*x
   }
   finish {
     diffuse 0.700
     specular 0.050
     roughness 0.5670
   }

}



//  $MRY$: 'Switch1Tex'
#declare Switch1Tex = texture {
   pigment {
     gradient z
     color_map {
       [ 0.000  color rgb<0.452, 0.452, 0.452> ]
       [ 0.273  color rgb<0.745, 0.745, 0.745> ]
       [ 1.000  color rgb<0.745, 0.745, 0.745> ]
     }
     frequency 6.000
     rotate    <-10.0000, 0.0000, 0.0000>
   }
   finish {
     diffuse 0.700
     specular 0.050
     roughness 0.5670
   }

}



//  $MRY$: 'FloorTexture'
#declare FloorTexture = texture {
   pigment {
     marble
     color_map {
       [ 0.000  color rgb<0.734, 0.732, 0.634> ]
       [ 0.698  color rgb<0.765, 0.762, 0.700> ]
       [ 0.849  color rgb<0.600, 0.533, 0.500> ]
       [ 1.000  color rgb<0.595, 0.550, 0.505> ]
     }
     turbulence 5.000
     frequency 2.000
     scale     <0.1000, 0.1000, 0.1000>
   }
   normal {
     bumps 0.1000
     scale     0.5000
   }
   finish {
     specular 0.300
     roughness 0.0500
   }

}



//  $MRY$: 'LampSilver'
#declare LampSilver = texture {
   pigment {
     color rgb<0.940, 0.930, 0.799>
   }
   normal {
     wrinkles 0.5000
     turbulence 0.500
     scale     <0.0100, 0.0100, 0.1000>
   }
   finish {
     diffuse 0.650
     ambient 0.250
     phong 1.000
     phong_size 100.000
     brilliance 6.000
   }

}



//  $MRY$: 'LampSilver2'
#declare LampSilver2 = texture {
   pigment {
     color rgb<0.940, 0.930, 0.699>
   }
   normal {
     bumps 0.5000
     turbulence 0.500
     scale     0.0500
   }
   finish {
     diffuse 0.650
     ambient 0.250
     phong 1.000
     phong_size 50.000
     brilliance 6.000
     metallic
   }

}



//  $MRY$: 'DMFWood4'
#declare DMFWood4 = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.400, 0.133, 0.066> ]
       [ 0.100  color rgb<0.400, 0.133, 0.066> ]
       [ 0.900  color rgb<0.200, 0.065, 0.033> ]
       [ 1.000  color rgb<0.200, 0.065, 0.033> ]
     }
     turbulence 0.100
     octaves 2
     scale     <0.0500, 0.0500, 1.0000>
   }
   finish {
     phong 0.200
     phong_size 50.000
   }

}



//  $MRY$: 'ChairTexture'
#declare ChairTexture = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.200, 0.200, 0.200> ]
       [ 0.784  color rgb<0.200, 0.200, 0.200> ]
       [ 1.000  color rgb<0.208, 0.367, 0.197> ]
     }
     turbulence 10.000
     scale     <0.0050, 0.0050, 0.0050>
   }
   normal {
     bumps 0.2000
     turbulence 10.000
     omega 2.000
     lambda 0.500
     scale     0.0020
   }
   finish {
     diffuse 0.690
     specular 0.100
     roughness 0.2090
   }

}



//  $MRY$: 'LampShadeTex'
#declare LampShadeTex = texture {
   pigment {
     gradient z
     color_map {
       [ 0.000  color rgb<0.560, 0.409, 0.000> ]
       [ 0.040  color rgb<0.560, 0.409, 0.000> ]
       [ 0.054  color rgb<1.000, 1.000, 0.800> ]
       [ 0.960  color rgb<1.000, 1.000, 0.800> ]
       [ 0.978  color rgb<0.560, 0.409, 0.000> ]
       [ 1.000  color rgb<0.560, 0.409, 0.000> ]
     }
   }
   finish {
     diffuse 0.100
     ambient 1.000
   }

}



//  $MRY$: 'DayPlanTex'
#declare DayPlanTex = texture {
   pigment {
     image_map {
       tga "D:\POV\MORAY25\..\WINDOW\DAYPLAN.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   normal {
     bump_map {
       gif "D:\POV\MORAY25\..\WINDOW\DAYPLAN.GIF"
       bump_size -0.500
       use_index
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
     omega 2.000
     lambda 0.500
   }
   finish {
     diffuse 0.400
     specular 0.400
     roughness 0.0100
   }

}



//  $MRX$: 'WaterGlassTex'
#declare WaterGlassTex = texture {
   pigment {
     color rgbf<1.000, 1.000, 1.000, 0.976>
   }
   finish {
     diffuse 0.100
     ambient 0.000
     phong 1.000
     phong_size 100.000
     refraction 1
     ior 1.499
     caustics 1
   }

}



//  $MRY$: 'PenBlack'
#declare PenBlack = texture {
   pigment {
     color rgb<0.100, 0.100, 0.100>
   }
   finish {
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'PenWhite'
#declare PenWhite = texture {
   pigment {
     color rgb<0.900, 0.900, 0.900>
   }
   finish {
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'PaperTex'
#declare PaperTex = texture {
   pigment {
     image_map {
       gif "D:\POV\MORAY25\..\WINDOW\PAPER.GIF"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.200
     roughness 0.8620
   }

}



//  $MRY$: 'BackgroundTex'
#declare BackgroundTex = texture {
   pigment {
     image_map {
       tga "D:\POV\MORAY25\..\WINDOW\MYTREE.TGA"
       map_type 0  // Planar
       interpolate 2  // Bilinear (2)
     }
   }
   finish {
     diffuse 0.000
     ambient 1.000
   }

}

