
#declare x_dist = 0.65  //distance the shelf cutouts are from each other
#declare z_dist = 0.65

#declare x_tri = 1.95
#declare z_tri = 2.6

//entire shelf is 72x24



//--------------------------
// colors and textures
//--------------------------

#declare P_ChromeA   = color rgb <0.35, 0.35, 0.35>


#declare F_ChromeA  =
	finish {
  	  	ambient 0.35
  	 	brilliance 4
  	 	diffuse 0.5
    	metallic
    	specular 0.80
    	roughness 1/80
    	reflection 0.15
	}
	
#declare F_ChromeB = 
	finish {
  	  	ambient 0.45
  	 	brilliance 4
  	 	diffuse 0.5
    	metallic
    	specular 0.80
    	roughness 1/80
    	reflection 0.05
	}



#declare T_ChromeA = texture { pigment { P_ChromeA } finish { F_ChromeA } }
#declare T_ChromeB = texture { pigment { P_ChromeA } finish { F_ChromeB } }





//the small shelf piece
#declare Shelf_rect = box { <0.0, -0.025, 0.0>, <0.651, 0.025, 1.301> }
      


//the cutout
#declare Shelf_cut = cylinder { <0, -0.026, 0>, <0, 0.026, 0>, 0.25 } 
    
  
#declare Small_piece = 
	difference {
		object { Shelf_rect }
		object { Shelf_cut translate <0.325, 0, 0.325> }
		object { Shelf_cut translate <0, 0, 0.975> }
		object { Shelf_cut translate <0.65, 0, 0.975> }
		bounded_by { box { <-0.001, -0.026, -0.001>, <0.652, 0.026, 1.302> }}
		
		texture { T_ChromeA }
	}
//end object Small_piece
		
#declare Tri_piece = 
	union {
		object { Small_piece }
		object { Small_piece translate <0.65, 0, 0> }
		object { Small_piece translate <0.65*2, 0, 0> }
		
		object { Small_piece translate <0, 0, 1.3> }
		object { Small_piece translate <0.65, 0, 1.3> }
		object { Small_piece translate <0.65*2, 0, 1.3> }
		
		//bounded_by { box { <-0.001, -0.026, -0.001>, <1.952, 0.026, 3.902> }}
	}
//end object Tri_piece





#declare Shelf_cut_all = 
union {
  #declare CountA = 0
  #while (CountA < 10)
    #declare CountB=0
    #while (CountB < 9)
      object { Tri_piece translate < (CountA*x_tri), 0, (CountB*z_tri)> }
      #declare CountB=CountB+1
    #end
  #declare CountA=CountA+1
  #end
}




#declare Shelf_temp = 
	box { <-72, -0.05, 1>, <-1, 0.05, 23> 
		texture {
			T_ChromeA
			pigment { quick_color Red } 
		}
	}





//----------------------
// start of rail
//----------------------



#declare rail_front = 
	difference {
		box { <-0.75, -0.75, -0.025>, <0.75, 0.751, 0.025> }
		box { <-0.35, -0.2, -0.03>, <0.35, 0.2, 0.03> }
		rotate <0, 90, 0>
	}
//end object rail_front


#declare rail_side = box { <0, -0.75, -0.025>, <0.5, 0.751, 0.025> }

#declare rail_section = 
	union {
		object { rail_front }
		object { rail_side translate <0, 0, 0.75> }
		object { rail_side translate <0, 0, -0.75> }
		texture { T_ChromeA }
	}
//end object rail_section


#declare rail = 
	union {
       #declare CountA = 0
 	   #while (CountA < 28)
  	       object { rail_section translate <0, (CountA*1.5), 0> }
  	       #declare CountA=CountA+1
  	   #end
	}
//end rail object






//---------------------
// start of shelf sides
//---------------------

#declare side_front_lower = box { <-72, -2.54, -0.05>, <0, 0, 0.05> }
#declare side_front_upper = box { <-72, -0.05, 0>, <0, 0.05, 2.54> }
#declare side_front_square = 
	union { 
		object { side_front_lower }
		object { side_front_upper }
	}
	
#declare side_front_cut = 
 	difference {
 		object { side_front_square }
 		box { <-72.1, -0.4, -0.4>, <0.1, 0.4, 0.4> }
 	}
 	
#declare side_front_round = 
 	union {
 		object { side_front_cut }
 		cylinder { <-72, -0.4, 0.4>, <0, -0.4, 0.4>, 0.45 }
 	}
 	
#declare side_front = 
 	difference {
 		object {side_front_round}
 		box { <0, -3, -1>, <3, 3, 5> rotate <0, -45, 0>}
 		texture { T_ChromeA }
 		pigment { quick_color Blue }
 		bounded_by { box { <-72.1, -2.55, -0.06>, <0.01, 0.06, 2.55> } }
 	}
 	
 	
#declare side_right_upper = box { <-2.54, -0.05, 0>, <0, 0.05, 24> }
#declare side_right_lower = box { <-0.05, -2.54, 0>, <0.05, 0, 24> }
#declare side_right_square = 
	union { 
		object { side_right_upper }
		object { side_right_lower }
	}
	
#declare side_right_cut = 
	difference {
		object { side_right_square }
		box { <-0.4, -0.4, -0.01>, <0.4, 0.4, 24.1> }
	}
	
#declare side_right_round = 
	union {
		object { side_right_cut }
		cylinder { <-0.4, -0.4, 0>, <-0.4, -0.4, 24>, 0.45 }
	}
	
#declare side_right = 
	difference {
		object { side_right_round }
		box { <-5, -3, -3>, <1, 3, 0> rotate <0, 45, 0> }
		box { <-5, -3, 0>, <1, 3, 3> rotate <0, -45, 0> translate <0, 0, 24>}
		texture { T_ChromeA }
		pigment { quick_color Blue }
	}
	

	  			
#declare side_back =
	object { side_front scale <1, 1, -1> }
	



//--------------------
// start of oven walls
//--------------------

#declare wall_side = box { <-0.05, 0, 0>, <0.05, 54, 30.1> }
#declare wall_back = box { <-74, 0, 30>, <0, 54, 30.1> }
#declare wall_top =  box { <-74, -0.05, 0>, <0, 0.05, 30.1> }

#declare walls = 
	union {
		object { wall_side }
		object { wall_side translate <-74, 0, 0> }
		object { wall_back }
		object { wall_top }
		object { wall_top translate <0, 54, 0> }
		
		texture { T_ChromeA }
		pigment { quick_color Yellow  }
	}
// end object walls


//--------------------
// start of random stuff = the lab!! which won't be seen, but just in case
// of reflections and stuff !!
//--------------------


#declare lab_floor = box { <-500, -45, -150>, <500, -45.1, 0> }
#declare lab_left_wall = box { <-500, -45, -150>, <-501, 300, 0> }
#declare lab_right_wall = object { lab_left_wall translate <1000, 0, 0> }
#declare lab_hood_face = box { <-500, -45, -150>, <500, 300, -151> }

#declare lab = 
	union {
		object { lab_floor }
		object { lab_left_wall }
		object { lab_right_wall }
		object { lab_hood_face }
	
		texture {
			pigment { color ( White ) }
			//finish { ambient 0.7 }
		}
	}
// end object lab







object { Shelf_cut_all scale <-1, 1, 1> }
//object { Shelf_temp }

object {rail translate <0.4, -30, 5> }
object {rail translate <0.4, -30, 19> }


object { side_front translate <0, 0.15, -0.15> }
object { side_right translate <0.15, 0.15, 0> }
object { side_back translate <0, 0.15, 24.15> }

object { walls translate <0.9, -30, -5> }   
object { lab }









