
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "stones.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <4, 1.2, -2>
  look_at   <0, 0.2,  5>
}
light_source { <10, 40, -25> color red 1 green 1 blue 0.8 }
sky_sphere {
    pigment {
      gradient y
      color_map {
        [(1-cos(radians( 30)))/2 color Red]
        [(1-cos(radians( 80)))/2 color Magenta]
        [(1-cos(radians(120)))/2 color Cyan]
      }
      scale 2
      translate -1
    }
  }
sphere { <0,0,0>, 10000
    scale <1,0.01,1>
    texture {
        T_Cloud1
        scale 50 //1000
    }
    hollow
    // scale <1,.1,1>
}
// ----------------------------------------
// plane { y, 0 texture {T_Stone25}}
// plane {y, 0 pigment{checker color Yellow color White} }
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal
  texture {
    pigment { Yellow
    }
   }
  finish {
   caustics 1.0
   phong 0.8 phong_size 300         // Very tight highlights
   reflection 0.2                // Needs a little reflection added
   }
}

#declare Cap = difference{
 union {
  box {<-0.3,0,-0.3>,<0.3,0.1,0.3>}
  cylinder { <-0.3,0,-0.3>,<-0.3,0,0.3>, 0.1}
  cylinder { <0.3,0,-0.3>,<0.3,0,0.3>,0.1}
 }
 sphere {<-0.3,0,-0.3>,0.05}
 sphere {<-0.3,0,0.3>,0.05}
 sphere {<0.3,0,-0.3>,0.05}
 sphere {<0.3,0,0.3>,0.05}
}
#declare Pillar = union{
 difference{
  cylinder { < 0,0.2,0 >, < 0,1.6,0 >,  0.2 }
  cylinder { < 0,-1,-0.2 >, < 0,2,-0.2 >,  0.05 }
  cylinder { < 0,-1,0.2 >, < 0,2,0.2 >,  0.05 }
  cylinder { < -0.2,-1,0 >, < -0.2,2,0 >,  0.05 }
  cylinder { < 0.2,-1,0 >, < 0.2,2,0 >,  0.05 }
  cylinder { < -0.1414,-1,-0.1414 >, < -0.1414,2,-0.1414 >,  0.05 }
  cylinder { <  0.1414,-1,-0.1414 >, <  0.1414,2,-0.1414 >,  0.05 }
  cylinder { < -0.1414,-1, 0.1414 >, < -0.1414,2, 0.1414 >,  0.05 }
  cylinder { <  0.1414,-1, 0.1414 >, <  0.1414,2, 0.1414 >,  0.05 }
 }
 object { Cap
  translate <0,1.6,0>
 }
 box { <-0.3,0,-0.3>,<0.3,0.08,0.3>}
 lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  8, // number of points
  <0, 0>, <0.28, 0>, <0.3,0.02>, <0.3,0.04>, <0.24,0.08>,
  <0.2,0.12>,<0,0.12>,<0,0>
  translate <0,0.08,0>
 }
}

#declare PRad = 4
#declare PNum = 13 // number of pillars & beams
#declare Dist = 0
#declare Palasade = union {
 #while ( Dist < PNum )
 object { Pillar
 translate <0,0,PRad>
 rotate <0,(360/PNum)*Dist,0>
 }
 #declare Dist=Dist+1
 #end
 translate <0,-1,PRad>
}
#declare HalfGlobe =  difference {
  sphere {<0,0,0>,PRad+0.25}
  box {<-(PRad+1),0,-(PRad+1)>,<(PRad+1),-(PRad+1),(PRad+1)>}
 }
#declare Beam = difference {
  object {
   HalfGlobe
   rotate <90,0,0>
   rotate <0,(45/PNum),0>
   }
  object {
   HalfGlobe
   scale <1.01,1.01,1.01>
   rotate <90,0,0>
   rotate <0,-(45/PNum),0>
   }
  object {
   HalfGlobe
   scale <1.01,1.01,1.01>
   rotate <180,0,0>
   }
  sphere {<0,0,0>,PRad-0.25
   scale <1,(PRad+0.4)/PRad,1>
   }
  rotate <0,270,0>
 }
#declare Dist = 0;
#declare Beams = union {
 #while ( Dist < PNum )
 object { Beam
 translate <0,0,0>
 rotate <0,(360/PNum)*Dist,0>
 }
 #declare Dist=Dist+1
 #end
 translate <0,-1,PRad>
}
#declare Dome = union {
 object { Palasade }
 object { Beams
  translate <0,1.7,0>
  }
 translate <0,-1,0>
}

object { Dome
 // pigment {Red}
  texture {
   pigment { rgb <0.8,1,1> filter 0.99 }
   finish {
    diffuse 0.05
    reflection 0.1
    refraction 1
    ior 1.5
    fade_distance 1
    fade_power 2
   }
  }
 scale <0.5,0.5,0.5>
}
// disk
#declare Coaster =
 cylinder { <1.02,1.02,0>,<1.02,1.02,.1>,1
 hollow
 texture {
  pigment {
   image_map {
    gif "c:\gif\circle.gif"
    // interpolate 2
    // once
    filter all 0.5
    filter 255,0.99
   }
   scale 2.05
  }
  finish {
   //ambient
   diffuse 0.05
   reflection 0.25
   refraction 1
   ior 1.5
   fade_distance 1
   fade_power 2
  }
 }
 rotate <270,0,0>
 scale <2,1,2>
}

object {
 Coaster
 translate <2.5,-0.979,3>
}
#declare R2=seed(3)
#declare Num = 50
#while (Num !=0)
object {
 Coaster
 translate <100*(rand(R2)-0.5),-0.979,10 + 70*rand(R2)>
 }
 #declare Num = Num-1
#end

plane { z,0
 texture {
  pigment {
   image_map {
    gif "c:\gif\hfthree.gif"
    interpolate 2
    once
    filter all 0
    filter 255,1
   }
   scale 8
  }
  finish {
   ambient 0.35
  }
 }
 hollow
 rotate <0,-15,0>
 translate <0,-5.05,0>
 scale <25,12.5,25>
 translate <-160,0,100>
}


