//=============================================================================
// Definition of Standard Chess Pieces
//
// Version 1.0 - Initial release; January 5, 1997
// by Peter R. Jones  [pjones@powerup.com.au]
//
// You may use this file to generate your own scenes.  However, if you do so,
// please acknowledge my efforts in designing this chess set - and I would be
// interested to hear about any pictures generated with this file.  Thanks.
// You may also modify the design of the pieces, or add more textures, or make
// whatever other "improvements" you can think of - on two conditions:
//    1: Please leave this portion of the comment intact.
//    2: Please email me a copy of your modifications - any that I choose to
//       incorporate into my own file will, of course, be acknowledged.
//=============================================================================
// The shapes are a slightly simplified version of my own set, which is roughly
// "Staunton" design.  The measurements of the pieces are in millimetres, more
// or less.
//
// Also included are a series of different textures which may be applied to the
// pieces automatically by #declaring the variable "ChessSet_Texture" to one of
// the following values BEFORE #including this file.  If the "ChessSet_Texture"
// variable is not #declared as any of these values, the default set of black
// and white plastic will be used.
//
//    1  Chess_Wood             *Light and Dark Oak
//    2  Chess_Glass             Clear Glass and Dark-Brown Glass
//    3  Chess_Gold              Silver and Gold
//    4  Chess_Bronze            Pewter and Bronze
//    5  Chess_Stone            *Marble and Jade
//   99  Chess_Default           White and Black Plastic
//
// The actual textures are defined in file "CHESSTEX.INC" which is
// automatically #included by this file AFTER the #declarations
// of the above values.
//
// These textures will be mapped to "T_ChessWhite" and "T_ChessBlack".
// Additionally, a set of white and black pieces will be #declared
// (eg Pawn_White, Rook_Black, etc) but with the patterned textures
// (marked "*" above) you may wish to apply the texture to each piece
// after placement, to avoid having eight identical pawns, for example.
//
// Of course, each texture is also available as "TW_Chess_****" and
// "TB_Chess_****"; the above mapping is just for convenience.
//=============================================================================


//=============================================================================
// Following are the piece definitions:

#declare Base_Small = merge {
  lathe {
    linear_spline
    7, <0,0>, <8,0>, <7.8,3.8>, <6,4>, <5,9>, <5,11>, <0,11>
    }
  torus {
    5,2.5
    translate <0,6.5,0>
    sturm
    }
  }

#declare Base_Medium = merge {
  lathe {
    linear_spline
    7, <0,0>, <9,0>, <8.8,4>, <7,4.2>, <5.5,10>, <6.5,12>, <0,12>
    }
  torus {
    4.1,3.95
    scale <1,0.75,1>
    translate <0,7,0>
    sturm
    }
  }

#declare Base_Large = merge {
  lathe {
    linear_spline
    7, <0,0>, <10,0>, <9,4.5>, <7,4.6>, <6,11>, <7,14>, <0,14>
    }
  torus {
    5,3.2
    translate <0,8,0>
    sturm
    }
  }

#declare Pawn = merge {
  object { Base_Small }
  lathe {
    linear_spline
    6, <0,10>, <4,11>, <3,18>, <5.8,18>, <6,19.5>, <0,22.2>
    }
  sphere { <0,23,0>, 4 }
  intersection {
    cylinder { <0,0,-0.9>, <0,0,0.9>, 4 }
    box { <0,0,-1>, <4,4,1> }
    scale <1,1.4,1>
    rotate <0,0,15>
    translate <0,23,0>
    }
  }

#declare Rook = merge {
  object { Base_Medium }
  difference {
    lathe {
      linear_spline
      8, <4.6,12>, <3,22>, <4.2,24>, <7,24>, <6.9,26>, <6,26.4>, <6,33>, <0,33>
      }
    box { <8,29,3>, <-8,34,8> }
    box { <8,29,-3>, <-8,34,-8> }
    box { <1.3,31,8>, <3.4,34,-8> }
    box { <-1.3,31,8>, <-3.4,34,-8> }
    }
  }

#declare Bishop = difference {
  merge {
    object { Base_Medium }
    lathe {
      linear_spline
      6, <4.6,12>, <3,22>, <4.2,24>, <7,24>, <6.9,26>, <0,29>
      }
    sphere {
      <0,0,0> 4
      scale <1,1.5,1>
      translate <0,31,0>
      }
    sphere { <0,37.75,0>, 1.15 }
    }
  box { <0.6,0,6>, <-0.6,20,-6> rotate <0,0,35> translate <-1,32.5,0> }
  }

#declare Knight = merge {
  object { Base_Medium }
  difference {
    prism {
      linear_sweep
      linear_spline
      -2.5,2.5
      27
      <-5.5,12.0>, <-7.15517,13.6552>, <-7.15517,14.7325>, <0,28.0>, <-1.65517,27.5862>,
      <-2.89655,27.5862>, <-5.5,23.5862>, <-7.74138,23.5862>, <-7.74138,24.4138>, <-8.56897,23.5862>,
      <-8.98276,24.0>, <-8.98276,26.069>, <-8.56897,26.069>, <-5.25862,33.0172>, <-5.67241,33.8448>,
      <-4.5625,35.4025>, <-2.6875,35.902>, <0.735396,35.9708>, <2.0,38.5>, <2.36207,35.9655>,
      <4.25862,35.5862>, <6.5,34.0>, <8.24138,32.1034>, <9.0,29.5>, <8.5625,25.287>,
      <5.5,12.0>, <-5.5,12.0>
      rotate <-90,0,0>
      }
    cylinder { <-5,38.5,0>, <5,38.5,0>, 2.25 }
    blob {
      threshold 1
      cylinder { <-1.5,12,5>, <0.5,22,6>, 1.5, 4 scale <2,1,0.5>}
      cylinder { <1,12,5>, <2,22,6>, 1.5, 4 scale <2,1,0.5>}
      }
    blob {
      threshold 1
      cylinder { <-1.5,12,-5>, <0.5,22,-6>, 1.5, 4 scale <2,1,0.5> }
      cylinder { <1,12,-5>, <2,22,-6>, 1.5, 4 scale <2,1,0.5> }
      }
    }
  prism {
    linear_sweep
    linear_spline
    -0.5,0.5
    11
    <5.0625,12.6738>, <8.3125,13.1733>, <9.9375,20.0419>, <6.9375,21.1658>, <10.3125,21.4156>,
    <10.8125,30.2823>, <8.08212,30.707>, <10.3125,32.5302>, <4.8125,37.026>, <1.9375,34.903>,
    <5.0625,12.6738>
    rotate <-90,0,0>
    }
  }

#declare Queen = merge {
  object { Base_Large }
  lathe {
    linear_spline
    18,
    <0,13>, <6,14>, <5,18>, <5.5,18.75>, <4.85,19.5>, <3.2,26>, <5,27>, <6.5,27>, <6.5,29>,
    <5,29>, <3,30>, <3,31.5>, <4,31.5>, <4,32>, <3,32>, <4.25,40.25>, <3.75,42>, <0,42>
    }
  sphere { <0,43,0>, 1.5 }
  #declare idxQueen = 0
  #while (idxQueen < 360)
    merge {
      cone { <3,40,0>, 1, <4.5,43,0>, 0.25 scale <1,1,2>}
      sphere { <4.5,43,0>, 0.75 }
      rotate <0,idxQueen,0>
      }
    #declare idxQueen = idxQueen + 60
    #end
  }

#declare King = merge {
  object { Base_Large }
  lathe {
    linear_spline
    22,
    <0,13>, <6,14>, <5,18>, <5.5,18.75>, <4.85,19.5>, <3.2,28>, <5,29>, <6.5,29>, <6.5,31>,
    <5,31>, <3,32>, <3,33.5>, <4,33.5>, <4,34>, <3,34>, <4.25,40.25>, <4.75,40.25>, <4.75,40.75>,
    <4.25,40.75>, <3,42.2>, <3,44>, <0,44>
    }
  box { <1,43,1.01>, <-1,52,-1.01> }
  box { <3,48,1>, <-3,50,-1> }
  }


//=============================================================================
// Following are the definitions of the default textured chess set:

#include "ChessTex.inc"        // Defines default texture based on
                               // "ChessSet_Texture".

#declare Pawn_White =   object { Pawn   texture { T_ChessWhite } }
#declare Rook_White =   object { Rook   texture { T_ChessWhite } }
#declare Knight_White = object { Knight texture { T_ChessWhite } }
#declare Bishop_White = object { Bishop texture { T_ChessWhite } }
#declare Queen_White =  object { Queen  texture { T_ChessWhite } }
#declare King_White =   object { King   texture { T_ChessWhite } }

#declare Pawn_Black =   object { Pawn   texture { T_ChessBlack } }
#declare Rook_Black =   object { Rook   texture { T_ChessBlack } }
#declare Knight_Black = object { Knight texture { T_ChessBlack } }
#declare Bishop_Black = object { Bishop texture { T_ChessBlack } }
#declare Queen_Black =  object { Queen  texture { T_ChessBlack } }
#declare King_Black =   object { King   texture { T_ChessBlack } }
