// Glass table with chrome metal legs.

#declare T_TableGlass = texture {
  pigment { color rgbf <0.6,0.6,0.6,0.8> }
  finish {
    ambient 0.1
    diffuse 0.1
    reflection 0.15
    refraction 1
    ior 1.4
    specular 0.8
    roughness 0.003
    phong 1.0
    phong_size 400
    }
  }

#declare T_TableLeg = texture {
  pigment { color rgb <0.2,0.2,0.2> }
  finish {
    ambient 0.15
    brilliance 5
    diffuse 0.6
    metallic
    specular 0.80
    roughness 0.01
    reflection 0.65
    }
  }

#declare TableLeg = union {
  sphere {
    <0,0,0>, 35
    scale <1.05,0.1,1.05>
    translate <0,0.35,0>
    texture {
      pigment { color rgb <0.15,0.15,0.15> }
      finish {
        phong 1.0
        phong_size 15
        }
      }
    }
  union {
    cylinder { <0,0.35,0>, <0,730,0>, 35 }
    box { <-50,680,-50>, <50,740,50> }
    texture { T_TableLeg }
    }
  }

#declare Table = union {
  merge {
    prism {
      linear_sweep
      linear_spline
      740,750
      9, <-750,-275>, <-600,-425>, <600,-425>, <750,-275>,
      <750,275>, <600,425>, <-600,425>, <-750,275>, <-750,-275>
      }
    cylinder { <-600,740,-275>, <-600,750,-275>, 150 }
    cylinder { <600,740,-275>, <600,750,-275>, 150 }
    cylinder { <-600,740,275>, <-600,750,275>, 150 }
    cylinder { <600,740,275>, <600,750,275>, 150 }
    texture { T_TableGlass }
    }
  object { TableLeg translate <600,0,275> }
  object { TableLeg translate <600,0,-275> }
  object { TableLeg translate <-600,0,275> }
  object { TableLeg translate <-600,0,-275> }
  union {
    cylinder { <600,710,275>, <600,710,-275>, 25 }
    cylinder { <600,710,-275>, <-600,710,-275>, 25 }
    cylinder { <-600,710,-275>, <-600,710,275>, 25 }
    cylinder { <-600,710,275>, <600,710,275>, 25 }
    texture { T_TableLeg }
    }
  }
